/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.financialdiscount;

import java.awt.Toolkit;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.FinancialDiscount;

public class FinancialDiscountController
implements ControlledScreen {
    private ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<FinancialDiscount> tableFinancialDiscount;
    @FXML
    private TableColumn<FinancialDiscount, String> columnName;
    @FXML
    private TableColumn<FinancialDiscount, Double> columnValue;
    @FXML
    private TableColumn<FinancialDiscount, Double> columnDiscount;
    @FXML
    private TableColumn<FinancialDiscount, Boolean> columnActive;
    @FXML
    private TextField tfFilter;
    @FXML
    private VBox vBoxRight;
    @FXML
    private Button btnDeactivate;

    public void initialize() {
        this.columnName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.columnDiscount.setCellValueFactory((Callback)new PropertyValueFactory("discount"));
        this.columnActive.setCellValueFactory((Callback)new PropertyValueFactory("active"));
        this.columnActive.setCellFactory(column -> new TableCell<FinancialDiscount, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.tableFinancialDiscount.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<FinancialDiscount>(){

            public void onChanged(ListChangeListener.Change<? extends FinancialDiscount> c) {
                if (FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem() != null) {
                    if (((FinancialDiscount)FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem()).isActive()) {
                        FinancialDiscountController.this.btnDeactivate.setText("Deaktiviraj");
                    } else {
                        FinancialDiscountController.this.btnDeactivate.setText("Aktiviraj");
                    }
                }
            }
        });
        this.btnDeactivate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem() != null) {
                    ((FinancialDiscount)FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem()).setActive(!((FinancialDiscount)FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem()).isActive());
                    ((FinancialDiscount)FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem()).update(FinancialDiscountController.this.controller);
                    if (FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem() != null) {
                        if (((FinancialDiscount)FinancialDiscountController.this.tableFinancialDiscount.getSelectionModel().getSelectedItem()).isActive()) {
                            FinancialDiscountController.this.btnDeactivate.setText("Deaktiviraj");
                        } else {
                            FinancialDiscountController.this.btnDeactivate.setText("Aktiviraj");
                        }
                    }
                }
                FinancialDiscountController.this.tableFinancialDiscount.refresh();
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.rootPane.getScene() != null) {
            this.vBoxRight.setMinWidth(this.rootPane.getScene().getWidth() * 12.0 / 100.0);
        } else {
            this.vBoxRight.setMinWidth(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 12.0 / 100.0);
        }
        this.tableFinancialDiscount.setItems(FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller));
        this.filter();
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void actionNew(ActionEvent event) {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("selectedFinancialDiscount", null);
        this.controller.showModalDialog("Interna Otpremnica - Detalji", ScreensController.SCREEN_BACKOFFICE_FINANSIJSKI_POPUST_DIALOG, hm, this.rootPane.getScene().getWindow());
        this.tableFinancialDiscount.setItems(FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller));
    }

    @FXML
    private void actionEdit(ActionEvent event) {
        if (this.tableFinancialDiscount.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("selectedFinancialDiscount", this.tableFinancialDiscount.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Interna Otpremnica - Detalji", ScreensController.SCREEN_BACKOFFICE_FINANSIJSKI_POPUST_DIALOG, hm, this.rootPane.getScene().getWindow());
            this.tableFinancialDiscount.setItems(FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller));
        } else {
            this.controller.alert("Obavestenje", "Odaberite finansijski popust iz tabele koju zelite da izmenite", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void actionDelete() {
        if (this.tableFinancialDiscount.getSelectionModel().getSelectedItem() != null) {
            ((FinancialDiscount)this.tableFinancialDiscount.getSelectionModel().getSelectedItem()).delete(this.controller);
        } else {
            this.controller.alert("Obavestenje", "Odaberite finansijski popust iz tabele koju zelite da obrisete", this.rootPane.getScene().getWindow());
        }
        this.tableFinancialDiscount.setItems(FinancialDiscount.getFinancialDiscountsList((ScreensController)this.controller));
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableFinancialDiscount.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(financialDiscount -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return financialDiscount.getName() != null && financialDiscount.getName().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableFinancialDiscount.comparatorProperty());
        this.tableFinancialDiscount.setItems((ObservableList)sortedData);
    }
}

