/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.enums.BuyerCostCenter;
import rs.petcom.enums.BuyerIdentification;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;

public class TINInsertController
implements DialogController {
    private ScreensController controller;
    private HashMap<String, Object> parameter;
    private Map<String, String> buyerIdsMap;
    private Map<String, String> buyerCenterId;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfSerialNumber;
    @FXML
    private TextField tfBuyerCostCenter;
    @FXML
    private TextField tfSerialNumberOption;
    @FXML
    private Label labInputHeadLine;
    @FXML
    private ComboBox<String> comboByerType;
    @FXML
    private ComboBox<String> comboByerTypeOption;
    @FXML
    private CheckBox checkBox;
    @FXML
    private CheckBox checkBoxOption;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        String headLine = (String)parameter.get("headLine");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.labInputHeadLine.setText(headLine);
        ((Stage)this.rootPane.getScene().getWindow()).setResizable(false);
        this.buyerIdsMap = this.loadBuyersIdentificationCombo();
        this.comboByerType.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> obs, String oldValue, String newValue) {
                if ("Predra\u010dun za kupca".equals(newValue)) {
                    TINInsertController.this.labInputHeadLine.setText("Unesite pib za kupca ");
                } else {
                    TINInsertController.this.labInputHeadLine.setText("Unesite " + newValue);
                }
            }
        });
        this.labInputHeadLine.setText("Unesite " + (String)this.comboByerType.getValue());
        this.buyerCenterId = this.loadBuyersIdentificationComboOption();
    }

    private Map<String, String> loadBuyersIdentificationCombo() {
        BuyerIdentification[] buyerIds;
        HashMap<String, String> buyerIdsMap = new HashMap<String, String>();
        for (BuyerIdentification buyerId : buyerIds = BuyerIdentification.values()) {
            this.comboByerType.getItems().add((Object)buyerId.getDescription());
            buyerIdsMap.put(buyerId.getDescription(), buyerId.getCode());
        }
        this.comboByerType.getSelectionModel().select(0);
        return buyerIdsMap;
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
    }

    @FXML
    void cancelAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void confirmAction(ActionEvent event) {
        String tin;
        String code = this.buyerIdsMap.get(this.comboByerType.getValue());
        if ("12".equals(code)) {
            if (this.tfSerialNumber.getText().trim().contains(":")) {
                tin = code + ":" + this.tfSerialNumber.getText().trim();
                this.parameter.put("tin", tin);
                ((Stage)this.rootPane.getScene().getWindow()).close();
                if (this.checkBox.isSelected()) {
                    this.parameter.put("predracun", "predracun");
                } else {
                    this.parameter.put("predracun", "racun");
                }
            } else {
                this.controller.alert("Obave\u0161tenje", "Morate uneti u sledecem formatu PIB:JBKJS", this.rootPane.getScene().getWindow());
            }
        } else {
            tin = code + ":" + this.tfSerialNumber.getText().trim();
            this.parameter.put("tin", tin);
            ((Stage)this.rootPane.getScene().getWindow()).close();
            if (this.checkBox.isSelected()) {
                this.parameter.put("predracun", "predracun");
            } else {
                this.parameter.put("predracun", "racun");
            }
        }
        if (this.checkBoxOption.isSelected() && (this.tfBuyerCostCenter.getText() == null || this.tfBuyerCostCenter.getText().isEmpty())) {
            this.controller.alert("Upozorenje", "Identifikacija opciono polje kupca ne sme biti prazno", this.rootPane.getScene().getWindow());
            return;
        }
        if (this.checkBoxOption.isSelected()) {
            String code1 = this.buyerCenterId.get(this.comboByerTypeOption.getValue());
            String identification = code1 + ":" + this.tfBuyerCostCenter.getText().trim();
            this.parameter.put("identification", identification);
        }
    }

    @FXML
    void confirmActionCheck(ActionEvent event) {
        if (this.checkBox.isSelected()) {
            this.parameter.put("predracun", "predracun");
        } else {
            this.parameter.put("predracun", "racun");
        }
    }

    @FXML
    public void confirmActionCheckOption(ActionEvent actionEvent) {
    }

    private Map<String, String> loadBuyersIdentificationComboOption() {
        BuyerCostCenter[] costCenters;
        HashMap<String, String> buyerIdsMap = new HashMap<String, String>();
        for (BuyerCostCenter center : costCenters = BuyerCostCenter.values()) {
            this.comboByerTypeOption.getItems().add((Object)center.getDescription());
            buyerIdsMap.put(center.getDescription(), center.getCode());
        }
        this.comboByerTypeOption.getSelectionModel().select(0);
        return buyerIdsMap;
    }
}

