/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.enums.BuyerIdentification;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Round;

public class TINInsertAvansController
implements DialogController {
    private ScreensController controller;
    private HashMap<String, Object> parameter;
    private Map<String, String> buyerIdsMap;
    private int modalResult;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TextField tfSerialNumber;
    @FXML
    private TextField tfRefNumber;
    @FXML
    private TextField tfSum;
    @FXML
    private Label labInputHeadLine;
    @FXML
    private ComboBox<String> comboByerType;
    @FXML
    private CheckBox checkBox;
    @FXML
    private CheckBox checkBoxKonacni;
    @FXML
    private CheckBox checkBoxRefundacija;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        String headLine = (String)parameter.get("headLine");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.labInputHeadLine.setText(headLine);
        ((Stage)this.rootPane.getScene().getWindow()).setResizable(false);
        this.buyerIdsMap = this.loadBuyersIdentificationCombo();
        this.comboByerType.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> obs, String oldValue, String newValue) {
                if ("Predra\u010dun za kupca".equals(newValue)) {
                    TINInsertAvansController.this.labInputHeadLine.setText("Unesite pib za kupca ");
                } else {
                    TINInsertAvansController.this.labInputHeadLine.setText("Unesite " + newValue);
                }
            }
        });
        this.labInputHeadLine.setText("Unesite " + (String)this.comboByerType.getValue());
    }

    private Map<String, String> loadBuyersIdentificationCombo() {
        BuyerIdentification[] buyerIds;
        HashMap<String, String> buyerIdsMap = new HashMap<String, String>();
        for (BuyerIdentification buyerId : buyerIds = BuyerIdentification.values()) {
            this.comboByerType.getItems().add((Object)buyerId.getDescription());
            buyerIdsMap.put(buyerId.getDescription(), buyerId.getCode());
        }
        this.comboByerType.getSelectionModel().select(0);
        return buyerIdsMap;
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
    }

    @FXML
    void cancelAction(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void confirmAction(ActionEvent event) {
        if (this.checkBox.isSelected() && this.checkBoxKonacni.isSelected()) {
            this.controller.alert("Obave\u0161tenje", "Morate oznaciti samo jedno polje", this.rootPane.getScene().getWindow());
            return;
        }
        if (this.checkBox.isSelected() && this.checkBoxRefundacija.isSelected()) {
            this.controller.alert("Obave\u0161tenje", "Morate oznaciti samo jedno polje", this.rootPane.getScene().getWindow());
            return;
        }
        if (this.checkBoxRefundacija.isSelected() && this.checkBoxKonacni.isSelected()) {
            this.controller.alert("Obave\u0161tenje", "Morate oznaciti samo jedno polje", this.rootPane.getScene().getWindow());
            return;
        }
        String code = this.buyerIdsMap.get(this.comboByerType.getValue());
        if ("12".equals(code)) {
            if (this.tfSerialNumber.getText().trim().contains(":")) {
                String tin = code + ":" + this.tfSerialNumber.getText().trim();
                this.parameter.put("tin", tin);
                ((Stage)this.rootPane.getScene().getWindow()).close();
                if (this.checkBox.isSelected()) {
                    this.parameter.put("avanstin", "avanstin");
                }
            } else {
                this.controller.alert("Obave\u0161tenje", "Morate uneti u sledecem formatu PIB:JBKJS", this.rootPane.getScene().getWindow());
            }
        } else {
            ArrayList roundItems;
            ArrayList roundList;
            Bill round;
            int i;
            ArrayList roundItemList;
            String tin = code + ":" + this.tfSerialNumber.getText().trim();
            this.parameter.put("tin", tin);
            ((Stage)this.rootPane.getScene().getWindow()).close();
            if (this.checkBox.isSelected()) {
                this.getTin(tin);
                this.parameter.put("avanstin", "avanstin");
            }
            if (this.checkBoxKonacni.isSelected()) {
                this.getTin(tin);
                this.parameter.put("avanstin", "konacniracun");
                roundItemList = this.controller.getBillList();
                for (i = 0; i < roundItemList.size(); ++i) {
                    round = (Bill)roundItemList.get(0);
                    roundList = round.getRoundList();
                    roundItems = ((Round)roundList.get(0)).getItemList();
                    roundItems.clear();
                }
            }
            if (this.checkBoxRefundacija.isSelected()) {
                this.getTin(tin);
                this.parameter.put("avanstin", "refundacija");
                roundItemList = this.controller.getBillList();
                for (i = 0; i < roundItemList.size(); ++i) {
                    round = (Bill)roundItemList.get(0);
                    roundList = round.getRoundList();
                    roundItems = ((Round)roundList.get(0)).getItemList();
                    roundItems.clear();
                }
            }
            if (this.checkBox.isSelected() && this.tfRefNumber.getText() != null && !this.tfRefNumber.getText().isEmpty()) {
                roundItemList = this.controller.getBillList();
                for (i = 0; i < roundItemList.size(); ++i) {
                    round = (Bill)roundItemList.get(0);
                    roundList = round.getRoundList();
                    roundItems = ((Round)roundList.get(0)).getItemList();
                    roundItems.clear();
                }
            }
            this.parameter.put("tfSum", this.tfSum.getText());
            this.parameter.put("tfRefNumber", this.tfRefNumber.getText());
        }
    }

    @FXML
    void confirmActionCheck(ActionEvent event) {
        if (this.checkBox.isSelected()) {
            this.parameter.put("avanstin", "avanstin");
            if (this.checkBoxKonacni.isSelected()) {
                this.parameter.put("avanstin", "konacniracun");
            }
        }
    }

    private void getTin(String tin) {
        if (this.tfSerialNumber != null && this.tfSerialNumber.getText() != null && this.tfSerialNumber.getText().trim().isEmpty()) {
            this.parameter.put("tin", "");
        }
    }

    @FXML
    public void confirmActionCheckRefundacija(ActionEvent actionEvent) {
        if (this.checkBoxRefundacija.isSelected()) {
            this.parameter.put("avanstin", "refundacija");
        }
    }
}

