/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.SravnjenjePoPopisu;
import rs.petcom.master.dal.document.SravnjenjePoPopisuDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class SravnjenjePoPopisuDetailesController
implements DialogController {
    private ScreensController controller;
    private SravnjenjePoPopisu sravnjenjePoPopisu;
    private int modalResult;
    private ArrayList<SravnjenjePoPopisuDetailes> deletedItems = new ArrayList();
    private ListView<SravnjenjePoPopisuDetailes> list;
    private SravnjenjePoPopisuDetailes spd;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DateTimePicker dtpDate;
    @FXML
    private TextField tfFilter;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnAddProduct;
    @FXML
    private GridPane gpContainer;
    @FXML
    private Button btnRemove;
    @FXML
    private CheckBox cbAllProducts;
    @FXML
    private TableView<SravnjenjePoPopisuDetailes> table;
    @FXML
    private TableColumn<SravnjenjePoPopisuDetailes, String> tcCode;
    @FXML
    private TableColumn<SravnjenjePoPopisuDetailes, String> tcName;
    @FXML
    private TableColumn<SravnjenjePoPopisuDetailes, String> tcBarcode;
    @FXML
    private TableColumn<SravnjenjePoPopisuDetailes, Double> tcRazlika;
    @FXML
    private TableColumn<SravnjenjePoPopisuDetailes, Double> tcStock;
    @FXML
    private TableColumn<Object, Double> tcQuantity;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfQuantityForTable;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.sravnjenjePoPopisu = (SravnjenjePoPopisu)parameter.get("sravnjenjePoPopisu");
        this.dtpDate.setValue((Object)Settings.fromDate((Date)this.sravnjenjePoPopisu.getDate()));
        if ((Boolean)parameter.get("selectAllProducts") != null) {
            this.cbAllProducts.setSelected(true);
            this.loadAllProducts();
        }
        this.deletedItems.clear();
        this.tfNapomena.setText(this.sravnjenjePoPopisu.getNote());
        this.tfFilter.requestFocus();
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.gpContainer.getChildren().size() > 1) {
                this.gpContainer.getChildren().remove(1);
            }
            this.gpContainer.add(this.populateFilterList((String)newValue), 0, 0);
        });
        this.tfFilter.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DOWN & SravnjenjePoPopisuDetailesController.this.list != null && !SravnjenjePoPopisuDetailesController.this.list.getItems().isEmpty()) {
                    SravnjenjePoPopisuDetailesController.this.list.requestFocus();
                    SravnjenjePoPopisuDetailesController.this.list.getSelectionModel().select(0);
                }
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    @FXML
    private void loadAllProducts() {
        if (this.cbAllProducts.isSelected()) {
            ObservableList lista = SravnjenjePoPopisuDetailes.getlist((SravnjenjePoPopisu)this.sravnjenjePoPopisu, (ScreensController)this.controller);
            if (lista.size() >= 300) {
                this.controller.alert("Obavestenje!", "Ucitano je prvih 300 artikala!", this.rootPane.getScene().getWindow());
            }
            this.table.setItems(lista);
            this.table.requestFocus();
        } else {
            this.table.getItems().clear();
        }
    }

    private ListView<SravnjenjePoPopisuDetailes> populateFilterList(String filterText) {
        this.gpContainer.getChildren().clear();
        this.list = new ListView();
        ObservableList listFromDb = SravnjenjePoPopisuDetailes.getFilteredList((String)filterText, (SravnjenjePoPopisu)this.sravnjenjePoPopisu, (ScreensController)this.controller);
        if (listFromDb.isEmpty()) {
            this.gpContainer.setVisible(false);
            return this.list;
        }
        this.list.getItems().addAll((Collection)listFromDb);
        this.gpContainer.setVisible(true);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
            MultipleSelectionModel<SravnjenjePoPopisuDetailes> selected;
            {
                this.selected = SravnjenjePoPopisuDetailesController.this.list.getSelectionModel();
            }

            public void handle(KeyEvent event) {
                SravnjenjePoPopisuDetailes sravnjenje = (SravnjenjePoPopisuDetailes)SravnjenjePoPopisuDetailesController.this.list.getSelectionModel().getSelectedItem();
                if (event.getCode() == KeyCode.ENTER) {
                    if (!SravnjenjePoPopisuDetailesController.this.table.getItems().contains((Object)sravnjenje)) {
                        SravnjenjePoPopisuDetailesController.this.actionAddProduct(sravnjenje, ((SravnjenjePoPopisuDetailes)this.selected.getSelectedItem()).getProductID());
                    }
                    SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().select((Object)sravnjenje);
                    int index = SravnjenjePoPopisuDetailesController.this.table.getItems().indexOf((Object)sravnjenje);
                    SravnjenjePoPopisuDetailesController.this.table.getFocusModel().focus(index);
                    SravnjenjePoPopisuDetailesController.this.tfQuantity.requestFocus();
                    SravnjenjePoPopisuDetailesController.this.gpContainer.setVisible(false);
                }
                if (event.getCode() == KeyCode.UP & this.selected.getSelectedIndex() == 0) {
                    SravnjenjePoPopisuDetailesController.this.tfFilter.requestFocus();
                }
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SravnjenjePoPopisuDetailes sppd = (SravnjenjePoPopisuDetailes)SravnjenjePoPopisuDetailesController.this.list.getSelectionModel().getSelectedItem();
                if (event.getClickCount() == 2) {
                    if (!SravnjenjePoPopisuDetailesController.this.table.getItems().contains((Object)sppd)) {
                        SravnjenjePoPopisuDetailesController.this.table.getItems().add((Object)sppd);
                    }
                    SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().select((Object)sppd);
                    SravnjenjePoPopisuDetailesController.this.tfQuantity.requestFocus();
                    SravnjenjePoPopisuDetailesController.this.gpContainer.setVisible(false);
                }
            }
        });
        return this.list;
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcRazlika.setCellValueFactory((Callback)new PropertyValueFactory("Razlika"));
        this.tcRazlika.setCellFactory(this.getDoubleCallBack(2));
        this.tcStock.setCellValueFactory((Callback)new PropertyValueFactory("PocetnoStanje"));
        this.tcStock.setCellFactory(this.getDoubleCallBack(2));
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Popisano"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                SravnjenjePoPopisuDetailes data = (SravnjenjePoPopisuDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                data.setPopisano(((Double)t.getNewValue()).doubleValue());
                data.setRazlika(data.getPopisano() - data.getPocetnoStanje());
                SravnjenjePoPopisuDetailesController.this.table.refresh();
            }
        });
        this.tcBarcode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<SravnjenjePoPopisuDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<SravnjenjePoPopisuDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject((long)((SravnjenjePoPopisuDetailes)param.getValue()).getProductID(), (Connection)SravnjenjePoPopisuDetailesController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tfQuantity.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case UP: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() - 1);
                    break;
                }
                case DOWN: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
                    break;
                }
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    this.spd = (SravnjenjePoPopisuDetailes)this.table.getSelectionModel().getSelectedItem();
                    try {
                        double d = Double.parseDouble(this.tfQuantity.getText());
                        if (d < 0.0) {
                            this.controller.alert("Upozorenje", "Koli\u010dina ne mo\u017ee biti negativna", this.rootPane.getScene().getWindow());
                            this.tfQuantity.setText("");
                            return;
                        }
                        ((SravnjenjePoPopisuDetailes)this.table.getSelectionModel().getSelectedItem()).setPopisano(d);
                    }
                    catch (NumberFormatException ex) {
                        ((SravnjenjePoPopisuDetailes)this.table.getSelectionModel().getSelectedItem()).setPopisano(0.0);
                    }
                    this.spd.setRazlika(this.spd.getPopisano() - this.spd.getPocetnoStanje());
                    this.tfFilter.setText("");
                    this.tfFilter.requestFocus();
                    keyValue.consume();
                    this.table.refresh();
                    this.tfQuantity.setText("");
                    break;
                }
            }
        });
        this.table.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    SravnjenjePoPopisuDetailesController.this.tfQuantity.setVisible(false);
                    SravnjenjePoPopisuDetailesController.this.tfQuantityForTable.setVisible(true);
                    SravnjenjePoPopisuDetailesController.this.tfQuantityForTable.requestFocus();
                }
            }
        });
        this.tfQuantityForTable.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    try {
                        double d = Double.parseDouble(SravnjenjePoPopisuDetailesController.this.tfQuantityForTable.getText());
                        if (d < 0.0) {
                            SravnjenjePoPopisuDetailesController.this.controller.alert("Upozorenje", "Koli\u010dina ne mo\u017ee biti negativna", SravnjenjePoPopisuDetailesController.this.rootPane.getScene().getWindow());
                            SravnjenjePoPopisuDetailesController.this.tfQuantityForTable.setText("");
                            return;
                        }
                        ((SravnjenjePoPopisuDetailes)SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().getSelectedItem()).setPopisano(d);
                    }
                    catch (NumberFormatException ex) {
                        ((SravnjenjePoPopisuDetailes)SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().getSelectedItem()).setPopisano(0.0);
                    }
                    SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().select(SravnjenjePoPopisuDetailesController.this.table.getSelectionModel().getSelectedIndex() + 1);
                    SravnjenjePoPopisuDetailesController.this.tfQuantityForTable.setText("");
                    SravnjenjePoPopisuDetailesController.this.table.refresh();
                }
                if (t.getCode() == KeyCode.UP || t.getCode() == KeyCode.DOWN) {
                    SravnjenjePoPopisuDetailesController.this.table.requestFocus();
                }
            }
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionSave(ActionEvent event) {
        boolean ispravnaKolicina = true;
        for (SravnjenjePoPopisuDetailes spd : this.table.getItems()) {
            if (!(spd.getPopisano() < 0.0)) continue;
            ispravnaKolicina = false;
        }
        if (ispravnaKolicina) {
            int i;
            this.sravnjenjePoPopisu.setNote(this.tfNapomena.getText());
            if (this.sravnjenjePoPopisu.getDocumentID() > 0L) {
                this.sravnjenjePoPopisu.update(this.controller);
            } else {
                try {
                    this.sravnjenjePoPopisu.insert(this.controller);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
            }
            for (i = 0; i < this.table.getItems().size(); ++i) {
                if (((SravnjenjePoPopisuDetailes)this.table.getItems().get(i)).getSravnjenjePoPopisuDetailesID() > 0L) {
                    ((SravnjenjePoPopisuDetailes)this.table.getItems().get(i)).update(this.controller);
                    continue;
                }
                ((SravnjenjePoPopisuDetailes)this.table.getItems().get(i)).setSravnjenjePoPopisuID(this.sravnjenjePoPopisu.getDocumentID());
                Long id = ((SravnjenjePoPopisuDetailes)this.table.getItems().get(i)).insert(this.controller);
                ((SravnjenjePoPopisuDetailes)this.table.getItems().get(i)).setSravnjenjePoPopisuDetailesID(id.longValue());
            }
        } else {
            this.controller.alert("Upozorenje", "Koli\u010dina ne mo\u017ee biti negativna", this.rootPane.getScene().getWindow());
            return;
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionAdd() {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int mr = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            Product product = (Product)hm.get("product");
            SravnjenjePoPopisuDetailes poPopisuDetailes = new SravnjenjePoPopisuDetailes();
            poPopisuDetailes.setDate(LocalDateTime.now());
            poPopisuDetailes.setSravnjenjePoPopisuDetailesID(-1L);
            poPopisuDetailes.setSravnjenjePoPopisuID(this.sravnjenjePoPopisu.getDocumentID());
            poPopisuDetailes.setProductID(product.getProductID());
            poPopisuDetailes.setProductCode(product.getCode());
            poPopisuDetailes.setProductName(product.getName());
            Barcode barcode = Barcode.getBarCodeObject((long)product.getProductID(), (Connection)this.controller.getSettings().getConnection());
            poPopisuDetailes.setBarcode(barcode.getBarCode());
            try {
                double stock = Product.getNewCurrentStock((ScreensController)this.controller, (LocalDateTime)WorkDay.datumPocetnogStanja((int)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), (Date)Settings.DatefromLocalDateTime((LocalDateTime)poPopisuDetailes.getDate()), (Connection)this.controller.getSettings().getConnection()), (LocalDateTime)WorkDay.getDateToForDep((LocalDate)Settings.fromDate((Date)new Timestamp(Settings.DatefromLocalDateTime((LocalDateTime)poPopisuDetailes.getDate()).getTime())), (int)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), (Connection)this.controller.getSettings().getConnection()), (long)poPopisuDetailes.getProductID());
                poPopisuDetailes.setPocetnoStanje(stock);
            }
            catch (SQLException e1) {
                poPopisuDetailes.setPocetnoStanje(0.0);
            }
            poPopisuDetailes.setRazlika(poPopisuDetailes.getPopisano() - poPopisuDetailes.getPocetnoStanje());
            if (!this.table.getItems().contains((Object)poPopisuDetailes)) {
                this.table.getItems().add((Object)poPopisuDetailes);
            }
            this.table.refresh();
            this.table.getSelectionModel().select((Object)poPopisuDetailes);
            this.tfQuantity.setText("");
        }
    }

    private void actionAddProduct(SravnjenjePoPopisuDetailes sravnjenje, long productId) {
        sravnjenje.setDate(LocalDateTime.now());
        sravnjenje.setSravnjenjePoPopisuDetailesID(-1L);
        sravnjenje.setSravnjenjePoPopisuID(this.sravnjenjePoPopisu.getDocumentID());
        try {
            double stock = Product.getNewCurrentStock((ScreensController)this.controller, (LocalDateTime)WorkDay.datumPocetnogStanja((int)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), (Date)Settings.DatefromLocalDateTime((LocalDateTime)sravnjenje.getDate()), (Connection)this.controller.getSettings().getConnection()), (LocalDateTime)WorkDay.getDateToForDep((LocalDate)Settings.fromDate((Date)new Timestamp(Settings.DatefromLocalDateTime((LocalDateTime)sravnjenje.getDate()).getTime())), (int)Department.getByPOS((PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection()).getDepartmentID(), (Connection)this.controller.getSettings().getConnection()), (long)productId);
            sravnjenje.setPocetnoStanje(stock);
        }
        catch (SQLException e1) {
            sravnjenje.setPocetnoStanje(0.0);
        }
        sravnjenje.setRazlika(sravnjenje.getPopisano() - sravnjenje.getPocetnoStanje());
        this.table.getItems().add((Object)sravnjenje);
        this.table.refresh();
        this.table.getSelectionModel().select((Object)sravnjenje);
        this.tfQuantity.setText("");
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            if (((SravnjenjePoPopisuDetailes)this.table.getSelectionModel().getSelectedItem()).getSravnjenjePoPopisuDetailesID() > 0L) {
                this.deletedItems.add((SravnjenjePoPopisuDetailes)this.table.getSelectionModel().getSelectedItem());
            }
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    public Callback<TableColumn<SravnjenjePoPopisuDetailes, Double>, TableCell<SravnjenjePoPopisuDetailes, Double>> getDoubleCallBack(final int numberOfDigits) {
        return new Callback<TableColumn<SravnjenjePoPopisuDetailes, Double>, TableCell<SravnjenjePoPopisuDetailes, Double>>(){

            public TableCell<SravnjenjePoPopisuDetailes, Double> call(TableColumn<SravnjenjePoPopisuDetailes, Double> param) {
                return new TableCell<SravnjenjePoPopisuDetailes, Double>(){

                    protected void updateItem(Double item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null) {
                            this.setText(null);
                        } else {
                            this.setText(Settings.getNumberFormat((int)numberOfDigits, (boolean)true).format(item));
                        }
                    }
                };
            }
        };
    }

    public int checkIfExist(long productID) {
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (((SravnjenjePoPopisuDetailes)this.table.getItems().get(i)).getProductID() != productID) continue;
            return i;
        }
        return -1;
    }
}

