/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.enums.BuyerIdentification;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.DialogController;
import rs.petcom.master.PosPrint.ESCPosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.NalogZaIspravku;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.fical.Izvestaji;
import rs.petcom.master.newFiscalization.badrequest.BadRequestHandler;
import rs.petcom.master.newFiscalization.badrequest.ModelState;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.RefundInvoiceRequest;
import rs.petcom.master.newFiscalization.print.BillFooter;
import rs.petcom.master.newFiscalization.print.BillPrint;
import rs.petcom.master.newFiscalization.print.JasperPrintBill;
import rs.petcom.master.newFiscalization.print.JasperStarter;

public class RefundDetailsController
implements DialogController {
    private Connection connection;
    private ScreensController controller;
    private ObservableList<DocumentDetails> refundDetails;
    private Map<String, String> buyerIdsMap;
    private boolean printA4;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<DocumentDetails> tblRefundDetails;
    @FXML
    private TableColumn<DocumentDetails, String> tcProductName;
    @FXML
    private TableColumn<DocumentDetails, Double> tcProductQuantity;
    @FXML
    private TableColumn<DocumentDetails, Double> tcProductPrice;
    @FXML
    private TableColumn<DocumentDetails, Double> tcProductValue;
    @FXML
    private Label labHeadLine;
    @FXML
    private Label lblInstruction;
    @FXML
    private ComboBox<String> comboByerType;
    @FXML
    private ComboBox<PaymentMethod> cbPayments;
    @FXML
    private TextField tfByerIdentification;
    private InvoiceType invoiceType;
    private Document document;
    private Person person;
    private String refNumberTextFieldl;

    public void setParameter(HashMap<String, Object> parameter) {
        String referentNumber;
        this.refNumberTextFieldl = referentNumber = (String)parameter.get("referentNumber");
        this.refundDetails = (ObservableList)parameter.get("refundDetails");
        this.controller = (ScreensController)parameter.get("controller");
        this.connection = this.controller.getSettings().getConnection();
        this.document = Document.getByIDREfund((long)((DocumentDetails)this.refundDetails.get(0)).getDocumentID(), (Connection)this.connection);
        this.person = Person.getById((long)this.document.getPersonID(), (ScreensController)this.controller);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.tcProductName.setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        this.tcProductQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.tcProductPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.tcProductValue.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.comboByerType.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> obs, String oldValue, String newValue) {
                RefundDetailsController.this.lblInstruction.setText("Unesite " + newValue);
            }
        });
        this.labHeadLine.setText("Detalji ra\u010duna za referentni broj:" + referentNumber);
        this.buyerIdsMap = this.loadBuyersIdentificationCombo();
        this.loadPaymants();
        this.lblInstruction.setText("Unesite " + (String)this.comboByerType.getValue());
        this.invoiceType = InvoiceType.REFUND_NORMAL;
        if (this.controller.getSettings().isTrainingMode()) {
            this.invoiceType = InvoiceType.REFUND_TRAINING;
        } else if (this.document.getDocumentTypeID() == 20) {
            this.invoiceType = InvoiceType.REFUND_PROFORMA;
        }
        this.printA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("print.A4"));
        this.loadTable();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return 0;
    }

    public void setModalResult(int modalResult) {
    }

    @FXML
    void confirmAction(ActionEvent event) {
        if (this.tfByerIdentification.getText().trim().isEmpty()) {
            this.controller.alert("Obave\u0161tenje", (String)this.comboByerType.getValue() + " ne sme biti prazan", this.rootPane.getScene().getWindow());
            return;
        }
        String code = this.buyerIdsMap.get(this.comboByerType.getValue());
        String buyer = code + ":" + this.tfByerIdentification.getText().trim();
        int index = this.cbPayments.getSelectionModel().getSelectedIndex();
        PaymentMethod payment = (PaymentMethod)this.cbPayments.getItems().get(index);
        payment.setCode(this.adjustPaymentCode(payment.getCode()));
        RefundInvoiceRequest refundRequest = new RefundInvoiceRequest(this.controller, this.refundDetails, buyer, payment, null);
        Document document1 = Document.getByID((long)((DocumentDetails)this.refundDetails.get(0)).getDocumentID(), (Connection)this.connection);
        InvoiceType invoiceType = InvoiceType.REFUND_NORMAL;
        if (document1.getDocumentTypeID() == 20) {
            invoiceType = InvoiceType.REFUND_PROFORMA;
        }
        if (this.controller.getSettings().isTrainingMode()) {
            invoiceType = InvoiceType.REFUND_TRAINING;
        }
        InvoiceResponse refundResponse = refundRequest.getInvoiceResponse(invoiceType);
        InvoiceBody refundBody = refundRequest.getBody();
        ModelState[] states = refundResponse.getModelState();
        if (states != null) {
            BadRequestHandler brHandler = new BadRequestHandler(this.controller, states, this.rootPane.getScene().getWindow());
            brHandler.handleBadRequest();
        }
        NalogZaIspravku ni = new NalogZaIspravku();
        long documentId = 0L;
        try {
            documentId = ni.insertRefund(this.controller, refundRequest.getBody(), refundResponse, this.refundDetails, payment, invoiceType);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Document document = Document.getByID((long)documentId, (Connection)this.connection);
        RefundInvoiceRequest refundCopyRequest = new RefundInvoiceRequest(this.controller, this.refundDetails, buyer, payment, document);
        InvoiceResponse refundResponseCopy = refundCopyRequest.getInvoiceResponse(InvoiceType.REFUND_COPY);
        ModelState[] modelStates = refundResponseCopy.getModelState();
        if (modelStates != null) {
            BadRequestHandler handler = new BadRequestHandler(this.controller, modelStates, this.rootPane.getScene().getWindow());
            handler.handleBadRequest();
            return;
        }
        if (this.printA4) {
            Person person = Person.getById((long)document.getPersonID(), (ScreensController)this.controller);
            if (person != null && person.getPersonID() < 1L) {
                person = null;
            }
            String path = ScreensController.SCREEN_JASPER_BILL_REF;
            HashMap<String, Object> reportResources = new HashMap<String, Object>();
            ObservableList billPrints = Izvestaji.vatRateDocuemntId((Connection)this.controller.getSettings().getConnection(), (Long)documentId, (InvoiceResponse)refundResponse);
            reportResources.put("datasTax", this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
            reportResources.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints.get(0), refundResponseCopy));
            reportResources.put("adtionalFooterName", this.getBillFooterNameFild());
            reportResources.put("qrUrl", refundResponse.getVerificationUrl());
            reportResources.put("RefBroj", " Ref broj: " + this.refNumberTextFieldl);
            reportResources.put("refVreme", " Ref vreme: " + refundResponse.getSdcDateTime());
            reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
            reportResources.put("poptpisKupca", " ");
            reportResources.put("controller", this.controller);
            ObservableList images = Images.getImagesList((ScreensController)this.controller);
            if (!images.isEmpty()) {
                reportResources.put("image", ((Images)images.get(0)).getImage());
            }
            reportResources.put("napomena", Bill.getBillNote((long)documentId, (ScreensController)this.controller));
            if (this.document.getDocumentTypeID() == 20) {
                for (BillPrint billPrint : ((BillFooter)billPrints.get(0)).getBillPrints()) {
                    billPrint.setTotalAmount(BigDecimal.valueOf(-0.0));
                    billPrint.setBasicPrice(BigDecimal.valueOf(-0.0));
                    billPrint.setRateValue(BigDecimal.valueOf(-0.0));
                }
            }
            LocalDateTime localDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
            String formatDateTime = localDateTime.format(formatter);
            reportResources.put("dateTime", formatDateTime);
            reportResources.put("infoCompany", JasperPrintBill.getInformationCompany((ScreensController)this.controller));
            reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany((ScreensController)this.controller));
            reportResources.put("typeBill", "=================================================FISKALNI RA\u010cUN=================================================");
            reportResources.put("krajRacuna", "===================================================KRAJ FISKALNOG RA\u010cUNA===============================================");
            reportResources.put("supplier", JasperPrintBill.getSupplier((InvoiceResponse)refundResponse, (InvoiceBody)refundBody));
            reportResources.put("customer", JasperPrintBill.getCusomer((Long)documentId, (Person)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson(), (ScreensController)this.controller));
            reportResources.put("nameBill", "PROMET REFUNDACIJA\n" + refundResponse.getInvoiceNumber());
            JasperStarter starter = new JasperStarter(reportResources, path, this.rootPane);
            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
            String path1 = ScreensController.SCREEN_JASPER_BILL_REF;
            HashMap<String, Object> reportResources1 = new HashMap<String, Object>();
            ObservableList billPrints1 = Izvestaji.vatRateDocuemntId((Connection)this.controller.getSettings().getConnection(), (Long)documentId, (InvoiceResponse)refundResponse);
            reportResources1.put("datasTax", this.getBillTax(((BillFooter)billPrints1.get(0)).getBillPrintMap()));
            reportResources1.put("adtionalFooter", this.getBillFooter((BillFooter)billPrints1.get(0), refundResponseCopy));
            reportResources1.put("adtionalFooterName", this.getBillFooterNameFild());
            reportResources1.put("qrUrl", refundResponse.getVerificationUrl());
            reportResources1.put("RefBroj", " Ref broj: " + this.refNumberTextFieldl);
            reportResources1.put("refVreme", " Ref vreme: " + refundResponse.getSdcDateTime());
            reportResources1.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
            reportResources1.put("poptpisKupca", " ");
            reportResources1.put("controller", this.controller);
            if (!images.isEmpty()) {
                reportResources1.put("image", ((Images)images.get(0)).getImage());
            }
            reportResources1.put("napomena", Bill.getBillNote((long)documentId, (ScreensController)this.controller));
            LocalDateTime localDateTime1 = LocalDateTime.now();
            DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
            String formatDateTime1 = localDateTime1.format(formatter1);
            reportResources.put("dateTime", formatDateTime1);
            reportResources1.put("infoCompany", JasperPrintBill.getInformationCompany((ScreensController)this.controller));
            reportResources1.put("addressCompany", JasperPrintBill.fetAddressCompany((ScreensController)this.controller));
            reportResources.put("poptpisKupca", " ");
            reportResources1.put("typeBill", "=============================================OVO NIJE FISKALNI RA\u010cUN=================================================");
            reportResources1.put("krajRacuna", "==============================================OVO NIJE FISKALNI RA\u010cUN===============================================");
            reportResources1.put("krajRacunaRefund", "================================OVO NIJE FISKALNI RA\u010cUN==============================");
            reportResources1.put("supplier", JasperPrintBill.getSupplier((InvoiceResponse)refundResponse, (InvoiceBody)refundBody));
            reportResources1.put("customer", JasperPrintBill.getCusomer((Long)documentId, (Person)((Bill)this.controller.getBillList().get(this.controller.getActiveBill())).getPerson(), (ScreensController)this.controller));
            reportResources1.put("nameBill", "KOPIJA REFUNDACIJA\n" + refundResponse.getInvoiceNumber());
            JasperStarter starter1 = new JasperStarter(reportResources1, path1, this.rootPane);
            starter1.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
        } else {
            ESCPosPrint posPrint = new ESCPosPrint(refundBody, refundResponse, document, this.controller);
            posPrint.printFiscalRefund(invoiceType, document);
        }
        if (invoiceType != InvoiceType.REFUND_TRAINING) {
            for (DocumentDetails detail : this.refundDetails) {
                DocumentDetails.updateRefundQuantity((Connection)this.connection, (DocumentDetails)detail);
            }
            User user = this.controller.getUser();
            Department department = null;
            try {
                department = Department.getById((int)1, (Connection)this.controller.getSettings().getConnection());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (!this.printA4) {
                ESCPosPrint posPrintCopy = new ESCPosPrint(refundRequest.getBody(), refundResponseCopy, document, this.controller);
                posPrintCopy.printFiscalRefund(InvoiceType.REFUND_COPY, document);
            }
            document.setDocumentTypeID(33);
            document.setDate(new Date());
            document.setDeliveryDate(new Date());
            document.setCurrencyDate(new Date());
            document.setSysDTCreated(new Date());
            document.setSysDTEdit(new Date());
            document.setSysUserAddID(user.getUserID());
            document.setSysUserEditID(user.getUserID());
            document.setReferentDateTime(refundResponseCopy.getSdcDateTime());
            document.setBuyerIdentification(refundRequest.getBody().getBuyerId());
            document.setReferentNumber(refundResponseCopy.getInvoiceNumber());
            document.setNumber(Document.getNextNumber((int)33, (Department)department, (ScreensController)this.controller, (LocalDate)LocalDate.now()));
            long docCopyId = document.insert(this.controller);
            ArrayList details = DocumentDetails.getList((long)documentId, (Connection)this.controller.getSettings().getConnection());
            for (DocumentDetails detail : details) {
                document.setClosed(Boolean.valueOf(true));
                detail.setDocumentID(docCopyId);
                detail.insert(this.controller.getSettings().getConnection());
            }
        }
        ni.updateDocument(this.controller, refundRequest.getDocument().getDocumentID());
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void cancelAction(ActionEvent event) {
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    void reduceQuantity(ActionEvent event) {
        int index = this.tblRefundDetails.getSelectionModel().getSelectedIndex();
        double quantity = ((DocumentDetails)this.refundDetails.get(index)).getQuantity() - 1.0;
        double price = ((DocumentDetails)this.refundDetails.get(index)).getPrice();
        if (quantity == 0.0) {
            this.refundDetails.remove(index);
        } else {
            ((DocumentDetails)this.refundDetails.get(index)).setQuantity(quantity);
            ((DocumentDetails)this.refundDetails.get(index)).setValue(quantity * price);
        }
        this.tblRefundDetails.refresh();
    }

    @FXML
    void removeRow(ActionEvent event) {
        int index = this.tblRefundDetails.getSelectionModel().getSelectedIndex();
        this.refundDetails.remove(index);
        this.tblRefundDetails.refresh();
    }

    private void loadTable() {
        this.tblRefundDetails.setItems(this.refundDetails);
    }

    private Map<String, String> loadBuyersIdentificationCombo() {
        BuyerIdentification[] buyerIds;
        HashMap<String, String> buyerIdsMap = new HashMap<String, String>();
        String bi = this.document.getBuyerIdentification();
        for (BuyerIdentification buyerId : buyerIds = BuyerIdentification.values()) {
            this.comboByerType.getItems().add((Object)buyerId.getDescription());
            buyerIdsMap.put(buyerId.getDescription(), buyerId.getCode());
        }
        this.comboByerType.getSelectionModel().select(0);
        return buyerIdsMap;
    }

    private void loadPaymants() {
        ObservableList paymentethods = PaymentMethod.getList((ScreensController)this.controller);
        for (PaymentMethod method : paymentethods) {
            if (method.getCode().equalsIgnoreCase("COMBINED")) continue;
            this.cbPayments.getItems().add((Object)method);
        }
        this.cbPayments.getSelectionModel().select(0);
    }

    private String adjustPaymentCode(String paymentCode) {
        String lcCode = paymentCode.toLowerCase();
        String capCode = lcCode.substring(0, 1).toUpperCase() + lcCode.substring(1);
        return capCode;
    }

    private List<BillPrint> getBillTax(Map<String, BillPrint> billPrintMap) {
        ArrayList<BillPrint> billPrints = new ArrayList<BillPrint>();
        for (Map.Entry<String, BillPrint> hm : billPrintMap.entrySet()) {
            billPrints.add(hm.getValue());
        }
        return billPrints;
    }

    private String getBillFooter(BillFooter billFooter, InvoiceResponse refundResponseCopy) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" " + billFooter.getSum());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getSumTax());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getPayment());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentDateTime());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentNumber());
        stringBuilder.append("\n");
        stringBuilder.append(" " + refundResponseCopy.getInvoiceCounter());
        return stringBuilder.toString();
    }

    private String getBillFooterNameFild() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Za uplatu: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Porez ukupno: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Na\u010dina placanja: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Prf vreme: ");
        stringBuilder.append("\n");
        stringBuilder.append(" PFR broj ra\u010duna: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Broja\u010d ra\u010duna: ");
        return stringBuilder.toString();
    }
}

