/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.PocetnoStanje;
import rs.petcom.master.dal.document.PocetnoStanjeDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;

public class PocetnoStanjeDetailesController
implements DialogController {
    private ScreensController controller;
    private PocetnoStanje pocetnoStanje;
    private int modalResult;
    private Connection connection;
    ObservableList<Product> stockList;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DatePicker dtpDate;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private Button btnImport;
    @FXML
    private Button btnInitialKep;
    @FXML
    private TableView<PocetnoStanjeDetailes> table;
    @FXML
    private TableColumn<PocetnoStanjeDetailes, String> tcCode;
    @FXML
    private TableColumn<PocetnoStanjeDetailes, String> tcName;
    @FXML
    private TableColumn<PocetnoStanjeDetailes, String> tcBarCode;
    @FXML
    private TableColumn<Object, Double> tcQuantity;
    @FXML
    private TableColumn<Object, Double> tcSellPrice;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantityForTable;
    @FXML
    private GridPane gpContainer;
    @FXML
    private Label lblVrednostPocetnogStanja;
    private ListView<PocetnoStanjeDetailes> list;
    private boolean kep;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;

    public void setParameter(HashMap<String, Object> parameter) {
        LocalDate ld;
        this.controller = (ScreensController)parameter.get("controller");
        this.pocetnoStanje = (PocetnoStanje)parameter.get("pocetnoStanje");
        this.stockList = Product.getNewProductStockList((ScreensController)this.controller);
        this.kep = (Boolean)parameter.get("kep");
        this.connection = this.controller.getSettings().getConnection();
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        if (this.pocetnoStanje.getDocumentID() >= 1L) {
            ld = Settings.fromDate((Date)this.pocetnoStanje.getDate());
            this.dtpDate.setValue((Object)ld);
        } else {
            ld = Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDate());
            this.dtpDate.setValue((Object)ld);
            this.dtpDate.valueProperty().addListener((observable, oldDate, newDate) -> {
                if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                    this.dtpDate.setValue((Object)this.lastDocumentLockDate.plusDays(1L));
                    this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
                }
            });
        }
        if ((Boolean)parameter.get("selectAllProducts") != null) {
            this.loadAllProducts();
        }
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.gpContainer.getChildren().size() > 1) {
                this.gpContainer.getChildren().remove(1);
            }
            this.gpContainer.add(this.populateFilterList((String)newValue), 0, 0);
        });
        this.tfFilter.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DOWN & PocetnoStanjeDetailesController.this.list != null && !PocetnoStanjeDetailesController.this.list.getItems().isEmpty()) {
                    PocetnoStanjeDetailesController.this.list.requestFocus();
                    PocetnoStanjeDetailesController.this.list.getSelectionModel().select(0);
                }
            }
        });
        this.tfFilter.focusedProperty().addListener((obs, wasFocused, isNowFocused) -> {
            if (isNowFocused.booleanValue()) {
                this.tfFilter.clear();
            }
        });
        this.tfNapomena.setText(this.pocetnoStanje.getNote());
        this.tfFilter.requestFocus();
        this.tfQuantity.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case UP: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() - 1);
                    break;
                }
                case DOWN: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
                    break;
                }
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    this.editQuantity(this.tfQuantity.getText());
                    this.tfQuantity.setText("");
                    this.tfFilter.setText("");
                    this.tfFilter.requestFocus();
                    keyValue.consume();
                    break;
                }
            }
        });
        this.table.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & PocetnoStanjeDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    PocetnoStanjeDetailesController.this.tfQuantity.setVisible(false);
                }
            }
        });
        this.table.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<PocetnoStanjeDetailes>(){

            public void onChanged(ListChangeListener.Change<? extends PocetnoStanjeDetailes> c) {
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        if (this.kep) {
            LocalDate initialKepDate = ((LocalDate)this.dtpDate.getValue()).with(TemporalAdjusters.firstDayOfYear());
            this.dtpDate.setValue((Object)initialKepDate);
            this.dtpDate.setDisable(true);
            this.tfFilter.setDisable(true);
            this.tfQuantity.setDisable(true);
            this.btnAdd.setDisable(true);
            this.btnRemove.setDisable(true);
            this.btnImport.setDisable(true);
            this.btnInitialKep.setVisible(true);
            this.loadInitialStockForKep();
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcBarCode.setCellValueFactory((Callback)new PropertyValueFactory("barcode"));
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((PocetnoStanjeDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow())).setQuantity(((Double)t.getNewValue()).doubleValue());
                PocetnoStanjeDetailesController.this.sumPocetnoStanje();
            }
        });
        this.tcSellPrice.setCellValueFactory((Callback)new PropertyValueFactory("SellPrice"));
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void importAction() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import pocetno stanje");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        PocetnoStanjeDetailesController.this.list = new ListView();
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)PocetnoStanjeDetailesController.this.controller, (long)3L)) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Bar Kod") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colBarcode = i;
                                    }
                                }
                            } else {
                                Product product = Product.getByBarcode((String)colNames[colBarcode], (Connection)PocetnoStanjeDetailesController.this.controller.getSettings().getConnection());
                                if (product == null) {
                                    product = Product.getByCode((String)colNames[colBarcode], (Connection)PocetnoStanjeDetailesController.this.controller.getSettings().getConnection());
                                }
                                if (product != null) {
                                    PocetnoStanjeDetailes pd = new PocetnoStanjeDetailes(new Long(-1L).longValue(), PocetnoStanjeDetailesController.this.pocetnoStanje.getDocumentID(), product.getProductID(), product.getCode(), product.getName(), colNames[colBarcode], Double.parseDouble(colNames[colQuantity]), product.getCurrentPriceBeforeDatePrijemnica(Settings.fromLocalDate((LocalDate)((LocalDate)PocetnoStanjeDetailesController.this.dtpDate.getValue())), (long)PocetnoStanjeDetailesController.this.pocetnoStanje.getDepartmentID(), PocetnoStanjeDetailesController.this.controller.getSettings().getConnection()));
                                    PocetnoStanjeDetailesController.this.list.getItems().add((Object)pd);
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.table.setItems(this.list.getItems());
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    @FXML
    public void actionSave(ActionEvent event) {
        final Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Upisivanje po\u010detnog stanja u toku...", this.rootPane.getScene().getWindow());
        Task<Void> creatingReport = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    LocalDate ld = (LocalDate)PocetnoStanjeDetailesController.this.dtpDate.getValue();
                    if (PocetnoStanjeDetailesController.this.pocetnoStanje.getDocumentID() != -1L) {
                        PocetnoStanjeDetailesController.this.pocetnoStanje.setStatus("Overen");
                        PocetnoStanjeDetailesController.this.pocetnoStanje.setNote(PocetnoStanjeDetailesController.this.tfNapomena.getText());
                        PocetnoStanjeDetailesController.this.pocetnoStanje.update(PocetnoStanjeDetailesController.this.controller, Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    } else {
                        PocetnoStanjeDetailesController.this.pocetnoStanje.setStatus("Overen");
                        PocetnoStanjeDetailesController.this.pocetnoStanje.setNote(PocetnoStanjeDetailesController.this.tfNapomena.getText());
                        PocetnoStanjeDetailesController.this.pocetnoStanje.insert(PocetnoStanjeDetailesController.this.controller, Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    }
                    for (int i = 0; i < PocetnoStanjeDetailesController.this.table.getItems().size(); ++i) {
                        if (((PocetnoStanjeDetailes)PocetnoStanjeDetailesController.this.table.getItems().get(i)).getPocetnoStanjeDetailesID() == -1L) {
                            ((PocetnoStanjeDetailes)PocetnoStanjeDetailesController.this.table.getItems().get(i)).setPocetnoStanjeID(PocetnoStanjeDetailesController.this.pocetnoStanje.getDocumentID());
                            ((PocetnoStanjeDetailes)PocetnoStanjeDetailesController.this.table.getItems().get(i)).insert(PocetnoStanjeDetailesController.this.controller);
                            continue;
                        }
                        ((PocetnoStanjeDetailes)PocetnoStanjeDetailesController.this.table.getItems().get(i)).update(PocetnoStanjeDetailesController.this.controller);
                    }
                }
                catch (Exception e) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            taskUpdateStage.hide();
                            PocetnoStanjeDetailesController.this.controller.alert("Obave\u0161tenje", "Neuspe\u0161an update/insert po\u010detnog stanja: " + e.getMessage(), PocetnoStanjeDetailesController.this.rootPane.getScene().getWindow());
                        }
                    });
                }
                return null;
            }
        };
        new Thread((Runnable)creatingReport).start();
        creatingReport.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        });
        creatingReport.exceptionProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        creatingReport.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisivanja po\u010detnog stanja. ", this.rootPane.getScene().getWindow());
        });
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int mr = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            Product product = (Product)hm.get("product");
            PocetnoStanjeDetailes psdInTable = null;
            boolean postoji = false;
            for (PocetnoStanjeDetailes pd : this.table.getItems()) {
                if (product.getProductID() != pd.getProductID()) continue;
                postoji = true;
                psdInTable = pd;
                break;
            }
            if (!postoji) {
                double pocetno = 0.0;
                for (Product p : this.stockList) {
                    if (p.getProductID() != product.getProductID()) continue;
                    pocetno = p.getStock();
                }
                PocetnoStanjeDetailes pd = new PocetnoStanjeDetailes(new Long(-1L).longValue(), this.pocetnoStanje.getDocumentID(), product.getProductID(), product.getCode(), product.getName(), Barcode.getBarCode((long)product.getProductID(), (Connection)this.controller.getSettings().getConnection()), 0.0, product.getCurrentPriceBeforeDatePrijemnica(Settings.fromLocalDate((LocalDate)((LocalDate)this.dtpDate.getValue())), (long)this.pocetnoStanje.getDepartmentID(), this.controller.getSettings().getConnection()));
                pd.setPocetno(pocetno);
                this.table.getItems().add((Object)pd);
                this.table.getSelectionModel().select((Object)pd);
                this.table.scrollTo((Object)pd);
                this.tfQuantity.requestFocus();
            } else {
                this.table.getSelectionModel().select(psdInTable);
                this.controller.alert("Artikal je ve\u0107 unet u listu!", "Artikal je ve\u0107 unet u listu!", this.rootPane.getScene().getWindow());
            }
        }
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            if (((PocetnoStanjeDetailes)this.table.getSelectionModel().getSelectedItem()).getPocetnoStanjeDetailesID() > 0L) {
                ((PocetnoStanjeDetailes)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            }
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
        this.loadAllProducts();
    }

    @FXML
    private void loadAllProducts() {
        this.table.setItems(PocetnoStanjeDetailes.getlist((PocetnoStanje)this.pocetnoStanje, (String)"", (ScreensController)this.controller));
        this.sumPocetnoStanje();
    }

    private void sumPocetnoStanje() {
        double vrednost = 0.0;
        for (PocetnoStanjeDetailes pocetnoStanjeDetailes : this.table.getItems()) {
            vrednost += pocetnoStanjeDetailes.getQuantity() * pocetnoStanjeDetailes.getSellPrice();
        }
        this.lblVrednostPocetnogStanja.setText(Settings.getNumberFormat((int)2, (boolean)false).format(vrednost));
    }

    private ListView<PocetnoStanjeDetailes> populateFilterList(String filterText) {
        this.gpContainer.getChildren().clear();
        this.list = new ListView();
        ObservableList listFromDb = PocetnoStanjeDetailes.getFilteredList((String)filterText, (Long)new Long(-1L), (Connection)this.controller.getSettings().getConnection(), (LocalDate)((LocalDate)this.dtpDate.getValue()));
        if (listFromDb.isEmpty()) {
            this.gpContainer.setVisible(false);
            return this.list;
        }
        this.list.getItems().addAll((Collection)listFromDb);
        this.gpContainer.setVisible(true);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
            MultipleSelectionModel<PocetnoStanjeDetailes> selected;
            {
                this.selected = PocetnoStanjeDetailesController.this.list.getSelectionModel();
            }

            public void handle(KeyEvent event) {
                double pocetno = 0.0;
                PocetnoStanjeDetailes psd = (PocetnoStanjeDetailes)PocetnoStanjeDetailesController.this.list.getSelectionModel().getSelectedItem();
                ObservableList datas = FXCollections.observableArrayList();
                for (Product p : PocetnoStanjeDetailesController.this.stockList) {
                    if (p.getProductID() != psd.getProductID()) continue;
                    pocetno = p.getStock();
                }
                psd.setPocetno(pocetno);
                datas.addAll((Collection)PocetnoStanjeDetailesController.this.table.getItems());
                if (event.getCode() == KeyCode.ENTER) {
                    if (!datas.contains((Object)psd)) {
                        datas.add((Object)psd);
                        PocetnoStanjeDetailesController.this.table.getItems().clear();
                        PocetnoStanjeDetailesController.this.table.getItems().addAll((Collection)datas);
                    }
                    PocetnoStanjeDetailesController.this.table.getSelectionModel().select((Object)psd);
                    int index = PocetnoStanjeDetailesController.this.table.getItems().indexOf((Object)psd);
                    PocetnoStanjeDetailesController.this.table.getFocusModel().focus(index);
                    PocetnoStanjeDetailesController.this.table.scrollTo(index);
                    PocetnoStanjeDetailesController.this.tfQuantity.requestFocus();
                    PocetnoStanjeDetailesController.this.gpContainer.setVisible(false);
                    PocetnoStanjeDetailesController.this.sumPocetnoStanje();
                }
                if (event.getCode() == KeyCode.UP & this.selected.getSelectedIndex() == 0) {
                    PocetnoStanjeDetailesController.this.tfFilter.requestFocus();
                }
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                PocetnoStanjeDetailes psd = (PocetnoStanjeDetailes)PocetnoStanjeDetailesController.this.list.getSelectionModel().getSelectedItem();
                if (event.getClickCount() == 2) {
                    if (!PocetnoStanjeDetailesController.this.table.getItems().contains((Object)psd)) {
                        PocetnoStanjeDetailesController.this.table.getItems().add((Object)psd);
                    }
                    PocetnoStanjeDetailesController.this.table.getSelectionModel().select((Object)psd);
                    int index = PocetnoStanjeDetailesController.this.table.getItems().indexOf((Object)psd);
                    PocetnoStanjeDetailesController.this.table.getFocusModel().focus(index);
                    PocetnoStanjeDetailesController.this.table.scrollTo(index);
                    PocetnoStanjeDetailesController.this.tfQuantity.requestFocus();
                    PocetnoStanjeDetailesController.this.gpContainer.setVisible(false);
                    PocetnoStanjeDetailesController.this.sumPocetnoStanje();
                }
            }
        });
        return this.list;
    }

    private void editQuantity(String number) {
        double currentQuantity = 0.0;
        currentQuantity = ((PocetnoStanjeDetailes)this.table.getSelectionModel().getSelectedItem()).getQuantity();
        if (number.contains(",")) {
            ((PocetnoStanjeDetailes)this.table.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(number.replace(",", ".")) + currentQuantity);
        } else {
            ((PocetnoStanjeDetailes)this.table.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(number) + currentQuantity);
        }
        this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
        this.table.refresh();
        this.sumPocetnoStanje();
    }

    @FXML
    private void loadInitialStockForKep() {
        final LocalDate initialKepDate = (LocalDate)this.dtpDate.getValue();
        boolean initialStockExsists = PocetnoStanje.initialStockExsistsOnDate((LocalDate)initialKepDate, (Connection)this.connection);
        if (initialStockExsists) {
            this.controller.alert("Upozorenje", "Po\u010detno stanje je ve\u0107 uneto na izabrani datum.", this.rootPane.getScene().getWindow());
            return;
        }
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
        Task<Void> initialStockKepTask = new Task<Void>(){

            protected Void call() throws Exception {
                LocalDate stockDate = initialKepDate.minusDays(1L);
                ObservableList initialStockDetails = FXCollections.observableArrayList();
                ObservableList listaAditionalFields = FXCollections.observableArrayList();
                ObservableList productStockList = Product.getNewReceivingReport((String)"", (ObservableList)listaAditionalFields, (String)"", (ScreensController)PocetnoStanjeDetailesController.this.controller, (int)1, (LocalDate)stockDate, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
                for (Product p : productStockList) {
                    PocetnoStanjeDetailes initialStockDetail = new PocetnoStanjeDetailes(new Long(-1L).longValue(), PocetnoStanjeDetailesController.this.pocetnoStanje.getDocumentID(), p.getProductID(), p.getCode(), p.getName(), p.getBarcode(), p.getStock(), p.getPrice());
                    initialStockDetails.add((Object)initialStockDetail);
                }
                PocetnoStanjeDetailesController.this.table.setItems(initialStockDetails);
                return null;
            }
        };
        initialStockKepTask.setOnSucceeded(eventValue -> taskUpdateStage.close());
        new Thread((Runnable)initialStockKepTask).start();
    }
}

