/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class OtpremnicaDetailesController
implements DialogController {
    private ScreensController controller;
    private Document otpremnica;
    private int modalResult;
    private ArrayList<DocumentDetails> deletedItems = new ArrayList();
    private ListView<DocumentDetails> list;
    private ObservableList<Person> personList = FXCollections.observableArrayList();
    private Department department;
    Person person;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DateTimePicker dtpDate;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private TableView<DocumentDetails> table;
    @FXML
    private TableColumn<DocumentDetails, String> tcCode;
    @FXML
    private TableColumn<DocumentDetails, String> tcName;
    @FXML
    private TableColumn<DocumentDetails, String> tcBarCode;
    @FXML
    private TableColumn<DocumentDetails, Double> tcCena;
    @FXML
    private TableColumn<Object, Double> tcQuantity;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfQuantityForTable;
    @FXML
    private GridPane gpContainer;
    @FXML
    private ComboBox<Person> cbBuyer;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.department = (Department)parameter.get("department");
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        try {
            this.otpremnica = (Document)parameter.get("otpremnica");
            this.dtpDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.otpremnica.getDate()));
            this.tfNapomena.setText(this.otpremnica.getNote());
        }
        catch (NullPointerException e) {
            this.otpremnica = new Document();
            this.otpremnica.setDocumentID(new Long(-1L).longValue());
            this.dtpDate.setValue((Object)Settings.fromDate((Date)new Date()));
            this.dtpDate.valueProperty().addListener((observable, oldDate, newDate) -> {
                if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                    this.dtpDate.setValue((Object)this.lastDocumentLockDate.plusDays(1L));
                    this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
                }
            });
            this.tfNapomena.setText("");
        }
        this.tfQuantity.setText("1.00");
        this.loadTable();
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.gpContainer.getChildren().size() > 1) {
                this.gpContainer.getChildren().remove(1);
            }
            this.gpContainer.add(this.populateFilterList((String)newValue), 0, 0);
        });
        this.loadBuyerComboBox();
        this.tfFilter.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DOWN & OtpremnicaDetailesController.this.list != null && !OtpremnicaDetailesController.this.list.getItems().isEmpty()) {
                    OtpremnicaDetailesController.this.list.requestFocus();
                    OtpremnicaDetailesController.this.list.getSelectionModel().select(0);
                }
            }
        });
        this.deletedItems.clear();
        this.tfQuantity.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case UP: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() - 1);
                    break;
                }
                case DOWN: {
                    this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
                    break;
                }
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    this.editQuantity(this.tfQuantity.getText());
                    this.tfQuantity.setText("1.00");
                    this.tfFilter.setText("");
                    this.tfFilter.requestFocus();
                    this.gpContainer.setVisible(false);
                    keyValue.consume();
                    break;
                }
            }
        });
        this.table.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & OtpremnicaDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    OtpremnicaDetailesController.this.tfQuantity.setVisible(false);
                    OtpremnicaDetailesController.this.tfQuantityForTable.setVisible(true);
                    OtpremnicaDetailesController.this.tfQuantityForTable.requestFocus();
                }
            }
        });
        this.tfQuantityForTable.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER & OtpremnicaDetailesController.this.table.getSelectionModel().getSelectedItem() != null) {
                    OtpremnicaDetailesController.this.editQuantity(OtpremnicaDetailesController.this.tfQuantityForTable.getText());
                    OtpremnicaDetailesController.this.tfQuantityForTable.setText("");
                }
                if (t.getCode() == KeyCode.UP || t.getCode() == KeyCode.DOWN) {
                    OtpremnicaDetailesController.this.table.requestFocus();
                }
            }
        });
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DocumentDetails, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DocumentDetails, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject((long)((DocumentDetails)param.getValue()).getProductID(), (Connection)OtpremnicaDetailesController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (Exception e) {
                    try {
                        return new JavaBeanStringPropertyBuilder().bean(param.getValue()).name("Code").build();
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
            }
        });
        this.tcCena.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((DocumentDetails)t.getTableView().getItems().get(t.getTablePosition().getRow())).setQuantity(((Double)t.getNewValue()).doubleValue());
            }
        });
    }

    @FXML
    private void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void actionImport() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setGroupingUsed(false);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import prijemnice");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje detalja u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<Void> loadingCsvTask = new Task<Void>(){

                protected Void call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colQuantity = -1;
                    int colBarcode = -1;
                    int counterRow = 0;
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        OtpremnicaDetailesController.this.list = new ListView();
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)OtpremnicaDetailesController.this.controller, (long)2L)) {
                                        if (csvImport.getCsvName().equals("Kolicina") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                            colQuantity = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Bar Kod") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                        colBarcode = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)OtpremnicaDetailesController.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    p.getCurrentPrice((long)OtpremnicaDetailesController.this.department.getDepartmentID(), OtpremnicaDetailesController.this.controller.getSettings().getConnection());
                                    DocumentDetails dd = new DocumentDetails();
                                    dd.setDocumentID(new Long(-1L).longValue());
                                    dd.setProductID(p.getProductID());
                                    dd.setProductCode(p.getCode());
                                    dd.setProductName(p.getName());
                                    dd.setBarcode(colNames[colBarcode]);
                                    dd.setQuantity((double)Integer.parseInt(colNames[colQuantity]));
                                    dd.setPrice(p.getPrice());
                                    OtpremnicaDetailesController.this.list.getItems().add((Object)dd);
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            };
            loadingCsvTask.setOnSucceeded(eventValue -> {
                taskUpdateStage.hide();
                this.table.setItems(this.list.getItems());
                if (unexistedProducts.size() > 0) {
                    this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
                }
            });
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    @FXML
    private void newBuyerAction() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", PersonCategory.BUYER);
        int result = this.controller.showModalDialog("Dodavanje komitenta", ScreensController.DIALOG_ADD_PERSON, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            this.loadBuyerComboBox();
        }
    }

    @FXML
    public void actionSave(ActionEvent event) {
        block12: {
            try {
                WorkDay workDay = WorkDay.getFromDbByDate((LocalDate)((LocalDate)this.dtpDate.getValue()), (Connection)this.controller.getSettings().getConnection());
                if (workDay == null) {
                    this.controller.alert("Obavestenje", "Ne postoji radni dan za ovaj datum, odaberite drugi datum.", this.rootPane.getScene().getWindow());
                    return;
                }
                if (this.otpremnica.getDocumentID() > 0L) {
                    this.otpremnica.setSysDTEdit(new Date());
                    this.otpremnica.setNote(this.tfNapomena.getText());
                    this.otpremnica.setDate(Settings.DatefromLocalDateTime((LocalDateTime)Settings.LocalDateTimefromDate((Date)workDay.getDateFrom()).plusSeconds(20L)));
                    this.otpremnica.setWorkDayID(workDay.getWorkDayID());
                    this.otpremnica.update(this.controller);
                    break block12;
                }
                this.otpremnica.setDocumentTypeID(DocumentType.getByCode((String)"OT", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
                this.otpremnica.setDocumentStatusID(1);
                this.otpremnica.setDepartmentID(this.department.getDepartmentID());
                this.otpremnica.setPointOfSaleID(1);
                this.otpremnica.setNumber(Document.getNextNumber((int)this.otpremnica.getDocumentTypeID(), (long)this.otpremnica.getPointOfSaleID(), (ScreensController)this.controller));
                this.otpremnica.setYear(Year.now().getValue());
                this.otpremnica.setDate(workDay.getDateFrom() == null ? new Date() : Settings.DatefromLocalDateTime((LocalDateTime)Settings.LocalDateTimefromDate((Date)workDay.getDateFrom()).plusSeconds(20L)));
                this.otpremnica.setDeliveryDate(workDay.getDateFrom() == null ? new Date() : Settings.DatefromLocalDateTime((LocalDateTime)Settings.LocalDateTimefromDate((Date)workDay.getDateFrom()).plusSeconds(20L)));
                this.otpremnica.setCurrencyDate(workDay.getDateFrom() == null ? new Date() : Settings.DatefromLocalDateTime((LocalDateTime)Settings.LocalDateTimefromDate((Date)workDay.getDateFrom()).plusSeconds(20L)));
                this.otpremnica.setNote(this.tfNapomena.getText());
                this.otpremnica.setPlace(Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection()).getCity());
                this.otpremnica.setPaymentMethodID(PaymentMethod.getByCode((String)"OTP", (Connection)this.controller.getSettings().getConnection()).getPaymentMethodID());
                try {
                    this.otpremnica.setWorkDayID(workDay.getWorkDayID());
                }
                catch (NullPointerException e) {
                    this.otpremnica.setWorkDayID(1L);
                }
                this.otpremnica.setSysDTCreated(new Date());
                this.otpremnica.setSysUserAddID(this.controller.getUser().getUserID());
                if (((Person)this.cbBuyer.getSelectionModel().getSelectedItem()).getPersonID() == -1L) {
                    this.controller.alert("Obavestenje", "Morate odabrati komitenta", this.rootPane.getScene().getWindow());
                    return;
                }
                this.otpremnica.setPersonID(((Person)this.cbBuyer.getSelectionModel().getSelectedItem()).getPersonID());
                this.otpremnica.setWorkDayID(WorkDay.getLastOpenWD((ScreensController)this.controller).getWorkDayID());
                this.otpremnica.insert(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.deletedItems.size(); ++i) {
            this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
        }
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.table.getItems()) {
            sum += documentDetails.getPrice() * documentDetails.getQuantity();
            if (documentDetails.getDocumentID() > 0L) {
                documentDetails.update(this.controller);
                continue;
            }
            documentDetails.setDocumentID(this.otpremnica.getDocumentID());
            documentDetails.setPriceWithDiscount(documentDetails.getPrice());
            documentDetails.setSysDTCreated(new Date());
            documentDetails.setSysUserAddID(this.otpremnica.getSysUserAddID());
            documentDetails.setUnitID(1);
            documentDetails.setVatID(1);
            documentDetails.setProduct(Product.getByID((long)documentDetails.getProductID(), (ScreensController)this.controller));
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        try {
            this.otpremnica.setSum(sum);
            this.otpremnica.setSumWithDiscount(sum);
            this.otpremnica.setPaid(sum);
            this.otpremnica.update(this.controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        int mr = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            Product product = (Product)hm.get("product");
            DocumentDetails psdInTable = null;
            boolean postoji = false;
            for (DocumentDetails documentDetails : this.table.getItems()) {
                if (product.getProductID() != documentDetails.getProductID()) continue;
                postoji = true;
                psdInTable = documentDetails;
                break;
            }
            if (!postoji) {
                DocumentDetails dd = new DocumentDetails();
                dd.setDocumentID(new Long(-1L).longValue());
                dd.setProductID(product.getProductID());
                dd.setProductCode(product.getCode());
                dd.setProductName(product.getName());
                dd.setBarcode(Barcode.getBarCode((long)product.getProductID(), (Connection)this.controller.getSettings().getConnection()));
                dd.setQuantity(0.0);
                product.getCurrentPriceAndDiscount(new PointOfSale(1, this.controller.getSettings().getConnection()), this.controller.getSettings().getConnection());
                dd.setPrice(product.getPrice());
                this.table.getItems().add((Object)dd);
                this.table.getSelectionModel().select((Object)dd);
                this.table.scrollTo((Object)dd);
                this.tfQuantity.requestFocus();
            } else {
                this.table.getSelectionModel().select(psdInTable);
                this.controller.alert("Artikal je ve\u0107 unet u listu!", "Artikal je ve\u0107 unet u listu!", this.rootPane.getScene().getWindow());
            }
        }
        this.tfQuantity.setText("1.00");
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            if (((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).getDocumentID() > 0L) {
                this.deletedItems.add((DocumentDetails)this.table.getSelectionModel().getSelectedItem());
            }
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    private ListView<DocumentDetails> populateFilterList(String filterText) {
        this.gpContainer.getChildren().clear();
        this.list = new ListView();
        ObservableList listFromDb = DocumentDetails.getFilteredList((String)filterText, (Document)this.otpremnica, (Department)this.department, (ScreensController)this.controller);
        if (listFromDb.isEmpty()) {
            this.gpContainer.setVisible(false);
            return this.list;
        }
        this.list.getItems().addAll((Collection)listFromDb);
        this.gpContainer.setVisible(true);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
            MultipleSelectionModel<DocumentDetails> selected;
            {
                this.selected = OtpremnicaDetailesController.this.list.getSelectionModel();
            }

            public void handle(KeyEvent event) {
                DocumentDetails psd = (DocumentDetails)OtpremnicaDetailesController.this.list.getSelectionModel().getSelectedItem();
                if (event.getCode() == KeyCode.ENTER) {
                    if (!OtpremnicaDetailesController.this.table.getItems().contains((Object)psd)) {
                        OtpremnicaDetailesController.this.table.getItems().add((Object)psd);
                    }
                    OtpremnicaDetailesController.this.table.getSelectionModel().select((Object)psd);
                    int index = OtpremnicaDetailesController.this.table.getItems().indexOf((Object)psd);
                    OtpremnicaDetailesController.this.table.getFocusModel().focus(index);
                    OtpremnicaDetailesController.this.tfQuantity.requestFocus();
                    OtpremnicaDetailesController.this.gpContainer.setVisible(false);
                }
                if (event.getCode() == KeyCode.UP & this.selected.getSelectedIndex() == 0) {
                    OtpremnicaDetailesController.this.tfFilter.requestFocus();
                }
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DocumentDetails psd = (DocumentDetails)OtpremnicaDetailesController.this.list.getSelectionModel().getSelectedItem();
                if (event.getClickCount() == 2) {
                    if (!OtpremnicaDetailesController.this.table.getItems().contains((Object)psd)) {
                        OtpremnicaDetailesController.this.table.getItems().add((Object)psd);
                    }
                    OtpremnicaDetailesController.this.table.getSelectionModel().select((Object)psd);
                    OtpremnicaDetailesController.this.tfQuantity.requestFocus();
                    OtpremnicaDetailesController.this.gpContainer.setVisible(false);
                }
            }
        });
        return this.list;
    }

    private void editQuantity(String number) {
        try {
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(number));
            this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
        }
        catch (NumberFormatException e) {
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setQuantity(0.0);
        }
        this.table.refresh();
    }

    private void loadBuyerComboBox() {
        this.cbBuyer.getItems().clear();
        Person person = new Person();
        person.setPersonID(-1L);
        person.setName("Svi kupci");
        this.cbBuyer.getItems().add((Object)person);
        this.cbBuyer.getSelectionModel().select((Object)person);
        this.personList = Person.getPersonsByersList((ScreensController)this.controller);
        for (Person p : this.personList) {
            this.cbBuyer.getItems().add((Object)p);
            if (this.otpremnica == null || this.otpremnica.getPersonID() != p.getPersonID()) continue;
            this.cbBuyer.getSelectionModel().select((Object)p);
        }
    }

    private void loadTable() {
        if (this.otpremnica != null) {
            this.table.setItems(DocumentDetails.getObeservableList((long)this.otpremnica.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
        }
    }
}

