/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.NalogZaIspravku;
import rs.petcom.master.dal.document.NalogZaIspravkuDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class NalogZaIspravkuDetailesController
implements DialogController {
    ScreensController controller;
    NalogZaIspravku nalogZaIspravku;
    int modalResult;
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    ArrayList<NalogZaIspravkuDetailes> deletedItems = new ArrayList();
    Department department;
    DocumentDetails documentDetails;
    private LocalDate lastDocumentLockDate;
    private boolean documentLockIsActive;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DateTimePicker dcDate;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnRemove;
    @FXML
    private TableView<NalogZaIspravkuDetailes> table;
    @FXML
    private TableColumn<NalogZaIspravkuDetailes, String> tcCode;
    @FXML
    private TableColumn<NalogZaIspravkuDetailes, String> tcName;
    @FXML
    private TableColumn<Object, Double> tcQuantity;
    @FXML
    private TableColumn<Object, Double> tcPrice;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfBI;
    @FXML
    private TextField tfIBFM;
    @FXML
    private TextField tfJMBG;
    @FXML
    private TextField tfFirstLastName;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private ComboBox<Product> cbProduct;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.nalogZaIspravku = (NalogZaIspravku)parameter.get("nalogZaIspravku");
        this.department = (Department)parameter.get("department");
        this.lastDocumentLockDate = (LocalDate)parameter.get("lastDocumentLockDate");
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        if (this.nalogZaIspravku.getDocumentID() != -1L) {
            this.dcDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.nalogZaIspravku.getDateFrom()));
        } else {
            this.dcDate.setDateTimeValue(Settings.LocalDateTimefromDate((Date)this.nalogZaIspravku.getDate()));
            this.dcDate.valueProperty().addListener((observable, oldDate, newDate) -> {
                if (this.documentLockIsActive && (newDate.isEqual(this.lastDocumentLockDate) || newDate.isBefore(this.lastDocumentLockDate))) {
                    this.dcDate.setValue((Object)this.lastDocumentLockDate.plusDays(1L));
                    this.controller.alert("Upozorenje", "Ne mo\u017eete izabrati datum za koji su zaklju\u010dani dokumenti ", this.rootPane.getScene().getWindow());
                }
            });
        }
        this.table.setItems(NalogZaIspravkuDetailes.getList((NalogZaIspravku)this.nalogZaIspravku, (Connection)this.controller.getSettings().getConnection()));
        this.tfBI.setText(this.nalogZaIspravku.getBi());
        this.tfIBFM.setText(this.nalogZaIspravku.getIbfm());
        this.tfFirstLastName.setText(this.nalogZaIspravku.getFirstLastName());
        this.tfJMBG.setText(this.nalogZaIspravku.getJmbg());
        this.deletedItems.clear();
        this.tfNapomena.setText(this.nalogZaIspravku.getNote());
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.cbFilterType.getItems().addAll((Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilterType.getSelectionModel().selectFirst();
        this.cbFilterType.setOnAction(actionEvent -> this.cbProductAutoComplete.setFilterType((String)this.cbFilterType.getSelectionModel().getSelectedItem()));
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, this.department.getDepartmentID(), ScreensController.FILTER_ALL, this.tfPrice);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
        DoubleTableCellFactory cellFactoryPrice = new DoubleTableCellFactory(2, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                NalogZaIspravkuDetailes data = (NalogZaIspravkuDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                data.setQuantity(((Double)t.getNewValue()).doubleValue());
            }
        });
        this.tcPrice.setCellFactory((Callback)cellFactoryPrice);
        this.tcPrice.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                NalogZaIspravkuDetailes data = (NalogZaIspravkuDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                data.setPrice(((Double)t.getNewValue()).doubleValue());
            }
        });
        this.tfJMBG.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("|[-\\+]?|[-\\+]?\\d+\\.?|[-\\+]?\\d+\\.?\\d+")) {
                    NalogZaIspravkuDetailesController.this.tfJMBG.setText(oldValue);
                }
            }
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionSave(ActionEvent event) {
        try {
            int i;
            this.nalogZaIspravku.setNote(this.tfNapomena.getText());
            if (this.nalogZaIspravku.getDocumentID() != -1L) {
                this.nalogZaIspravku.setDate(this.nalogZaIspravku.getDate());
            } else {
                this.nalogZaIspravku.setDate(new Date());
            }
            this.nalogZaIspravku.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dcDate.getDateTimeValue()));
            this.nalogZaIspravku.setFirstLastName(this.tfFirstLastName.getText());
            this.nalogZaIspravku.setJmbg(this.tfJMBG.getText());
            this.nalogZaIspravku.setBi(this.tfBI.getText());
            this.nalogZaIspravku.setIbfm(this.tfIBFM.getText());
            double sum = 0.0;
            for (i = 0; i < this.table.getItems().size(); ++i) {
                sum += ((NalogZaIspravkuDetailes)this.table.getItems().get(i)).getPrice() * ((NalogZaIspravkuDetailes)this.table.getItems().get(i)).getQuantity();
            }
            if (sum > 500.0 && (this.tfFirstLastName.getText().equals("") || this.tfJMBG.getText().equals(""))) {
                this.controller.alert("Obavestenje", "Polja Ime i prezime i jmbg moraju biti popunje yato sto vrednost naloga ya ispravku prelati 500.00 dinara", this.rootPane.getScene().getWindow());
                return;
            }
            if (this.nalogZaIspravku.getDocumentID() > 0L) {
                this.nalogZaIspravku.update(this.controller);
            } else {
                this.nalogZaIspravku.insert(this.controller);
            }
            for (i = 0; i < this.deletedItems.size(); ++i) {
                if (this.deletedItems.get(i).getNalogZaIspravkuDetailesID() <= 0L) continue;
                this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
            }
            for (i = 0; i < this.table.getItems().size(); ++i) {
                if (((NalogZaIspravkuDetailes)this.table.getItems().get(i)).getNalogZaIspravkuDetailesID() > 0L) {
                    ((NalogZaIspravkuDetailes)this.table.getItems().get(i)).update(this.controller);
                    continue;
                }
                ((NalogZaIspravkuDetailes)this.table.getItems().get(i)).setNalogZaIspravkuID(this.nalogZaIspravku.getDocumentID());
                Long id = ((NalogZaIspravkuDetailes)this.table.getItems().get(i)).insert(this.controller);
                ((NalogZaIspravkuDetailes)this.table.getItems().get(i)).setNalogZaIspravkuDetailesID(id.longValue());
            }
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.controller.alert("Gre\u0161ka pri snimanju u bazu!", "Do\u0161lo je do gre\u0161ke prilikom snimanja u bazu!\n" + e.getMessage(), this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        if (this.cbProduct.getSelectionModel().getSelectedItem() != null) {
            if (this.tfBI.getText().equals("")) {
                this.controller.alert("Obave\u0161tenje", "Morate uneti broj fiskalnog ra\u010duna, za koji vr\u0161ite nalog za ispravku", this.rootPane.getScene().getWindow());
                return;
            }
            this.documentDetails = DocumentDetails.getDocumentDetailsByFullNumber((int)Integer.parseInt(this.tfBI.getText()), (Connection)this.controller.getSettings().getConnection());
            if (this.tfQuantity.getText().trim().equals("")) {
                this.controller.alert("Obave\u0161tenje", "Morate uneti cenu odabranog artikla", this.rootPane.getScene().getWindow());
                return;
            }
            NalogZaIspravkuDetailes pd = new NalogZaIspravkuDetailes(-1L, this.nalogZaIspravku.getDocumentID(), ((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getProductID(), ((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getCode(), ((Product)this.cbProduct.getSelectionModel().getSelectedItem()).getName(), Double.parseDouble(this.tfQuantity.getText()), Double.parseDouble(this.tfPrice.getText()), this.documentDetails.getDiscount());
            this.table.getItems().add((Object)pd);
            this.table.getSelectionModel().select((Object)pd);
            this.table.scrollTo((Object)pd);
            this.table.requestFocus();
            this.clearFields();
        } else {
            this.controller.alert("Morate odabrati artikal!", "Morate odabrati artikal!", this.rootPane.getScene().getWindow());
        }
    }

    private void clearFields() {
        this.cbProduct.getSelectionModel().clearSelection();
        this.cbProduct.getEditor().setText("");
        this.tfQuantity.setText("");
        this.tfPrice.setText("");
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            this.deletedItems.add((NalogZaIspravkuDetailes)this.table.getSelectionModel().getSelectedItem());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }
}

