/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.backoffice.controller.reports.ReportMapModel;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.PosPrint.ESCPosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.NalogZaIspravku;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.newFiscalization.badrequest.BadRequestHandler;
import rs.petcom.master.newFiscalization.badrequest.ModelState;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.RefundInvoiceRequest;
import rs.petcom.master.newFiscalization.print.A4PrintUtils;
import rs.petcom.master.newFiscalization.print.BillFooter;
import rs.petcom.master.newFiscalization.print.BillPrint;
import rs.petcom.master.newFiscalization.print.JasperStarter;
import rs.petcom.master.utility.NPrintUtil;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class NalogZaIspravkuControllerLpfr
implements ControlledScreen {
    ScreensController controller;
    private boolean documentLockIsActive;
    private InvoiceType invoiceType;
    private boolean printA4;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<User> cbUser;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TableView<NalogZaIspravku> table;
    @FXML
    private TableColumn<NalogZaIspravku, Integer> tcBroj;
    @FXML
    private TableColumn<NalogZaIspravku, Date> tcDate;
    @FXML
    private TableColumn<NalogZaIspravku, String> tcNapomena;
    @FXML
    private TableColumn<NalogZaIspravku, String> tcUser;
    @FXML
    private TableColumn<NalogZaIspravku, String> tcZakljucan;
    @FXML
    private ComboBox<String> cbRefundationType;
    @FXML
    private Button btnNew;
    @FXML
    private Button btnCopy;
    @FXML
    private Button btnDelete;
    @FXML
    private Label lblZakljucaniDokumentiUpozorenje;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.printA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("print.A4"));
    }

    public void setParameter(java.lang.Object parameter) {
        this.loadDepartment();
        this.loadUser();
        this.documentLockIsActive = Boolean.parseBoolean(this.controller.getSettings().getActualByName("documentLock.active"));
        this.dpFrom.setValue((java.lang.Object)LocalDate.now());
        this.dpTo.setValue((java.lang.Object)LocalDate.now());
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void initialize() {
        this.cbDepartment.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Department>(){

            public void changed(ObservableValue<? extends Department> observable, Department oldValue, Department newValue) {
                NalogZaIspravkuControllerLpfr.this.loadDocumentList();
            }
        });
        this.cbUser.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<User>(){

            public void changed(ObservableValue<? extends User> observable, User oldValue, User newValue) {
                NalogZaIspravkuControllerLpfr.this.loadDocumentList();
            }
        });
        this.dpFrom.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocumentList());
        this.dpTo.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocumentList());
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NalogZaIspravku>(){

            public void changed(ObservableValue<? extends NalogZaIspravku> observable, NalogZaIspravku oldValue, NalogZaIspravku newValue) {
                if (newValue == null) {
                    NalogZaIspravkuControllerLpfr.this.btnDelete.setDisable(true);
                    NalogZaIspravkuControllerLpfr.this.btnCopy.setDisable(true);
                } else if (NalogZaIspravkuControllerLpfr.this.documentLockIsActive && newValue.isLocked()) {
                    NalogZaIspravkuControllerLpfr.this.btnDelete.setDisable(true);
                    NalogZaIspravkuControllerLpfr.this.btnCopy.setDisable(false);
                    NalogZaIspravkuControllerLpfr.this.lblZakljucaniDokumentiUpozorenje.setVisible(true);
                } else {
                    NalogZaIspravkuControllerLpfr.this.btnDelete.setDisable(false);
                    NalogZaIspravkuControllerLpfr.this.btnCopy.setDisable(false);
                    NalogZaIspravkuControllerLpfr.this.lblZakljucaniDokumentiUpozorenje.setVisible(false);
                }
            }
        });
        this.tcBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<NalogZaIspravku, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcUser.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<NalogZaIspravku, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<NalogZaIspravku, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)((NalogZaIspravku)param.getValue()).getUser()).name("username").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.tcZakljucan.setCellValueFactory(cellValue -> {
            boolean isLocked = ((NalogZaIspravku)cellValue.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
        this.loadInvoiceTypeComboBox();
    }

    @FXML
    public void actionNew(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("headLine", "Unesite referentni broj ra\u010duna za koji radite ispravku");
        int result = this.controller.showModalDialog("Nalog za ispravku - refernetni broj ra\u010duna", ScreensController.SCREEN_BACKOFFICE_SEARCH_PARAM_INSERT, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_OK) {
            result = this.controller.showModalDialog("Nalog za ispravku - detalji", ScreensController.SCREEN_BACKOFFICE_REFUND_DETAILS, hm, this.rootPane.getScene().getWindow());
            this.loadDocumentList();
        }
    }

    @FXML
    public void actionPrint(ActionEvent event) {
        String reportFileName = "rs/petcom/backoffice/jasper/NalogZaIspravku.jasper";
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        Document document = Document.getByID((long)((NalogZaIspravku)this.table.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        Address address = Address.getByID((long)this.controller.getObject().getAddressID(), (Connection)this.controller.getSettings().getConnection());
        try {
            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            if (file.exists() && file.isFile()) {
                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            } else {
                hm.put("memorandum", "");
            }
            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
            hm.put("documentId", document.getDocumentID());
            hm.put("document", document);
            hm.put("object", this.controller.getObject());
            hm.put("company", CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller));
            hm.put("department", this.cbDepartment.getSelectionModel().getSelectedItem());
            hm.put("address", address);
            hm.put("parentDocumentId", document.getDocumentID());
            hm.put("ImePrezime", document.getName());
            hm.put("JMBG", document.getJmbg());
            hm.put("BI", document.getFullNumber());
            hm.put("documentNI", true);
            hm.put("datumNaloga", ((NalogZaIspravku)this.table.getSelectionModel().getSelectedItem()).getDate());
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (Connection)this.controller.getSettings().getConnection());
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Po\u010detno stanje", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    @FXML
    public void actionCopy(ActionEvent event) {
        int index = this.table.getSelectionModel().getSelectedIndex();
        NalogZaIspravku ni = (NalogZaIspravku)this.table.getItems().get(index);
        Document refundation = Document.getByID((long)ni.getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        PaymentMethod payment = PaymentMethod.getByID((int)refundation.getPaymentMethodID(), (Connection)this.controller.getSettings().getConnection());
        ObservableList refundDetails = DocumentDetails.getObeservableList((long)refundation.getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        RefundInvoiceRequest refundRequest = new RefundInvoiceRequest(this.controller, refundDetails, refundation.getBuyerIdentification(), payment, null);
        InvoiceBody refundBody = refundRequest.getBody();
        InvoiceResponse refundResponseCopy = refundRequest.getInvoiceResponse(InvoiceType.REFUND_COPY);
        ModelState[] modelStates = refundResponseCopy.getModelState();
        if (modelStates != null) {
            BadRequestHandler handler = new BadRequestHandler(this.controller, modelStates, this.rootPane.getScene().getWindow());
            handler.handleBadRequest();
            return;
        }
        User user = this.controller.getUser();
        Department department = null;
        try {
            department = Department.getById((int)1, (Connection)this.controller.getSettings().getConnection());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.printA4) {
            String path = ScreensController.SCREEN_JASPER_FISCAL_BILL;
            Person person = Person.getById((long)refundation.getPersonID(), (ScreensController)this.controller);
            if (person.getPersonID() < 1L) {
                person = null;
            }
            Map<String, java.lang.Object> reportResources = ReportMapModel.getReportMap(this.controller);
            reportResources.put("datas", A4PrintUtils.getItemsList((InvoiceBody)refundBody));
            reportResources.put("rates", A4PrintUtils.getRatesList((InvoiceResponse)refundResponseCopy));
            reportResources.put("pfrDate", NPrintUtil.textDatefromISO8601((String)refundResponseCopy.getSdcDateTime()));
            reportResources.put("person", person);
            reportResources.put("payments", A4PrintUtils.getPaymentsList((InvoiceBody)refundBody));
            reportResources.put("controller", this.controller);
            reportResources.put("header", A4PrintUtils.a4PrintHeader((InvoiceResponse)refundResponseCopy));
            reportResources.put("adtionalHeader", A4PrintUtils.a4PrintHeaderAditional((InvoiceResponse)refundResponseCopy, (InvoiceBody)refundBody, (InvoiceType)InvoiceType.REFUND_COPY));
            reportResources.put("invoiceType", InvoiceType.REFUND_COPY);
            reportResources.put("response", refundResponseCopy);
            reportResources.put("body", refundBody);
            JasperStarter starter = new JasperStarter(reportResources, path, this.rootPane);
            starter.createReportCollectionDataSource(this.rootPane.getScene().getWindow());
        } else if (!this.printA4) {
            refundation.setDocumentTypeID(33);
            refundation.setDate(new Date());
            refundation.setDeliveryDate(new Date());
            refundation.setCurrencyDate(new Date());
            refundation.setSysDTCreated(new Date());
            refundation.setSysDTEdit(new Date());
            refundation.setSysUserAddID(user.getUserID());
            refundation.setSysUserEditID(user.getUserID());
            refundation.setReferentDateTime(refundResponseCopy.getSdcDateTime());
            refundation.setBuyerIdentification(refundRequest.getBody().getBuyerId());
            refundation.setReferentNumber(refundResponseCopy.getInvoiceNumber());
            refundation.setNumber(Document.getNextNumber((int)33, (Department)department, (ScreensController)this.controller, (LocalDate)LocalDate.now()));
            long docCopyId = refundation.insert(this.controller);
            ArrayList details = DocumentDetails.getList((long)refundation.getDocumentID(), (Connection)this.controller.getSettings().getConnection());
            for (DocumentDetails detail : refundDetails) {
                detail.setDocumentID(docCopyId);
                detail.insert(this.controller.getSettings().getConnection());
            }
            this.loadDocumentList();
            ESCPosPrint posPrintCopy = new ESCPosPrint(refundRequest.getBody(), refundResponseCopy, refundation, this.controller);
            posPrintCopy.printFiscalRefund(InvoiceType.REFUND_COPY, refundation);
        } else {
            refundation.setDocumentTypeID(33);
            refundation.setDate(new Date());
            refundation.setDeliveryDate(new Date());
            refundation.setCurrencyDate(new Date());
            refundation.setSysDTCreated(new Date());
            refundation.setSysDTEdit(new Date());
            refundation.setSysUserAddID(user.getUserID());
            refundation.setSysUserEditID(user.getUserID());
            refundation.setReferentDateTime(refundResponseCopy.getSdcDateTime());
            refundation.setBuyerIdentification(refundRequest.getBody().getBuyerId());
            refundation.setReferentNumber(refundResponseCopy.getInvoiceNumber());
            refundation.setNumber(Document.getNextNumber((int)33, (Department)department, (ScreensController)this.controller, (LocalDate)LocalDate.now()));
            long docCopyId = refundation.insert(this.controller);
            ArrayList details = DocumentDetails.getList((long)refundation.getDocumentID(), (Connection)this.controller.getSettings().getConnection());
            for (DocumentDetails detail : refundDetails) {
                detail.setDocumentID(docCopyId);
                detail.insert(this.controller.getSettings().getConnection());
            }
            this.loadDocumentList();
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        try {
            ((NalogZaIspravku)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
        catch (SQLException e) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje naloga za ispravku nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje po\u010detnog stanja nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
        Log.writeLog((User)this.controller.getUser(), (String)"Brisanje naloga za ispravku", (Connection)this.controller.getSettings().getConnection());
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        this.cbDepartment.getSelectionModel().select(0);
    }

    private List<BillPrint> getBillTax(Map<String, BillPrint> billPrintMap) {
        ArrayList<BillPrint> billPrints = new ArrayList<BillPrint>();
        for (Map.Entry<String, BillPrint> hm : billPrintMap.entrySet()) {
            billPrints.add(hm.getValue());
        }
        return billPrints;
    }

    private String getBillFooter(InvoiceResponse refundResponseCopy, BillFooter billFooter) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" " + billFooter.getSum());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getSumTax());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getPayment());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentDateTime());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentNumber());
        stringBuilder.append("\n");
        stringBuilder.append(" " + refundResponseCopy.getInvoiceCounter());
        return stringBuilder.toString();
    }

    private String getBillFooterNameFild() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Za uplatu: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Porez ukupno: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Na\u010dina placanja: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Prf vreme: ");
        stringBuilder.append("\n");
        stringBuilder.append(" PFR broj ra\u010duna: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Broja\u010d ra\u010duna: ");
        return stringBuilder.toString();
    }

    private void loadUser() {
        this.cbUser.getItems().clear();
        User sviOperateri = new User();
        sviOperateri.setUserID(-1L);
        sviOperateri.setUserName("Operateri");
        this.cbUser.getItems().add((java.lang.Object)sviOperateri);
        for (User user : User.getUserList((Connection)this.controller.getSettings().getConnection())) {
            this.cbUser.getItems().add((java.lang.Object)user);
        }
        this.cbUser.getSelectionModel().select((java.lang.Object)sviOperateri);
    }

    @FXML
    void RefundationTypeChanged(ActionEvent event) {
        System.out.println("Radiii");
        this.invoiceType = InvoiceType.getByName((String)((String)this.cbRefundationType.getValue()));
        if (this.invoiceType.getTypeId() == 22) {
            this.btnCopy.setVisible(true);
        } else {
            this.btnCopy.setVisible(false);
        }
        this.loadDocumentList();
    }

    private void loadDocumentList() {
        this.table.getItems().clear();
        try {
            if (((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() > 0) {
                this.table.setItems(NalogZaIspravku.getlist((int)this.invoiceType.getTypeId(), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue())), (long)((User)this.cbUser.getSelectionModel().getSelectedItem()).getUserID(), (Connection)this.controller.getSettings().getConnection()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void loadInvoiceTypeComboBox() {
        InvoiceType[] iTypes;
        for (InvoiceType iType : iTypes = InvoiceType.values()) {
            String name = iType.getName();
            if (!name.contains("Refundacija")) continue;
            this.cbRefundationType.getItems().add((java.lang.Object)name);
        }
        this.cbRefundationType.getSelectionModel().select((java.lang.Object)"Refundacija");
        this.invoiceType = InvoiceType.getByName((String)((String)this.cbRefundationType.getValue()));
    }

    @FXML
    private void actionExport() {
    }
}

