/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.document;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.AutoCompleteComboBoxListener;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class InternaOtpremnicaDetailesControllerStara
implements DialogController {
    private ScreensController controller;
    private Document otpremnica;
    private int modalResult;
    private ArrayList<DocumentDetails> deletedItems = new ArrayList();
    private ListView<DocumentDetails> list;
    DocumentDetails psd;
    @FXML
    private BorderPane rootPane;
    @FXML
    private DateTimePicker dtpDate;
    @FXML
    private Button btnRemove;
    @FXML
    private TableView<DocumentDetails> table;
    @FXML
    private TableColumn<DocumentDetails, String> tcCode;
    @FXML
    private TableColumn<DocumentDetails, String> tcName;
    @FXML
    private TableColumn<DocumentDetails, String> tcBarCode;
    @FXML
    private TableColumn<java.lang.Object, Double> tcQuantity;
    @FXML
    private TableColumn<java.lang.Object, Double> tcPrice;
    @FXML
    private GridPane gpContainer;
    @FXML
    private TextField tfNumber;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfNapomena;
    @FXML
    private TextField tfQuantity;
    @FXML
    private ComboBox<Department> cbDepartment;
    @FXML
    private ComboBox<Person> cbPerson;

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.otpremnica = (Document)parameter.get("otpremnica");
        this.loadData();
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.gpContainer.getChildren().size() > 1) {
                this.gpContainer.getChildren().remove(1);
            }
            this.gpContainer.add(this.populateFilterList((String)newValue), 0, 0);
        });
        this.tfFilter.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DOWN & InternaOtpremnicaDetailesControllerStara.this.list != null && !InternaOtpremnicaDetailesControllerStara.this.list.getItems().isEmpty()) {
                    InternaOtpremnicaDetailesControllerStara.this.list.requestFocus();
                    InternaOtpremnicaDetailesControllerStara.this.list.getSelectionModel().select(0);
                }
            }
        });
        this.tfFilter.requestFocus();
        this.tfQuantity.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case UP: {
                    this.tfQuantity.setText(String.valueOf(Double.parseDouble(this.tfQuantity.getText()) + 1.0));
                    break;
                }
                case DOWN: {
                    this.tfQuantity.setText(String.valueOf(Double.parseDouble(this.tfQuantity.getText()) - 1.0));
                    break;
                }
                case TAB: {
                    this.tfPrice.requestFocus();
                    keyValue.consume();
                    break;
                }
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    this.tfPrice.requestFocus();
                    keyValue.consume();
                    break;
                }
            }
        });
        this.tfPrice.setOnKeyPressed(keyValue -> {
            switch (keyValue.getCode()) {
                case ENTER: {
                    if (this.table.getSelectionModel().getSelectedItem() == null) break;
                    this.editPrice(this.tfPrice.getText());
                    this.tfQuantity.setText("");
                    this.tfPrice.setText("");
                    this.tfFilter.setText("");
                    this.tfFilter.requestFocus();
                    this.table.getSelectionModel().clearSelection();
                    keyValue.consume();
                    break;
                }
            }
        });
    }

    private void loadData() {
        this.cbPerson.getItems().clear();
        this.loadDepartment();
        this.cbPerson.setItems(Person.getListByCategory((String)PersonCategory.INTERN_BUYER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        new AutoCompleteComboBoxListener(this.cbPerson);
        if (this.otpremnica == null) {
            this.dtpDate.setValue((java.lang.Object)LocalDate.now());
            this.tfNumber.setText(String.valueOf(Document.getNextNumber((int)DocumentType.getByCode((String)"IO", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (Department)((Department)this.cbDepartment.getSelectionModel().getSelectedItem()), (ScreensController)this.controller, (LocalDate)((LocalDate)this.dtpDate.getValue()))));
            this.tfNapomena.setText("");
        } else {
            this.setDobavljac(Person.getById((long)this.otpremnica.getPersonID(), (ScreensController)this.controller));
            this.loadTable();
            this.dtpDate.setValue((java.lang.Object)Settings.fromDate((Date)this.otpremnica.getDate()));
            this.tfNumber.setText(String.valueOf(this.otpremnica.getNumber()));
            this.tfNapomena.setText(this.otpremnica.getNote());
        }
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("ProductCode"));
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DocumentDetails, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DocumentDetails, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)Barcode.getBarCodeObject((long)((DocumentDetails)param.getValue()).getProductID(), (Connection)InternaOtpremnicaDetailesControllerStara.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<java.lang.Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<java.lang.Object, Double> t) {
                ((DocumentDetails)t.getTableView().getItems().get(t.getTablePosition().getRow())).setQuantity(((Double)t.getNewValue()).doubleValue());
            }
        });
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcPrice.setCellFactory((Callback)cellFactory);
        this.tcPrice.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<java.lang.Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<java.lang.Object, Double> t) {
                ((DocumentDetails)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrice(((Double)t.getNewValue()).doubleValue());
                ((DocumentDetails)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPriceWithDiscount(((Double)t.getNewValue()).doubleValue());
            }
        });
    }

    @FXML
    public void actionClose(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionSave(ActionEvent event) {
        for (int i = 0; i < this.deletedItems.size(); ++i) {
            if (this.deletedItems.get(i).getDocumentDetailsID() == -1L) continue;
            this.deletedItems.get(i).delete(this.controller.getSettings().getConnection());
        }
        double sum = 0.0;
        for (DocumentDetails documentDetails : this.table.getItems()) {
            sum += documentDetails.getQuantity() * documentDetails.getPrice();
        }
        long otpremnicaID = 0L;
        if (this.otpremnica != null) {
            try {
                this.otpremnica.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
                this.otpremnica.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dtpDate.getDateTimeValue()));
                this.otpremnica.setDeliveryDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dtpDate.getDateTimeValue()));
                this.otpremnica.setNote(this.tfNapomena.getText().trim());
                this.otpremnica.setSum(sum);
                this.otpremnica.setSumWithDiscount(sum);
                this.otpremnica.setSysUserEditID(this.controller.getUser().getUserID());
                this.otpremnica.setNumber(Integer.parseInt(this.tfNumber.getText().trim()));
                this.otpremnica.setPersonID(((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())).getPersonID());
                this.otpremnica.update(this.controller);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            this.otpremnica = new Document();
            this.otpremnica.setDocumentTypeID(DocumentType.getByCode((String)"IO", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
            this.otpremnica.setDocumentStatusID(DocumentStatus.getStatusByName((ScreensController)this.controller, (String)"Overen").getDocumentStatusID());
            this.otpremnica.setDepartmentID(((Department)this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID());
            this.otpremnica.setDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dtpDate.getDateTimeValue()));
            this.otpremnica.setDeliveryDate(Settings.DatefromLocalDateTime((LocalDateTime)this.dtpDate.getDateTimeValue()));
            this.otpremnica.setNote(this.tfNapomena.getText().trim());
            this.otpremnica.setSum(sum);
            this.otpremnica.setSumWithDiscount(sum);
            this.otpremnica.setNumber(Integer.parseInt(this.tfNumber.getText().trim()));
            this.otpremnica.setSysUserAddID(this.controller.getUser().getUserID());
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            this.otpremnica.setYear(cal.get(1));
            this.otpremnica.setPersonID(((Person)this.cbPerson.getItems().get(this.cbPerson.getSelectionModel().getSelectedIndex())).getPersonID());
            otpremnicaID = this.otpremnica.insert(this.controller);
        }
        for (DocumentDetails documentDetails : this.table.getItems()) {
            if (documentDetails.getDocumentDetailsID() != -1L) {
                documentDetails.setSysUserEditID(this.controller.getUser().getUserID());
                documentDetails.update(this.controller);
                continue;
            }
            if (documentDetails.getDocumentID() == -1L) {
                documentDetails.setDocumentID(otpremnicaID);
            }
            documentDetails.setSysUserAddID(this.controller.getUser().getUserID());
            documentDetails.setUnitID(Product.getByID((long)documentDetails.getProductID(), (ScreensController)this.controller).getUnitID());
            documentDetails.setVatID(Product.getByID((long)documentDetails.getProductID(), (ScreensController)this.controller).getVatID());
            documentDetails.insert(this.controller.getSettings().getConnection());
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void actionRemove(ActionEvent event) {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            if (((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).getDocumentID() > 0L) {
                this.deletedItems.add((DocumentDetails)this.table.getSelectionModel().getSelectedItem());
            }
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    @FXML
    public void addPerson(ActionEvent event) {
        HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
        hm.put("controller", this.controller);
        hm.put("personCategory", PersonCategory.INTERN_BUYER);
        String title = "Kreiranje novog internog dobavlja\u010da";
        this.controller.showModalDialog(title, ScreensController.DIALOG_ADD_PERSON, hm, (Window)((Stage)((Node)event.getSource()).getScene().getWindow()));
        this.loadData();
    }

    private ListView<DocumentDetails> populateFilterList(String filterText) {
        this.gpContainer.getChildren().clear();
        this.list = new ListView();
        final ObservableList listFromDb = DocumentDetails.getFilteredListInternaOtpremnica((String)filterText, (Document)this.otpremnica, (ScreensController)this.controller);
        if (!this.table.getItems().isEmpty()) {
            for (DocumentDetails ddTable : this.table.getItems()) {
                ListIterator iter = listFromDb.listIterator();
                while (iter.hasNext()) {
                    DocumentDetails a = (DocumentDetails)iter.next();
                    if (!ddTable.getProductCode().equals(a.getProductCode())) continue;
                    iter.remove();
                }
            }
        }
        if (listFromDb.isEmpty()) {
            this.gpContainer.setVisible(false);
            return this.list;
        }
        this.list.getItems().addAll((Collection)listFromDb);
        this.gpContainer.setVisible(true);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){
            MultipleSelectionModel<DocumentDetails> selected;
            {
                this.selected = InternaOtpremnicaDetailesControllerStara.this.list.getSelectionModel();
            }

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    if (((Department)InternaOtpremnicaDetailesControllerStara.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() != -1) {
                        InternaOtpremnicaDetailesControllerStara.this.psd = (DocumentDetails)InternaOtpremnicaDetailesControllerStara.this.list.getSelectionModel().getSelectedItem();
                        if (InternaOtpremnicaDetailesControllerStara.this.otpremnica != null) {
                            InternaOtpremnicaDetailesControllerStara.this.psd.setDocumentID(InternaOtpremnicaDetailesControllerStara.this.otpremnica.getDocumentID());
                        }
                        InternaOtpremnicaDetailesControllerStara.this.tfPrice.setText(String.valueOf(InternaOtpremnicaDetailesControllerStara.this.psd.getPrice()));
                        if (!InternaOtpremnicaDetailesControllerStara.this.table.getItems().contains((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd)) {
                            InternaOtpremnicaDetailesControllerStara.this.table.getItems().add((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                        }
                    } else {
                        InternaOtpremnicaDetailesControllerStara.this.controller.alert("Obavestenje", "Morate odabrati odeljenje", InternaOtpremnicaDetailesControllerStara.this.rootPane.getScene().getWindow());
                        InternaOtpremnicaDetailesControllerStara.this.tfFilter.setText("");
                        InternaOtpremnicaDetailesControllerStara.this.gpContainer.setVisible(false);
                        return;
                    }
                    InternaOtpremnicaDetailesControllerStara.this.table.getSelectionModel().select((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                    int index = InternaOtpremnicaDetailesControllerStara.this.table.getItems().indexOf((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                    InternaOtpremnicaDetailesControllerStara.this.table.getFocusModel().focus(index);
                    listFromDb.remove((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                    InternaOtpremnicaDetailesControllerStara.this.tfQuantity.requestFocus();
                    InternaOtpremnicaDetailesControllerStara.this.gpContainer.setVisible(false);
                    InternaOtpremnicaDetailesControllerStara.this.tfFilter.setText("");
                }
                if (event.getCode() == KeyCode.UP & this.selected.getSelectedIndex() == 0) {
                    InternaOtpremnicaDetailesControllerStara.this.tfFilter.requestFocus();
                }
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    if (((Department)InternaOtpremnicaDetailesControllerStara.this.cbDepartment.getSelectionModel().getSelectedItem()).getDepartmentID() != -1) {
                        InternaOtpremnicaDetailesControllerStara.this.psd = (DocumentDetails)InternaOtpremnicaDetailesControllerStara.this.list.getSelectionModel().getSelectedItem();
                        InternaOtpremnicaDetailesControllerStara.this.tfPrice.setText(String.valueOf(InternaOtpremnicaDetailesControllerStara.this.psd.getPrice()));
                        InternaOtpremnicaDetailesControllerStara.this.psd.setPrice(Double.parseDouble(InternaOtpremnicaDetailesControllerStara.this.tfPrice.getText().trim()));
                        InternaOtpremnicaDetailesControllerStara.this.psd.setPriceWithDiscount(InternaOtpremnicaDetailesControllerStara.this.psd.getPrice());
                        if (!InternaOtpremnicaDetailesControllerStara.this.table.getItems().contains((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd)) {
                            InternaOtpremnicaDetailesControllerStara.this.table.getItems().add((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                        }
                    } else {
                        InternaOtpremnicaDetailesControllerStara.this.controller.alert("Obavestenje", "Morate odabrati odeljenje", InternaOtpremnicaDetailesControllerStara.this.rootPane.getScene().getWindow());
                        InternaOtpremnicaDetailesControllerStara.this.tfFilter.setText("");
                        InternaOtpremnicaDetailesControllerStara.this.gpContainer.setVisible(false);
                        return;
                    }
                    InternaOtpremnicaDetailesControllerStara.this.table.getSelectionModel().select((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                    int index = InternaOtpremnicaDetailesControllerStara.this.table.getItems().indexOf((java.lang.Object)InternaOtpremnicaDetailesControllerStara.this.psd);
                    InternaOtpremnicaDetailesControllerStara.this.table.getFocusModel().focus(index);
                    InternaOtpremnicaDetailesControllerStara.this.tfQuantity.requestFocus();
                    InternaOtpremnicaDetailesControllerStara.this.gpContainer.setVisible(false);
                    InternaOtpremnicaDetailesControllerStara.this.tfFilter.setText("");
                }
            }
        });
        return this.list;
    }

    private void editPrice(String number) {
        try {
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setQuantity(Double.parseDouble(this.tfQuantity.getText().trim()));
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setPrice(Double.parseDouble(number));
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setPriceWithDiscount(Double.parseDouble(number));
            this.table.getSelectionModel().select(this.table.getSelectionModel().getSelectedIndex() + 1);
        }
        catch (NumberFormatException e) {
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setQuantity(0.0);
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setPrice(0.0);
            ((DocumentDetails)this.table.getSelectionModel().getSelectedItem()).setPriceWithDiscount(0.0);
        }
        this.table.refresh();
    }

    private void loadTable() {
        this.table.getItems().clear();
        this.table.setItems(DocumentDetails.getObeservableList((long)this.otpremnica.getDocumentID(), (Connection)this.controller.getSettings().getConnection()));
    }

    private void loadDepartment() {
        this.cbDepartment.getItems().clear();
        for (Department d : Department.getList((Object)this.controller.getObject(), (Connection)this.controller.getSettings().getConnection())) {
            this.cbDepartment.getItems().add((java.lang.Object)d);
        }
        if (!this.cbDepartment.getItems().isEmpty()) {
            this.cbDepartment.getSelectionModel().select(0);
        }
    }

    private void setDobavljac(Person dobavlac) {
        if (dobavlac != null) {
            for (Person p : this.cbPerson.getItems()) {
                if (p.getPersonID() != this.otpremnica.getPersonID()) continue;
                this.cbPerson.getSelectionModel().select((java.lang.Object)p);
                break;
            }
        }
    }
}

