/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.blagajna;

import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentRecord;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Person;

public class PaidAmountDialogController
implements DialogController {
    private ScreensController controller;
    private int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    private HashMap<String, Object> parameter;
    private Document document;
    private Person person;
    private double uplata;
    private double vecUplaceno;
    @FXML
    private BorderPane rootPane;
    @FXML
    private Label lblNumber;
    @FXML
    private Label lblDobavljac;
    @FXML
    private Label lblDug;
    @FXML
    private TextField tfUplati;
    @FXML
    private TextArea taNote;

    public void setParameter(HashMap<String, Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.document = (Document)parameter.get("document");
        this.person = Person.getById((long)this.document.getPersonID(), (ScreensController)this.controller);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.lblNumber.setText(String.valueOf(this.document.getNumber()));
        this.lblDobavljac.setText(this.person.getName());
        this.lblDug.setText(String.valueOf(Settings.round((double)(this.document.getSumWithDiscount() - this.document.getPaid()), (int)4)));
        this.tfUplati.setText(String.valueOf(Settings.round((double)(this.document.getSumWithDiscount() - this.document.getPaid()), (int)4)));
    }

    public HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    private void commit() {
        this.vecUplaceno = PaymentRecord.getPaidAmountSum((long)this.document.getDocumentID(), (ScreensController)this.controller);
        this.uplata = Double.parseDouble(this.tfUplati.getText());
        PaymentRecord paymentRecord = new PaymentRecord();
        paymentRecord.setDocumentID(this.document.getDocumentID());
        paymentRecord.setNote(this.taNote.getText());
        paymentRecord.setPaidAmount(Settings.round((double)this.uplata, (int)4));
        paymentRecord.insert(this.controller);
        if (Settings.round((double)this.document.getSumWithDiscount(), (int)4) == Settings.round((double)(paymentRecord.getPaidAmount() + this.vecUplaceno), (int)4)) {
            this.document.setRealized(true);
            this.document.updateRealized(this.controller);
        }
        this.modalResult = ScreensController.MODAL_RESULT_OK;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }
}

