/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.blagajna;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.gui.DoubleTableCellFactory;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class KnjigaUlazaIzlazaKomitenataController
implements ControlledScreen {
    private ScreensController controller;
    private final DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
    private double sum = 0.0;
    private double sumVanValute = 0.0;
    private double sumVanValutePlaceno = 0.0;
    private double sumUplaceno = 0.0;
    private DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TextField tfFilter;
    @FXML
    private TableView<Document> table;
    @FXML
    private TableColumn<Document, String> columnDocumentName;
    @FXML
    private TableColumn<Document, String> columnPerson;
    @FXML
    private TableColumn<Document, Integer> columnNumber;
    @FXML
    private TableColumn<Document, Date> columnDocDate;
    @FXML
    private TableColumn<Document, Date> columnDate;
    @FXML
    private TableColumn<Document, Date> columnPaidDate;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<Object, Double> columnValuePaid;
    @FXML
    private Label lblUplaceno;
    @FXML
    private Label lblAllDocValue;
    @FXML
    private Label lblDug;
    @FXML
    private Label lblAllDocValueVanValute;
    @FXML
    private CheckBox cbCeoPeriod;

    @FXML
    public void initialize() {
        this.columnDocDate.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.columnDocDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("currencyDate"));
        this.columnDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPaidDate.setCellValueFactory((Callback)new PropertyValueFactory("deliveryDate"));
        this.columnPaidDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnDocumentName.setCellValueFactory((Callback)new PropertyValueFactory("nazivDokumenta"));
        this.columnPerson.setCellValueFactory((Callback)new PropertyValueFactory("personName"));
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("sum"));
        this.columnValue.setCellFactory((Callback)this.cellFactory);
        this.columnValuePaid.setCellValueFactory((Callback)new PropertyValueFactory("paid"));
        this.columnValuePaid.setCellFactory((Callback)this.cellFactory);
        final PseudoClass myConditionPseudoClass = PseudoClass.getPseudoClass((String)"my-condition");
        this.table.setRowFactory(tv -> new TableRow<Document>(){

            public void updateItem(Document item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.pseudoClassStateChanged(myConditionPseudoClass, !empty && item.getPaid() != 0.0);
            }
        });
        this.cbPerson.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaIzlazaKomitenataController.this.loadTableDocuments((Person)KnjigaUlazaIzlazaKomitenataController.this.cbPerson.getSelectionModel().getSelectedItem());
            }
        });
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaIzlazaKomitenataController.this.loadTableDocuments((Person)KnjigaUlazaIzlazaKomitenataController.this.cbPerson.getSelectionModel().getSelectedItem());
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaIzlazaKomitenataController.this.loadTableDocuments((Person)KnjigaUlazaIzlazaKomitenataController.this.cbPerson.getSelectionModel().getSelectedItem());
            }
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                KnjigaUlazaIzlazaKomitenataController.this.loadTableDocuments((Person)KnjigaUlazaIzlazaKomitenataController.this.cbPerson.getSelectionModel().getSelectedItem());
            }
        });
        this.cbCeoPeriod.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (KnjigaUlazaIzlazaKomitenataController.this.cbCeoPeriod.isSelected()) {
                    KnjigaUlazaIzlazaKomitenataController.this.dpFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getFirstStart((Connection)KnjigaUlazaIzlazaKomitenataController.this.controller.getSettings().getConnection())));
                    KnjigaUlazaIzlazaKomitenataController.this.dpTo.setValue((Object)Settings.fromDate((Date)WorkDay.getFromDb((PointOfSale)KnjigaUlazaIzlazaKomitenataController.this.controller.getPointOfSale(), (Connection)KnjigaUlazaIzlazaKomitenataController.this.controller.getSettings().getConnection()).getDate()));
                } else {
                    KnjigaUlazaIzlazaKomitenataController.this.dpFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getFromDb((PointOfSale)KnjigaUlazaIzlazaKomitenataController.this.controller.getPointOfSale(), (Connection)KnjigaUlazaIzlazaKomitenataController.this.controller.getSettings().getConnection()).getDate()));
                    KnjigaUlazaIzlazaKomitenataController.this.dpTo.setValue((Object)Settings.fromDate((Date)WorkDay.getFromDb((PointOfSale)KnjigaUlazaIzlazaKomitenataController.this.controller.getPointOfSale(), (Connection)KnjigaUlazaIzlazaKomitenataController.this.controller.getSettings().getConnection()).getDate()));
                }
                KnjigaUlazaIzlazaKomitenataController.this.loadTableDocuments((Person)KnjigaUlazaIzlazaKomitenataController.this.cbPerson.getSelectionModel().getSelectedItem());
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        this.dpFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpTo.setValue((Object)LocalDate.now());
        Person p = new Person();
        p.setPersonID(-1L);
        p.setName("Svi komitenti");
        this.cbPerson.getItems().add((Object)p);
        this.cbPerson.getItems().addAll((Collection)Person.getListByCategory((boolean)true, (Connection)this.controller.getSettings().getConnection()));
        this.cbPerson.getSelectionModel().selectFirst();
        this.df.setMaximumFractionDigits(340);
        this.loadTableDocuments((Person)this.cbPerson.getSelectionModel().getSelectedItem());
    }

    public void setParameter(Object parameter) {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
    }

    public Object getParameter() {
        return null;
    }

    @FXML
    private void printAction() {
        String reportFileName = "rs/petcom/backoffice/jasper/blagajna/KarticaKomitenata.jasper";
        ObservableList dataList = this.table.getItems();
        JRBeanCollectionDataSource beanColDataSource = new JRBeanCollectionDataSource((Collection)dataList);
        HashMap<String, String> hm = new HashMap<String, String>();
        File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        if (file.exists() && file.isFile()) {
            hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
        } else {
            hm.put("memorandum", "");
        }
        try {
            JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
            JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, hm, (JRDataSource)beanColDataSource);
            JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld(jprint);
            HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
            hm2.put("report", printViewPane);
            this.controller.showModalDialog("Povrat", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void loadTableDocuments(Person person) {
        ObservableList tableList = Document.getKnjigaKomitenataList((LocalDate)((LocalDate)this.dpFrom.getValue()), (LocalDate)((LocalDate)this.dpTo.getValue()), (Person)person, (String)this.tfFilter.getText(), (ScreensController)this.controller);
        if (!tableList.isEmpty()) {
            this.table.setItems(tableList);
        } else {
            this.table.getItems().clear();
        }
        this.sum = 0.0;
        this.sumUplaceno = 0.0;
        this.sumVanValute = 0.0;
        this.sumVanValutePlaceno = 0.0;
        this.ukupnaVrednostDokumenata();
        this.ukupnaVrednostUplacena();
        this.ukupanDug();
        this.ukupnaVrednostDokumenataVanValute();
    }

    private void ukupnaVrednostDokumenata() {
        for (Document document : this.table.getItems()) {
            this.sum += document.getSum();
        }
        this.lblAllDocValue.setText(this.df.format(Settings.round((double)this.sum, (int)2)));
    }

    private void ukupnaVrednostDokumenataVanValute() {
        for (Document document : this.table.getItems()) {
            try {
                if (!document.getCurrencyDate().before(new Date())) continue;
                this.sumVanValute += document.getSum();
            }
            catch (NullPointerException nullPointerException) {}
        }
        for (Document document : this.table.getItems()) {
            try {
                if (!document.getDeliveryDate().before(new Date())) continue;
                this.sumVanValutePlaceno += document.getPaid();
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.lblAllDocValueVanValute.setText(this.df.format(Settings.round((double)(this.sumVanValute - this.sumVanValutePlaceno), (int)2)));
    }

    private void ukupnaVrednostUplacena() {
        for (Document document : this.table.getItems()) {
            this.sumUplaceno += document.getPaid();
        }
        this.lblUplaceno.setText(String.valueOf(Settings.round((double)this.sumUplaceno, (int)2)));
    }

    private void ukupanDug() {
        this.lblDug.setText(this.df.format(Settings.round((double)(this.sum - this.sumUplaceno), (int)2)));
    }
}

