/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.blagajna;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.PaymentRecord;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.gui.DoubleTableCellFactory;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class KnjigaUlazaController
implements ControlledScreen {
    private ScreensController controller;
    private final DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(4, true);
    private int interval;
    private ToggleGroup tGroup = new ToggleGroup();
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TableView<Document> table;
    @FXML
    private TableColumn<Document, Integer> columnNumber;
    @FXML
    private TableColumn<Document, Date> columnDocDate;
    @FXML
    private TableColumn<Document, Date> columnDate;
    @FXML
    private TableColumn<Document, String> columnPerson;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<Object, Double> columnValuePaid;
    @FXML
    private TableView<PaymentRecord> tablePR;
    @FXML
    private TableColumn<PaymentRecord, Date> columnPRDate;
    @FXML
    private TableColumn<Object, Double> columnPRPaidAmount;
    @FXML
    private TableColumn<PaymentRecord, String> columnPRNote;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfDaysUValuti;
    @FXML
    private CheckBox cbPaid;
    @FXML
    private CheckBox cbUValuti;
    @FXML
    private CheckBox cbVanValute;
    @FXML
    private RadioButton prikaziUValuti;
    @FXML
    private RadioButton prikaziVanValute;
    @FXML
    private Button btnPaid;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnPrintAll;
    @FXML
    private Label lblAllDocValue;
    @FXML
    private Label lblByDocValue;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @FXML
    public void initialize() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.tfDaysUValuti.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    KnjigaUlazaController.this.tfDaysUValuti.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.cbPerson.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.cbPaid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (KnjigaUlazaController.this.cbPaid.isSelected()) {
                    KnjigaUlazaController.this.cbUValuti.setSelected(false);
                    KnjigaUlazaController.this.cbVanValute.setSelected(false);
                } else {
                    KnjigaUlazaController.this.cbUValuti.setSelected(true);
                    KnjigaUlazaController.this.cbVanValute.setSelected(true);
                }
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.cbUValuti.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaController.this.cbPaid.setSelected(false);
                KnjigaUlazaController.this.tfDaysUValuti.setDisable(false);
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.cbVanValute.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaUlazaController.this.cbPaid.setSelected(false);
                KnjigaUlazaController.this.tfDaysUValuti.setDisable(true);
                KnjigaUlazaController.this.loadTableDocuments();
            }
        });
        this.prikaziUValuti.setToggleGroup(this.tGroup);
        this.prikaziVanValute.setToggleGroup(this.tGroup);
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> observable, Document oldValue, Document newValue) {
                if (newValue != null) {
                    KnjigaUlazaController.this.btnPaid.setDisable(false);
                    KnjigaUlazaController.this.loadTablePR(newValue.getDocumentID());
                    if (!KnjigaUlazaController.this.tablePR.getItems().isEmpty()) {
                        KnjigaUlazaController.this.btnPrint.setDisable(false);
                    }
                } else {
                    KnjigaUlazaController.this.btnPaid.setDisable(true);
                    KnjigaUlazaController.this.btnPrint.setDisable(true);
                }
            }
        });
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.paidAction();
                }
            });
            return row;
        });
    }

    @FXML
    private void prikaziAction() {
        if (!this.tfDaysUValuti.getText().equals("")) {
            this.loadTableDocumentsPrikazi();
            this.tfDaysUValuti.setText("");
        }
    }

    public void init() {
        this.dpFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpTo.setValue((Object)LocalDate.now());
        this.interval = 0;
        Person p = new Person();
        p.setPersonID(-1L);
        p.setName("Svi dobavlja\u010di");
        this.cbPerson.getItems().add((Object)p);
        this.cbPerson.getItems().addAll((Collection)Person.getListByCategory((String)PersonCategory.SUPPLIER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        this.cbPerson.getSelectionModel().selectFirst();
        if (this.cbUValuti.isSelected()) {
            this.tfDaysUValuti.setDisable(false);
        }
        this.loadTableDocuments();
    }

    public void setParameter(Object parameter) {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
    }

    public Object getParameter() {
        return null;
    }

    private void loadTableDocumentsPrikazi() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.columnDocDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.columnDocDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("CurrencyDate"));
        this.columnDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPerson.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)KnjigaUlazaController.this.controller)).name("Name").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.columnValue.setCellFactory((Callback)this.cellFactory);
        this.columnValuePaid.setCellValueFactory((Callback)new PropertyValueFactory("Paid"));
        this.columnValuePaid.setCellFactory((Callback)this.cellFactory);
        String type = String.valueOf(DocumentType.getByCode((String)"PR", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        this.table.setItems(Document.getKnjigaListPrikazi((Person)((Person)this.cbPerson.getSelectionModel().getSelectedItem()), (String)type, (boolean)this.prikaziUValuti.isSelected(), (boolean)this.prikaziVanValute.isSelected(), (int)Integer.parseInt(this.tfDaysUValuti.getText().trim()), (ScreensController)this.controller));
        this.btnPaid.setDisable(true);
        this.allDocValue();
        this.tablePR.getItems().clear();
    }

    private void loadTableDocuments() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.columnDocDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.columnDocDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("CurrencyDate"));
        this.columnDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPerson.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)KnjigaUlazaController.this.controller)).name("Name").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.columnValue.setCellFactory((Callback)this.cellFactory);
        this.columnValuePaid.setCellValueFactory((Callback)new PropertyValueFactory("Paid"));
        this.columnValuePaid.setCellFactory((Callback)this.cellFactory);
        String type = String.valueOf(DocumentType.getByCode((String)"PR", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID());
        this.table.setItems(Document.getKnjigaList((Person)((Person)this.cbPerson.getSelectionModel().getSelectedItem()), (String)type, (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue())), (String)this.tfFilter.getText(), (boolean)this.cbPaid.isSelected(), (boolean)this.cbUValuti.isSelected(), (boolean)this.cbVanValute.isSelected(), (int)this.interval, (ScreensController)this.controller));
        this.btnPaid.setDisable(true);
        this.allDocValue();
        this.tablePR.getItems().clear();
    }

    private void loadTablePR(long documentID) {
        this.columnPRNote.setCellValueFactory((Callback)new PropertyValueFactory("note"));
        this.columnPRDate.setCellValueFactory((Callback)new PropertyValueFactory("sysCreateDate"));
        this.columnPRDate.setCellFactory(column -> new TableCell<PaymentRecord, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPRPaidAmount.setCellValueFactory((Callback)new PropertyValueFactory("paidAmount"));
        this.columnPRPaidAmount.setCellFactory((Callback)this.cellFactory);
        this.tablePR.setItems(PaymentRecord.getListByDocumentId((ScreensController)this.controller, (long)documentID));
        this.byDocValue();
    }

    @FXML
    private void paidAction() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hMap = new HashMap<String, Object>();
            hMap.put("controller", this.controller);
            hMap.put("document", this.table.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Dodavanje placanja", ScreensController.DIALOG_BACKOFFICE_PAID_AMOUNT, hMap, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadTableDocuments();
            }
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele za koji zelite da odradite placanje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void printAction() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            final String reportFileName = "rs/petcom/backoffice/jasper/blagajna/KnjigaUlaza.jasper";
            final HashMap<String, Object> hm = new HashMap<String, Object>();
            Document document = (Document)this.table.getSelectionModel().getSelectedItem();
            CompanyConfig company = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
            hm.put("objekat", this.controller.getObject());
            hm.put("company", company);
            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            if (file.exists() && file.isFile()) {
                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            } else {
                hm.put("memorandum", "");
            }
            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
            hm.put("documentId", document.getDocumentID());
            hm.put("document", document);
            hm.put("dobavljac", Person.getById((long)document.getPersonID(), (ScreensController)this.controller));
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje stampe placanja u toku.", this.rootPane.getScene().getWindow());
            Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

                protected JasperPrint call() throws Exception {
                    try {
                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)KnjigaUlazaController.this.controller.getSettings().getConnection());
                        virtualizer.setReadOnly(true);
                        return jprint;
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
            creatingReport.setOnSucceeded(arg_0 -> this.lambda$printAction$7(taskUpdateStage, (Task)creatingReport, arg_0));
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje kalkulacije", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)creatingReport).start();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele za koji zelite da stampate placanja", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void printActionAll() {
        if (!this.table.getItems().isEmpty()) {
            final String reportFileName = "rs/petcom/backoffice/jasper/blagajna/KnjigaUlazaAll.jasper";
            final HashMap<String, Object> hm = new HashMap<String, Object>();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.table.getItems().size(); ++i) {
                stringBuilder.append(String.valueOf(((Document)this.table.getItems().get(i)).getDocumentID()));
                if (this.table.getItems().size() == i + 1) continue;
                stringBuilder.append(",");
            }
            CompanyConfig company = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
            hm.put("objekat", this.controller.getObject());
            hm.put("company", company);
            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            if (file.exists() && file.isFile()) {
                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            } else {
                hm.put("memorandum", "");
            }
            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
            hm.put("All_Id", stringBuilder.toString());
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje stampe placanja u toku.", this.rootPane.getScene().getWindow());
            Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

                protected JasperPrint call() throws Exception {
                    try {
                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)KnjigaUlazaController.this.controller.getSettings().getConnection());
                        virtualizer.setReadOnly(true);
                        return jprint;
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
            creatingReport.setOnSucceeded(arg_0 -> this.lambda$printActionAll$10(taskUpdateStage, (Task)creatingReport, arg_0));
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje kalkulacije", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)creatingReport).start();
        } else {
            this.controller.alert("Obavestenje", "Mora postojati bar jedan dokument u tabeli", this.rootPane.getScene().getWindow());
        }
    }

    void allDocValue() {
        double sum = 0.0;
        for (Document document : this.table.getItems()) {
            sum += document.getSumWithDiscount();
        }
        this.lblAllDocValue.setText(String.valueOf(Settings.round((double)sum, (int)2)));
    }

    void byDocValue() {
        double sum = 0.0;
        for (PaymentRecord paymentRecord : this.tablePR.getItems()) {
            sum += paymentRecord.getPaidAmount();
        }
        this.lblByDocValue.setText(String.valueOf(Settings.round((double)sum, (int)2)));
    }

    private /* synthetic */ void lambda$printActionAll$10(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
        HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
        hm2.put("report", printViewPane);
        this.controller.showModalDialog("Knjiga ulaza", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
    }

    private /* synthetic */ void lambda$printAction$7(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
        HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
        hm2.put("report", printViewPane);
        this.controller.showModalDialog("Knjiga ulaza", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
    }
}

