/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller.blagajna;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.company.CompanyConfig;
import rs.petcom.master.dal.PaymentRecord;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.person.PersonCategory;
import rs.petcom.master.gui.DoubleTableCellFactory;
import rs.petcom.print.JRPrintPreviewPaneOld;

public class KnjigaIzlazaController
implements ControlledScreen {
    private ScreensController controller;
    private final DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
    private int interval;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Person> cbPerson;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private TableView<Document> table;
    @FXML
    private TableColumn<Document, Integer> columnNumber;
    @FXML
    private TableColumn<Document, Date> columnDocDate;
    @FXML
    private TableColumn<Document, Date> columnDate;
    @FXML
    private TableColumn<Document, String> columnPerson;
    @FXML
    private TableColumn<Object, Double> columnValue;
    @FXML
    private TableColumn<Object, Double> columnValuePaid;
    @FXML
    private TableView<PaymentRecord> tablePR;
    @FXML
    private TableColumn<PaymentRecord, Date> columnPRDate;
    @FXML
    private TableColumn<Object, Double> columnPRPaidAmount;
    @FXML
    private TableColumn<PaymentRecord, String> columnPRNote;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfDaysUValuti;
    @FXML
    private TextField tfDaysVanValute;
    @FXML
    private CheckBox cbPaid;
    @FXML
    private CheckBox cbUValuti;
    @FXML
    private CheckBox cbVanValute;
    @FXML
    private CheckBox prikaziUValuti;
    @FXML
    private CheckBox prikaziVanValute;
    @FXML
    private Button btnPaid;
    @FXML
    private Button btnPrint;
    @FXML
    private Button btnPrintAll;
    @FXML
    private Label lblAllDocValue;
    @FXML
    private Label lblByDocValue;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    @FXML
    public void initialize() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.tfDaysUValuti.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("")) {
                    KnjigaIzlazaController.this.prikaziUValuti.setDisable(false);
                } else {
                    KnjigaIzlazaController.this.prikaziUValuti.setDisable(true);
                }
            }
        });
        this.tfDaysVanValute.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("")) {
                    KnjigaIzlazaController.this.prikaziVanValute.setDisable(false);
                } else {
                    KnjigaIzlazaController.this.prikaziVanValute.setDisable(true);
                }
            }
        });
        this.dpFrom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.dpTo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.cbPerson.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.cbPaid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (KnjigaIzlazaController.this.cbPaid.isSelected()) {
                    KnjigaIzlazaController.this.cbUValuti.setSelected(false);
                    KnjigaIzlazaController.this.cbVanValute.setSelected(false);
                } else {
                    KnjigaIzlazaController.this.cbUValuti.setSelected(true);
                    KnjigaIzlazaController.this.cbVanValute.setSelected(true);
                }
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.cbUValuti.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaIzlazaController.this.prikaziUValuti.setDisable(false);
                KnjigaIzlazaController.this.prikaziVanValute.setDisable(true);
                KnjigaIzlazaController.this.cbPaid.setSelected(false);
                KnjigaIzlazaController.this.tfDaysUValuti.setDisable(false);
                KnjigaIzlazaController.this.tfDaysVanValute.setDisable(true);
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.cbVanValute.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                KnjigaIzlazaController.this.prikaziUValuti.setDisable(true);
                KnjigaIzlazaController.this.prikaziVanValute.setDisable(false);
                KnjigaIzlazaController.this.cbPaid.setSelected(false);
                KnjigaIzlazaController.this.tfDaysUValuti.setDisable(true);
                KnjigaIzlazaController.this.tfDaysVanValute.setDisable(false);
                KnjigaIzlazaController.this.loadTableDocuments();
            }
        });
        this.prikaziUValuti.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (KnjigaIzlazaController.this.prikaziUValuti.isSelected()) {
                    if (!KnjigaIzlazaController.this.tfDaysUValuti.getText().equals("")) {
                        KnjigaIzlazaController.this.interval = Integer.parseInt(KnjigaIzlazaController.this.tfDaysUValuti.getText().trim());
                        KnjigaIzlazaController.this.loadTableDocuments();
                    } else {
                        KnjigaIzlazaController.this.controller.alert("Obavestenje", "Morate upasati BROJ dana u tekstualnom polju", KnjigaIzlazaController.this.rootPane.getScene().getWindow());
                        KnjigaIzlazaController.this.prikaziUValuti.setSelected(false);
                    }
                } else {
                    KnjigaIzlazaController.this.interval = 0;
                    KnjigaIzlazaController.this.loadTableDocuments();
                    KnjigaIzlazaController.this.tfDaysUValuti.setText("");
                    KnjigaIzlazaController.this.prikaziUValuti.setDisable(false);
                }
            }
        });
        this.prikaziVanValute.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (KnjigaIzlazaController.this.prikaziVanValute.isSelected()) {
                    if (!KnjigaIzlazaController.this.tfDaysVanValute.getText().equals("")) {
                        KnjigaIzlazaController.this.interval = Integer.parseInt(KnjigaIzlazaController.this.tfDaysVanValute.getText().trim());
                        KnjigaIzlazaController.this.loadTableDocuments();
                    } else {
                        KnjigaIzlazaController.this.controller.alert("Obavestenje", "Morate upasati BROJ dana u tekstualnom polju", KnjigaIzlazaController.this.rootPane.getScene().getWindow());
                    }
                } else {
                    KnjigaIzlazaController.this.interval = 0;
                    KnjigaIzlazaController.this.loadTableDocuments();
                    KnjigaIzlazaController.this.tfDaysVanValute.setText("");
                    KnjigaIzlazaController.this.prikaziVanValute.setDisable(false);
                }
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> observable, Document oldValue, Document newValue) {
                if (newValue != null) {
                    KnjigaIzlazaController.this.btnPaid.setDisable(false);
                    KnjigaIzlazaController.this.loadTablePR(newValue.getDocumentID());
                    if (!KnjigaIzlazaController.this.tablePR.getItems().isEmpty()) {
                        KnjigaIzlazaController.this.btnPrint.setDisable(false);
                    }
                } else {
                    KnjigaIzlazaController.this.btnPaid.setDisable(true);
                    KnjigaIzlazaController.this.btnPrint.setDisable(true);
                }
            }
        });
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.paidAction();
                }
            });
            return row;
        });
    }

    public void init() {
        this.dpFrom.setValue((Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpTo.setValue((Object)LocalDate.now());
        this.interval = 0;
        Person p = new Person();
        p.setPersonID(-1L);
        p.setName("Svi kupci");
        this.cbPerson.getItems().add((Object)p);
        this.cbPerson.getItems().addAll((Collection)Person.getListByCategory((String)PersonCategory.BUYER, (boolean)true, (Connection)this.controller.getSettings().getConnection()));
        this.cbPerson.getSelectionModel().selectFirst();
        if (this.cbUValuti.isSelected()) {
            this.prikaziUValuti.setDisable(false);
            this.prikaziVanValute.setDisable(true);
            this.tfDaysUValuti.setDisable(false);
            this.tfDaysVanValute.setDisable(true);
        }
        this.loadTableDocuments();
    }

    public void setParameter(Object parameter) {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
    }

    public Object getParameter() {
        return null;
    }

    private void loadTableDocuments() {
        this.columnNumber.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.columnDocDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.columnDocDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnDate.setCellValueFactory((Callback)new PropertyValueFactory("CurrencyDate"));
        this.columnDate.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPerson.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)KnjigaIzlazaController.this.controller)).name("Name").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.columnValue.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.columnValue.setCellFactory((Callback)this.cellFactory);
        this.columnValuePaid.setCellValueFactory((Callback)new PropertyValueFactory("Paid"));
        this.columnValuePaid.setCellFactory((Callback)this.cellFactory);
        String type = DocumentType.getByCode((String)"F", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID() + "," + DocumentType.getByCode((String)"VPF", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID();
        ObservableList tableList = Document.getKnjigaList((Person)((Person)this.cbPerson.getSelectionModel().getSelectedItem()), (String)type, (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpFrom.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpTo.getValue())), (String)this.tfFilter.getText(), (boolean)this.cbPaid.isSelected(), (boolean)this.cbUValuti.isSelected(), (boolean)this.cbVanValute.isSelected(), (int)this.interval, (ScreensController)this.controller);
        if (!tableList.isEmpty()) {
            this.table.setItems(tableList);
        } else {
            this.table.getItems().clear();
        }
        this.btnPaid.setDisable(true);
        this.allDocValue();
    }

    private void loadTablePR(long documentID) {
        this.columnPRNote.setCellValueFactory((Callback)new PropertyValueFactory("note"));
        this.columnPRDate.setCellValueFactory((Callback)new PropertyValueFactory("sysCreateDate"));
        this.columnPRDate.setCellFactory(column -> new TableCell<PaymentRecord, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.columnPRPaidAmount.setCellValueFactory((Callback)new PropertyValueFactory("paidAmount"));
        this.columnPRPaidAmount.setCellFactory((Callback)this.cellFactory);
        this.tablePR.setItems(PaymentRecord.getListByDocumentId((ScreensController)this.controller, (long)documentID));
        this.byDocValue();
    }

    @FXML
    private void printActionAll() {
        if (!this.table.getItems().isEmpty()) {
            final String reportFileName = "rs/petcom/backoffice/jasper/blagajna/KnjigaIzlazaAll.jasper";
            final HashMap<String, Object> hm = new HashMap<String, Object>();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.table.getItems().size(); ++i) {
                stringBuilder.append(String.valueOf(((Document)this.table.getItems().get(i)).getDocumentID()));
                if (this.table.getItems().size() == i + 1) continue;
                stringBuilder.append(",");
            }
            CompanyConfig company = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
            hm.put("objekat", this.controller.getObject());
            hm.put("company", company);
            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            if (file.exists() && file.isFile()) {
                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            } else {
                hm.put("memorandum", "");
            }
            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
            hm.put("All_Id", stringBuilder.toString());
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje stampe placanja u toku.", this.rootPane.getScene().getWindow());
            Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

                protected JasperPrint call() throws Exception {
                    try {
                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)KnjigaIzlazaController.this.controller.getSettings().getConnection());
                        virtualizer.setReadOnly(true);
                        return jprint;
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
            creatingReport.setOnSucceeded(arg_0 -> this.lambda$printActionAll$5(taskUpdateStage, (Task)creatingReport, arg_0));
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje kalkulacije", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)creatingReport).start();
        } else {
            this.controller.alert("Obavestenje", "Mora postojati bar jedan dokument u tabeli", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void paidAction() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hMap = new HashMap<String, Object>();
            hMap.put("controller", this.controller);
            hMap.put("document", this.table.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Dodavanje placanja", ScreensController.DIALOG_BACKOFFICE_PAID_AMOUNT, hMap, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadTableDocuments();
            }
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele za koji zelite da odradite placanje", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void printAction() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            final String reportFileName = "rs/petcom/backoffice/jasper/blagajna/KnjigaIzlaza.jasper";
            final HashMap<String, Object> hm = new HashMap<String, Object>();
            Document document = (Document)this.table.getSelectionModel().getSelectedItem();
            CompanyConfig company = CompanyConfig.getByID((long)this.controller.getObject().getCompanyConfigID(), (ScreensController)this.controller);
            hm.put("objekat", this.controller.getObject());
            hm.put("company", company);
            File file = new File(this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            if (file.exists() && file.isFile()) {
                hm.put("memorandum", this.controller.getSettings().getSetting("company.memorandum", this.controller.getPointOfSale()));
            } else {
                hm.put("memorandum", "");
            }
            hm.put("person", Person.getByCode((String)"1", (Connection)this.controller.getSettings().getConnection()));
            hm.put("documentId", document.getDocumentID());
            hm.put("document", document);
            hm.put("dobavljac", Person.getById((long)document.getPersonID(), (ScreensController)this.controller));
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Kreiranje stampe placanja u toku.", this.rootPane.getScene().getWindow());
            Task<JasperPrint> creatingReport = new Task<JasperPrint>(){

                protected JasperPrint call() throws Exception {
                    try {
                        JRGzipVirtualizer virtualizer = new JRGzipVirtualizer(0);
                        hm.put("REPORT_VIRTUALIZER", virtualizer);
                        JasperReport report = (JasperReport)JRLoader.loadObject((InputStream)JRLoader.getResourceInputStream((String)reportFileName));
                        JasperPrint jprint = JasperFillManager.fillReport((JasperReport)report, (Map)hm, (Connection)KnjigaIzlazaController.this.controller.getSettings().getConnection());
                        virtualizer.setReadOnly(true);
                        return jprint;
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
            creatingReport.setOnSucceeded(arg_0 -> this.lambda$printAction$8(taskUpdateStage, (Task)creatingReport, arg_0));
            creatingReport.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no kreiranje kalkulacije", this.rootPane.getScene().getWindow());
            });
            creatingReport.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)creatingReport).start();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele za koji zelite da stampate placanja", this.rootPane.getScene().getWindow());
        }
    }

    void allDocValue() {
        double sum = 0.0;
        for (Document document : this.table.getItems()) {
            sum += document.getSumWithDiscount();
        }
        this.lblAllDocValue.setText(String.valueOf(Settings.round((double)sum, (int)2)));
    }

    void byDocValue() {
        double sum = 0.0;
        for (PaymentRecord paymentRecord : this.tablePR.getItems()) {
            sum += paymentRecord.getPaidAmount();
        }
        this.lblByDocValue.setText(String.valueOf(Settings.round((double)sum, (int)2)));
    }

    private /* synthetic */ void lambda$printAction$8(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
        HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
        hm2.put("report", printViewPane);
        this.controller.showModalDialog("Knjiga ulaza", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
    }

    private /* synthetic */ void lambda$printActionAll$5(Stage taskUpdateStage, Task creatingReport, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        JRPrintPreviewPaneOld printViewPane = new JRPrintPreviewPaneOld((JasperPrint)creatingReport.getValue());
        HashMap<String, JRPrintPreviewPaneOld> hm2 = new HashMap<String, JRPrintPreviewPaneOld>();
        hm2.put("report", printViewPane);
        this.controller.showModalDialog("Knjiga ulaza", ScreensController.DIALOG_PRINT_PREVIEW, hm2, this.rootPane.getScene().getWindow());
    }
}

