/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;

public class WebDocumentsController
implements ControlledScreen {
    ScreensController controller;
    CashBuyer selectedCashBuyer;
    HashMap<String, java.lang.Object> hm;
    DocumentType docType;
    ObservableList<Document> documentList;
    ObservableList<DocumentDetails> detailesList;
    ObservableList<Document> data;
    @FXML
    private BorderPane rootPane;
    @FXML
    private VBox actionPanel;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    TableView<Document> documentsTable;
    @FXML
    TableColumn<Document, Integer> tcDocBroj;
    @FXML
    TableColumn<Document, Date> tcDocDatum;
    @FXML
    TableColumn<Document, String> tcDocKomitent;
    @FXML
    TableColumn<Document, Double> tcDocVrednost;
    @FXML
    TableView<DocumentDetails> docDetailesTable;
    @FXML
    TableColumn<DocumentDetails, String> tcDocDetProduct;
    @FXML
    TableColumn<DocumentDetails, String> tcDocStatus;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetQuantity;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetPrice;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetValue;
    @FXML
    DatePicker dpStartWorkDay;
    @FXML
    DatePicker dpEndWorkDay;
    @FXML
    TextField tfFilter;
    @FXML
    Label lDocCount;
    @FXML
    Label lDocValue;

    public void initialize() {
        this.documentsTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Document>(){

            public void onChanged(ListChangeListener.Change<? extends Document> c) {
                WebDocumentsController.this.loadDocDetTable();
            }
        });
        this.tcDocBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocKomitent.setCellValueFactory((Callback)new PropertyValueFactory("personName"));
        this.tcDocVrednost.setCellValueFactory((Callback)new PropertyValueFactory("Sum"));
        this.tcDocVrednost.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetProduct.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcDocStatus.setCellValueFactory((Callback)new PropertyValueFactory("statusName"));
        this.tcDocDetQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcDocDetQuantity.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)4, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcDocDetPrice.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tcDocDetValue.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.dpStartWorkDay.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
        this.dpEndWorkDay.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
        this.dpStartWorkDay.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.dpEndWorkDay.valueProperty().addListener((obs, oldDate, newDate) -> this.loadDocTable());
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != null && newValue.length() < oldValue.length()) {
                    WebDocumentsController.this.documentsTable.setItems(WebDocumentsController.this.data);
                }
                String value = newValue.toLowerCase();
                ObservableList subentries = FXCollections.observableArrayList();
                long count = WebDocumentsController.this.documentsTable.getColumns().stream().count();
                block0: for (int i = 0; i < WebDocumentsController.this.documentsTable.getItems().size(); ++i) {
                    int j = 0;
                    while ((long)j < count) {
                        String entry = "" + ((TableColumn)WebDocumentsController.this.documentsTable.getColumns().get(j)).getCellData(i);
                        if (entry.toLowerCase().contains(value)) {
                            subentries.add(WebDocumentsController.this.documentsTable.getItems().get(i));
                            continue block0;
                        }
                        ++j;
                    }
                }
                WebDocumentsController.this.documentsTable.setItems(subentries);
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
        }
    }

    public void setParameter(java.lang.Object parameter) {
        this.hm = (HashMap)parameter;
        this.docType = DocumentType.getByCode((String)this.hm.get("documentCode").toString(), (Connection)this.controller.getSettings().getConnection());
        if (this.docType.getCode().equals("WR")) {
            this.popuniDugmiceZaRacune();
        }
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(false);
                break;
            }
        }
        if (this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(false);
                break;
            }
        }
        this.loadDocTable();
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void cbPosChange() {
        this.loadDocTable();
    }

    @FXML
    private void cbPaymentMethodChange() {
        try {
            this.loadDocTable();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void dpWorkDayClick() {
        this.loadDocTable();
        this.loadDocDetTable();
    }

    private void loadDocTable() {
        if (this.cbObject.getSelectionModel().getSelectedItem() != null && this.dpStartWorkDay.getValue() != null) {
            this.documentsTable.setItems(Document.getObeservableListWebRacun((int)DocumentType.getByCode((String)"WR", (Connection)this.controller.getSettings().getConnection()).getDocumentTypeID(), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpStartWorkDay.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpEndWorkDay.getValue())), (Connection)this.controller.getSettings().getConnection()));
        }
        double sum = 0.0;
        for (Document d : this.documentsTable.getItems()) {
            sum += d.getSumWithDiscount();
        }
        this.lDocCount.setText(String.valueOf(this.documentsTable.getItems().size()));
        this.lDocValue.setText(String.valueOf(sum));
        this.data = this.documentsTable.getItems();
    }

    private void loadDocDetTable() {
        try {
            this.detailesList = DocumentDetails.getObeservableList((long)((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        }
        catch (NullPointerException e) {
            this.detailesList = FXCollections.observableArrayList();
        }
        this.docDetailesTable.setItems(this.detailesList);
    }

    private void popuniDugmiceZaRacune() {
        this.actionPanel.getChildren().clear();
        Button printCashBill = new Button("\u0160tampa");
        printCashBill.setPrefWidth(120.0);
        printCashBill.setWrapText(true);
        printCashBill.setId("Web racun");
        printCashBill.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    Document d = Document.getByID((long)((Document)WebDocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)WebDocumentsController.this.controller.getSettings().getConnection());
                    d.setBi(((Document)WebDocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getBi());
                    d.printWebInvoice(Person.getById((long)d.getPersonID(), (ScreensController)WebDocumentsController.this.controller), WebDocumentsController.this.controller, WebDocumentsController.this.rootPane.getScene().getWindow());
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    WebDocumentsController.this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele za stampu", WebDocumentsController.this.rootPane.getScene().getWindow());
                }
            }
        });
        Button changeStatus = new Button("Status");
        changeStatus.setPrefWidth(120.0);
        changeStatus.setWrapText(true);
        changeStatus.setId("Status");
        changeStatus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    Document d = Document.getByID((long)((Document)WebDocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)WebDocumentsController.this.controller.getSettings().getConnection());
                    d.setDocumentStatusID(1);
                    d.update(WebDocumentsController.this.controller);
                    WebDocumentsController.this.loadDocTable();
                }
                catch (NullPointerException | SQLException e) {
                    e.printStackTrace();
                    WebDocumentsController.this.controller.alert("Obavestenje", "Morate odabrati dokument iz tabele za promenu status", WebDocumentsController.this.rootPane.getScene().getWindow());
                }
            }
        });
        this.actionPanel.getChildren().addAll((java.lang.Object[])new Node[]{printCashBill, changeStatus});
    }

    public void runTask() {
        double wndwWidth = 300.0;
        Label updateLabel = new Label("Stampa ra\u010duna u toku...");
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{updateLabel, progress});
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        final Stage taskUpdateStage = new Stage();
        taskUpdateStage.setScene(new Scene((Parent)updatePane));
        taskUpdateStage.initOwner(this.rootPane.getScene().getWindow());
        taskUpdateStage.initStyle(StageStyle.UTILITY);
        taskUpdateStage.show();
        Task<Void> longTask = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 50;
                for (int i = 1; i <= max && this.isCancelled(); ++i) {
                    this.updateProgress(i, max);
                    this.updateMessage("Task part " + String.valueOf(i) + " complete");
                }
                return null;
            }
        };
        longTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                taskUpdateStage.hide();
            }
        });
        progress.progressProperty().bind((ObservableValue)longTask.progressProperty());
        updateLabel.textProperty().bind((ObservableValue)longTask.messageProperty());
        taskUpdateStage.show();
        new Thread((Runnable)longTask).start();
    }
}

