/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.WorkDay;

public class RekapitulacijaUtrosakaController
implements ControlledScreen {
    ScreensController controller;
    StringConverter<LocalDate> converter = new StringConverter<LocalDate>(){
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

        public String toString(LocalDate date) {
            if (date != null) {
                return this.dateFormatter.format(date);
            }
            return "";
        }

        public LocalDate fromString(String string) {
            if (string != null && !string.isEmpty()) {
                return LocalDate.parse(string, this.dateFormatter);
            }
            return null;
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    private DatePicker dateFrom;
    @FXML
    private DatePicker dateTo;
    @FXML
    private BorderPane reportPane;
    @FXML
    private Button btnUtrosci;
    @FXML
    private Button btnNivelacija;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.dateFrom.setConverter(this.converter);
        this.dateFrom.setValue((java.lang.Object)LocalDate.now());
        this.dateTo.setConverter(this.converter);
        this.dateTo.setValue((java.lang.Object)LocalDate.now());
        this.cbObject.setItems(Object.getList((Connection)this.controller.getSettings().getConnection()));
        for (Object o : this.cbObject.getItems()) {
            if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
            this.cbObject.getSelectionModel().select((java.lang.Object)o);
            break;
        }
    }

    @FXML
    private void showReport(ActionEvent event) {
        try {
            if ((Button)event.getSource() == this.btnUtrosci) {
                for (WorkDay wd : WorkDay.getList((LocalDate)((LocalDate)this.dateFrom.getValue()), (LocalDate)((LocalDate)this.dateTo.getValue()), (int)((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID(), (Connection)this.controller.getSettings().getConnection())) {
                    wd.saveRecap(this.controller);
                }
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("title", "Rekalkulacija utro\u0161aka");
                hm.put("text", "Rekalkulacija utro\u0161aka zavr\u0161ena");
                this.controller.showModalDialog("RekalkulacijaUtro\u0161aka", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            } else {
                for (WorkDay wd : WorkDay.getListWithLastClosedPOSInDep((LocalDate)((LocalDate)this.dateFrom.getValue()), (LocalDate)((LocalDate)this.dateTo.getValue()), (int)((Object)this.cbObject.getSelectionModel().getSelectedItem()).getObjectID(), (Connection)this.controller.getSettings().getConnection())) {
                    wd.deleteNivelacijaForWD(this.controller);
                }
                for (WorkDay wd : WorkDay.getWorkDayFroNivelation((LocalDate)((LocalDate)this.dateFrom.getValue()), (LocalDate)((LocalDate)this.dateTo.getValue()), (ScreensController)this.controller)) {
                    wd.createNivelation(this.controller);
                    wd.createNivelationSellingChangePrice(this.controller);
                }
                HashMap hm = new HashMap();
                hm.put("title", "Retroaktivna nivelacija");
                hm.put("text", "Retroaktivna nivelacija zavr\u0161ena");
                this.controller.showModalDialog("RetroaktivnaNivelacija", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            }
        }
        catch (SQLException e) {
            this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisa u bazu\n\n" + e.getMessage(), this.rootPane.getScene().getWindow());
        }
    }
}

