/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Group;
import rs.petcom.master.dal.KitchenDisplay;
import rs.petcom.master.dal.NormativeItem;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PointOfSaleProductDescription;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Printer;
import rs.petcom.master.dal.ProductToPrinter;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.product.Description;
import rs.petcom.master.dal.product.GroupPointOfSale;
import rs.petcom.master.dal.product.GroupPointOfSaleProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.ProductType;

public class ProductsController
implements ControlledScreen {
    ScreensController controller;
    Product oldValue = null;
    Product selectedProduct = null;
    Printer selectedPrinter = null;
    ProductToPrinter selectedProductToPrinter = null;
    ProductDepartment pd = new ProductDepartment();
    NormativeItem selectedNormative = null;
    PointOfSaleProductDescription selectedPointOfSaleProductDescription = null;
    Description selectedDescription = null;
    Product selectedDodatni = null;
    ProductType selectedProductType = new ProductType();
    Group selectedGroup = new Group();
    Object sviObjekti = new Object(-1, "Svi objekti");
    KitchenDisplay nemaDisplaya = new KitchenDisplay(-1, -1, "");
    ObservableList<Product> productList;
    ObservableList<Vat> vatList;
    ObservableList<ProductCategory> productCategoryList;
    ObservableList<ProductType> productTypeList;
    ObservableList<Unit> productUnitList;
    ObservableList<NormativeItem> normativeList;
    ObservableList<NormativeItem> normativeKopirajList;
    ObservableList<PointOfSaleProductDescription> descriptionIdList;
    ObservableList<GroupPointOfSaleProduct> additionalList;
    @FXML
    BorderPane rootPane;
    @FXML
    TableView<Product> productTable;
    @FXML
    TableColumn<Product, String> codeCol;
    @FXML
    TableColumn<Product, String> nameCol;
    @FXML
    TableColumn<Product, String> grupeCol;
    @FXML
    TableColumn<Product, String> shortNameCol;
    @FXML
    TableColumn<Product, String> jedinicaMereCol;
    @FXML
    ComboBox<Object> cbObjekat;
    @FXML
    ComboBox<Department> cbOdeljenje;
    @FXML
    ComboBox<PointOfSale> cbPos;
    @FXML
    TextField tfFilter;
    @FXML
    CheckBox cbSamoAktivni;
    @FXML
    ComboBox<ProductType> cbTipArtikla;
    @FXML
    ComboBox<Group> cbGrupaArtikala;
    @FXML
    Tab tabGrupe;
    @FXML
    Tab tabNormativ;
    @FXML
    Tab tabDodatni;
    @FXML
    Tab tabOpisni;
    @FXML
    Tab tabRobnaKartica;
    @FXML
    Tab tabPOSPriner;
    @FXML
    TextField tfCode;
    @FXML
    TextField tfCena;
    @FXML
    TextField tfName;
    @FXML
    TextField tfShortName;
    @FXML
    CheckBox cbActive;
    @FXML
    CheckBox cbMeasurable;
    @FXML
    CheckBox cbDiscountAllowed;
    @FXML
    ComboBox<Vat> cbVat;
    @FXML
    TextField tfNutritional;
    @FXML
    TextField tfEnergy;
    @FXML
    ComboBox<ProductCategory> cbCategory;
    @FXML
    ComboBox<ProductType> cbType;
    @FXML
    ComboBox<Unit> cbUnit;
    @FXML
    TextField tfPrepTime;
    @FXML
    ComboBox<KitchenDisplay> cbKitchenDisplay;
    @FXML
    AnchorPane apGrupe;
    @FXML
    AnchorPane apNormativ;
    @FXML
    HBox hbGrupeNormativ;
    @FXML
    TableView<NormativeItem> normativTable;
    @FXML
    TableColumn<NormativeItem, String> ntColCode;
    @FXML
    TableColumn<NormativeItem, String> ntColName;
    @FXML
    TableColumn<NormativeItem, String> ntColShortName;
    @FXML
    TableColumn<NormativeItem, String> ntColUnit;
    @FXML
    TableColumn<NormativeItem, Double> ntColNormative;
    @FXML
    TableColumn<NormativeItem, Integer> ntColOrder;
    @FXML
    TextField tfNormative;
    @FXML
    TextField tfOrder;
    @FXML
    TableView<GroupPointOfSaleProduct> tableGroup;
    @FXML
    TableColumn<GroupPointOfSaleProduct, String> grColName;
    @FXML
    TextField tfGroupSort;
    @FXML
    TextField tfGroupPosition;
    @FXML
    ColorPicker cpGroupColor;
    @FXML
    CheckBox cbGroupActive;
    @FXML
    TableView<Product> tableDodatni;
    @FXML
    TableColumn<Product, String> dodatniColCode;
    @FXML
    TableColumn<Product, String> dodatniColName;
    @FXML
    TextField tfPozicijaDodatni;
    @FXML
    ColorPicker cpDodatni;
    ArrayList<ProductDepartment> productDepartments;
    ArrayList<Product> aditionalProducts;
    @FXML
    TableView<PointOfSaleProductDescription> tableOpisni;
    @FXML
    TableColumn<PointOfSaleProductDescription, Integer> opisniColId;
    @FXML
    TableColumn<PointOfSaleProductDescription, String> opisniColName;
    @FXML
    TextField tfOpisniSort;
    @FXML
    TextField tfOpisniPosition;
    @FXML
    TextField tfOpisniColor;
    @FXML
    CheckBox cbOpisniActive;
    @FXML
    ColorPicker colorPickerOpisni;
    @FXML
    TableView<Document> robnaKarticaTable;
    @FXML
    TableColumn<Document, String> datumColumnRK;
    @FXML
    TableColumn<Document, Double> ulazColumnRK;
    @FXML
    TableColumn<Document, Double> izlazColumnRK;
    @FXML
    TableColumn<Document, Double> stanjeColumnRK;
    @FXML
    TableColumn<Document, Double> nabavnaCenaColumnRK;
    @FXML
    TableColumn<Document, Double> nabavnaVrednostColumnRK;
    @FXML
    TableColumn<Document, String> nazivDokumentaCenaColumnRK;
    @FXML
    DatePicker datePickerOdRobnaKartica;
    @FXML
    DatePicker datePickerDoRobnaKartica;
    @FXML
    TableView<Printer> tablePOSPrinter;
    @FXML
    TableColumn<Printer, Integer> columnPOSPrinterID;
    @FXML
    TableColumn<Printer, String> columnPOSPrinterName;

    public void initialize() {
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsController.this.loadProductList(ProductsController.this.cbSamoAktivni.isSelected(), ((Group)ProductsController.this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)ProductsController.this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
            }
        });
        this.tfNormative.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (ProductsController.this.tfNormative.isFocused()) {
                    ProductsController.this.tfNormative.requestFocus();
                    ProductsController.this.tfNormative.positionCaret(0);
                    ProductsController.this.tfNormative.selectAll();
                }
            }
        });
        this.cbSamoAktivni.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ProductsController.this.tfFilter.setText("");
                try {
                    if (newValue.booleanValue()) {
                        ProductsController.this.loadProductList(newValue, ((Group)ProductsController.this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)ProductsController.this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
                    } else {
                        ProductsController.this.loadProductList(newValue, ((Group)ProductsController.this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)ProductsController.this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        if (this.controller.getUser().hasRole("izmena.normativa")) {
            this.hbGrupeNormativ.setDisable(false);
            this.apGrupe.setDisable(false);
            this.apNormativ.setDisable(false);
        } else {
            this.hbGrupeNormativ.setDisable(true);
            this.apGrupe.setDisable(true);
            this.apNormativ.setDisable(true);
        }
        this.cbObjekat.getItems().add((java.lang.Object)this.sviObjekti);
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObjekat.getItems().add((java.lang.Object)o);
        }
        this.cbObjekat.getSelectionModel().select((java.lang.Object)this.sviObjekti);
        this.cbOdeljenje.setDisable(true);
        this.cbPos.setDisable(true);
        this.cbSamoAktivni.setSelected(true);
        this.tabGrupe.setDisable(true);
        this.tabNormativ.setDisable(true);
        this.tabDodatni.setDisable(true);
        this.tabOpisni.setDisable(true);
        this.datePickerOdRobnaKartica.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
        this.datePickerDoRobnaKartica.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
        this.popuniFilterOdeljene();
        this.popuniFilterPos();
        this.popuniFilterTipaArtikala();
        this.popuniFilterGrupeArtikala();
        this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
        this.tfFilter.setText("");
        this.vatList = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
        this.productCategoryList = ProductCategory.getObeservableList((Connection)this.controller.getSettings().getConnection());
        this.productTypeList = this.selectedProductType.getObeservableList(this.cbSamoAktivni.isSelected(), this.controller.getSettings().getConnection());
        this.productUnitList = Unit.getList((Connection)this.controller.getSettings().getConnection());
        this.codeCol.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.grupeCol.setCellValueFactory((Callback)new PropertyValueFactory("GroupName"));
        this.shortNameCol.setCellValueFactory((Callback)new PropertyValueFactory("ShortName"));
        this.jedinicaMereCol.setCellValueFactory((Callback)new PropertyValueFactory("UnitName"));
        this.productTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Product>(){

            public void onChanged(ListChangeListener.Change<? extends Product> c) {
                try {
                    ProductsController.this.clearProductGroupData();
                    ProductsController.this.tableGroup.getSelectionModel().clearSelection();
                    if (!ProductsController.this.cbOdeljenje.getSelectionModel().isSelected(0)) {
                        int ProductTypeId = ((Product)ProductsController.this.productTable.getSelectionModel().getSelectedItem()).getProductTypeID();
                        if (ProductTypeId == 3 || ProductTypeId == 4 || ProductTypeId == 6 || ProductTypeId == 7) {
                            ProductsController.this.tabNormativ.setDisable(false);
                        } else {
                            ProductsController.this.tabNormativ.setDisable(true);
                        }
                    }
                    ProductsController.this.loadPrinterProduct(((Product)ProductsController.this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                }
                catch (NullPointerException e) {
                    ProductsController.this.tabNormativ.setDisable(false);
                }
                ProductsController.this.loadOpisni();
                ProductsController.this.loadDodatni();
                ProductsController.this.showProduct((Product)ProductsController.this.productTable.getSelectionModel().getSelectedItem());
            }
        });
        this.tableGroup.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<GroupPointOfSaleProduct>(){

            public void onChanged(ListChangeListener.Change<? extends GroupPointOfSaleProduct> c) {
                ObservableList list = FXCollections.observableArrayList();
                try {
                    list = GroupPointOfSaleProduct.getListProductGroup((PointOfSale)((PointOfSale)ProductsController.this.cbPos.getSelectionModel().getSelectedItem()), (Product)((Product)ProductsController.this.productTable.getSelectionModel().getSelectedItem()), (String)ProductsController.this.tfFilter.getText(), (int)((GroupPointOfSaleProduct)ProductsController.this.tableGroup.getSelectionModel().getSelectedItem()).getGroupID(), (Connection)ProductsController.this.controller.getSettings().getConnection());
                    for (GroupPointOfSaleProduct gposp : list) {
                        ProductsController.this.showProductGroupData(gposp);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.tfCode.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsController.this.selectedProduct.setCode(newValue);
            }
        });
        this.tfName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsController.this.selectedProduct.setName(newValue);
            }
        });
        this.tfShortName.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ProductsController.this.selectedProduct.setShortName(newValue);
            }
        });
        this.cbVat.setItems(this.vatList);
        this.cbVat.valueProperty().addListener((ChangeListener)new ChangeListener<Vat>(){

            public void changed(ObservableValue<? extends Vat> observable, Vat oldValue, Vat newValue) {
                try {
                    ProductsController.this.selectedProduct.setVatID(newValue.getVatID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbCategory.setItems(this.productCategoryList);
        this.cbCategory.valueProperty().addListener((ChangeListener)new ChangeListener<ProductCategory>(){

            public void changed(ObservableValue<? extends ProductCategory> observable, ProductCategory oldValue, ProductCategory newValue) {
                try {
                    ProductsController.this.selectedProduct.setProductCategoryID(newValue.getProductCategoryID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbType.setItems(this.productTypeList);
        this.cbType.valueProperty().addListener((ChangeListener)new ChangeListener<ProductType>(){

            public void changed(ObservableValue<? extends ProductType> observable, ProductType oldValue, ProductType newValue) {
                try {
                    ProductsController.this.selectedProduct.setProductTypeID(newValue.getProductTypeID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbUnit.setItems(this.productUnitList);
        this.cbUnit.valueProperty().addListener((ChangeListener)new ChangeListener<Unit>(){

            public void changed(ObservableValue<? extends Unit> observable, Unit oldValue, Unit newValue) {
                try {
                    ProductsController.this.selectedProduct.setUnitID(newValue.getUnitID());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.cbActive.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ProductsController.this.selectedProduct.setActive(newValue.booleanValue());
            }
        });
        this.cbMeasurable.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ProductsController.this.selectedProduct.setMeasurable(newValue.booleanValue());
            }
        });
        this.tfNutritional.setTextFormatter(new TextFormatter(Settings.getDoubleFilter()));
        this.tfNutritional.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    ProductsController.this.selectedProduct.setNutritionalValue(Settings.getNumberFormat((int)4, (boolean)true).parse(newValue).doubleValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.tfEnergy.setTextFormatter(new TextFormatter(Settings.getDoubleFilter()));
        this.tfEnergy.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    ProductsController.this.selectedProduct.setEnergyValue(Settings.getNumberFormat((int)4, (boolean)true).parse(newValue).doubleValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.normativTable.setItems(this.normativeList);
        this.normativTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<NormativeItem>(){

            public void onChanged(ListChangeListener.Change<? extends NormativeItem> c) {
                ProductsController.this.showNormative((NormativeItem)ProductsController.this.normativTable.getSelectionModel().getSelectedItem());
            }
        });
        this.ntColCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.ntColName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.ntColShortName.setCellValueFactory((Callback)new PropertyValueFactory("ShortName"));
        this.ntColUnit.setCellValueFactory((Callback)new PropertyValueFactory("UnitName"));
        this.ntColNormative.setCellValueFactory((Callback)new PropertyValueFactory("Normative"));
        this.ntColOrder.setCellValueFactory((Callback)new PropertyValueFactory("Order"));
        this.ntColOrder.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<NormativeItem, Integer>>(){

            public void handle(TableColumn.CellEditEvent<NormativeItem, Integer> t) {
                ((NormativeItem)t.getTableView().getItems().get(t.getTablePosition().getRow())).setOrder(((Integer)t.getNewValue()).intValue());
            }
        });
        this.tfOrder.setTextFormatter(new TextFormatter(Settings.getDoubleFilter()));
        this.tfOrder.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    ProductsController.this.selectedNormative.setOrder(Settings.getNumberFormat((int)0, (boolean)true).parse(newValue).intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.grColName.setCellValueFactory((Callback)new PropertyValueFactory("GroupName"));
        this.tableGroup.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<GroupPointOfSaleProduct>(){

            public void onChanged(ListChangeListener.Change<? extends GroupPointOfSaleProduct> c) {
            }
        });
        this.tableDodatni.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Product>(){

            public void onChanged(ListChangeListener.Change<? extends Product> c) {
                ProductsController.this.showDodatniData((Product)ProductsController.this.tableDodatni.getSelectionModel().getSelectedItem());
            }
        });
        this.tfPozicijaDodatni.textProperty().addListener(e -> this.setDodatniPozicija());
        this.cpDodatni.setOnAction(arg0 -> this.setDodatniColor());
        this.tableOpisni.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<PointOfSaleProductDescription>(){

            public void onChanged(ListChangeListener.Change<? extends PointOfSaleProductDescription> c) {
                if (ProductsController.this.tableOpisni.isFocused()) {
                    ProductsController.this.showOpisniData((PointOfSaleProductDescription)ProductsController.this.tableOpisni.getSelectionModel().getSelectedItem());
                }
            }
        });
    }

    private void showProduct(Product p) {
        try {
            this.oldValue = p.getCopy();
            this.selectedProduct = p;
            this.tfCode.setText(this.selectedProduct.getCode());
            this.tfCena.setText("" + this.selectedProduct.getPrice());
            this.tfName.setText(this.selectedProduct.getName());
            this.tfShortName.setText(this.selectedProduct.getShortName());
            this.cbActive.setSelected(this.selectedProduct.isActive());
            this.cbMeasurable.setSelected(this.selectedProduct.isMeasurable());
            this.cbVat.setValue((java.lang.Object)this.getVatByIndex(this.selectedProduct.getVatID()));
            this.cbCategory.setValue((java.lang.Object)this.getProductCategoryByIndex(this.selectedProduct.getProductCategoryID()));
            this.cbType.setValue((java.lang.Object)this.getProductTypeByIndex(this.selectedProduct.getProductTypeID()));
            this.cbUnit.setValue((java.lang.Object)this.getProductUnitByIndex(this.selectedProduct.getUnitID()));
            this.tfNutritional.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.selectedProduct.getNutritionalValue()));
            this.tfEnergy.setText(Settings.getNumberFormat((int)4, (boolean)true).format(this.selectedProduct.getEnergyValue()));
            if (this.selectedProduct.getPreparationTime() != null) {
                this.tfPrepTime.setText(Settings.getTimeFromatter().format(this.selectedProduct.getPreparationTime()));
            } else {
                this.tfPrepTime.setText("");
            }
            this.getKitchenDisplayByIndex(this.selectedProduct.getKitchenDisplayID());
            this.loadNormative(p.getProductDepartmentID());
            this.loadGroup();
            this.loadDodatni();
        }
        catch (NullPointerException e) {
            this.tfCode.setText("");
            this.tfCena.setText("");
            this.tfName.setText("");
            this.tfShortName.setText("");
            this.cbActive.setSelected(false);
            this.cbMeasurable.setSelected(false);
            this.cbVat.getSelectionModel().select(0);
            this.cbCategory.getSelectionModel().select(0);
            this.cbType.getSelectionModel().select(0);
            this.tfNutritional.setText("");
            this.tfEnergy.setText("");
            this.tfPozicijaDodatni.setText("");
        }
    }

    private Vat getVatByIndex(int id) {
        for (Vat v : this.vatList) {
            if (v.getVatID() != id) continue;
            return v;
        }
        return null;
    }

    private ProductCategory getProductCategoryByIndex(int id) {
        for (ProductCategory pc : this.productCategoryList) {
            if (pc.getProductCategoryID() != id) continue;
            return pc;
        }
        return null;
    }

    private ProductType getProductTypeByIndex(int id) {
        for (ProductType pt : this.productTypeList) {
            if (pt.getProductTypeID() != id) continue;
            return pt;
        }
        return null;
    }

    private Unit getProductUnitByIndex(int id) {
        for (Unit u : this.productUnitList) {
            if (u.getUnitID() != id) continue;
            return u;
        }
        return null;
    }

    private void getKitchenDisplayByIndex(int id) {
        boolean selected = false;
        for (int i = 0; i < this.cbKitchenDisplay.getItems().size(); ++i) {
            if (((KitchenDisplay)this.cbKitchenDisplay.getItems().get(i)).getKitchenDisplayID() != id) continue;
            this.cbKitchenDisplay.getSelectionModel().select(i);
            selected = true;
            break;
        }
        if (!selected) {
            this.cbKitchenDisplay.getSelectionModel().select(0);
        }
    }

    @FXML
    private void commitArtikal() {
        try {
            if (this.selectedProduct.getProductID() != new Long(0L).longValue()) {
                try {
                    this.selectedProduct.update(this.controller.getUser(), Boolean.valueOf(this.cbMeasurable.isSelected()), Boolean.valueOf(this.cbDiscountAllowed.isSelected()), this.controller.getSettings().getConnection());
                    if (this.selectedProduct.havePriceListDetailesID(this.controller.getSettings().getConnection())) {
                        PriceListDetailes.updatePrice((double)Double.parseDouble(this.tfCena.getText()), (long)this.selectedProduct.getProductID(), (int)1, (Connection)this.controller.getSettings().getConnection());
                    } else {
                        PriceListDetailes.insertProductPrice((long)this.selectedProduct.getProductID(), (double)Double.parseDouble(this.tfCena.getText()), (Connection)this.controller.getSettings().getConnection());
                    }
                    this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
                }
                catch (SQLException e) {
                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", e.getMessage(), this.rootPane.getScene().getWindow());
                }
            } else {
                this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
            }
        }
        catch (NullPointerException e) {
            this.controller.alert("Obavestenje", "Odaberite artikal iz tabele", this.rootPane.getScene().getWindow());
        }
        this.selectedProduct = null;
    }

    @FXML
    private void cancelAction() {
        this.selectedProduct = this.oldValue.getCopy();
        this.showProduct(this.selectedProduct);
    }

    @FXML
    private void sacuvajDodatnePodatke() {
        try {
            if (this.selectedProduct.getProductID() != new Long(0L).longValue()) {
                try {
                    this.selectedProduct.update(this.controller.getUser(), Boolean.valueOf(this.cbMeasurable.isSelected()), Boolean.valueOf(this.cbDiscountAllowed.isSelected()), this.controller.getSettings().getConnection());
                    this.pd.setKitchenDisplayID(((KitchenDisplay)this.cbKitchenDisplay.getSelectionModel().getSelectedItem()).getKitchenDisplayID());
                    this.pd.setPreparationTime(Time.valueOf(this.tfPrepTime.getText()));
                    this.pd.updateKitchenMonitor(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID(), ((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductDepartmentID(), this.controller.getSettings().getConnection());
                    this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
                }
                catch (SQLException e) {
                    this.controller.alert("Gre\u0161ka prilikom snimanja izmena", e.getMessage(), this.rootPane.getScene().getWindow());
                    e.printStackTrace();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void copyAction() {
    }

    @FXML
    private void deleteAction() {
        if (this.cbOdeljenje.getSelectionModel().getSelectedItem() == null || ((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID() == -1) {
            try {
                ((Product)this.productTable.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.productTable.getItems().remove(this.productTable.getSelectionModel().getSelectedItem());
                this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
            }
            catch (SQLException e) {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("title", "Gre\u0161ka prilikom brisanja");
                hm.put("text", "Artikal se ne mo\u017ee obrisati, vec je unet u arhivu");
                this.controller.showModalDialog("Gre\u0161ka prilikom brisanja", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            }
        } else {
            try {
                ProductDepartment pd = new ProductDepartment();
                pd.setProductDepartmentID(this.selectedProduct.getProductDepartmentID());
                pd.delete(this.controller.getSettings().getConnection());
                this.productTable.getItems().remove((java.lang.Object)this.selectedProduct);
                this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
            }
            catch (SQLException e) {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("title", "Gre\u0161ka prilikom brisanja");
                hm.put("text", "Artikal se ne mo\u017ee obrisati, vec je unet u arhivu");
                this.controller.showModalDialog("Gre\u0161ka prilikom brisanja", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
            }
        }
    }

    @FXML
    private void newAction() {
        if (this.cbObjekat.getSelectionModel().getSelectedItem() != this.sviObjekti) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("department", this.cbOdeljenje.getSelectionModel().getSelectedItem());
            int mr = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
            if (mr == ScreensController.MODAL_RESULT_OK) {
                try {
                    ProductDepartment pd = new ProductDepartment();
                    pd.setProductID(((Product)hm.get("product")).getProductID());
                    pd.setSort(0);
                    pd.setActive(true);
                    pd.setFavorite(false);
                    pd.setMin(0L);
                    pd.setMax(0L);
                    pd.setWarehouseID(0);
                    pd.setPrinterID(0);
                    pd.setDepartmentID(((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID());
                    pd.insert(this.controller.getSettings().getConnection());
                    this.productList = Product.getObeservableList(null, (String)"", (boolean)false, (Department)((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection());
                    this.productTable.setItems(this.productList);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
            hm2.put("controller", this.controller);
            int result = this.controller.showModalDialog("Dodavanje artikla", ScreensController.DIALOG_BACKOFFICE_ADD_PRODUCT, hm2, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
            }
        }
    }

    private void loadNormative(long productId) {
        try {
            this.normativeList = NormativeItem.getObeservableList((long)productId, (Department)((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection());
            this.normativTable.setItems(this.normativeList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void showNormative(NormativeItem ni) {
        this.selectedNormative = ni;
        try {
            this.tfNormative.setText(Settings.getNumberFormat((int)6, (boolean)true).format(ni.getNormative()));
        }
        catch (NullPointerException e) {
            this.tfNormative.setText("");
        }
        try {
            this.tfOrder.setText(Settings.getNumberFormat((int)0, (boolean)true).format(ni.getOrder()));
        }
        catch (NullPointerException e) {
            this.tfOrder.setText("");
        }
    }

    @FXML
    private void normativeComit() {
        if (this.selectedNormative != null) {
            try {
                this.selectedNormative.setNormative(new BigDecimal(this.tfNormative.getText()));
                this.selectedNormative.setOrder(Settings.getNumberFormat((int)0, (boolean)true).parse(this.tfOrder.getText()).intValue());
                this.selectedNormative.update(this.controller.getSettings().getConnection());
                this.loadNormative(this.selectedProduct.getProductDepartmentID());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void normativeNew() {
        if (this.selectedProduct != null) {
            Product p = new Product();
            p.setProductID(this.selectedProduct.getProductID());
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("product", p);
            hm.put("controller", this.controller);
            hm.put("productController", this);
            hm.put("department", this.cbOdeljenje.getSelectionModel().getSelectedItem());
            hm.put("normative", this.normativeList);
            int result = this.controller.showModalDialog("Izbor proizvoda", ScreensController.DIALOG_SELECT_NORMATIVE_PRODUCT, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                NormativeItem ni = new NormativeItem();
                ni.setArticleProductDepartmenID(this.selectedProduct.getProductDepartmentID());
                ni.setProduct((Product)hm.get("product"));
                ni.setNormative(new BigDecimal(1.0));
                int maxOrder = 0;
                for (int i = 0; i < this.normativeList.size(); ++i) {
                    if (maxOrder >= ((NormativeItem)this.normativeList.get(i)).getOrder()) continue;
                    maxOrder = ((NormativeItem)this.normativeList.get(i)).getOrder();
                }
                ni.setOrder(maxOrder + 1);
                ni.insert(this.controller.getSettings().getConnection());
                this.loadNormative(this.selectedProduct.getProductDepartmentID());
                this.normativTable.getSelectionModel().select(this.normativeList.size() - 1);
                this.showNormative((NormativeItem)this.normativTable.getSelectionModel().getSelectedItem());
            }
        }
    }

    @FXML
    private void normativeDelete() {
        if (this.selectedNormative != null) {
            this.selectedNormative.delete(this.controller.getSettings().getConnection());
            this.loadNormative(this.selectedProduct.getProductDepartmentID());
        }
    }

    @FXML
    private void normativeKopirajComit() {
        HashMap<String, java.lang.Object> hm2 = new HashMap<String, java.lang.Object>();
        hm2.put("controller", this.controller);
        hm2.put("productController", this);
        hm2.put("normativeItem", this.selectedNormative);
        this.controller.showModalDialog("Kopiranje normativa", ScreensController.DIALOG_COPY_NORMATIV, hm2, this.rootPane.getScene().getWindow());
    }

    private void loadGroup() {
        try {
            this.tableGroup.setItems(GroupPointOfSaleProduct.getListGroup((PointOfSale)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()), (Product)this.selectedProduct, (String)"", (Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void loadOpisni() {
        try {
            this.opisniColId.setCellValueFactory((Callback)new PropertyValueFactory("DescriptionID"));
            this.opisniColName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
            this.descriptionIdList = PointOfSaleProductDescription.getListLoadTableOpisni((PointOfSale)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()), (Product)((Product)this.productTable.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection());
            this.tableOpisni.setItems(this.descriptionIdList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void opisniNew() {
        if (this.selectedProduct != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("user", this.controller.getUser());
            hm.put("PointOfSale", this.cbPos.getSelectionModel().getSelectedItem());
            hm.put("connection", this.controller.getSettings().getConnection());
            hm.put("product", this.selectedProduct);
            hm.put("description", this.selectedDescription);
            Group g = new Group();
            hm.put("group", g);
            int result = this.controller.showModalDialog("Izbor grupe", ScreensController.DIALOG_SELECT_OPISNI, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                this.selectedDescription = (Description)hm.get("description");
                PointOfSaleProductDescription pospd = new PointOfSaleProductDescription();
                pospd.setColor("#" + Integer.toHexString(((Color)this.colorPickerOpisni.getValue()).hashCode()).substring(0, 6).toUpperCase());
                pospd.setPointOfSaleID(((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
                pospd.setProductID(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID());
                pospd.setDescriptionID(this.selectedDescription.getDescriptionID());
                pospd.setActive(this.selectedDescription.isActive());
                pospd.insert(this.controller.getSettings().getConnection());
                this.loadOpisni();
            }
        }
    }

    @FXML
    private void opisniDelete() {
        try {
            ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.loadOpisni();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void opisniPost() {
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setPointOfSaleID(((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setProductID(this.selectedProduct.getProductID());
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setDescriptionID(((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).getDescriptionID());
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setColor("#" + Integer.toHexString(((Color)this.colorPickerOpisni.getValue()).hashCode()).substring(0, 6).toUpperCase());
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setActive(this.cbOpisniActive.isSelected());
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setPositionBtn(Integer.parseInt(this.tfOpisniPosition.getText()));
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).setPointOfSaleProductDescriptionID(((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).getPointOfSaleProductDescriptionID());
        ((PointOfSaleProductDescription)this.tableOpisni.getSelectionModel().getSelectedItem()).update(this.controller.getSettings().getConnection());
    }

    @FXML
    private void groupNew() {
        if (this.selectedProduct != null) {
            try {
                HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
                hm.put("user", this.controller.getUser());
                hm.put("PointOfSale", this.cbPos.getSelectionModel().getSelectedItem());
                hm.put("connection", this.controller.getSettings().getConnection());
                hm.put("product", this.selectedProduct);
                Group g = new Group();
                hm.put("group", g);
                int result = this.controller.showModalDialog("Izbor grupe", ScreensController.DIALOG_SELECT_GROUP, hm, this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_OK) {
                    GroupPointOfSaleProduct gpp = new GroupPointOfSaleProduct();
                    GroupPointOfSale gps = GroupPointOfSale.getFromDb((int)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID(), (int)((Group)hm.get("group")).getGroupID(), (Connection)this.controller.getSettings().getConnection());
                    gpp.setGroupID(gps.getGroupID());
                    gpp.setProductID(this.selectedProduct.getProductID());
                    gpp.setProductDepartmentID(this.selectedProduct.getProductDepartmentID());
                    gpp.setActive(true);
                    gpp.setSysUserAddID(this.controller.getUser().getUserID());
                    gpp.setColor("#" + Integer.toHexString(((Color)this.cpGroupColor.getValue()).hashCode()).substring(0, 6).toUpperCase());
                    gpp.setPointOfSaleID(((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
                    ObservableList listPosition = GroupPointOfSaleProduct.getListPosition((int)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID(), (int)((Group)hm.get("group")).getGroupID(), (Connection)this.controller.getSettings().getConnection());
                    for (int i = 1; i < 46; ++i) {
                        if (i == ((GroupPointOfSaleProduct)listPosition.get(i - 1)).getPosition()) continue;
                        gpp.insert(i, this.controller.getSettings().getConnection());
                        this.controller.alert("Obavestenje", "Artiklu je dodeljena pozicija: " + i, this.rootPane.getScene().getWindow());
                        break;
                    }
                    this.loadGroup();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void groupDelete() {
        try {
            ((GroupPointOfSaleProduct)this.tableGroup.getSelectionModel().getSelectedItem()).delete(((GroupPointOfSaleProduct)this.tableGroup.getSelectionModel().getSelectedItem()).getGroupProductID(), this.controller.getSettings().getConnection());
            this.loadGroup();
            this.loadProductList(this.cbActive.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void groupPost() {
        try {
            ((Product)this.productTable.getSelectionModel().getSelectedItem()).setProductID(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID());
            ((Product)this.productTable.getSelectionModel().getSelectedItem()).setProductDepartmentID(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductDepartmentID());
            ((Product)this.productTable.getSelectionModel().getSelectedItem()).setActive(this.cbActive.isSelected());
            ((Product)this.productTable.getSelectionModel().getSelectedItem()).setPosition(Integer.parseInt(this.tfGroupPosition.getText()));
            ((Product)this.productTable.getSelectionModel().getSelectedItem()).setColor("#" + Integer.toHexString(((Color)this.cpGroupColor.getValue()).hashCode()).substring(0, 6).toUpperCase());
            ((Product)this.productTable.getSelectionModel().getSelectedItem()).updateProductGroup(((GroupPointOfSaleProduct)this.tableGroup.getSelectionModel().getSelectedItem()).getGroupID(), Integer.parseInt(this.tfGroupSort.getText()), ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID(), ((GroupPointOfSaleProduct)this.tableGroup.getSelectionModel().getSelectedItem()).getGroupProductID(), this.controller.getSettings().getConnection());
        }
        catch (NullPointerException e) {
            this.controller.alert("Obavestenje", "Morate selektovati GRUPU iz tabele", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void posPrinterNew() {
        if (this.selectedProduct != null) {
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("controller", this.controller);
            hm.put("product", this.selectedProduct);
            int result = this.controller.showModalDialog("Izbor printera", ScreensController.DIALOG_SELECT_PRINTER, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                ProductToPrinter ptp = new ProductToPrinter();
                ptp.setProductID(this.selectedProduct.getProductID());
                ptp.setPrinterID(((Printer)hm.get("printer")).getPrinterID());
                ptp.insertProductToPrinter(this.controller.getSettings().getConnection());
                this.loadPrinterProduct(this.selectedProduct.getProductID());
            }
        }
    }

    @FXML
    private void posPrinterDelete() {
        this.selectedProductToPrinter = new ProductToPrinter();
        this.selectedProductToPrinter.deleteProductToPrinter(((Printer)this.tablePOSPrinter.getSelectionModel().getSelectedItem()).getPrinterID(), this.controller.getSettings().getConnection());
        this.loadPrinterProduct(((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID());
    }

    private void showProductGroupData(GroupPointOfSaleProduct gposp) {
        try {
            this.tfGroupSort.setText(String.valueOf(gposp.getSort()));
        }
        catch (NullPointerException e) {
            this.tfGroupSort.setText("");
        }
        try {
            this.tfGroupPosition.setText("" + gposp.getPosition());
        }
        catch (NullPointerException e) {
            this.tfGroupPosition.setText("");
        }
        try {
            if (gposp.getColor() != null || gposp.getColor().equals("")) {
                this.cpGroupColor.setValue((java.lang.Object)Color.valueOf((String)gposp.getColor()));
            } else {
                this.cpGroupColor.setValue((java.lang.Object)Color.AZURE);
            }
        }
        catch (NullPointerException e) {
            this.cpGroupColor.setValue((java.lang.Object)Color.ALICEBLUE);
        }
        try {
            this.cbGroupActive.setSelected(gposp.isActive());
        }
        catch (NullPointerException e) {
            this.cbGroupActive.setSelected(false);
        }
    }

    private void clearProductGroupData() {
        this.tfGroupSort.setText("");
        this.tfGroupPosition.setText("");
        this.cpGroupColor.setValue((java.lang.Object)Color.ALICEBLUE);
        this.cbGroupActive.setSelected(false);
    }

    private void loadDodatni() {
        try {
            this.productDepartments = ProductDepartment.getAdditionalListPositionAndColor((long)this.selectedProduct.getProductID(), (int)((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID(), (PointOfSale)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()), (ScreensController)this.controller);
            this.aditionalProducts = new ArrayList();
            if (this.productDepartments != null) {
                for (ProductDepartment productDepartment : this.productDepartments) {
                    this.aditionalProducts.add(productDepartment.getProduct());
                }
            }
            this.dodatniColCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
            this.dodatniColName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.tableDodatni.setItems(FXCollections.observableArrayList(this.aditionalProducts));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void showDodatniData(Product selectedProductAditional) {
        try {
            int positionAditional = this.getProductDepartment(selectedProductAditional.getProductID()).getPosition();
            if (positionAditional == -1) {
                this.tfPozicijaDodatni.setText("");
            } else {
                this.tfPozicijaDodatni.setText("" + positionAditional);
            }
            try {
                this.cpDodatni.setValue((java.lang.Object)Color.valueOf((String)this.getProductDepartment(selectedProductAditional.getProductID()).getColor()));
            }
            catch (NullPointerException e) {
                this.cpDodatni.setValue((java.lang.Object)Color.valueOf((String)"#505050"));
            }
            if (this.productDepartments.isEmpty()) {
                this.tfPozicijaDodatni.setText("");
                this.cpDodatni.setValue((java.lang.Object)Color.valueOf((String)"#FFFFFF"));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    private void setDodatniPozicija() {
        this.selectedDodatni = (Product)this.tableDodatni.getSelectionModel().getSelectedItem();
        try {
            if (this.productDepartments != null) {
                ProductDepartment selectedDodatniProductDepartment = this.getProductDepartment(this.selectedDodatni.getProductID());
                selectedDodatniProductDepartment.setPosition(Integer.parseInt(this.tfPozicijaDodatni.getText()));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    private void setDodatniColor() {
        this.selectedDodatni = (Product)this.tableDodatni.getSelectionModel().getSelectedItem();
        try {
            if (this.productDepartments != null) {
                ProductDepartment selectedDodatniProductDepartment = this.getProductDepartment(this.selectedDodatni.getProductID());
                selectedDodatniProductDepartment.setColor(this.toRGBCode((Color)this.cpDodatni.getValue()));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ProductDepartment getProductDepartment(long productID) {
        ProductDepartment pDepartment = null;
        for (ProductDepartment productDepartment : this.productDepartments) {
            if (productDepartment.getProduct().getProductID() != productID) continue;
            pDepartment = productDepartment;
        }
        return pDepartment;
    }

    @FXML
    private void dodatniCommit() {
        for (ProductDepartment productDepartment : this.productDepartments) {
            productDepartment.updatePositionColor(this.selectedProduct.getProductID(), this.controller.getSettings().getConnection());
        }
    }

    @FXML
    private void dodatniNew() {
        if (this.selectedProduct != null) {
            Product p = new Product();
            p.setProductID(this.selectedProduct.getProductID());
            HashMap<String, java.lang.Object> hm = new HashMap<String, java.lang.Object>();
            hm.put("product", p);
            hm.put("controller", this.controller);
            hm.put("department", this.cbOdeljenje.getSelectionModel().getSelectedItem());
            int result = this.controller.showModalDialog("Izbor dodatnih proizvoda", ScreensController.DIALOG_SELECT_ADITIONAL_PRODUCT, hm, this.rootPane.getScene().getWindow());
            if (result == ScreensController.MODAL_RESULT_OK) {
                Product selectedAditionalProduct = (Product)hm.get("product");
                if (this.checkIfAditionalExist(selectedAditionalProduct.getProductID())) {
                    this.controller.alert("Obave\u0161tenje", "Dodatni proizvod ve\u00e6 postoji.", this.rootPane.getScene().getWindow());
                } else {
                    Product.insertProductAditional((int)((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID(), (Product)this.selectedProduct, (Product)selectedAditionalProduct, (Connection)this.controller.getSettings().getConnection());
                    this.loadDodatni();
                }
            }
        }
    }

    @FXML
    private void dodatniDelete() {
        this.selectedDodatni = (Product)this.tableDodatni.getSelectionModel().getSelectedItem();
        if (this.selectedDodatni != null) {
            Product.deleteAditionalProductPositionColor((long)this.selectedProduct.getProductID(), (Product)this.selectedDodatni, (Connection)this.controller.getSettings().getConnection());
            this.loadDodatni();
            this.tfPozicijaDodatni.setText("");
            this.cpDodatni.setValue((java.lang.Object)Color.valueOf((String)"#505050"));
        }
    }

    private boolean checkIfAditionalExist(long aditionalProductID) {
        for (Product p : this.tableDodatni.getItems()) {
            if (p.getProductID() != aditionalProductID) continue;
            return true;
        }
        return false;
    }

    private void showOpisniData(PointOfSaleProductDescription point) {
        try {
            if (point.getColor() != null || point.getColor().equals("")) {
                this.colorPickerOpisni.setValue((java.lang.Object)Color.valueOf((String)point.getColor()));
            } else {
                this.colorPickerOpisni.setValue((java.lang.Object)Color.AZURE);
            }
        }
        catch (NullPointerException e) {
            this.colorPickerOpisni.setValue((java.lang.Object)Color.ALICEBLUE);
        }
        try {
            this.tfOpisniPosition.setText("" + point.getPositionBtn());
        }
        catch (NullPointerException e) {
            this.tfOpisniPosition.setText("");
        }
        try {
            this.cbOpisniActive.setSelected(point.isActive());
        }
        catch (NullPointerException e) {
            this.cbOpisniActive.setSelected(false);
        }
    }

    @FXML
    private void objekatChange() {
        if (((Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID() == -1) {
            try {
                this.cbOdeljenje.getSelectionModel().select(0);
                this.cbPos.getSelectionModel().select(0);
                this.cbOdeljenje.setDisable(true);
                this.cbPos.setDisable(true);
                this.tabNormativ.setDisable(true);
                this.tabGrupe.setDisable(true);
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            this.popuniFilterOdeljene();
            this.cbOdeljenje.setDisable(false);
            this.cbOdeljenje.getSelectionModel().select(0);
            this.popuniFilterPos();
        }
    }

    @FXML
    private void departmentChange() {
        if (this.cbOdeljenje.getSelectionModel().getSelectedItem() == null || ((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()).getDepartmentID() == -1) {
            this.cbPos.getSelectionModel().select(0);
            this.cbPos.setDisable(true);
            this.tabNormativ.setDisable(true);
            this.tfPrepTime.setText("");
            this.tfPrepTime.setDisable(true);
            this.cbKitchenDisplay.getSelectionModel().select(-1);
            this.cbKitchenDisplay.setDisable(true);
        } else {
            this.tabDodatni.setDisable(false);
            this.cbPos.setDisable(false);
            this.tfPrepTime.setDisable(false);
            this.cbKitchenDisplay.setItems(KitchenDisplay.getList((Object)((Object)this.cbObjekat.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection()));
            if (this.cbKitchenDisplay.getItems().size() > 0) {
                this.cbKitchenDisplay.getSelectionModel().select(1);
            }
            this.cbKitchenDisplay.setDisable(false);
            this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
        }
    }

    @FXML
    private void posChange() {
        if (this.cbPos.getSelectionModel().getSelectedItem() == null || ((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID() == -1) {
            this.tabGrupe.setDisable(true);
            this.tabOpisni.setDisable(true);
        } else {
            this.tabGrupe.setDisable(false);
            this.tabOpisni.setDisable(false);
            this.tabNormativ.setDisable(false);
            this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
        }
        this.loadGroup();
    }

    @FXML
    private void cbTipArtiklaChange() {
        this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
    }

    @FXML
    private void cbGrupaArtiklaChange() {
        this.loadProductList(this.cbSamoAktivni.isSelected(), ((Group)this.cbGrupaArtikala.getSelectionModel().getSelectedItem()).getGroupID(), ((ProductType)this.cbTipArtikla.getSelectionModel().getSelectedItem()).getProductTypeID());
    }

    private void popuniFilterOdeljene() {
        this.cbOdeljenje.getItems().clear();
        for (Department d : Department.getList((Object)((Object)this.cbObjekat.getSelectionModel().getSelectedItem()), (String)"", (Connection)this.controller.getSettings().getConnection())) {
            this.cbOdeljenje.getItems().add((java.lang.Object)d);
        }
        this.cbPos.setDisable(true);
    }

    private void popuniFilterTipaArtikala() {
        this.cbTipArtikla.getItems().clear();
        ProductType sviTipovi = new ProductType();
        sviTipovi.setProductTypeID(-1);
        sviTipovi.setName("Svi Tipovi");
        this.cbTipArtikla.getItems().add((java.lang.Object)sviTipovi);
        for (ProductType productType : this.selectedProductType.getObeservableList(true, this.controller.getSettings().getConnection())) {
            this.cbTipArtikla.getItems().add((java.lang.Object)productType);
        }
        this.cbTipArtikla.getSelectionModel().select((java.lang.Object)sviTipovi);
    }

    private void popuniFilterGrupeArtikala() {
        this.cbGrupaArtikala.getItems().clear();
        Group sveGrupe = new Group();
        sveGrupe.setGroupID(-1);
        sveGrupe.setName("Sve Grupe");
        this.cbGrupaArtikala.getItems().add((java.lang.Object)sveGrupe);
        for (Group gr : Group.getList((String)"", (ScreensController)this.controller)) {
            this.cbGrupaArtikala.getItems().add((java.lang.Object)gr);
        }
        this.cbGrupaArtikala.getSelectionModel().select((java.lang.Object)sveGrupe);
    }

    private void popuniFilterPos() {
        this.cbPos.getItems().clear();
        PointOfSale sviPosovi = new PointOfSale();
        sviPosovi.setPointOfSaleID(-1);
        sviPosovi.setName("Sva prodajna mesta");
        this.cbPos.getItems().add((java.lang.Object)sviPosovi);
        for (PointOfSale p : PointOfSale.getPosList((Object)((Object)this.cbObjekat.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbPos.getItems().add((java.lang.Object)p);
        }
        this.cbPos.getSelectionModel().select((java.lang.Object)sviPosovi);
    }

    private void loadProductList(Boolean active, int groupID, int productTypeID) {
        this.productTable.getSelectionModel().clearSelection();
        long productId = -1L;
        try {
            productId = ((Product)this.productTable.getSelectionModel().getSelectedItem()).getProductID();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.productTable.getItems().clear();
        this.productTable.setItems(Product.getObeservableListActive((Object)this.controller.getObject(), (PointOfSale)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()), (Department)((Department)this.cbOdeljenje.getSelectionModel().getSelectedItem()), (String)this.tfFilter.getText(), (boolean)active, (int)groupID, (int)productTypeID, (Connection)this.controller.getSettings().getConnection()));
        if (productId > 0L) {
            for (Product p : this.productTable.getItems()) {
                if (p.getProductID() != productId) continue;
                this.productTable.getSelectionModel().select((java.lang.Object)p);
            }
        }
    }

    private void loadPrinterProduct(long productID) {
        this.columnPOSPrinterID.setCellValueFactory((Callback)new PropertyValueFactory("PrinterID"));
        this.columnPOSPrinterName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tablePOSPrinter.setItems(Printer.getProductToPrinter((long)productID, (Connection)this.controller.getSettings().getConnection()));
    }

    @FXML
    private void prikaziRobnuKarticu() {
        this.robnaKarticaTable.getItems().clear();
    }
}

