/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.PriceListType;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.gui.TimeTextField;
import tornadofx.control.DateTimePicker;

public class PriceListsController
implements ControlledScreen {
    ScreensController controller;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<PriceList> table;
    @FXML
    private TableColumn<PriceList, String> tcTitle;
    @FXML
    private TableColumn<PriceList, Date> tcDateFrom;
    @FXML
    private TableColumn<PriceList, Date> tcDateTo;
    @FXML
    private TableColumn<PriceList, String> tcType;
    @FXML
    private TableColumn<PriceList, Integer> tcPriority;
    @FXML
    private TextField tfTitle;
    @FXML
    private TextField tfComent;
    @FXML
    private CheckBox cbActive;
    @FXML
    private DateTimePicker dcDateFrom;
    @FXML
    private DateTimePicker dcDateTo;
    @FXML
    private TextField tfPriority;
    @FXML
    private ComboBox<Integer> cbDomOd;
    @FXML
    private ComboBox<Integer> cbDomDo;
    @FXML
    private ComboBox<PriceListType> cbType;
    @FXML
    private TimeTextField tfTimeOd;
    @FXML
    private TimeTextField tfTimeDo;
    @FXML
    private CheckBox cbMonday;
    @FXML
    private CheckBox cbTuesday;
    @FXML
    private CheckBox cbWednesday;
    @FXML
    private CheckBox cbThursday;
    @FXML
    private CheckBox cbFriday;
    @FXML
    private CheckBox cbSaturday;
    @FXML
    private CheckBox cbSunday;
    @FXML
    ComboBox<rs.petcom.master.dal.Object> cbObjekat;
    @FXML
    ComboBox<PointOfSale> cbPos;

    public void initialize() {
        this.cbType.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PriceListType>(){

            public void changed(ObservableValue<? extends PriceListType> selected, PriceListType oldValue, PriceListType newValue) {
                switch (newValue.getType()) {
                    case 1: {
                        PriceListsController.this.cbDomOd.setDisable(true);
                        PriceListsController.this.cbDomDo.setDisable(true);
                        PriceListsController.this.tfTimeOd.setDisable(true);
                        PriceListsController.this.tfTimeDo.setDisable(true);
                        PriceListsController.this.cbMonday.setDisable(true);
                        PriceListsController.this.cbTuesday.setDisable(true);
                        PriceListsController.this.cbWednesday.setDisable(true);
                        PriceListsController.this.cbThursday.setDisable(true);
                        PriceListsController.this.cbFriday.setDisable(true);
                        PriceListsController.this.cbSaturday.setDisable(true);
                        PriceListsController.this.cbSunday.setDisable(true);
                        break;
                    }
                    case 2: {
                        PriceListsController.this.cbDomOd.setDisable(false);
                        PriceListsController.this.cbDomDo.setDisable(false);
                        PriceListsController.this.tfTimeOd.setDisable(true);
                        PriceListsController.this.tfTimeDo.setDisable(true);
                        PriceListsController.this.cbMonday.setDisable(true);
                        PriceListsController.this.cbTuesday.setDisable(true);
                        PriceListsController.this.cbWednesday.setDisable(true);
                        PriceListsController.this.cbThursday.setDisable(true);
                        PriceListsController.this.cbFriday.setDisable(true);
                        PriceListsController.this.cbSaturday.setDisable(true);
                        PriceListsController.this.cbSunday.setDisable(true);
                        break;
                    }
                    case 3: {
                        PriceListsController.this.cbDomOd.setDisable(true);
                        PriceListsController.this.cbDomDo.setDisable(true);
                        PriceListsController.this.tfTimeOd.setDisable(true);
                        PriceListsController.this.tfTimeDo.setDisable(true);
                        PriceListsController.this.cbMonday.setDisable(false);
                        PriceListsController.this.cbTuesday.setDisable(false);
                        PriceListsController.this.cbWednesday.setDisable(false);
                        PriceListsController.this.cbThursday.setDisable(false);
                        PriceListsController.this.cbFriday.setDisable(false);
                        PriceListsController.this.cbSaturday.setDisable(false);
                        PriceListsController.this.cbSunday.setDisable(false);
                        break;
                    }
                    case 4: {
                        PriceListsController.this.cbDomOd.setDisable(true);
                        PriceListsController.this.cbDomDo.setDisable(true);
                        PriceListsController.this.tfTimeOd.setDisable(false);
                        PriceListsController.this.tfTimeDo.setDisable(false);
                        PriceListsController.this.cbMonday.setDisable(true);
                        PriceListsController.this.cbTuesday.setDisable(true);
                        PriceListsController.this.cbWednesday.setDisable(true);
                        PriceListsController.this.cbThursday.setDisable(true);
                        PriceListsController.this.cbFriday.setDisable(true);
                        PriceListsController.this.cbSaturday.setDisable(true);
                        PriceListsController.this.cbSunday.setDisable(true);
                    }
                }
            }
        });
        this.dcDateTo.getEditor().textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue.equals("")) {
                    PriceListsController.this.dcDateTo.setValue(null);
                }
            }
        });
        this.cbPos.setDisable(true);
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.tcTitle.setCellValueFactory((Callback)new PropertyValueFactory("Title"));
        this.tcDateFrom.setCellValueFactory((Callback)new PropertyValueFactory("DateFrom"));
        this.tcDateFrom.setCellFactory(column -> new TableCell<PriceList, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDateTo.setCellValueFactory((Callback)new PropertyValueFactory("DateTo"));
        this.tcDateTo.setCellFactory(column -> new TableCell<PriceList, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcType.setCellValueFactory((Callback)new PropertyValueFactory("Type"));
        this.tcPriority.setCellValueFactory((Callback)new PropertyValueFactory("Priority"));
        rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object();
        sviObjekti.setObjectID(-1);
        sviObjekti.setName("Svi objekti");
        this.cbObjekat.getItems().add((Object)sviObjekti);
        for (rs.petcom.master.dal.Object o : rs.petcom.master.dal.Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObjekat.getItems().add((Object)o);
        }
        this.cbObjekat.getSelectionModel().select((Object)sviObjekti);
        this.cbType.setItems(PriceListType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbDomOd.getItems().clear();
        this.cbDomDo.getItems().clear();
        for (int i = 1; i < 32; ++i) {
            this.cbDomOd.getItems().add((Object)new Integer(i));
            this.cbDomDo.getItems().add((Object)new Integer(i));
        }
        this.popuniFilterPos();
        this.loadTable();
        this.table.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<PriceList>(){

            public void onChanged(ListChangeListener.Change<? extends PriceList> c) {
                PriceListsController.this.fillPriceListData();
            }
        });
    }

    public void setParameter(Object parameter) {
    }

    public Object getParameter() {
        return null;
    }

    private void popuniFilterPos() {
        this.cbPos.getItems().clear();
        PointOfSale sviPosovi = new PointOfSale();
        sviPosovi.setPointOfSaleID(-1);
        sviPosovi.setName("Sva prodajna mesta");
        this.cbPos.getItems().add((Object)sviPosovi);
        this.cbPos.getSelectionModel().select((Object)sviPosovi);
        for (PointOfSale p : PointOfSale.getPosList((rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbPos.getItems().add((Object)p);
        }
    }

    @FXML
    private void objectChange() {
        this.popuniFilterPos();
    }

    @FXML
    private void podChange() {
        this.loadTable();
    }

    private void loadTable() {
        this.table.getItems().clear();
        this.table.setItems(PriceList.getObeservableList((boolean)true, (rs.petcom.master.dal.Object)((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection()));
    }

    @FXML
    private void showDetailes() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("priceList", this.table.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Cenovnik - Detalji", ScreensController.DIALOG_PRICE_LISTS_DETAILES, hm, this.rootPane.getScene().getWindow());
        }
    }

    private void setType() {
        try {
            for (PriceListType plt : this.cbType.getItems()) {
                if (plt.getType() != ((PriceList)this.table.getSelectionModel().getSelectedItem()).getPriceListTypeID()) continue;
                this.cbType.getSelectionModel().select((Object)plt);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setDomFrom() {
        try {
            for (Integer b : this.cbDomOd.getItems()) {
                if (b.intValue() != ((PriceList)this.table.getSelectionModel().getSelectedItem()).getDomFrom()) continue;
                this.cbDomOd.getSelectionModel().select((Object)b);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setDomTo() {
        try {
            for (Integer b : this.cbDomDo.getItems()) {
                if (b.intValue() != ((PriceList)this.table.getSelectionModel().getSelectedItem()).getDomTo()) continue;
                this.cbDomDo.getSelectionModel().select((Object)b);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void fillPriceListData() {
        if (this.table.getSelectionModel().getSelectedItem() != null) {
            PriceList pl = (PriceList)this.table.getSelectionModel().getSelectedItem();
            this.setType();
            this.tfPriority.setText(String.valueOf(pl.getPriority()));
            this.cbActive.setSelected(pl.isActive());
            this.dcDateFrom.setDateTimeValue(Settings.LocalDateTimefromDate((Date)pl.getDateFrom()));
            if (pl.getDateTo() != null) {
                this.dcDateTo.setValue((Object)Settings.fromDate((Date)pl.getDateTo()));
            } else {
                this.dcDateTo.setValue(null);
            }
            this.tfTitle.setText(pl.getTitle());
            this.tfComent.setText(pl.getComment());
            if (pl.getPriceListTypeID() == 2) {
                this.setDomFrom();
                this.setDomTo();
            } else {
                this.cbDomOd.getSelectionModel().select(-1);
                this.cbDomDo.getSelectionModel().select(-1);
            }
            if (pl.getPriceListTypeID() == 3) {
                this.cbMonday.setSelected(pl.isMonday());
                this.cbTuesday.setSelected(pl.isTuesday());
                this.cbWednesday.setSelected(pl.isWednesday());
                this.cbThursday.setSelected(pl.isThursday());
                this.cbFriday.setSelected(pl.isFriday());
                this.cbSaturday.setSelected(pl.isSaturday());
                this.cbSunday.setSelected(pl.isSunday());
            } else {
                this.cbMonday.setSelected(false);
                this.cbTuesday.setSelected(false);
                this.cbWednesday.setSelected(false);
                this.cbThursday.setSelected(false);
                this.cbFriday.setSelected(false);
                this.cbSaturday.setSelected(false);
                this.cbSunday.setSelected(false);
            }
            if (pl.getPriceListTypeID() == 4) {
                if (pl.getTimeFrom() != null) {
                    this.tfTimeOd.setText(Settings.getTimeFromatter().format(pl.getTimeFrom()));
                }
                if (pl.getTimeTo() != null) {
                    this.tfTimeDo.setText(Settings.getTimeFromatter().format(pl.getTimeTo()));
                }
            } else {
                this.tfTimeOd.setText("00:00:00");
                this.tfTimeDo.setText("00:00:00");
            }
        } else {
            this.setType();
            this.tfPriority.setText("");
            this.cbActive.setSelected(false);
            this.dcDateFrom.setValue(null);
            this.dcDateTo.setValue(null);
            this.tfTitle.setText("");
            this.tfComent.setText("");
            this.cbMonday.setSelected(false);
            this.cbTuesday.setSelected(false);
            this.cbWednesday.setSelected(false);
            this.cbThursday.setSelected(false);
            this.cbFriday.setSelected(false);
            this.cbSaturday.setSelected(false);
            this.cbSunday.setSelected(false);
            this.tfTimeOd.setText("");
            this.tfTimeDo.setText("");
        }
    }

    @FXML
    private void save() {
        PriceList pl = (PriceList)this.table.getSelectionModel().getSelectedItem();
        if (pl.getPriceListID() < 1L) {
            pl.setObjectID(((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID());
        }
        pl.setPointOfSaleID(((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        pl.setPriceListTypeID(((PriceListType)this.cbType.getSelectionModel().getSelectedItem()).getType());
        pl.setTitle(this.tfTitle.getText());
        pl.setComment(this.tfComent.getText());
        pl.setDateFrom(Settings.DatefromLocalDateTime((LocalDateTime)this.dcDateFrom.getDateTimeValue()));
        if (!this.dcDateTo.getEditor().getText().equals("")) {
            pl.setDateTo(Settings.DatefromLocalDateTime((LocalDateTime)this.dcDateTo.getDateTimeValue()));
        } else {
            pl.setDateTo(null);
        }
        if (pl.getPriceListTypeID() == 2) {
            pl.setDomFrom(((Integer)this.cbDomOd.getSelectionModel().getSelectedItem()).byteValue());
            pl.setDomTo(((Integer)this.cbDomDo.getSelectionModel().getSelectedItem()).byteValue());
        } else {
            pl.setDomFrom((byte)0);
            pl.setDomTo((byte)0);
        }
        if (pl.getPriceListTypeID() == 3) {
            pl.setMonday(this.cbMonday.isSelected());
            pl.setTuesday(this.cbTuesday.isSelected());
            pl.setWednesday(this.cbWednesday.isSelected());
            pl.setThursday(this.cbThursday.isSelected());
            pl.setFriday(this.cbFriday.isSelected());
            pl.setSaturday(this.cbSaturday.isSelected());
            pl.setSunday(this.cbSunday.isSelected());
        } else {
            pl.setMonday(false);
            pl.setTuesday(false);
            pl.setWednesday(false);
            pl.setThursday(false);
            pl.setFriday(false);
            pl.setSaturday(false);
            pl.setSunday(false);
        }
        if (pl.getPriceListTypeID() == 4) {
            pl.setTimeFrom((Date)Time.valueOf(this.tfTimeOd.getText()));
            pl.setTimeTo((Date)Time.valueOf(this.tfTimeDo.getText()));
        } else {
            pl.setTimeFrom(null);
            pl.setTimeTo(null);
        }
        pl.setPriority(Byte.parseByte(this.tfPriority.getText()));
        pl.setActive(this.cbActive.isSelected());
        if (pl.getPriceListID() > 0L) {
            pl.update(this.controller.getSettings().getConnection());
        } else {
            pl.insert(this.controller.getSettings().getConnection());
        }
        this.table.refresh();
    }

    @FXML
    private void newPricelist() {
        PriceList pl = new PriceList();
        pl.setPriceListID(new Long(-1L));
        pl.setPriceListTypeID(1);
        pl.setActive(false);
        pl.setDateFrom(new Date());
        pl.setObjectID(((rs.petcom.master.dal.Object)this.cbObjekat.getSelectionModel().getSelectedItem()).getObjectID());
        pl.setPointOfSaleID(((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()).getPointOfSaleID());
        pl.insert(this.controller.getSettings().getConnection());
        this.table.getItems().add((Object)pl);
        this.table.scrollTo((Object)pl);
        this.table.getSelectionModel().select((Object)pl);
        this.fillPriceListData();
    }

    @FXML
    private void deletePricelist() {
        try {
            PriceListDetailes pDetailes = new PriceListDetailes();
            pDetailes.setPriceListID(((PriceList)this.table.getSelectionModel().getSelectedItem()).getPriceListID());
            pDetailes.deleteALLByPriceListID(this.controller.getSettings().getConnection());
            ((PriceList)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
        catch (SQLException e) {
            e.printStackTrace();
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("title", "Brisanje cenovnika nije mogu\u0107e!");
            hm.put("text", "\nPoruka o gre\u0161ci:\n\n" + e.getLocalizedMessage());
            this.controller.showModalDialog("Brisanje cenovnika nije mogu\u0107e!", ScreensController.DIALOG_ALLERT_TRGOVINA, hm, this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void dcDateToChange() {
    }
}

