/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.animation.RotateTransition;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Duration;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class PriceListDetailesController
implements DialogController {
    ScreensController controller;
    PriceList priceList;
    int modalResult;
    ObservableList<PriceListDetailes> data;
    ObservableList<PriceListDetailes> list;
    ObservableList<PriceListDetailes> listNivelation;
    FilteredList<PriceListDetailes> filteredData;
    ArrayList<PriceListDetailes> deletedItems = new ArrayList();
    ArrayList<PriceListDetailes> insertItems = new ArrayList();
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), null);
    EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case DELETE: {
                    PriceListDetailesController.this.productRemove(null);
                    break;
                }
                case INSERT: {
                    PriceListDetailesController.this.productAdd(null);
                    break;
                }
            }
        }
    };
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<PriceListDetailes> table;
    @FXML
    private TableColumn<PriceListDetailes, String> tcCode;
    @FXML
    private TableColumn<PriceListDetailes, String> tcName;
    @FXML
    private TableColumn<PriceListDetailes, String> tcBarCode;
    @FXML
    private TableColumn<Object, Double> tcPrice;
    @FXML
    private TableColumn<Object, Double> tcDiscount;
    @FXML
    private TableColumn<PriceListDetailes, Date> tcDate;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfDiscount;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private Button btnAddPrice;
    @FXML
    private Button btnImportCsv;
    @FXML
    private DateTimePicker dpDate;

    public void initialize() {
        this.dpDate.setDateTimeValue(LocalDateTime.now());
        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, this.eventHandler);
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        this.tcCode.setCellValueFactory((Callback)new PropertyValueFactory("Code"));
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<PriceListDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<PriceListDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject((long)((PriceListDetailes)param.getValue()).getProductID(), (Connection)PriceListDetailesController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException | NullPointerException e) {
                    return null;
                }
            }
        });
        this.tcName.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcPrice.setCellFactory((Callback)cellFactory);
        this.tcPrice.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                PriceListDetailes pld = (PriceListDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow());
                pld.setPrice((Double)t.getNewValue());
                if (pld.getPriceListDetailsID() > 0L && new Date().getTime() > pld.getDate().getTime()) {
                    pld.setDate(new Date());
                    pld.setPriceListDetailsID(new Long(-1L));
                }
                PriceListDetailesController.this.clearFields();
                PriceListDetailesController.this.loadTable();
            }
        });
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory);
        this.tcDiscount.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((PriceListDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDiscount((Double)t.getNewValue());
            }
        });
        this.tcDate.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDate.setCellFactory(column -> new TableCell<PriceListDetailes, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.priceList = (PriceList)parameter.get("priceList");
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Task<Void> sleeper = new Task<Void>(){

                    protected Void call() throws Exception {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return null;
                    }
                };
                sleeper.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                    public void handle(WorkerStateEvent event) {
                        PriceListDetailesController.this.loadTable();
                    }
                });
                new Thread((Runnable)sleeper).start();
            }
        });
        this.tfPrice.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                    PriceListDetailesController.this.actionAddPrice(new ActionEvent());
                    PriceListDetailesController.this.cbProduct.requestFocus();
                }
            }
        });
        this.tfDiscount.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
                this.actionAddPrice(new ActionEvent());
                this.cbProduct.getEditor().setText("");
                this.cbProduct.getSelectionModel().clearSelection();
                this.cbProduct.requestFocus();
            }
        });
        this.loadTable();
        this.cbFilterType.getItems().addAll((Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilterType.getSelectionModel().selectFirst();
        this.cbFilterType.setOnAction(actionEvent -> this.cbProductAutoComplete.setFilterType((String)this.cbFilterType.getSelectionModel().getSelectedItem()));
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, -1, ScreensController.FILTER_ALL, this.tfPrice);
        this.cbProductAutoComplete.setLoadAllProduct(true);
        this.deletedItems.clear();
        this.insertItems.clear();
        this.table.setFocusTraversable(false);
    }

    private void loadTable() {
        this.list = PriceListDetailes.getList((PriceList)this.priceList, (String)this.tfFilter.getText(), (Connection)this.controller.getSettings().getConnection());
        this.table.setItems(this.list);
        this.data = this.table.getItems();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void productAddFromPriceList(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("pricelist", this.priceList);
        int mr = this.controller.showModalDialog("Izbor cenovnika", ScreensController.DIALOG_SELECT_PRICELIST, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            PriceList pl = (PriceList)hm.get("pricelistID");
            ObservableList listPriceListDetails = PriceListDetailes.getList((PriceList)pl, (String)"", (Connection)this.controller.getSettings().getConnection());
            Date datePickerValue = Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue());
            for (int i = 0; i < listPriceListDetails.size(); ++i) {
                int existIndex = this.checkIfProductExist(((PriceListDetailes)listPriceListDetails.get(i)).getProductID());
                if (existIndex >= 0) {
                    if (((PriceListDetailes)this.table.getItems().get(existIndex)).getPriceListDetailsID() > 0L) {
                        if (((PriceListDetailes)this.table.getItems().get(existIndex)).getDate().getTime() > new Date().getTime()) {
                            if (datePickerValue.getTime() > new Date().getTime()) {
                                ((PriceListDetailes)this.table.getItems().get(existIndex)).setDate(datePickerValue);
                            }
                        } else {
                            ((PriceListDetailes)this.table.getItems().get(existIndex)).setPriceListDetailsID(new Long(-1L));
                            ((PriceListDetailes)this.table.getItems().get(existIndex)).setDate(datePickerValue);
                        }
                    }
                    ((PriceListDetailes)this.table.getItems().get(existIndex)).setPrice(Double.valueOf(0.0));
                    ((PriceListDetailes)this.table.getItems().get(existIndex)).setDiscount(Double.valueOf(0.0));
                    continue;
                }
                ((PriceListDetailes)listPriceListDetails.get(i)).setPriceListDetailsID(new Long(-1L));
                ((PriceListDetailes)listPriceListDetails.get(i)).setPriceListID(this.priceList.getPriceListID());
                ((PriceListDetailes)listPriceListDetails.get(i)).setPrice(Double.valueOf(0.0));
                ((PriceListDetailes)listPriceListDetails.get(i)).setDiscount(Double.valueOf(0.0));
                ((PriceListDetailes)listPriceListDetails.get(i)).setDate(datePickerValue);
                this.list.add(listPriceListDetails.get(i));
            }
            this.table.refresh();
            this.table.requestFocus();
            this.clearFields();
        }
    }

    @FXML
    public void actionAddPrice(ActionEvent event) {
        Product selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            Date datePickerValue = Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue());
            try {
                int existIndex = this.checkIfProductExist(selectedProduct.getProductID());
                if (existIndex >= 0) {
                    if (((PriceListDetailes)this.table.getItems().get(existIndex)).getPriceListDetailsID() > 0L) {
                        if (((PriceListDetailes)this.table.getItems().get(existIndex)).getDate().getTime() > new Date().getTime()) {
                            if (datePickerValue.getTime() > new Date().getTime()) {
                                ((PriceListDetailes)this.table.getItems().get(existIndex)).setDate(datePickerValue);
                            }
                        } else {
                            ((PriceListDetailes)this.table.getItems().get(existIndex)).setPriceListDetailsID(new Long(-1L));
                            ((PriceListDetailes)this.table.getItems().get(existIndex)).setDate(datePickerValue);
                        }
                    }
                    ((PriceListDetailes)this.table.getItems().get(existIndex)).setPrice(Double.valueOf(Double.parseDouble(this.tfPrice.getText())));
                    try {
                        ((PriceListDetailes)this.table.getItems().get(existIndex)).setDiscount(Double.valueOf(Double.parseDouble(this.tfDiscount.getText())));
                    }
                    catch (NumberFormatException e) {
                        ((PriceListDetailes)this.table.getItems().get(existIndex)).setDiscount(Double.valueOf(0.0));
                    }
                    this.table.getSelectionModel().select(existIndex);
                    this.table.scrollTo(existIndex);
                    this.table.refresh();
                } else {
                    PriceListDetailes pld = new PriceListDetailes();
                    pld.setPriceListDetailsID(new Long(-1L));
                    pld.setProductID(Long.valueOf(selectedProduct.getProductID()));
                    pld.setCode(selectedProduct.getCode());
                    pld.setName(selectedProduct.getName());
                    pld.setPrice(Double.valueOf(Double.parseDouble(this.tfPrice.getText())));
                    try {
                        pld.setDiscount(Double.valueOf(Double.parseDouble(this.tfDiscount.getText())));
                    }
                    catch (NumberFormatException e) {
                        pld.setDiscount(Double.valueOf(0.0));
                    }
                    pld.setPriceListID(this.priceList.getPriceListID());
                    pld.setDate(datePickerValue);
                    this.list.add((Object)pld);
                    this.table.getSelectionModel().select((Object)pld);
                    this.table.scrollTo((Object)pld);
                    this.table.requestFocus();
                }
                this.clearFields();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.controller.alert("Upozorenje", "Nepravilan format cene: ", this.rootPane.getScene().getWindow());
            }
        } else {
            this.controller.alert("Upozorenje", "Morate odabrati artikal ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionImport(ActionEvent e) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Unesite datum od kog \u0107e va\u017eiti cene.");
        int result = this.controller.showModalDialogWithoutFullScreen("Unesite datum.", ScreensController.DIALOG_DATE_TIME_PICKER, hm, this.rootPane.getScene().getWindow());
        if (result == ScreensController.MODAL_RESULT_YES) {
            final LocalDateTime datePrice = (LocalDateTime)hm.get("datumVazenja");
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Import cenovnika");
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
            if (file != null) {
                Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditvanje stavki u toku.", this.rootPane.getScene().getWindow());
                final ArrayList unexistedProducts = new ArrayList();
                Task<ArrayList<PriceListDetailes>> loadingCsvTask = new Task<ArrayList<PriceListDetailes>>(){

                    protected ArrayList<PriceListDetailes> call() throws Exception {
                        String line = "";
                        String[] colNames = null;
                        int colBarcode = -1;
                        int colPrice = -1;
                        int colOfferPrice = -1;
                        int counterRow = 0;
                        ArrayList<PriceListDetailes> importedList = new ArrayList<PriceListDetailes>();
                        try {
                            BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                            while ((line = bf.readLine()) != null) {
                                colNames = line.split(";");
                                if (counterRow == 0) {
                                    for (int i = 0; i < colNames.length; ++i) {
                                        for (CsvImport csvImport : CsvImport.getList((ScreensController)PriceListDetailesController.this.controller, (long)1L)) {
                                            if (csvImport.getCsvName().equals("Cena") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                                colPrice = i;
                                            }
                                            if (csvImport.getCsvName().equals("Bar Kod") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) {
                                                colBarcode = i;
                                            }
                                            if (!csvImport.getCsvName().equals("Akcijska Cena") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue())) continue;
                                            colOfferPrice = i;
                                        }
                                    }
                                } else {
                                    PriceListDetailes pld;
                                    Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)PriceListDetailesController.this.controller.getSettings().getConnection());
                                    if (p != null) {
                                        pld = new PriceListDetailes();
                                        pld.setPriceListDetailsID(new Long(-1L));
                                        pld.setProductID(Long.valueOf(p.getProductID()));
                                        pld.setCode(p.getCode());
                                        pld.setName(p.getName());
                                        pld.setPrice(Double.valueOf(colOfferPrice > -1 ? Double.parseDouble(colNames[colOfferPrice].replace(",", ".")) : Double.parseDouble(colNames[colPrice].replace(",", "."))));
                                        pld.setDiscount(Double.valueOf(0.0));
                                        pld.setPriceListID(PriceListDetailesController.this.priceList.getPriceListID());
                                        pld.setDate(Settings.DatefromLocalDateTime((LocalDateTime)datePrice));
                                        importedList.add(pld);
                                    } else {
                                        try {
                                            p = Product.getByCode((String)colNames[colBarcode].trim(), (Connection)PriceListDetailesController.this.controller.getSettings().getConnection());
                                            pld = new PriceListDetailes();
                                            pld.setPriceListDetailsID(new Long(-1L));
                                            pld.setProductID(Long.valueOf(p.getProductID()));
                                            pld.setCode(p.getCode());
                                            pld.setName(p.getName());
                                            pld.setPrice(Double.valueOf(colOfferPrice > -1 ? Double.parseDouble(colNames[colOfferPrice].replace(",", ".")) : Double.parseDouble(colNames[colPrice].replace(",", "."))));
                                            pld.setDiscount(Double.valueOf(0.0));
                                            pld.setPriceListID(PriceListDetailesController.this.priceList.getPriceListID());
                                            pld.setDate(Settings.DatefromLocalDateTime((LocalDateTime)datePrice));
                                            importedList.add(pld);
                                        }
                                        catch (NullPointerException e2) {
                                            unexistedProducts.add(colNames[colBarcode]);
                                        }
                                    }
                                }
                                ++counterRow;
                            }
                            bf.close();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return importedList;
                    }
                };
                loadingCsvTask.setOnSucceeded(arg_0 -> this.lambda$actionImport$3(taskUpdateStage, (Task)loadingCsvTask, unexistedProducts, arg_0));
                loadingCsvTask.setOnFailed(eventValue -> {
                    taskUpdateStage.hide();
                    this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
                });
                loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                    if (newValue != null) {
                        Exception ex = (Exception)newValue;
                        ex.printStackTrace();
                    }
                });
                new Thread((Runnable)loadingCsvTask).start();
            }
        }
    }

    @FXML
    public void productAdd(ActionEvent event) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("priceField", true);
        int mr = this.controller.showModalDialog("Izbor cenovnika", ScreensController.DIALOG_SELECT_PRODUCT, hm, this.rootPane.getScene().getWindow());
        if (mr == ScreensController.MODAL_RESULT_OK) {
            Product product = (Product)hm.get("product");
            double cena = (Double)hm.get("cena");
            Date datePickerValue = Settings.DatefromLocalDateTime((LocalDateTime)this.dpDate.getDateTimeValue());
            PriceListDetailes pld = new PriceListDetailes();
            pld.setPriceListDetailsID(new Long(-1L));
            pld.setPriceListID(this.priceList.getPriceListID());
            pld.setProductID(Long.valueOf(product.getProductID()));
            pld.setPrice(Double.valueOf(cena));
            try {
                pld.setDiscount(Double.valueOf(Double.parseDouble(this.tfDiscount.getText())));
            }
            catch (NumberFormatException e) {
                pld.setDiscount(Double.valueOf(0.0));
            }
            pld.setDate(datePickerValue);
            pld.setName(product.getName());
            pld.setCode(product.getCode());
            this.list.add((Object)pld);
            this.table.getSelectionModel().select((Object)pld);
            this.table.scrollTo((Object)pld);
            this.table.requestFocus();
        }
    }

    @FXML
    public void productRemove(ActionEvent event) {
        if (((PriceListDetailes)this.table.getSelectionModel().getSelectedItem()).getPriceListDetailsID() != -1L) {
            ((PriceListDetailes)this.table.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
            this.list.remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    @FXML
    public void close(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void save(ActionEvent event) {
        final ArrayList pldList = new ArrayList(this.table.getItems());
        this.listNivelation = FXCollections.observableArrayList();
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Upis detalja je u toku...", this.rootPane.getScene().getWindow());
        Task<Void> savingTask = new Task<Void>(){

            protected Void call() throws Exception {
                for (int i = 0; i < pldList.size(); ++i) {
                    if (((PriceListDetailes)pldList.get(i)).getPriceListDetailsID() < 0L) {
                        PriceListDetailesController.this.listNivelation.add(pldList.get(i));
                        Long id = ((PriceListDetailes)pldList.get(i)).insert(PriceListDetailesController.this.controller.getSettings().getConnection());
                        ((PriceListDetailes)pldList.get(i)).setPriceListDetailsID(id);
                    }
                    if (((PriceListDetailes)pldList.get(i)).getPriceListDetailsID() <= 0L) continue;
                    ((PriceListDetailes)pldList.get(i)).update(PriceListDetailesController.this.controller.getSettings().getConnection());
                }
                return null;
            }
        };
        savingTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        });
        savingTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no upisivanje u bazu.", this.rootPane.getScene().getWindow());
        });
        savingTask.exceptionProperty().addListener((obs, old, newValue) -> {
            taskUpdateStage.hide();
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)savingTask).start();
    }

    public int checkIfProductExist(long productID) {
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (((PriceListDetailes)this.table.getItems().get(i)).getProductID() != productID) continue;
            return i;
        }
        return -1;
    }

    public void clearFields() {
        this.tfFilter.requestFocus();
        this.tfFilter.setPromptText(this.tfFilter.getText());
        this.tfPrice.setText("");
        this.cbProduct.getSelectionModel().clearSelection();
        this.cbProduct.getEditor().setText("");
    }

    private /* synthetic */ void lambda$actionImport$3(Stage taskUpdateStage, Task loadingCsvTask, ArrayList unexistedProducts, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        for (PriceListDetailes pld : (ArrayList)loadingCsvTask.getValue()) {
            int existIndex = this.checkIfProductExist(pld.getProductID());
            if (existIndex >= 0) {
                if (((PriceListDetailes)this.table.getItems().get(existIndex)).getPriceListDetailsID() > 0L && pld.getDate().getTime() > ((PriceListDetailes)this.table.getItems().get(existIndex)).getDate().getTime()) {
                    ((PriceListDetailes)this.table.getItems().get(existIndex)).setPriceListDetailsID(new Long(-1L));
                    ((PriceListDetailes)this.table.getItems().get(existIndex)).setDate(pld.getDate());
                }
                ((PriceListDetailes)this.table.getItems().get(existIndex)).setPrice(pld.getPrice());
                ((PriceListDetailes)this.table.getItems().get(existIndex)).setDiscount(Double.valueOf(0.0));
                continue;
            }
            this.list.add((Object)pld);
        }
        this.table.refresh();
        this.table.scrollTo(this.table.getItems().size() - 1);
        if (unexistedProducts.size() > 0) {
            this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
        }
    }
}

