/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;
import rs.petcom.backoffice.gui.AutoCompleteCBWithoutProducts;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.CsvImport;
import rs.petcom.master.dal.CsvImportType;
import rs.petcom.master.dal.OfferPrice;
import rs.petcom.master.dal.OfferPriceDetailes;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.DoubleTableCellFactory;
import tornadofx.control.DateTimePicker;

public class OfferPriceListDetailesController
implements DialogController {
    ScreensController controller;
    OfferPrice offerPrice;
    int modalResult;
    ObservableList<OfferPriceDetailes> data;
    String pathWithoutName = null;
    ArrayList<OfferPriceDetailes> deletedItems = new ArrayList();
    ObservableList<OfferPriceDetailes> insertItems = FXCollections.observableArrayList();
    AutoCompleteCBWithoutProducts<Product> cbProductAutoComplete;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<OfferPriceDetailes> table;
    @FXML
    private TableColumn<OfferPriceDetailes, String> tcCode;
    @FXML
    private TableColumn<OfferPriceDetailes, String> tcName;
    @FXML
    private TableColumn<OfferPriceDetailes, String> tcBarCode;
    @FXML
    private TableColumn<Object, Double> tcPrice;
    @FXML
    private TableColumn<Object, Double> tcDiscount;
    @FXML
    private TableColumn<Object, Double> tcQuantity;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfPrice;
    @FXML
    private TextField tfDiscount;
    @FXML
    private TextField tfQuantity;
    @FXML
    private ComboBox<Product> cbProduct;
    @FXML
    private ComboBox<String> cbFilterType;
    @FXML
    private Button btnAddPrice;
    @FXML
    private Button btnImportCsv;
    @FXML
    private DateTimePicker dpDate;

    public void initialize() {
        DoubleTableCellFactory cellFactory = new DoubleTableCellFactory(2, true);
        EventHandler<KeyEvent> eventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case DELETE: {
                        break;
                    }
                    case INSERT: {
                        break;
                    }
                }
            }
        };
        this.dpDate.setDateTimeValue(LocalDateTime.now());
        this.rootPane.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)eventHandler);
        this.tcCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<OfferPriceDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<OfferPriceDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)((OfferPriceDetailes)param.getValue()).getProduct()).name("Code").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcName.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<OfferPriceDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<OfferPriceDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)((OfferPriceDetailes)param.getValue()).getProduct()).name("ShortName").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcBarCode.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<OfferPriceDetailes, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<OfferPriceDetailes, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((Object)Barcode.getBarCodeObject((long)((OfferPriceDetailes)param.getValue()).getProductID(), (Connection)OfferPriceListDetailesController.this.controller.getSettings().getConnection())).name("BarCode").build();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return null;
                }
            }
        });
        this.tcPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcPrice.setCellFactory((Callback)cellFactory);
        this.tcPrice.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((OfferPriceDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPrice(((Double)t.getNewValue()).doubleValue());
            }
        });
        this.tcDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDiscount.setCellFactory((Callback)cellFactory);
        this.tcDiscount.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((OfferPriceDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDiscount(((Double)t.getNewValue()).doubleValue());
            }
        });
        this.tcQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.tcQuantity.setCellFactory((Callback)cellFactory);
        this.tcQuantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Object, Double>>(){

            public void handle(TableColumn.CellEditEvent<Object, Double> t) {
                ((OfferPriceDetailes)t.getTableView().getItems().get(t.getTablePosition().getRow())).setQuantity(((Double)t.getNewValue()).doubleValue());
            }
        });
    }

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        this.offerPrice = (OfferPrice)parameter.get("offerPrice");
        this.tfQuantity.setText("1.00");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.tfPrice.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    event.consume();
                    OfferPriceListDetailesController.this.actionAddPrice(new ActionEvent());
                    OfferPriceListDetailesController.this.cbProduct.requestFocus();
                }
            }
        });
        this.tfDiscount.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                event.consume();
                this.actionAddPrice(new ActionEvent());
                this.cbProduct.getEditor().setText("");
                this.cbProduct.getSelectionModel().clearSelection();
                this.cbProduct.requestFocus();
            }
        });
        this.insertItems = OfferPriceDetailes.getListByOfferPriceID((long)this.offerPrice.getOfferPriceID(), (Connection)this.controller.getSettings().getConnection());
        this.table.setItems(this.insertItems);
        this.filter();
        this.cbFilterType.getItems().addAll((Object[])new String[]{ScreensController.FILTER_ALL, ScreensController.FILTER_CODE, ScreensController.FILTER_BARCODE});
        this.cbFilterType.getSelectionModel().selectFirst();
        this.cbFilterType.setOnAction(actionEvent -> this.cbProductAutoComplete.setFilterType((String)this.cbFilterType.getSelectionModel().getSelectedItem()));
        this.cbProductAutoComplete = new AutoCompleteCBWithoutProducts(this.cbProduct, this.controller, -1, ScreensController.FILTER_ALL, this.tfPrice, this.data);
        this.cbProductAutoComplete.setLoadAllProduct(true);
        this.deletedItems.clear();
        this.table.setFocusTraversable(false);
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void productAdd(ActionEvent event) {
        Product selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            try {
                int existIndex = this.checkIfProductExist(selectedProduct.getProductID());
                if (existIndex >= 0) {
                    ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setPrice(Double.parseDouble(this.tfPrice.getText()));
                    try {
                        ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setDiscount(Double.parseDouble(this.tfDiscount.getText()));
                    }
                    catch (NumberFormatException e) {
                        ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setDiscount(0.0);
                    }
                    this.table.getSelectionModel().select(existIndex);
                    this.table.scrollTo(existIndex);
                    this.table.refresh();
                } else {
                    OfferPriceDetailes opd = new OfferPriceDetailes();
                    opd.setOfferPriceDetailsID(new Long(-1L).longValue());
                    opd.setProduct(selectedProduct);
                    opd.setProductID(selectedProduct.getProductID());
                    if (this.tfPrice.getText().trim().equals("") || this.tfPrice.getText().trim() == "") {
                        opd.setPrice(0.0);
                    } else {
                        opd.setPrice(Double.parseDouble(this.tfPrice.getText()));
                    }
                    opd.setQuantity(Double.parseDouble(this.tfQuantity.getText().trim().replace(",", ".")));
                    if (opd.getPrice() != 0.0) {
                        opd.setDiscount(0.0);
                    } else {
                        opd.setDiscount(Double.parseDouble(this.tfDiscount.getText()));
                    }
                    opd.setOfferPriceID(this.offerPrice.getOfferPriceID().longValue());
                    this.insertItems.add((Object)opd);
                    this.table.setItems(this.insertItems);
                    this.table.getSelectionModel().select((Object)opd);
                    this.table.scrollTo((Object)opd);
                    this.table.requestFocus();
                }
                this.clearFields();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.controller.alert("Upozorenje", "Nepravilan format cene: ", this.rootPane.getScene().getWindow());
            }
        } else {
            this.controller.alert("Upozorenje", "Morate odabrati artikal ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    private void saveToExcelAction() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
        fileChooser.setTitle(this.controller.getBundle().getString("selectFileForExport"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
        File file = fileChooser.showSaveDialog(this.controller.getRoot().getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            String filePath;
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            this.pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            if (file != null && !(filePath = file.getAbsolutePath()).toUpperCase().endsWith(".CSV")) {
                filePath = filePath + ".xml";
            }
            OfferPriceDetailes.getReceivingReportToExcel((ScreensController)this.controller, (ObservableList)this.table.getItems(), (String)this.pathWithoutName, (String)file.getName());
            this.controller.printFileFromPDF(file);
        }
    }

    @FXML
    public void actionAddPrice(ActionEvent event) {
        Product selectedProduct = (Product)this.cbProduct.getSelectionModel().getSelectedItem();
        if (selectedProduct != null) {
            try {
                int existIndex = this.checkIfProductExist(selectedProduct.getProductID());
                if (existIndex >= 0) {
                    ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setPrice(Double.parseDouble(this.tfPrice.getText()));
                    try {
                        ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setDiscount(Double.parseDouble(this.tfDiscount.getText()));
                    }
                    catch (NumberFormatException e) {
                        ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setDiscount(0.0);
                    }
                    this.table.getSelectionModel().select(existIndex);
                    this.table.scrollTo(existIndex);
                    this.table.refresh();
                } else {
                    OfferPriceDetailes opd = new OfferPriceDetailes();
                    opd.setOfferPriceDetailsID(new Long(-1L).longValue());
                    opd.setProductID(selectedProduct.getProductID());
                    opd.setPrice(Double.parseDouble(this.tfPrice.getText()));
                    if (opd.getPrice() != 0.0) {
                        opd.setDiscount(0.0);
                    } else {
                        opd.setDiscount(Double.parseDouble(this.tfDiscount.getText()));
                    }
                    opd.setOfferPriceID(this.offerPrice.getOfferPriceID().longValue());
                    this.table.getItems().add((Object)opd);
                    this.table.getSelectionModel().select((Object)opd);
                    this.table.scrollTo((Object)opd);
                    this.table.requestFocus();
                }
                this.clearFields();
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.controller.alert("Upozorenje", "Nepravilan format cene: ", this.rootPane.getScene().getWindow());
            }
        } else {
            this.controller.alert("Upozorenje", "Morate odabrati artikal ", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionImport(ActionEvent e) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("controller", this.controller);
        hm.put("title", "Unesite datum od kog \u0107e va\u017eiti cene.");
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Import cenovnika");
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.csv"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        final File file = fileChooser.showOpenDialog(this.rootPane.getScene().getWindow());
        if (file != null) {
            Stage taskUpdateStage = this.controller.getSettings().getInfoStage("U\u010ditavanje stavki u toku.", this.rootPane.getScene().getWindow());
            final ArrayList unexistedProducts = new ArrayList();
            Task<ArrayList<OfferPriceDetailes>> loadingCsvTask = new Task<ArrayList<OfferPriceDetailes>>(){

                protected ArrayList<OfferPriceDetailes> call() throws Exception {
                    String line = "";
                    String[] colNames = null;
                    int colBarcode = -1;
                    int colOfferPrice = -1;
                    int colDiscount = -1;
                    int colQuantity = -1;
                    int counterRow = 0;
                    ArrayList<OfferPriceDetailes> importedList = new ArrayList<OfferPriceDetailes>();
                    try {
                        BufferedReader bf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        while ((line = bf.readLine()) != null) {
                            colNames = line.split(";");
                            if (counterRow == 0) {
                                for (int i = 0; i < colNames.length; ++i) {
                                    for (CsvImport csvImport : CsvImport.getList((ScreensController)OfferPriceListDetailesController.this.controller, (long)CsvImportType.getByName((ScreensController)OfferPriceListDetailesController.this.controller, (String)"Cenovnik Akcija").getImportCsvTypeId())) {
                                        if (csvImport.getCsvName().equals("Akcijska Cena") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue().toLowerCase())) {
                                            colOfferPrice = i;
                                        }
                                        if (csvImport.getCsvName().equals("Bar Kod") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue().toLowerCase())) {
                                            colBarcode = i;
                                        }
                                        if (csvImport.getCsvName().equals("Popust") && colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue().toLowerCase())) {
                                            colDiscount = i;
                                        }
                                        if (!csvImport.getCsvName().equals("Kolicina") || !colNames[i].trim().toLowerCase().equals(csvImport.getCsvValue().toLowerCase())) continue;
                                        colQuantity = i;
                                    }
                                }
                            } else {
                                Product p = Product.getByBarcode((String)colNames[colBarcode], (Connection)OfferPriceListDetailesController.this.controller.getSettings().getConnection());
                                if (p != null) {
                                    OfferPriceDetailes opd = new OfferPriceDetailes();
                                    opd.setProduct(p);
                                    opd.setOfferPriceDetailsID(new Long(-1L).longValue());
                                    opd.setProductID(p.getProductID());
                                    opd.setPrice(colOfferPrice > -1 ? Double.parseDouble(colNames[colOfferPrice].replace(",", ".")) : 0.0);
                                    try {
                                        opd.setQuantity(Double.parseDouble(colNames[colQuantity].replace(",", ".")));
                                    }
                                    catch (ArrayIndexOutOfBoundsException e) {
                                        opd.setQuantity(Double.parseDouble(colNames[colQuantity].replace(",", ".")));
                                    }
                                    if (opd.getPrice() != 0.0) {
                                        opd.setDiscount(0.0);
                                    } else {
                                        opd.setDiscount(Double.parseDouble(colNames[colDiscount].replace(",", ".")));
                                    }
                                    opd.setOfferPriceID(OfferPriceListDetailesController.this.offerPrice.getOfferPriceID().longValue());
                                    importedList.add(opd);
                                } else {
                                    unexistedProducts.add(colNames[colBarcode]);
                                }
                            }
                            ++counterRow;
                        }
                        bf.close();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return importedList;
                }
            };
            loadingCsvTask.setOnSucceeded(arg_0 -> this.lambda$actionImport$2(taskUpdateStage, (Task)loadingCsvTask, unexistedProducts, arg_0));
            loadingCsvTask.setOnFailed(eventValue -> {
                taskUpdateStage.hide();
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje iz csv fajla", this.rootPane.getScene().getWindow());
            });
            loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                if (newValue != null) {
                    Exception ex = (Exception)newValue;
                    ex.printStackTrace();
                }
            });
            new Thread((Runnable)loadingCsvTask).start();
        }
    }

    @FXML
    public void productRemove(ActionEvent event) {
        if (((OfferPriceDetailes)this.table.getSelectionModel().getSelectedItem()).getOfferPriceDetailsID() != -1L) {
            this.deletedItems.add((OfferPriceDetailes)this.table.getSelectionModel().getSelectedItem());
            this.data.remove(this.table.getSelectionModel().getSelectedItem());
        } else {
            this.table.getItems().remove(this.table.getSelectionModel().getSelectedItem());
        }
    }

    @FXML
    public void close(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    public void save(ActionEvent event) {
        final ObservableList opdList = this.table.getItems();
        Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Upis detalja je u toku...", this.rootPane.getScene().getWindow());
        Task<Void> savingTask = new Task<Void>(){

            protected Void call() throws Exception {
                for (int i = 0; i < opdList.size(); ++i) {
                    if (((OfferPriceDetailes)opdList.get(i)).getOfferPriceDetailsID() < 0L) {
                        Long id = ((OfferPriceDetailes)opdList.get(i)).insert(OfferPriceListDetailesController.this.controller.getSettings().getConnection());
                        ((OfferPriceDetailes)opdList.get(i)).setOfferPriceDetailsID(id.longValue());
                    }
                    if (((OfferPriceDetailes)opdList.get(i)).getOfferPriceDetailsID() <= 0L) continue;
                    ((OfferPriceDetailes)opdList.get(i)).update(OfferPriceListDetailesController.this.controller);
                }
                if (!OfferPriceListDetailesController.this.deletedItems.isEmpty()) {
                    for (OfferPriceDetailes OfferPriceDetailes2 : OfferPriceListDetailesController.this.deletedItems) {
                        OfferPriceDetailes2.delete(OfferPriceListDetailesController.this.controller);
                    }
                }
                return null;
            }
        };
        savingTask.setOnSucceeded(eventValue -> {
            taskUpdateStage.hide();
            this.modalResult = ScreensController.MODAL_RESULT_OK;
            ((Stage)this.rootPane.getScene().getWindow()).close();
        });
        savingTask.setOnFailed(eventValue -> {
            taskUpdateStage.hide();
            this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no upisivanje u bazu.", this.rootPane.getScene().getWindow());
        });
        savingTask.exceptionProperty().addListener((obs, old, newValue) -> {
            taskUpdateStage.hide();
            if (newValue != null) {
                Exception ex = (Exception)newValue;
                ex.printStackTrace();
            }
        });
        new Thread((Runnable)savingTask).start();
    }

    public int checkIfProductExist(long productID) {
        for (int i = 0; i < this.table.getItems().size(); ++i) {
            if (((OfferPriceDetailes)this.table.getItems().get(i)).getProductID() != productID) continue;
            return i;
        }
        return -1;
    }

    public void clearFields() {
        this.cbProduct.getSelectionModel().clearSelection();
        this.cbProduct.getEditor().setText("");
        this.tfPrice.setText("0.00");
        this.tfFilter.setText("");
        this.tfQuantity.setText("1.00");
    }

    private void filter() {
        this.data = this.insertItems;
        FilteredList filteredData = new FilteredList(this.data, p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(opd -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            if (opd.getProduct().getCode().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            if (opd.getProduct().getBarcode().toLowerCase().contains(lowerCaseFilter)) {
                return true;
            }
            return opd.getProduct().getShortName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
    }

    private /* synthetic */ void lambda$actionImport$2(Stage taskUpdateStage, Task loadingCsvTask, ArrayList unexistedProducts, WorkerStateEvent eventValue) {
        taskUpdateStage.hide();
        ObservableList lista = FXCollections.observableArrayList();
        for (OfferPriceDetailes pld : (ArrayList)loadingCsvTask.getValue()) {
            int existIndex = this.checkIfProductExist(pld.getProductID());
            if (existIndex >= 0) {
                ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setPrice(pld.getPrice());
                ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setQuantity(pld.getQuantity());
                ((OfferPriceDetailes)this.table.getItems().get(existIndex)).setDiscount(0.0);
                this.table.refresh();
                continue;
            }
            lista.add((Object)pld);
        }
        this.table.setItems(lista);
        this.table.refresh();
        this.table.scrollTo(this.table.getItems().size() - 1);
        if (unexistedProducts.size() > 0) {
            this.controller.alert("Nepostoje\u0107i artikli", unexistedProducts.toString(), this.rootPane.getScene().getWindow());
        }
    }
}

