/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.NetAmountType;
import rs.petcom.master.dal.NormativeItem;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.PriceListDetailes;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductCategory;
import rs.petcom.master.dal.product.ProductDepartment;
import rs.petcom.master.dal.product.ProductType;
import rs.petcom.master.gui.ProductPointOfSaleCheckBoxCell;

public class ImportDialogController
implements DialogController {
    ScreensController controller;
    ProductType productType = new ProductType();
    ObservableList<NormativeItem> normativeList = FXCollections.observableArrayList();
    ObservableList<ProductType> productTypeList = FXCollections.observableArrayList();
    ObservableList<ProductCategory> productCategoryList = FXCollections.observableArrayList();
    ObservableList<Vat> productVatList = FXCollections.observableArrayList();
    ObservableList<Unit> productUnitList = FXCollections.observableArrayList();
    ObservableList<String> columns;
    BufferedReader bf;
    ObservableList<AditionalField> aditionalFieldsList = FXCollections.observableArrayList();
    TreeItem<PointOfSale> treeRootD = new TreeItem();
    int colCode = -1;
    int colBarcode = -1;
    int colTezinskiBarcode = -1;
    int colName = -1;
    int colShortname = -1;
    int colVat = -1;
    int colPrice = -1;
    int colUnit = -1;
    int colNetAmount = -1;
    int colNetAmountType = -1;
    int colMeasurable = -1;
    int colActive = -1;
    int modalResult = ScreensController.MODAL_RESULT_CANCEL;
    HashMap<String, java.lang.Object> parameter;
    @FXML
    private BorderPane rootPane;
    @FXML
    private ComboBox<Vat> cbVat;
    @FXML
    private ComboBox<NetAmountType> cbNetAmountType;
    @FXML
    private ComboBox<Unit> cbUnit;
    @FXML
    private ComboBox<String> cbCode;
    @FXML
    private ComboBox<String> cbBarcode;
    @FXML
    private ComboBox<String> cbTezinskiBarcode;
    @FXML
    private ComboBox<String> cbTezinskiBarcodeFile;
    @FXML
    private ComboBox<String> cbName;
    @FXML
    private ComboBox<String> cbShortname;
    @FXML
    private ComboBox<String> cbPrice;
    @FXML
    private ComboBox<String> cbNetAmount;
    @FXML
    private ComboBox<String> cbUnitFile;
    @FXML
    private ComboBox<String> cbVatFile;
    @FXML
    private ComboBox<String> cbNetAmountTypeFile;
    @FXML
    private ComboBox<String> cbMeasurableFile;
    @FXML
    private ComboBox<String> cbActiveFile;
    @FXML
    private FlowPane hBoxAdditional;
    @FXML
    private TextArea taInfo;
    @FXML
    private TextArea taErrInfo;
    @FXML
    private Button btnCommit;
    @FXML
    private Button btnCancel;
    @FXML
    private TreeView<PointOfSale> treeDepartment;
    @FXML
    private CheckBox cbDiscoundAllowed;
    @FXML
    private CheckBox cbActive;
    @FXML
    private CheckBox cbIsMeasurable;
    @FXML
    private CheckBox cbFromUnitOfMesure;
    private HashMap<String, Integer> adiHashMap = new HashMap();

    public void initialize() {
        this.treeDepartment.setCellFactory((Callback)new Callback<TreeView<PointOfSale>, TreeCell<PointOfSale>>(){

            public TreeCell<PointOfSale> call(TreeView<PointOfSale> param) {
                return new ProductPointOfSaleCheckBoxCell(Boolean.valueOf(true));
            }
        });
        this.treeDepartment.setShowRoot(false);
    }

    public void setParameter(HashMap<String, java.lang.Object> parameter) {
        this.parameter = parameter;
        this.controller = (ScreensController)parameter.get("controller");
        this.bf = (BufferedReader)parameter.get("bufferedReader");
        this.loadComboBoxItems();
        this.setColumnInitialValue();
        ((Stage)this.rootPane.getScene().getWindow()).setMaximized(true);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.productTypeList = this.productType.getObeservableList(true, this.controller.getSettings().getConnection());
        this.cbNetAmountType.setItems(NetAmountType.getList((Connection)this.controller.getSettings().getConnection()));
        this.cbNetAmountType.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode().equals((java.lang.Object)KeyCode.TAB)) {
                this.btnCommit.requestFocus();
            }
        });
        this.btnCommit.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((java.lang.Object)KeyCode.ENTER)) {
                    ImportDialogController.this.commit();
                }
            }
        });
        this.productVatList = Vat.getObeservableList((Connection)this.controller.getSettings().getConnection());
        this.cbVat.setItems(this.productVatList);
        ObservableList listTezinskih = FXCollections.observableArrayList();
        listTezinskih.add((java.lang.Object)"False");
        listTezinskih.add((java.lang.Object)"True");
        this.cbTezinskiBarcode.setItems(listTezinskih);
        this.cbTezinskiBarcode.getSelectionModel().select(0);
        this.productUnitList = Unit.getList((Connection)this.controller.getSettings().getConnection());
        this.cbUnit.setItems(this.productUnitList);
        this.treeRootD = new TreeItem();
        this.treeRootD.setValue((java.lang.Object)new PointOfSale(-1, "Objekti"));
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            TreeItem objekatItem = new TreeItem();
            objekatItem.setValue((java.lang.Object)new PointOfSale(o.getObjectID(), o.getName()));
            for (PointOfSale d : PointOfSale.getPosList((Object)o, (Connection)this.controller.getSettings().getConnection())) {
                TreeItem departmentItem = new TreeItem();
                departmentItem.setValue((java.lang.Object)d);
                objekatItem.getChildren().add((java.lang.Object)departmentItem);
                objekatItem.setExpanded(true);
            }
            this.treeRootD.getChildren().add((java.lang.Object)objekatItem);
        }
        this.treeRootD.setExpanded(true);
        this.treeDepartment.setRoot(this.treeRootD);
        this.cbFromUnitOfMesure.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ImportDialogController.this.cbIsMeasurable.setDisable(newValue.booleanValue());
            }
        });
    }

    public HashMap<String, java.lang.Object> getParameter() {
        return this.parameter;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    @FXML
    public void cancel(ActionEvent event) {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    @FXML
    private void commit() {
        final StringBuilder info = new StringBuilder();
        final StringBuilder errInfo = new StringBuilder();
        final StringBuilder sbFailedProductInsert = new StringBuilder();
        this.doColumnIndexing();
        Task<Void> task = new Task<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void call() throws Exception {
                String line = "";
                int lineIndex = 1;
                while ((line = ImportDialogController.this.bf.readLine()) != null) {
                    ++lineIndex;
                    String[] columnTitle = line.split("[;]", -1);
                    try {
                        Product p;
                        ImportDialogController.this.controller.getSettings().getConnection().setAutoCommit(false);
                        long productId = 0L;
                        if (!ImportDialogController.this.validacijaComboBoxova()) {
                            ImportDialogController.this.controller.alert("Upozorenje", "Morate popuniti Naziv, kratak naziv, poresku stopu, cenu i jedinicu mere.", ImportDialogController.this.rootPane.getScene().getWindow());
                            break;
                        }
                        ArrayList<Integer> izabraniObjekti = new ArrayList<Integer>();
                        ArrayList<java.lang.Object> izabraniPosovi = new ArrayList<java.lang.Object>();
                        for (TreeItem pos : ImportDialogController.this.treeRootD.getChildren()) {
                            for (TreeItem pos1 : pos.getChildren()) {
                                if (!((PointOfSale)pos1.getValue()).isSelected()) continue;
                                izabraniPosovi.add(pos1.getValue());
                                boolean objectExist = false;
                                for (int i = 0; i < izabraniObjekti.size(); ++i) {
                                    if (((Integer)izabraniObjekti.get(i)).intValue() != ((PointOfSale)pos1.getValue()).getObjectID()) continue;
                                    objectExist = true;
                                }
                                if (objectExist) continue;
                                izabraniObjekti.add(((PointOfSale)pos1.getValue()).getObjectID());
                            }
                        }
                        if (!izabraniPosovi.isEmpty()) {
                            p = new Product();
                            try {
                                p.setNetAmountTypeID(ImportDialogController.this.cbNetAmountType.getSelectionModel().getSelectedItem() != null ? ((NetAmountType)ImportDialogController.this.cbNetAmountType.getSelectionModel().getSelectedItem()).getNetAmountTypeID() : Integer.parseInt(columnTitle[ImportDialogController.this.colNetAmountType]));
                            }
                            catch (IndexOutOfBoundsException | NullPointerException e) {
                                p.setNetAmountTypeID(0);
                            }
                            p.setVatID(ImportDialogController.this.cbVat.getSelectionModel().getSelectedItem() != null ? ((Vat)ImportDialogController.this.cbVat.getSelectionModel().getSelectedItem()).getVatID() : Integer.parseInt(columnTitle[ImportDialogController.this.colVat]));
                            p.setName(columnTitle[ImportDialogController.this.colName]);
                            System.out.println("p.getName() " + p.getName());
                            p.setUnitID(ImportDialogController.this.cbUnit.getSelectionModel().getSelectedItem() != null ? ((Unit)ImportDialogController.this.cbUnit.getSelectionModel().getSelectedItem()).getUnitID() : Integer.parseInt(columnTitle[ImportDialogController.this.colUnit]));
                            p.setProductCategoryID(1);
                            p.setSysDTCreated(new Date());
                            try {
                                p.setCode(columnTitle[ImportDialogController.this.colCode].trim());
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                // empty catch block
                            }
                            p.setShortName(columnTitle[ImportDialogController.this.colShortname].trim());
                            p.setSysUserAddID(ImportDialogController.this.controller.getUser().getUserID());
                            try {
                                p.setNetAmount(Settings.getNumberFormat((int)2, (boolean)true).parse(columnTitle[ImportDialogController.this.colNetAmount]).doubleValue());
                            }
                            catch (ArrayIndexOutOfBoundsException | ParseException e) {
                                p.setNetAmount(0.0);
                            }
                            p.setDiscountAllowed(ImportDialogController.this.cbDiscoundAllowed.isSelected());
                            if (ImportDialogController.this.cbMeasurableFile.getSelectionModel().getSelectedItem() != null && !((String)ImportDialogController.this.cbMeasurableFile.getSelectionModel().getSelectedItem()).trim().equals("")) {
                                p.setMeasurable(columnTitle[ImportDialogController.this.colMeasurable].equals("1"));
                            } else if (ImportDialogController.this.cbFromUnitOfMesure.isSelected()) {
                                p.setMeasurable(Unit.getUnitById((int)p.getUnitID(), (Connection)ImportDialogController.this.controller.getSettings().getConnection()).isMeasurable());
                            } else {
                                p.setMeasurable(ImportDialogController.this.cbIsMeasurable.isSelected());
                            }
                            if (ImportDialogController.this.cbActiveFile.getSelectionModel().getSelectedItem() != null && !((String)ImportDialogController.this.cbActiveFile.getSelectionModel().getSelectedItem()).trim().equals("")) {
                                try {
                                    p.setActive(columnTitle[ImportDialogController.this.colActive].equals("1"));
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                p.setActive(ImportDialogController.this.cbActive.isSelected());
                            }
                            productId = p.insert(ImportDialogController.this.controller.getUser(), ImportDialogController.this.controller.getSettings().getConnection());
                            try {
                                if (ImportDialogController.this.colBarcode > -1) {
                                    Barcode b = new Barcode();
                                    b.setProductID(productId);
                                    b.setBarCode(columnTitle[ImportDialogController.this.colBarcode].trim());
                                    p.setBarcode(b.getBarCode());
                                    if (ImportDialogController.this.cbTezinskiBarcodeFile.getSelectionModel().getSelectedItem() != null && !((String)ImportDialogController.this.cbTezinskiBarcodeFile.getSelectionModel().getSelectedItem()).trim().equals("")) {
                                        if (b.getBarCode().trim().length() == 5) {
                                            b.setIsWeight(Boolean.valueOf(columnTitle[ImportDialogController.this.colTezinskiBarcode].equals("1")));
                                        } else {
                                            b.setIsWeight(Boolean.valueOf(false));
                                        }
                                    } else if (b.getBarCode().trim().length() == 5) {
                                        b.setIsWeight(Boolean.valueOf(Boolean.parseBoolean((String)ImportDialogController.this.cbTezinskiBarcode.getSelectionModel().getSelectedItem())));
                                    } else {
                                        b.setIsWeight(Boolean.valueOf(false));
                                    }
                                    b.insertNewBarCode(ImportDialogController.this.controller.getSettings().getConnection());
                                }
                            }
                            catch (IndexOutOfBoundsException b) {
                                // empty catch block
                            }
                            try {
                                for (Integer n : izabraniObjekti) {
                                    try {
                                        Double price = Double.parseDouble(columnTitle[ImportDialogController.this.colPrice].replace(",", "."));
                                        p.setPrice(price.doubleValue());
                                        if (!(price > 0.0)) continue;
                                        PriceListDetailes.insertProductPriceTrgovinaYesterday((PriceList)PriceList.getRegular((LocalDateTime)LocalDateTime.now(), (int)n, (Connection)ImportDialogController.this.controller.getSettings().getConnection()), (long)productId, (double)Double.parseDouble(columnTitle[ImportDialogController.this.colPrice].replace(",", ".")), (Connection)ImportDialogController.this.controller.getSettings().getConnection());
                                    }
                                    catch (Exception price) {}
                                }
                            }
                            catch (NumberFormatException e) {
                                ImportDialogController.this.controller.alert("Obave\u0161tenje", "Nije upisana cena: " + e.getMessage(), ImportDialogController.this.rootPane.getScene().getWindow());
                            }
                            p.setProductID(productId);
                            for (String string : ImportDialogController.this.adiHashMap.keySet()) {
                                System.out.println("kljuc " + string + ", vrednost " + ImportDialogController.this.adiHashMap.get(string));
                                AditionalField aditionalField = AditionalField.getByName((String)string, (Connection)ImportDialogController.this.controller.getSettings().getConnection());
                                AditionalFieldDetails afd = AditionalFieldDetails.getByNameAndAfId((String)columnTitle[(Integer)ImportDialogController.this.adiHashMap.get(string)], (AditionalField)aditionalField, (Connection)ImportDialogController.this.controller.getSettings().getConnection());
                                if (afd == null) {
                                    afd = new AditionalFieldDetails();
                                    afd.setAditionalFiledID(aditionalField.getAditionalFieldID());
                                    afd.setName(columnTitle[(Integer)ImportDialogController.this.adiHashMap.get(string)]);
                                    afd.insert(ImportDialogController.this.controller.getSettings().getConnection());
                                }
                                AditionalFieldDetailsProduct afdp = new AditionalFieldDetailsProduct();
                                afdp.setProductID(p.getProductID());
                                afdp.setAditionalFieldID(aditionalField.getAditionalFieldID());
                                afdp.setAditionalFieldDetailsID(afd.getAditionalFieldDetailsID());
                                afdp.insert(ImportDialogController.this.controller.getSettings().getConnection());
                            }
                        } else {
                            ImportDialogController.this.controller.alert("Obavestenje", "Morate izabrati prodajno mesto", ImportDialogController.this.rootPane.getScene().getWindow());
                            p = null;
                            return p;
                        }
                        info.append(p.getBarcode()).append(" - ").append(p.getName()).append(" - ").append(p.getPrice()).append("\r\n");
                        ArrayList<Department> odeljenjaZaDodavanje = new ArrayList<Department>();
                        for (PointOfSale pointOfSale : izabraniPosovi) {
                            for (Department d : pointOfSale.getDepartmentList(ImportDialogController.this.controller.getSettings().getConnection())) {
                                boolean postoji = false;
                                for (Department dp : odeljenjaZaDodavanje) {
                                    if (dp.getDepartmentID() != d.getDepartmentID()) continue;
                                    postoji = true;
                                    break;
                                }
                                if (postoji) continue;
                                odeljenjaZaDodavanje.add(d);
                            }
                        }
                        ArrayList<ProductDepartment> dodatiProductDepartment = new ArrayList<ProductDepartment>();
                        if (!odeljenjaZaDodavanje.isEmpty()) {
                            for (Department d : odeljenjaZaDodavanje) {
                                ProductDepartment pd = new ProductDepartment();
                                pd.setProductID(productId);
                                pd.setSort(0);
                                pd.setActive(true);
                                pd.setFavorite(false);
                                pd.setDepartmentID(d.getDepartmentID());
                                pd.insert(ImportDialogController.this.controller.getSettings().getConnection());
                                dodatiProductDepartment.add(pd);
                            }
                        }
                        ImportDialogController.this.controller.getSettings().getConnection().commit();
                    }
                    catch (IndexOutOfBoundsException | SQLException e) {
                        e.printStackTrace();
                        errInfo.append(e.getMessage()).append("\r\n");
                        sbFailedProductInsert.append(lineIndex + ", ");
                        try {
                            ImportDialogController.this.controller.getSettings().getConnection().rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            ImportDialogController.this.controller.getSettings().getConnection().setAutoCommit(true);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ImportDialogController.this.taInfo.setText(info.toString());
                            ImportDialogController.this.taInfo.selectPositionCaret(ImportDialogController.this.taInfo.getLength());
                        }
                    });
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ImportDialogController.this.taErrInfo.setText(errInfo.toString());
                            ImportDialogController.this.taErrInfo.selectPositionCaret(ImportDialogController.this.taErrInfo.getLength());
                        }
                    });
                }
                return null;
            }
        };
        new Thread((Runnable)task).start();
        task.setOnSucceeded(eventValue -> {
            this.taInfo.selectPositionCaret(this.taInfo.getLength());
            this.taErrInfo.selectPositionCaret(this.taErrInfo.getLength());
            if (sbFailedProductInsert.length() > 0) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no ubacivanje proizvoda pod rednim brojem: " + sbFailedProductInsert.toString(), this.rootPane.getScene().getWindow());
            } else {
                this.controller.alert("Obave\u0161tenje", "Zavr\u0161en import artikala. ", this.rootPane.getScene().getWindow());
            }
            this.btnCancel.setText("Zatvori");
            this.btnCommit.setDisable(true);
        });
        this.modalResult = ScreensController.MODAL_RESULT_OK;
    }

    public boolean validacijaComboBoxova() {
        return !(this.colName <= -1 || this.colShortname <= -1 || this.colPrice <= -1 || this.colVat <= -1 && this.cbVat.getSelectionModel().getSelectedItem() == null || this.colUnit <= -1 && this.cbUnit.getSelectionModel().getSelectedItem() == null);
    }

    private void loadComboBoxItems() {
        try {
            this.columns = FXCollections.observableArrayList();
            this.columns.add((java.lang.Object)"");
            this.columns.addAll((java.lang.Object[])this.bf.readLine().split(";"));
            this.cbCode.setItems(this.columns);
            this.cbBarcode.setItems(this.columns);
            this.cbTezinskiBarcodeFile.setItems(this.columns);
            this.cbName.setItems(this.columns);
            this.cbShortname.setItems(this.columns);
            this.cbPrice.setItems(this.columns);
            this.cbNetAmount.setItems(this.columns);
            this.cbUnitFile.setItems(this.columns);
            this.cbNetAmountTypeFile.setItems(this.columns);
            this.cbMeasurableFile.setItems(this.columns);
            this.cbActiveFile.setItems(this.columns);
            this.cbVatFile.setItems(this.columns);
            this.hBoxAdditional.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
            this.hBoxAdditional.setVgap(4.0);
            this.hBoxAdditional.setHgap(4.0);
            this.hBoxAdditional.setPrefWrapLength(100.0);
            for (AditionalField aditionalField : AditionalField.getList((Connection)this.controller.getSettings().getConnection())) {
                final CheckBox adiComboBox = new CheckBox();
                adiComboBox.setText(aditionalField.getName());
                adiComboBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        if (adiComboBox.isSelected()) {
                            ImportDialogController.this.aditionalFieldsList.add((java.lang.Object)AditionalField.getByName((String)adiComboBox.getText().trim(), (Connection)ImportDialogController.this.controller.getSettings().getConnection()));
                        } else {
                            ImportDialogController.this.aditionalFieldsList.remove((java.lang.Object)AditionalField.getByName((String)adiComboBox.getText().trim(), (Connection)ImportDialogController.this.controller.getSettings().getConnection()));
                        }
                    }
                });
                this.hBoxAdditional.getChildren().add((java.lang.Object)adiComboBox);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setColumnInitialValue() {
        this.colCode = -1;
        this.colBarcode = -1;
        this.colTezinskiBarcode = -1;
        this.colName = -1;
        this.colShortname = -1;
        this.colVat = -1;
        this.colPrice = -1;
        this.colUnit = -1;
        this.colNetAmount = -1;
        this.colNetAmountType = -1;
        this.colMeasurable = -1;
        this.colActive = -1;
    }

    private void doColumnIndexing() {
        for (int i = 1; i < this.columns.size(); ++i) {
            if (((String)this.columns.get(i)).equals("")) continue;
            if (((String)this.columns.get(i)).trim().equals(this.cbCode.getSelectionModel().getSelectedItem())) {
                this.colCode = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbBarcode.getSelectionModel().getSelectedItem())) {
                this.colBarcode = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbTezinskiBarcodeFile.getSelectionModel().getSelectedItem())) {
                this.colTezinskiBarcode = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbName.getSelectionModel().getSelectedItem())) {
                this.colName = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbShortname.getSelectionModel().getSelectedItem())) {
                this.colShortname = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbVatFile.getSelectionModel().getSelectedItem())) {
                this.colVat = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbPrice.getSelectionModel().getSelectedItem())) {
                this.colPrice = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbUnitFile.getSelectionModel().getSelectedItem())) {
                this.colUnit = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbNetAmount.getSelectionModel().getSelectedItem())) {
                this.colNetAmount = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbNetAmountTypeFile.getSelectionModel().getSelectedItem())) {
                this.colNetAmountType = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbMeasurableFile.getSelectionModel().getSelectedItem())) {
                this.colMeasurable = i - 1;
            }
            if (((String)this.columns.get(i)).trim().equals(this.cbActiveFile.getSelectionModel().getSelectedItem())) {
                this.colActive = i - 1;
            }
            for (int j = 0; j < this.aditionalFieldsList.size(); ++j) {
                if (!((String)this.columns.get(i)).trim().equals(((AditionalField)this.aditionalFieldsList.get(j)).getName())) continue;
                this.adiHashMap.put(((AditionalField)this.aditionalFieldsList.get(j)).getName(), i - 1);
            }
        }
    }
}

