/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.adapter.JavaBeanStringPropertyBuilder;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javax.swing.filechooser.FileSystemView;
import rs.petcom.backoffice.gui.TextHooverOnTableCell;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.PosPrint.ESCPosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Images;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentCorrection;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.CashBuyer;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.master.fical.Izvestaji;
import rs.petcom.master.newFiscalization.badrequest.BadRequestHandler;
import rs.petcom.master.newFiscalization.badrequest.ModelState;
import rs.petcom.master.newFiscalization.invoice.CopyInvoiceRequest;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.print.BillFooter;
import rs.petcom.master.newFiscalization.print.BillPrint;
import rs.petcom.master.newFiscalization.print.JasperPrintBill;
import rs.petcom.master.newFiscalization.print.JasperStarter;

public class DocumentsController
implements ControlledScreen {
    ScreensController controller;
    CashBuyer selectedCashBuyer;
    HashMap<String, java.lang.Object> hm;
    DocumentType docType;
    PaymentMethod paymentMethod;
    ObservableList<Document> documentList;
    ObservableList<DocumentDetails> detailesList;
    ObservableList<Document> data;
    private InvoiceType invoiceType;
    private boolean printA4;
    private Button repeatFiscal;
    boolean inoiceA4;
    @FXML
    private BorderPane rootPane;
    @FXML
    private VBox vBox;
    @FXML
    private ComboBox<Object> cbObject;
    @FXML
    TableView<Document> documentsTable;
    @FXML
    TableColumn<Document, Integer> tcDocBroj;
    @FXML
    TableColumn<Document, Date> tcDocDatum;
    @FXML
    TableColumn<Document, String> tcDocKomitent;
    @FXML
    TableColumn<Document, String> tcPlacanje;
    @FXML
    TableColumn<Document, String> tcBI;
    @FXML
    TableColumn<Document, String> tcNapomena;
    @FXML
    TableColumn<Document, Double> tcDocVrednost;
    @FXML
    TableColumn<Document, String> tcZakljucan;
    @FXML
    TableView<DocumentDetails> docDetailesTable;
    @FXML
    TableColumn<DocumentDetails, String> tcDocDetProduct;
    @FXML
    TableColumn<DocumentDetails, String> tcBarCode;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetQuantity;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetPrice;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetDiscount;
    @FXML
    TableColumn<DocumentDetails, Double> tcDocDetValue;
    @FXML
    DatePicker dpStartWorkDay;
    @FXML
    DatePicker dpEndWorkDay;
    @FXML
    ComboBox<PointOfSale> cbPos;
    @FXML
    ComboBox<PaymentMethod> cbPaymentMethod;
    @FXML
    private ComboBox<String> cbInvoiceType;
    @FXML
    TextField tfFilter;
    @FXML
    Label lDocCount;
    @FXML
    Label lDocValue;
    @FXML
    CheckBox cbFizickaLica;

    public void initialize() {
        this.cbObject.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                DocumentsController.this.loadPointOfSale();
                DocumentsController.this.loadPaymentMethod();
            }
        });
        this.documentsTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<Document>(){

            public void onChanged(ListChangeListener.Change<? extends Document> c) {
                DocumentsController.this.loadDocDetTable();
                for (Node node : DocumentsController.this.vBox.getChildren()) {
                    if (!(node instanceof Button)) continue;
                    try {
                        Boolean fakt = ((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getPaymentMethodID() == 5;
                        Button b = (Button)node;
                        if (b.getId() != null && b.getId().equals("Faktura")) {
                            b.setDisable(fakt == false);
                            continue;
                        }
                        if (b.getId() == null || !b.getId().equals("Gotovinski")) continue;
                        b.setDisable(fakt.booleanValue());
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
        });
        this.tcDocBroj.setCellValueFactory((Callback)new PropertyValueFactory("Number"));
        this.tcDocDatum.setCellValueFactory((Callback)new PropertyValueFactory("Date"));
        this.tcDocDatum.setCellFactory(column -> new TableCell<Document, Date>(){

            protected void updateItem(Date item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getDateTimeFromatter().format(item));
                }
            }
        });
        this.tcDocKomitent.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    Person person = Person.getById((long)((Document)param.getValue()).getPersonID(), (ScreensController)DocumentsController.this.controller);
                    if (person != null && 2 == person.getPersonTypeID()) {
                        return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)person).name("Name").build();
                    }
                    if (person != null && 1 == person.getPersonTypeID()) {
                        return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)person).name("Name").build();
                    }
                    return null;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcBI.setCellValueFactory((Callback)new PropertyValueFactory("FullNumber"));
        this.tcNapomena.setCellValueFactory((Callback)new PropertyValueFactory("Note"));
        this.documentsTable.setOnMouseClicked(event -> {
            Document selectedD;
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && (selectedD = (Document)this.documentsTable.getSelectionModel().getSelectedItem()) != null) {
                Document document = Document.getByDocumentID((long)selectedD.getDocumentID(), (Connection)this.controller.getSettings().getConnection(), (ScreensController)this.controller);
                this.showAlert("Napomena : ", document.getNote());
            }
        });
        this.tcPlacanje.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<Document, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<Document, String> param) {
                try {
                    return new JavaBeanStringPropertyBuilder().bean((java.lang.Object)PaymentMethod.getByID((int)((Document)param.getValue()).getPaymentMethodID(), (Connection)DocumentsController.this.controller.getSettings().getConnection())).name("Name").build();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        this.tcDocVrednost.setCellValueFactory((Callback)new PropertyValueFactory("SumWithDiscount"));
        this.tcDocVrednost.setCellFactory(column -> new TableCell<Document, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcZakljucan.setCellValueFactory(cellData -> {
            boolean isLocked = ((Document)cellData.getValue()).isLocked();
            String locked = isLocked ? "DA" : "NE";
            return new ReadOnlyStringWrapper(locked);
        });
        this.tcBarCode.setCellValueFactory((Callback)new PropertyValueFactory("Barcode"));
        this.tcDocDetProduct.setCellValueFactory((Callback)new PropertyValueFactory("ProductName"));
        this.tcDocDetQuantity.setCellValueFactory((Callback)new PropertyValueFactory("Quantity"));
        this.tcDocDetQuantity.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)4, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetPrice.setCellValueFactory((Callback)new PropertyValueFactory("Price"));
        this.tcDocDetPrice.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetDiscount.setCellValueFactory((Callback)new PropertyValueFactory("Discount"));
        this.tcDocDetDiscount.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.tcDocDetValue.setCellValueFactory((Callback)new PropertyValueFactory("Value"));
        this.tcDocDetValue.setCellFactory(column -> new TableCell<DocumentDetails, Double>(){

            protected void updateItem(Double item, boolean empty) {
                super.updateItem((java.lang.Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(Settings.getNumberFormat((int)2, (boolean)true).format(item));
                }
            }
        });
        this.dpStartWorkDay.valueProperty().addListener((obs, oldDate, newDate) -> {
            if (this.cbPaymentMethod.getSelectionModel().getSelectedItem() != null) {
                this.loadDocTable(((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID());
            }
        });
        this.dpEndWorkDay.valueProperty().addListener((obs, oldDate, newDate) -> {
            if (this.cbPaymentMethod.getSelectionModel().getSelectedItem() != null) {
                this.loadDocTable(((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID());
            }
        });
        this.tfFilter.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (oldValue != null && newValue.length() < oldValue.length()) {
                    DocumentsController.this.documentsTable.setItems(DocumentsController.this.data);
                }
                String value = newValue.toLowerCase();
                ObservableList subentries = FXCollections.observableArrayList();
                long count = DocumentsController.this.documentsTable.getColumns().stream().count();
                block0: for (int i = 0; i < DocumentsController.this.documentsTable.getItems().size(); ++i) {
                    int j = 0;
                    while ((long)j < count) {
                        String entry = "" + ((TableColumn)DocumentsController.this.documentsTable.getColumns().get(j)).getCellData(i);
                        if (entry.toLowerCase().contains(value)) {
                            subentries.add(DocumentsController.this.documentsTable.getItems().get(i));
                            continue block0;
                        }
                        ++j;
                    }
                }
                DocumentsController.this.documentsTable.setItems(subentries);
            }
        });
        this.loadInvoiceTypeComboBox();
    }

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/dialogTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/treeviewTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tableTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/tabpaneTrgovina.css");
        }
        this.printA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("print.A4"));
        this.inoiceA4 = Boolean.parseBoolean(this.controller.getSettings().getActualByName("invoice.A4"));
        this.dpStartWorkDay.setValue((java.lang.Object)Settings.fromDate((Date)WorkDay.getLastOpenWD((ScreensController)this.controller).getDateFrom()));
        this.dpEndWorkDay.setValue((java.lang.Object)Settings.fromDate((Date)new Date()));
        for (Object o : Object.getList((Connection)this.controller.getSettings().getConnection())) {
            this.cbObject.getItems().add((java.lang.Object)o);
        }
        if (this.cbObject.getItems().size() > 0) {
            this.cbObject.getSelectionModel().select(0);
            this.cbPaymentMethod.getSelectionModel().select(0);
        }
    }

    public void setParameter(java.lang.Object parameter) {
        this.hm = (HashMap)parameter;
        this.docType = DocumentType.getByCode((String)this.hm.get("documentCode").toString(), (Connection)this.controller.getSettings().getConnection());
        if (this.docType.getCode().equals("R")) {
            this.popuniDugmiceZaRacune();
        }
        if (this.docType.getCode().equals("NI")) {
            this.popuniDugmiceNalogeZaIspravku();
        }
        this.cbObject.setDisable(false);
        if (this.controller.getPointOfSale() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getPointOfSale().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(false);
                break;
            }
        }
        if (this.controller.getObject() != null) {
            for (Object o : this.cbObject.getItems()) {
                if (o.getObjectID() != this.controller.getObject().getObjectID()) continue;
                this.cbObject.getSelectionModel().select((java.lang.Object)o);
                this.cbObject.setDisable(false);
                break;
            }
        }
        this.tcPlacanje.setCellFactory(TextHooverOnTableCell.forTableColumn(this.controller));
        this.cbFizickaLica.setDisable(true);
        this.cbFizickaLica.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                int paymentMethodId = ((PaymentMethod)DocumentsController.this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID();
                DocumentsController.this.loadDocTable(paymentMethodId);
            }
        });
    }

    public java.lang.Object getParameter() {
        return null;
    }

    @FXML
    private void cbPosChange() {
        this.loadDocTable(((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID());
    }

    private void showAlert(String title, String message) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    @FXML
    private void cbPaymentMethodChange() {
        int paymentMethodId = ((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID();
        this.activateFizickaLicaCheckBoxForInvoice(paymentMethodId);
        try {
            this.loadDocTable(paymentMethodId);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @FXML
    void cbInvoiceTypeChange(ActionEvent event) {
        System.out.println("nesa");
        int paymentMethodId = ((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID();
        this.invoiceType = InvoiceType.getByName((String)((String)this.cbInvoiceType.getValue()));
        if (this.invoiceType == InvoiceType.SALE_COPY || this.invoiceType == InvoiceType.SALE_TRAINING) {
            this.repeatFiscal.setDisable(true);
        } else if (this.invoiceType == InvoiceType.REFUND_NORMAL) {
            this.repeatFiscal.setDisable(true);
        } else {
            this.repeatFiscal.setDisable(false);
        }
        this.loadDocTable(paymentMethodId);
    }

    private void loadDocTable(int paymentMethodID) {
        ObservableList docs = Document.getObeservableList((int)this.invoiceType.getTypeId(), (int)paymentMethodID, (Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (PointOfSale)((PointOfSale)this.cbPos.getSelectionModel().getSelectedItem()), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpStartWorkDay.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)this.dpEndWorkDay.getValue())), (boolean)true, (boolean)true, (Connection)this.controller.getSettings().getConnection(), (boolean)this.cbFizickaLica.isSelected());
        if (this.cbObject.getSelectionModel().getSelectedItem() != null && this.cbPos.getSelectionModel().getSelectedItem() != null && this.dpStartWorkDay.getValue() != null) {
            this.documentsTable.setItems(docs);
        }
        double sum = 0.0;
        for (Document d : this.documentsTable.getItems()) {
            sum += d.getSumWithDiscount();
        }
        this.lDocCount.setText(String.valueOf(this.documentsTable.getItems().size()));
        this.lDocValue.setText(String.valueOf(Settings.round((double)sum, (int)2)));
        this.data = this.documentsTable.getItems();
    }

    private void loadDocDetTable() {
        try {
            this.detailesList = DocumentDetails.getObeservableList((long)((Document)this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)this.controller.getSettings().getConnection());
        }
        catch (NullPointerException e) {
            this.detailesList = FXCollections.observableArrayList();
        }
        this.docDetailesTable.setItems(this.detailesList);
    }

    private void popuniDugmiceZaRacune() {
        this.vBox.getChildren().clear();
        this.repeatFiscal = new Button("Ponovna \u0161tampa fiskalnog ra\u010duna");
        this.repeatFiscal.setPrefWidth(220.0);
        this.repeatFiscal.setWrapText(true);
        this.repeatFiscal.setTextAlignment(TextAlignment.CENTER);
        this.repeatFiscal.setAlignment(Pos.CENTER);
        this.repeatFiscal.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                int result = DocumentsController.this.controller.yesNoDialog("Ponovna stampa fiskalnog ra\u010duna", "UPOZORENJE: Ovo nije stampa kopije racuna, novom akcijom cete ponovo zaduziti fiskalni uredjaj za izabrani racun!\n\nDa li zelite \u0161tampu fiskalnog ra\u010duna?", DocumentsController.this.rootPane.getScene().getWindow());
                if (result == ScreensController.MODAL_RESULT_YES) {
                    DocumentsController.this.runTask();
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                boolean update = true;
                                DocumentCorrection dc = DocumentCorrection.getDocument((long)((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)DocumentsController.this.controller.getSettings().getConnection());
                                if (dc == null) {
                                    dc = new DocumentCorrection();
                                    update = false;
                                }
                                dc.setCorrectionTypeID(2);
                                dc.setFiscalPrinterID(FiscalPrinter.getIBFM((String)DocumentsController.this.controller.getSettings().getFiscalFolder()));
                                dc.setDate(((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDate());
                                dc.setDoucmentID(((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID());
                                dc.setWorkDayID(((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getWorkDayID());
                                dc.setUserCreated(((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getSysUserAddID());
                                dc.setReciptNumber(((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getFullNumber());
                                dc.setPrintTime(new Date());
                                dc.setUserPrinted(DocumentsController.this.controller.getUser().getUserID());
                                try {
                                    if (update) {
                                        dc.update(DocumentsController.this.controller.getUser(), DocumentsController.this.controller.getSettings().getConnection());
                                    } else {
                                        dc.insert(DocumentsController.this.controller.getUser(), DocumentsController.this.controller.getSettings().getConnection());
                                    }
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                }
                                String BI = FiscalPrinter.printCopy((Document)((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()), (String)DocumentsController.this.controller.getSettings().getFiscalFolder(), (User)DocumentsController.this.controller.getUser(), (boolean)true, (Connection)DocumentsController.this.controller.getSettings().getConnection());
                                Document d = Document.getByID((long)((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID(), (Connection)DocumentsController.this.controller.getSettings().getConnection());
                                d.setFullNumber(BI);
                                d.setAlternativeFullNumber(FiscalPrinter.getIBFM((String)DocumentsController.this.controller.getSettings().getFiscalFolder()));
                                d.update(DocumentsController.this.controller);
                                DocumentsController.this.loadDocTable(((PaymentMethod)DocumentsController.this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID());
                            }
                            catch (SQLException e) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        DocumentsController.this.controller.alert("Gre\u0161ka prilikom snimanja ra\u010duna!", "Do\u0161lo je do gre\u0161ke prilikom snimanja ra\u010duna. \nPoruka gre\u0161ke: \n" + e.getMessage(), DocumentsController.this.rootPane.getScene().getWindow());
                                    }
                                });
                                Log.writeLog((User)DocumentsController.this.controller.getUser(), (String)("PointOfSale: " + DocumentsController.this.controller.getPointOfSale().getName() + " " + e.getLocalizedMessage()), (Connection)DocumentsController.this.controller.getSettings().getConnection());
                                e.printStackTrace();
                            }
                        }
                    }.start();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.repeatFiscal.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                long docId = ((Document)DocumentsController.this.documentsTable.getSelectionModel().getSelectedItem()).getDocumentID();
                User user = DocumentsController.this.controller.getUser();
                Document document = Document.getByID((long)docId, (Connection)DocumentsController.this.controller.getSettings().getConnection());
                CopyInvoiceRequest copyRequest = new CopyInvoiceRequest(document, DocumentsController.this.controller);
                InvoiceResponse response = copyRequest.getInvoiceResponse();
                InvoiceBody copyBody = copyRequest.getBody();
                ModelState[] states = response.getModelState();
                if (states != null) {
                    BadRequestHandler brHandler = new BadRequestHandler(DocumentsController.this.controller, states, DocumentsController.this.rootPane.getScene().getWindow());
                    brHandler.handleBadRequest();
                }
                document.setDocumentTypeID(31);
                document.setDate(new Date());
                document.setDeliveryDate(new Date());
                document.setCurrencyDate(new Date());
                document.setSysDTCreated(new Date());
                document.setSysDTEdit(new Date());
                document.setSysUserAddID(user.getUserID());
                document.setSysUserEditID(user.getUserID());
                document.setReferentDateTime(response.getSdcDateTime());
                document.setReferentNumber(response.getInvoiceNumber());
                document.setNumber(Document.getNextNumber((int)31, (long)document.getPointOfSaleID(), (ScreensController)DocumentsController.this.controller));
                long docCopyId = document.insert(DocumentsController.this.controller);
                ArrayList details = DocumentDetails.getList((long)docId, (Connection)DocumentsController.this.controller.getSettings().getConnection());
                for (DocumentDetails detail : details) {
                    detail.setDocumentID(docCopyId);
                    detail.insert(DocumentsController.this.controller.getSettings().getConnection());
                }
                if (DocumentsController.this.printA4 || DocumentsController.this.inoiceA4) {
                    Person person = Person.getById((long)document.getPersonID(), (ScreensController)DocumentsController.this.controller);
                    if (person != null && person.getPersonID() < 1L) {
                        person = null;
                    }
                    String path = ScreensController.SCREEN_JASPER_BILL_REF;
                    HashMap<String, java.lang.Object> reportResources = new HashMap<String, java.lang.Object>();
                    ObservableList billPrints = Izvestaji.vatRateDocuemntId((Connection)DocumentsController.this.controller.getSettings().getConnection(), (Long)document.getDocumentID(), (InvoiceResponse)response);
                    if (!"Prenos na ra\u010dun".equals(((BillFooter)billPrints.get(0)).getPayment()) && DocumentsController.this.inoiceA4) {
                        ESCPosPrint escPos = new ESCPosPrint(copyRequest.getBody(), response, document, DocumentsController.this.controller);
                        escPos.printFiscalBill(InvoiceType.SALE_COPY, null);
                    } else if ("Prenos na ra\u010dun".equals(((BillFooter)billPrints.get(0)).getPayment()) && DocumentsController.this.inoiceA4 || DocumentsController.this.printA4) {
                        reportResources.put("datasTax", DocumentsController.this.getBillTax(((BillFooter)billPrints.get(0)).getBillPrintMap()));
                        reportResources.put("adtionalFooter", DocumentsController.this.getBillFooter((BillFooter)billPrints.get(0), response));
                        reportResources.put("adtionalFooterName", DocumentsController.this.getBillFooterNameFild());
                        reportResources.put("qrUrl", response.getVerificationUrl());
                        reportResources.put("RefBroj", " Ref broj: " + response.getInvoiceNumber());
                        reportResources.put("refVreme", " Ref vreme: " + response.getSdcDateTime());
                        reportResources.put("datas", ((BillFooter)billPrints.get(0)).getBillPrints());
                        reportResources.put("poptpisKupca", "");
                        reportResources.put("controller", DocumentsController.this.controller);
                        ObservableList images = Images.getImagesList((ScreensController)DocumentsController.this.controller);
                        if (!images.isEmpty()) {
                            reportResources.put("image", ((Images)images.get(0)).getImage());
                        }
                        reportResources.put("napomena", Bill.getBillNote((long)document.getDocumentID(), (ScreensController)DocumentsController.this.controller));
                        LocalDateTime localDateTime = LocalDateTime.now();
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
                        String formatDateTime = localDateTime.format(formatter);
                        reportResources.put("dateTime", formatDateTime);
                        reportResources.put("infoCompany", JasperPrintBill.getInformationCompany((ScreensController)DocumentsController.this.controller));
                        reportResources.put("addressCompany", JasperPrintBill.fetAddressCompany((ScreensController)DocumentsController.this.controller));
                        reportResources.put("typeBill", "=============================================OVO NIJE FISKALNI RA\u010cUN=================================================");
                        reportResources.put("krajRacuna", "==============================================OVO NIJE FISKALNI RA\u010cUN===============================================");
                        reportResources.put("krajRacunaRefund", "================================OVO NIJE FISKALNI RA\u010cUN==============================");
                        reportResources.put("supplier", JasperPrintBill.getSupplier((InvoiceResponse)response, (InvoiceBody)copyBody));
                        reportResources.put("customer", JasperPrintBill.getCusomer((Long)document.getDocumentID(), (Person)new Person(document.getPersonID()), (ScreensController)DocumentsController.this.controller));
                        reportResources.put("nameBill", "KOPIJA RA\u010cUNA\n" + response.getInvoiceNumber());
                        JasperStarter starter = new JasperStarter(reportResources, path, DocumentsController.this.rootPane);
                        starter.createReportCollectionDataSource(DocumentsController.this.rootPane.getScene().getWindow());
                    }
                } else {
                    ESCPosPrint escPos = new ESCPosPrint(copyRequest.getBody(), response, document, DocumentsController.this.controller);
                    escPos.printFiscalBill(InvoiceType.SALE_COPY, null);
                }
            }
        });
        Button exportBills = new Button("Izvoz ra\u010duna u excel");
        exportBills.setPrefWidth(220.0);
        exportBills.setWrapText(true);
        exportBills.setId("racunExcel");
        exportBills.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                System.out.println("Export");
                ObservableList docs = Document.getObeservableList((int)DocumentsController.this.invoiceType.getTypeId(), (int)-1, (Object)((Object)DocumentsController.this.cbObject.getSelectionModel().getSelectedItem()), (PointOfSale)((PointOfSale)DocumentsController.this.cbPos.getSelectionModel().getSelectedItem()), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)DocumentsController.this.dpStartWorkDay.getValue())), (Date)Settings.fromLocalDate((LocalDate)((LocalDate)DocumentsController.this.dpEndWorkDay.getValue())), (boolean)true, (boolean)true, (Connection)DocumentsController.this.controller.getSettings().getConnection(), (boolean)false);
                FileChooser fileChooser = new FileChooser();
                fileChooser.setInitialDirectory(FileSystemView.getFileSystemView().getHomeDirectory().getAbsoluteFile());
                fileChooser.setTitle(DocumentsController.this.controller.getBundle().getString("selectFileForExport"));
                fileChooser.getExtensionFilters().add((java.lang.Object)new FileChooser.ExtensionFilter("XLS files (*.xls)", new String[]{"*.xlsx"}));
                File file = fileChooser.showSaveDialog(DocumentsController.this.controller.getRoot().getScene().getWindow());
                String putanja = file.getPath();
                Document.getPregledRacunaToExcel((ScreensController)DocumentsController.this.controller, (List)docs, (String)putanja, (BorderPane)DocumentsController.this.rootPane);
            }
        });
        if (this.controller.getUser().hasRole("storno")) {
            this.vBox.getChildren().addAll((java.lang.Object[])new Node[]{this.repeatFiscal, exportBills});
        } else {
            this.vBox.getChildren().addAll((java.lang.Object[])new Node[]{this.repeatFiscal, exportBills});
        }
    }

    private void loadPointOfSale() {
        PointOfSale allPos = new PointOfSale();
        allPos.setPointOfSaleID(0);
        allPos.setName("Sva prodajna mesta");
        this.cbPos.getItems().clear();
        this.cbPos.getItems().add((java.lang.Object)allPos);
        for (PointOfSale ps : PointOfSale.getPosList((Object)((Object)this.cbObject.getSelectionModel().getSelectedItem()), (Connection)this.controller.getSettings().getConnection())) {
            this.cbPos.getItems().add((java.lang.Object)ps);
        }
        this.cbPos.getSelectionModel().select(0);
    }

    private void loadPaymentMethod() {
        PaymentMethod allPaymentMethod = new PaymentMethod();
        allPaymentMethod.setPaymentMethodID(-1);
        allPaymentMethod.setName("Sve metode");
        this.cbPaymentMethod.getItems().clear();
        this.cbPaymentMethod.getItems().add((java.lang.Object)allPaymentMethod);
        for (PaymentMethod pay : PaymentMethod.getAllList((Connection)this.controller.getSettings().getConnection())) {
            this.cbPaymentMethod.getItems().add((java.lang.Object)pay);
        }
        this.cbPaymentMethod.getSelectionModel().select(0);
        this.loadDocTable(((PaymentMethod)this.cbPaymentMethod.getSelectionModel().getSelectedItem()).getPaymentMethodID());
    }

    private void popuniDugmiceNalogeZaIspravku() {
        this.vBox.getChildren().clear();
    }

    public void runTask() {
        double wndwWidth = 300.0;
        Label updateLabel = new Label("Stampa ra\u010duna u toku...");
        updateLabel.setStyle("-fx-text-fill: white;  -fx-font-size: 20px; -fx-alignment: CENTER;");
        updateLabel.setPrefWidth(300.0);
        ProgressIndicator progress = new ProgressIndicator();
        progress.setPrefWidth(300.0);
        VBox updatePane = new VBox();
        updatePane.setPadding(new Insets(10.0));
        updatePane.setSpacing(5.0);
        updatePane.setStyle("-fx-background-color: #21252e;\t-fx-border-width: 1px; -fx-border-color: #7CB72A;");
        updatePane.getChildren().addAll((java.lang.Object[])new Node[]{updateLabel, progress});
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        final Stage taskUpdateStage = new Stage();
        taskUpdateStage.setScene(new Scene((Parent)updatePane));
        taskUpdateStage.initOwner(this.rootPane.getScene().getWindow());
        taskUpdateStage.initStyle(StageStyle.UTILITY);
        taskUpdateStage.show();
        Task<Void> longTask = new Task<Void>(){

            protected Void call() throws Exception {
                int max = 50;
                for (int i = 1; i <= max && this.isCancelled(); ++i) {
                    this.updateProgress(i, max);
                    this.updateMessage("Task part " + String.valueOf(i) + " complete");
                }
                return null;
            }
        };
        longTask.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                taskUpdateStage.hide();
            }
        });
        progress.progressProperty().bind((ObservableValue)longTask.progressProperty());
        updateLabel.textProperty().bind((ObservableValue)longTask.messageProperty());
        taskUpdateStage.show();
        new Thread((Runnable)longTask).start();
    }

    private void activateFizickaLicaCheckBoxForInvoice(int paymentMethodId) {
        int invoice = 5;
        if (paymentMethodId == invoice) {
            this.cbFizickaLica.setDisable(false);
        } else {
            this.cbFizickaLica.setDisable(true);
            this.cbFizickaLica.setSelected(false);
        }
    }

    private void loadInvoiceTypeComboBox() {
        InvoiceType[] iTypes;
        for (InvoiceType iType : iTypes = InvoiceType.values()) {
            String name = iType.getName();
            if (name.contains("Ra\u010dun")) {
                this.cbInvoiceType.getItems().add((java.lang.Object)name);
                continue;
            }
            if (!name.contains("Refundacija")) continue;
            String name1 = iType.getName();
            this.cbInvoiceType.getItems().add((java.lang.Object)name1);
        }
        this.cbInvoiceType.getSelectionModel().select((java.lang.Object)"Ra\u010dun");
        this.invoiceType = InvoiceType.getByName((String)((String)this.cbInvoiceType.getValue()));
    }

    private List<BillPrint> getBillTax(Map<String, BillPrint> billPrintMap) {
        ArrayList<BillPrint> billPrints = new ArrayList<BillPrint>();
        for (Map.Entry<String, BillPrint> hm : billPrintMap.entrySet()) {
            billPrints.add(hm.getValue());
        }
        return billPrints;
    }

    private String getBillFooter(BillFooter billFooter, InvoiceResponse refundResponseCopy) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" " + billFooter.getSum());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getSumTax());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getPayment());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentDateTime());
        stringBuilder.append("\n");
        stringBuilder.append(" " + billFooter.getReferentNumber());
        stringBuilder.append("\n");
        stringBuilder.append(" " + refundResponseCopy.getInvoiceCounter());
        return stringBuilder.toString();
    }

    private String getBillFooterNameFild() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" Za uplatu: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Porez ukupno: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Na\u010dina placanja: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Prf vreme: ");
        stringBuilder.append("\n");
        stringBuilder.append(" PFR broj ra\u010duna: ");
        stringBuilder.append("\n");
        stringBuilder.append(" Broja\u010d ra\u010duna: ");
        return stringBuilder.toString();
    }
}

