/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.print;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.Product;

public class JRPrintPreviewPane
extends BorderPane {
    public static final int REPORT_DPI_RESOLUTION = 72;
    protected final int SPACING = 25;
    protected final float MIN_ZOOM = 0.5f;
    protected final float MAX_ZOOM = 10.0f;
    protected final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected float zoom = 0.0f;
    protected float realZoom = 0.0f;
    protected DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    protected JasperPrint jasperPrint;
    protected double screenResolution = 72.0;
    protected JasperReportsContext jasperReportsContext;
    protected ResourceBundle resourceBundle;
    protected ScreensController controller;
    protected ObservableList<Product> list = FXCollections.observableArrayList();
    protected ToggleButton btnActualSize = new ToggleButton();
    protected ToggleButton btnFitPage = new ToggleButton();
    protected ToggleButton btnFitWidth = new ToggleButton();
    protected Button btnFirst = new Button();
    protected Button btnLast = new Button();
    protected Button btnNext = new Button();
    protected Button btnPrevious = new Button();
    protected Button btnPrint = new Button();
    protected Button btnSave = new Button();
    protected Button btnZoomIn = new Button();
    protected Button btnZoomOut = new Button();
    protected ComboBox<String> cmbZoom = new ComboBox();
    protected Label lblStatus = new Label();
    protected VBox vBoxPage = new VBox();
    protected HBox statusBar = new HBox();
    protected ScrollPane scrollPane = new ScrollPane();
    protected ToolBar toolBar = new ToolBar();
    protected TextField txtGoTo = new TextField();
    protected DropShadow dropShadow = new DropShadow();
    protected int pageIndex;
    protected Label lblStampaOd = new Label();
    protected Label lblStampaDo = new Label();
    protected TextField txtStampaDo = new TextField();
    protected TextField txtStampaOd = new TextField();

    public JRPrintPreviewPane(JasperPrint jasperPrint) {
        this(jasperPrint, null);
    }

    public ScreensController getController() {
        return this.controller;
    }

    public void setController(ScreensController controller) {
        this.controller = controller;
    }

    public JRPrintPreviewPane(JasperPrint jasperPrint, ScreensController controller, ObservableList<Product> list) {
        this(jasperPrint, null);
        this.controller = controller;
        this.list = list;
    }

    public JRPrintPreviewPane(JasperPrint jasperPrint, ResourceBundle resBundle) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperPrint, resBundle);
    }

    public JRPrintPreviewPane(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, ResourceBundle resBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.jasperPrint = jasperPrint;
        this.initResources(resBundle);
        this.screenResolution = Screen.getPrimary().getDpi();
        this.initComponents();
        this.setZoomRatio(1.0f);
        double width = this.vBoxPage.getBoundsInParent().getWidth() + 50.0 + 13.0;
        this.setWidth(width > 1000.0 ? 1000.0 : width);
        this.btnFitWidth.setSelected(true);
        this.onSetFitToWidthPressed();
        this.btnActualSize.setStyle("-fx-text-fill: black;");
        this.btnFitPage.setStyle("-fx-text-fill: black;");
        this.btnFitWidth.setStyle("-fx-text-fill: black;");
        this.txtGoTo.setStyle("-fx-text-fill: black;");
        this.toolBar.setStyle("-fx-background-color: gray;");
        this.btnFirst.setStyle("-fx-background-color: gray;");
        this.btnLast.setStyle("-fx-background-color: gray;");
        this.btnNext.setStyle("-fx-background-color: gray;");
        this.btnPrevious.setStyle("-fx-background-color: gray;");
        this.btnPrint.setStyle("-fx-background-color: gray;");
        this.btnSave.setStyle("-fx-background-color: gray;");
        this.btnZoomIn.setStyle("-fx-background-color: gray;");
        this.btnZoomOut.setStyle("-fx-background-color: gray;");
        this.cmbZoom.setStyle("-fx-font-size: 10px;");
        this.cmbZoom.setPrefSize(100.0, 24.0);
    }

    protected void initResources(ResourceBundle resBundle) {
        this.resourceBundle = resBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", Locale.getDefault()) : resBundle;
    }

    private void initComponents() {
        ToggleGroup group = new ToggleGroup();
        this.btnActualSize.setToggleGroup(group);
        this.btnFitPage.setToggleGroup(group);
        this.btnFitWidth.setToggleGroup(group);
        this.btnActualSize.setSelected(true);
        this.btnPrint.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/print.GIF"))));
        this.btnPrint.setTooltip(new Tooltip(this.resourceBundle.getString("print")));
        this.btnPrint.setPrefSize(23.0, 23.0);
        this.btnPrint.setOnAction(e -> this.onBtnPrint());
        this.btnPrint.setFocusTraversable(false);
        this.btnSave.setText("Save");
        this.btnSave.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/rs/petcom/master/img/save-white18x18.png"))));
        this.btnSave.setTooltip(new Tooltip("Save as..."));
        this.btnSave.setMinSize(40.0, 23.0);
        this.btnSave.setPrefSize(40.0, 23.0);
        this.btnSave.setOnAction(e -> this.onBtnSave());
        this.btnSave.setFocusTraversable(false);
        this.btnFirst.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/first.GIF"))));
        this.btnFirst.setTooltip(new Tooltip(this.resourceBundle.getString("first.page")));
        this.btnFirst.setPrefSize(23.0, 23.0);
        this.btnFirst.setOnAction(e -> this.onBtnFirstPressed());
        this.btnFirst.setFocusTraversable(false);
        this.btnPrevious.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/previous.GIF"))));
        this.btnPrevious.setTooltip(new Tooltip(this.resourceBundle.getString("previous.page")));
        this.btnPrevious.setPrefSize(23.0, 23.0);
        this.btnPrevious.setOnAction(e -> this.onBtnPreviousPressed());
        this.btnPrevious.setFocusTraversable(false);
        this.btnPrevious.setDisable(false);
        this.btnNext.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/next.GIF"))));
        this.btnNext.setTooltip(new Tooltip(this.resourceBundle.getString("next.page")));
        this.btnNext.setPrefSize(23.0, 23.0);
        this.btnNext.setOnAction(e -> this.onBtnNextPressed());
        this.btnNext.setFocusTraversable(false);
        this.btnNext.setDisable(false);
        this.btnLast.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/last.GIF"))));
        this.btnLast.setTooltip(new Tooltip(this.resourceBundle.getString("last.page")));
        this.btnLast.setPrefSize(23.0, 23.0);
        this.btnLast.setOnAction(e -> this.onBtnLastPressed());
        this.btnLast.setFocusTraversable(false);
        this.txtGoTo.setTooltip(new Tooltip(this.resourceBundle.getString("go.to.page")));
        this.txtGoTo.setAlignment(Pos.CENTER);
        this.txtGoTo.setPrefSize(40.0, 23.0);
        this.txtGoTo.setOnAction(e -> this.onGoToTextChanged());
        this.txtGoTo.setFocusTraversable(false);
        this.btnActualSize.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/actualsize.GIF"))));
        this.btnActualSize.setTooltip(new Tooltip(this.resourceBundle.getString("actual.size")));
        this.btnActualSize.setPrefSize(23.0, 23.0);
        this.btnActualSize.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onActualSizePressed();
            }
        });
        this.btnActualSize.setFocusTraversable(false);
        this.btnFitPage.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/fitpage.GIF"))));
        this.btnFitPage.setTooltip(new Tooltip(this.resourceBundle.getString("fit.page")));
        this.btnFitPage.setPrefSize(23.0, 23.0);
        this.btnFitPage.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onFitPagePressed();
            }
        });
        this.btnFitPage.setFocusTraversable(false);
        this.btnFitWidth.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/fitwidth.GIF"))));
        this.btnFitWidth.setTooltip(new Tooltip(this.resourceBundle.getString("fit.width")));
        this.btnFitWidth.setPrefSize(23.0, 23.0);
        this.btnFitWidth.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onSetFitToWidthPressed();
            }
        });
        this.btnFitWidth.setFocusTraversable(false);
        this.lblStampaOd.setFont(new Font("Dialog", 10.0));
        this.lblStampaOd.setText("\ufffdtampaj od ");
        this.lblStampaDo.setFont(new Font("Dialog", 10.0));
        this.lblStampaDo.setText(" do ");
        this.txtStampaOd.setTooltip(new Tooltip("Prva stranica za stampu (izmedju 1 i " + this.jasperPrint.getPages().size() + ")"));
        this.txtStampaOd.setAlignment(Pos.CENTER);
        this.txtStampaOd.setPrefSize(40.0, 23.0);
        this.txtStampaOd.setFocusTraversable(false);
        this.txtStampaOd.setText("1");
        this.txtStampaOd.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                return;
            }
            try {
                Integer i = Integer.valueOf(newValue);
                if (i <= 0 || i > this.jasperPrint.getPages().size()) {
                    ((StringProperty)observable).setValue(oldValue);
                }
            }
            catch (Exception e) {
                ((StringProperty)observable).setValue(oldValue);
            }
        });
        this.txtStampaDo.setTooltip(new Tooltip("Poslednja stranica za \ufffdtampu (izme\ufffdu 1 i " + this.jasperPrint.getPages().size() + ")"));
        this.txtStampaDo.setAlignment(Pos.CENTER);
        this.txtStampaDo.setPrefSize(40.0, 23.0);
        this.txtStampaDo.setFocusTraversable(false);
        this.txtStampaDo.setText("" + this.jasperPrint.getPages().size());
        this.txtStampaDo.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                return;
            }
            try {
                Integer i = Integer.valueOf(newValue);
                if (i <= 0 || i > this.jasperPrint.getPages().size()) {
                    ((StringProperty)observable).setValue(oldValue);
                }
            }
            catch (Exception e) {
                ((StringProperty)observable).setValue(oldValue);
            }
        });
        this.toolBar.getItems().addAll((Object[])new Node[]{this.btnActualSize, this.btnFitPage, this.btnFitWidth, new Separator(), this.btnZoomIn, this.btnZoomOut, this.cmbZoom, new Separator(), this.btnFirst, this.btnPrevious, this.txtGoTo, this.btnNext, this.btnLast, new Separator(), this.lblStampaOd, this.txtStampaOd, this.lblStampaDo, this.txtStampaDo, this.btnPrint, this.btnSave});
        this.btnZoomIn.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/zoomin.GIF"))));
        this.btnZoomIn.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.in")));
        this.btnZoomIn.setPrefSize(23.0, 23.0);
        this.btnZoomIn.setOnAction(e -> this.onBtnZoomIn());
        this.btnZoomIn.setFocusTraversable(false);
        this.btnZoomOut.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/zoomout.GIF"))));
        this.btnZoomOut.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.out")));
        this.btnZoomOut.setPrefSize(23.0, 23.0);
        this.btnZoomOut.setOnAction(e -> this.onBtnZoomOut());
        this.btnZoomOut.setFocusTraversable(false);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.ratio")));
        this.cmbZoom.setPrefSize(100.0, 24.0);
        for (int zoom : this.zooms) {
            this.cmbZoom.getItems().add((Object)(zoom + "%"));
        }
        this.cmbZoom.getSelectionModel().select(2);
        this.cmbZoom.setFocusTraversable(false);
        this.cmbZoom.setOnAction(e -> this.onComboBoxZoomChanged());
        this.cmbZoom.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.onComboBoxZoomChanged();
            }
        });
        this.vBoxPage.setSpacing(25.0);
        this.vBoxPage.setPadding(new Insets(25.0));
        this.vBoxPage.setAlignment(Pos.CENTER);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setContent((Node)this.vBoxPage);
        this.scrollPane.viewportBoundsProperty().addListener((arg0, arg1, arg2) -> {
            if (this.btnFitWidth.isSelected()) {
                this.onSetFitToWidthPressed();
            }
            this.scrollPane.setFitToWidth(this.vBoxPage.prefWidth(-1.0) < arg2.getWidth());
            this.scrollPane.setFitToHeight(this.vBoxPage.prefHeight(-1.0) < arg2.getHeight());
        });
        this.scrollPane.vvalueProperty().addListener((observable, oldValue, newValue) -> {
            if (1.0 == newValue.doubleValue()) {
                ++this.pageIndex;
                this.refresh();
            }
            if (0.03676470588235293 == oldValue.doubleValue() && newValue.doubleValue() == 0.0 && this.pageIndex > 0) {
                --this.pageIndex;
                this.refresh();
            }
        });
        this.lblStatus.setFont(new Font("Dialog", 10.0));
        this.statusBar.setAlignment(Pos.CENTER);
        this.statusBar.setMaxHeight(24.0);
        this.statusBar.getChildren().add((Object)this.lblStatus);
        this.setTop((Node)this.toolBar);
        this.setCenter((Node)this.scrollPane);
        this.setBottom((Node)this.statusBar);
        this.dropShadow.setColor(Color.GREY);
        this.dropShadow.setOffsetX(2.0);
        this.dropShadow.setOffsetY(2.0);
    }

    protected void refresh() {
        this.vBoxPage.getChildren().clear();
        try {
            BufferedImage awtImage = (BufferedImage)JasperPrintManager.getInstance((JasperReportsContext)this.jasperReportsContext).printToImage(this.jasperPrint, this.pageIndex, this.realZoom);
            WritableImage image = SwingFXUtils.toFXImage((BufferedImage)awtImage, null);
            ImageView iv = new ImageView((Image)image);
            double contentsHeight = this.vBoxPage.getBoundsInLocal().getHeight();
            double viewportHeight = this.scrollPane.getViewportBounds().getHeight();
            this.scrollPane.setVvalue(iv.getBoundsInParent().getMinY() / (contentsHeight - viewportHeight));
            iv.setEffect((Effect)this.dropShadow);
            this.vBoxPage.getChildren().add((Object)iv);
        }
        catch (JRException ex) {
            ex.printStackTrace();
        }
    }

    protected void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.cmbZoom.getEditor().setText(this.zoomDecimalFormat.format(newZoom * 100.0f) + "%");
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                this.realZoom = (float)((double)this.zoom * this.screenResolution / 72.0);
                if (this.realZoom == 0.0f) {
                    this.realZoom = 1.0f;
                }
                System.out.println("realZoom " + this.realZoom);
                this.refresh();
            }
        }
        this.btnZoomIn.setDisable(this.zoom >= (float)this.zooms[this.zooms.length - 1] / 100.0f);
        this.btnZoomOut.setDisable(this.zoom <= (float)this.zooms[0] / 100.0f);
    }

    private void setRealZoomRatio(float newZoom) {
        if (newZoom > 0.0f && this.realZoom != newZoom) {
            this.zoom = (float)((double)(newZoom * 72.0f) / this.screenResolution);
            this.realZoom = newZoom;
            this.cmbZoom.getEditor().setText(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refresh();
        }
        this.btnZoomIn.setDisable(this.zoom >= (float)this.zooms[this.zooms.length - 1] / 100.0f);
        this.btnZoomOut.setDisable(this.zoom <= (float)this.zooms[0] / 100.0f);
    }

    protected int getZoomRatio() {
        try {
            return this.zoomDecimalFormat.parse(this.cmbZoom.getEditor().getText()).intValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return (int)this.zoom;
        }
    }

    private void onBtnZoomIn() {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int index = Arrays.binarySearch(this.zooms, this.getZoomRatio());
        if (index < 0) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[-index - 1]) + "%"));
        } else if (index < this.cmbZoom.getItems().size() - 1) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[index + 1]) + "%"));
        }
    }

    private void onBtnZoomOut() {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int index = Arrays.binarySearch(this.zooms, this.getZoomRatio());
        if (index > 0) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[index - 1]) + "%"));
        } else if (index < -1) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[-index - 2]) + "%"));
        }
    }

    private void onComboBoxZoomChanged() {
        try {
            if (this.cmbZoom.getValue() != null) {
                float newZoom = this.zoomDecimalFormat.parse((String)this.cmbZoom.getValue()).floatValue() / 100.0f;
                if (newZoom < 0.5f) {
                    newZoom = 0.5f;
                }
                if (newZoom > 10.0f) {
                    newZoom = 10.0f;
                }
                this.setZoomRatio(newZoom);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void onGoToTextChanged() {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber > 0 && pageNumber <= this.jasperPrint.getPages().size()) {
                this.pageIndex = pageNumber - 1;
            }
            this.refresh();
        }
        catch (NumberFormatException e) {
            this.refresh();
        }
    }

    private void onBtnFirstPressed() {
        this.pageIndex = 0;
        this.refresh();
    }

    private void onBtnPreviousPressed() {
        --this.pageIndex;
        this.refresh();
    }

    private void onBtnNextPressed() {
        ++this.pageIndex;
        this.refresh();
    }

    private void onBtnLastPressed() {
        this.pageIndex = this.jasperPrint.getPages().size() - 1;
        this.refresh();
    }

    private void setPage(int index) {
        double contentsHeight = this.vBoxPage.getBoundsInLocal().getHeight();
        double viewportHeight = this.scrollPane.getViewportBounds().getHeight();
        ImageView iv = (ImageView)this.vBoxPage.getChildren().get(index);
        this.scrollPane.setVvalue(iv.getBoundsInParent().getMinY() / (contentsHeight - viewportHeight));
        this.setPageIndex(index);
    }

    protected void setPageIndex(int index) {
        int pagesNo = this.jasperPrint.getPages().size();
        this.btnFirst.setDisable(index == 0);
        this.btnPrevious.setDisable(index == 0);
        this.btnLast.setDisable(index == pagesNo - 1);
        this.btnNext.setDisable(index == pagesNo - 1);
        this.txtGoTo.setDisable(pagesNo == 1);
        this.txtGoTo.setText(String.valueOf(index + 1));
        this.lblStatus.setText(MessageFormat.format(this.resourceBundle.getString("page"), index + 1, pagesNo));
        this.pageIndex = index;
    }

    private void onSetFitToWidthPressed() {
        this.cmbZoom.getSelectionModel().clearSelection();
        this.setRealZoomRatio((float)(this.scrollPane.getViewportBounds().getWidth() - 50.0 - 2.0) / (float)this.jasperPrint.getPageFormat(this.pageIndex).getPageWidth().intValue());
    }

    private void onActualSizePressed() {
        this.cmbZoom.getSelectionModel().select(2);
    }

    private void onFitPagePressed() {
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
        float heightRatio = ((float)this.scrollPane.getViewportBounds().getHeight() - 50.0f) / (float)pageFormat.getPageHeight().intValue();
        float widthRatio = ((float)this.scrollPane.getViewportBounds().getWidth() - 50.0f) / (float)pageFormat.getPageWidth().intValue();
        this.cmbZoom.getSelectionModel().clearSelection();
        this.setRealZoomRatio(heightRatio < widthRatio ? heightRatio : widthRatio);
    }

    private void onBtnPrint() {
        Task<Boolean> task = new Task<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean call() throws Exception {
                try {
                    Boolean bl;
                    JRPrintPreviewPane.this.btnPrint.setDisable(true);
                    JRPrintPreviewPane.this.getScene().setCursor(Cursor.WAIT);
                    int firstPage = -1;
                    int lastPage = -1;
                    if (!JRPrintPreviewPane.this.txtStampaOd.getText().equals("") || !JRPrintPreviewPane.this.txtStampaDo.getText().equals("")) {
                        try {
                            firstPage = Integer.parseInt(JRPrintPreviewPane.this.txtStampaOd.getText());
                            if (firstPage < 1) {
                                firstPage = 1;
                            } else if (firstPage > JRPrintPreviewPane.this.jasperPrint.getPages().size()) {
                                firstPage = JRPrintPreviewPane.this.jasperPrint.getPages().size();
                            }
                        }
                        catch (Exception e) {
                            firstPage = 1;
                        }
                        try {
                            lastPage = Integer.parseInt(JRPrintPreviewPane.this.txtStampaDo.getText());
                            if (lastPage < 1) {
                                lastPage = 1;
                            } else if (lastPage > JRPrintPreviewPane.this.jasperPrint.getPages().size()) {
                                lastPage = JRPrintPreviewPane.this.jasperPrint.getPages().size();
                            }
                        }
                        catch (Exception e) {
                            lastPage = JRPrintPreviewPane.this.jasperPrint.getPages().size();
                        }
                    }
                    if (firstPage != -1 && lastPage != -1) {
                        bl = JasperPrintManager.getInstance((JasperReportsContext)JRPrintPreviewPane.this.jasperReportsContext).print(JRPrintPreviewPane.this.jasperPrint, firstPage - 1, lastPage - 1, false);
                        return bl;
                    }
                    bl = JasperPrintManager.getInstance((JasperReportsContext)JRPrintPreviewPane.this.jasperReportsContext).print(JRPrintPreviewPane.this.jasperPrint, false);
                    return bl;
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
                finally {
                    JRPrintPreviewPane.this.getScene().setCursor(Cursor.DEFAULT);
                    JRPrintPreviewPane.this.btnPrint.setDisable(false);
                }
                return false;
            }
        };
        task.run();
    }

    private void onBtnSave() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Sa\u010duvaj kao...");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("EXCEL files (*.xlsx)", new String[]{"*.XLSX"}), new FileChooser.ExtensionFilter("CSV files (*.csv)", new String[]{"*.CSV"}), new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.PDF"}), new FileChooser.ExtensionFilter("WORD files (*.docx)", new String[]{"*.DOCX"})});
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (fileChooser.getSelectedExtensionFilter() != null && fileChooser.getSelectedExtensionFilter().getExtensions() != null) {
            List selectedExtension = fileChooser.getSelectedExtensionFilter().getExtensions();
            int extensionLength = 0;
            if (selectedExtension.contains("*.PDF") || selectedExtension.contains("*.CSV")) {
                extensionLength = 4;
            }
            if (selectedExtension.contains("*.XLSX") || selectedExtension.contains("*.DOCX")) {
                extensionLength = 5;
            }
            String nameWithoutExt = file.getName().substring(0, file.getName().length() - extensionLength);
            String pathWithoutExt = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - extensionLength);
            String pathWithoutName = pathWithoutExt.substring(0, pathWithoutExt.lastIndexOf(nameWithoutExt) - 1);
            if (selectedExtension.contains("*.CSV")) {
                this.getReceivingReportToExcel(nameWithoutExt, pathWithoutName);
            }
            if (selectedExtension.contains("*.XLSX")) {
                this.getReceivingReportToExcel(nameWithoutExt, pathWithoutName);
            }
            if (selectedExtension.contains("*.PDF")) {
                this.getPdfFromJasper(this.jasperPrint, nameWithoutExt, pathWithoutName);
            }
            if (selectedExtension.contains("*.DOCX")) {
                this.getDocFromJasper(this.jasperPrint, nameWithoutExt, pathWithoutName);
            }
        }
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                return false;
            }
        };
        task.run();
    }

    public void getCsvFromJasper() {
    }

    public File getPdfFromJasper(JasperPrint jprint, String ime, String path) {
        File pdf = null;
        try {
            File directory = new File(String.valueOf(path));
            if (!directory.exists()) {
                directory.mkdir();
            }
            pdf = File.createTempFile(ime, ".pdf", directory);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jprint, (OutputStream)new FileOutputStream(pdf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        return pdf;
    }

    public void getDocFromJasper(JasperPrint jprint, String ime, String path) {
        try {
            File directory = new File(String.valueOf(path));
            if (!directory.exists()) {
                directory.mkdir();
            }
            JRDocxExporter exporter = new JRDocxExporter();
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jprint));
            File exportReportFile = new File(directory + File.separator + ime + ".docx");
            exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(exportReportFile));
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void getXlsxFromJasper(JasperPrint jprint, String ime, String path) {
        HashMap<String, String> dateFormats = new HashMap<String, String>();
        dateFormats.put("EEE, MMM d, yyyy", "ddd, mmm d, yyyy");
        File directory = new File(String.valueOf(path));
        if (!directory.exists()) {
            directory.mkdir();
        }
        JRXlsxExporter exporter = new JRXlsxExporter();
        SimpleXlsxReportConfiguration repConfig = new SimpleXlsxReportConfiguration();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jprint));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(directory + File.separator + ime + ".xlsx"));
        repConfig.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
        repConfig.setDetectCellType(Boolean.TRUE);
        repConfig.setCollapseRowSpan(Boolean.valueOf(false));
        repConfig.setFormatPatternsMap(dateFormats);
        repConfig.setFontSizeFixEnabled(Boolean.valueOf(true));
        exporter.setConfiguration((ReportExportConfiguration)repConfig);
        try {
            exporter.exportReport();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    protected void getReceivingReportToExcel(String ime, String path) {
        File directory = new File(String.valueOf(path));
        if (!directory.exists()) {
            directory.mkdir();
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Promet artikala");
        XSSFRow header = sheet.createRow(0);
        header.createCell(0).setCellValue("Kod");
        header.createCell(1).setCellValue("BarKod");
        header.createCell(2).setCellValue("Name");
        header.createCell(3).setCellValue("Ime grupe");
        header.createCell(4).setCellValue("Velicina");
        header.createCell(5).setCellValue("Boja");
        header.createCell(6).setCellValue("Kolicina");
        header.createCell(7).setCellValue("Cena");
        header.createCell(8).setCellValue("Vrednost");
        header.createCell(9).setCellValue("Osnovica");
        header.createCell(10).setCellValue("Pdv Iznos");
        header.createCell(11).setCellValue("Pdv stopa");
        header.createCell(12).setCellValue("JM");
        header.createCell(13).setCellValue("Datum");
        sheet.setColumnWidth(0, 3600);
        sheet.setColumnWidth(1, 3600);
        sheet.setColumnWidth(2, 16900);
        sheet.setColumnWidth(3, 2800);
        sheet.setColumnWidth(4, 1600);
        sheet.setColumnWidth(5, 3600);
        sheet.setColumnWidth(6, 1000);
        sheet.setColumnWidth(7, 1900);
        sheet.setColumnWidth(8, 1900);
        sheet.setColumnWidth(9, 3600);
        sheet.setColumnWidth(10, 3600);
        sheet.setColumnWidth(11, 1900);
        sheet.setColumnWidth(12, 1900);
        sheet.setColumnWidth(13, 3750);
        DecimalFormat df = new DecimalFormat("0.00");
        df.setRoundingMode(RoundingMode.UP);
        int index = 1;
        for (Product product : this.list) {
            XSSFRow row = sheet.createRow(index);
            row.createCell(0).setCellValue(product.getCode());
            row.createCell(1).setCellValue(product.getBarcode());
            row.createCell(2).setCellValue(product.getName());
            row.createCell(3).setCellValue(product.getGroupName());
            row.createCell(4).setCellValue(product.getSize());
            row.createCell(5).setCellValue(product.getColor());
            row.createCell(6).setCellValue(df.format(product.getStock()));
            row.createCell(7).setCellValue(df.format(product.getPrice()));
            row.createCell(8).setCellValue(df.format(product.getNabavnaCena()));
            row.createCell(9).setCellValue(df.format(product.getNetAmount()));
            row.createCell(10).setCellValue(df.format(product.getValuePdv()));
            row.createCell(11).setCellValue(product.getVatName());
            row.createCell(12).setCellValue(product.getUnitName());
            System.out.println("Setovanje datuma " + product.getSysDTCreated());
            String datum = String.valueOf(product.getSysDTCreated());
            row.createCell(13).setCellValue(datum);
            ++index;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(directory + File.separator + ime + ".xlsx");
            wb.write((OutputStream)fileOutputStream);
            wb.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

