/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.print;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;

public class DynamicColumnDataSource
extends JRAbstractBeanDataSource {
    private List<String> columnHeaders;
    private List<List<String>> rows;
    private Iterator<List<String>> iterator;
    private List<String> currentRow;

    public DynamicColumnDataSource(List<String> columnHeaders, List<List<String>> rows) {
        super(true);
        this.rows = rows;
        this.columnHeaders = columnHeaders;
        if (this.rows != null && this.rows != null) {
            this.iterator = this.rows.iterator();
        }
    }

    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRow = this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        if (fieldName.startsWith("col")) {
            String indexValue = fieldName.substring("col".length());
            String column = this.currentRow.get(Integer.parseInt(indexValue));
            return column;
        }
        if (fieldName.startsWith("header")) {
            int indexValue = Integer.parseInt(fieldName.substring("header".length()));
            String columnHeader = this.columnHeaders.get(indexValue);
            return columnHeader;
        }
        throw new RuntimeException("The field name '" + fieldName + "' in the Jasper Report is not valid");
    }

    public void moveFirst() {
        if (this.rows != null) {
            this.iterator = this.rows.iterator();
        }
    }
}

