/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.utility;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import rs.petcom.master.dal.Settings;

public final class PurchasePrice {
    public static double lastPurchasePriceForTheDate(Connection connection, LocalDate dateTo, long productId) {
        double purchasePrice = 0.0;
        Date to = Settings.sqlDateFromLocalDate(dateTo);
        String query = "SELECT dd.PriceWithDiscount AS PurchasePrice FROM documentdetails dd  JOIN document d ON dd.DocumentID = d.DocumentID WHERE d.DocumentTypeID = 1 AND CAST(d.Date AS DATE) <= ? AND dd.ProductID = ? ORDER BY dd.DocumentID DESC LIMIT 1  ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, to);
            ps.setLong(2, productId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                purchasePrice = rs.getDouble("PurchasePrice");
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return purchasePrice;
    }

    public static double averagePurchesPriceForPeriod(Connection connection, LocalDate dateFrom, LocalDate dateTo, long productId) {
        double purchasePrice = 0.0;
        Date from = Settings.sqlDateFromLocalDate(dateFrom);
        Date to = Settings.sqlDateFromLocalDate(dateTo);
        String query = "SELECT ROUND(COALESCE(AVG(dd.PriceWithDiscount),0),2)  AS PurchasePrice FROM documentdetails dd JOIN document d ON dd.DocumentID = d.DocumentID WHERE d.DocumentTypeID = 1 AND CAST(d.Date AS DATE) BETWEEN ? AND ? AND dd.ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, from);
            ps.setDate(2, to);
            ps.setLong(3, productId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                purchasePrice = rs.getDouble("PurchasePrice");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (purchasePrice == 0.0) {
            purchasePrice = PurchasePrice.lastPurchasePriceForTheDate(connection, dateFrom, productId);
        }
        return purchasePrice;
    }
}

