/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.queries;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import rs.petcom.master.queries.QueryName;

public class Queries {
    public static final Map<QueryName, String> QUERIES = new EnumMap<QueryName, String>(QueryName.class){

        @Override
        public String get(Object key) {
            QueryName mapKey = (QueryName)((Object)key);
            if (!this.containsKey((Object)mapKey)) {
                this.put(mapKey, "/query/".concat(mapKey.getPath()));
            }
            return (String)super.get(key);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(Queries.class.getName());
    private static final Charset defaultCharset = Charset.forName("UTF8");
    private static char[] buffer = new char[4096];
    private static int count;

    private static String readResource(String fileName) {
        String out;
        try (InputStream stream = Queries.class.getResourceAsStream(fileName);
             InputStreamReader isr = new InputStreamReader(stream, defaultCharset);){
            out = "";
            while ((count = isr.read(buffer)) != -1) {
                out = out.concat(new String(buffer, 0, count));
            }
        }
        catch (Exception ioe) {
            LOGGER.log(Level.WARNING, MessageFormat.format("Error reading query resource!\n{0}", ioe.getMessage()), ioe);
            out = null;
        }
        return out;
    }
}

