/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.tax;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.stage.Window;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.newFiscalization.tax.AllTaxRates;
import rs.petcom.master.newFiscalization.tax.TaxCategories;
import rs.petcom.master.newFiscalization.tax.TaxRate;
import rs.petcom.master.newFiscalization.tax.TaxRateRequest;
import rs.petcom.master.newFiscalization.tax.TaxRateResponse;
import rs.petcom.master.utility.TaxRateValuesUtility;

public class TaxRateSynchronization {
    ScreensController controller;
    Connection connection;
    List<TaxRate> rates;
    ObservableList<Vat> vatList;
    User user;

    public TaxRateSynchronization(ScreensController controller, User logUser) {
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
        this.rates = this.getTaxRates();
        this.vatList = Vat.getAllRates(this.connection);
        this.user = logUser == null || logUser.getUserID() == 0L ? User.getUserByID(1L, this.connection) : logUser;
    }

    public void synchronizeRates(Window owner) {
        if (!this.isSameNumberOfRates()) {
            this.deleteInsertRates(owner);
            return;
        }
        for (TaxRate rate : this.rates) {
            if (this.rateExsistsInDb(rate)) continue;
            this.deleteInsertRates(owner);
            return;
        }
        Log.writeLog(this.user, "Proverene poreske stope sa LPFR - sve u redu", this.connection);
    }

    private void deleteInsertRates(Window owner) {
        String label = "";
        double rate = 0.0;
        double rate1 = 0.0;
        Vat.deleteAllFromVat(this.connection);
        System.out.println("Brisem sve stope");
        Vat vat1 = new Vat();
        vat1.setActive(true);
        vat1.setVatID(11);
        vat1.setCode("GRUPA_P");
        vat1.setName("8%");
        vat1.setValue(1.08);
        vat1.setValue2(0.92);
        vat1.setValue3(0.07407407);
        for (TaxRate tRate : this.rates) {
            label = tRate.getLabel();
            rate = tRate.getRate();
            Vat vat = new Vat();
            vat.setActive(true);
            int value = (int)rate;
            vat.setName(value + "%");
            vat.setCode(label);
            vat.setActive(true);
            vat.setValue(TaxRateValuesUtility.getVatValue(rate));
            vat.setValue2(TaxRateValuesUtility.getVatValue2(rate));
            vat.setValue3(TaxRateValuesUtility.getVatValue3(rate));
            vat.insertVat(this.connection);
        }
        vat1.insertVat1(this.connection);
        this.controller.alert("Obave\u0161tenje", "Do\u0161lo je do sinhronizacije poreskih stopa sa LPFR.Proverite poreske stope va\u0161ih artikala.", owner);
        System.out.println("Insertujem stope iz LPFR");
        Log.writeLog(this.user, "Do\u0161lo je do sinhronizacije poreskih stopa sa LPFR", this.connection);
    }

    private List<TaxRate> getTaxRates() {
        TaxCategories[] taxCategories;
        ArrayList<TaxRate> taxRates = new ArrayList<TaxRate>();
        TaxRateRequest request = new TaxRateRequest(this.controller);
        TaxRateResponse response = request.getTaxRates();
        AllTaxRates allTaxRates = response.getCurrentTaxRates();
        for (TaxCategories category : taxCategories = allTaxRates.getTaxCategories()) {
            TaxRate[] rates;
            for (TaxRate rate : rates = category.getTaxRates()) {
                taxRates.add(rate);
            }
        }
        return taxRates;
    }

    private boolean isSameNumberOfRates() {
        return this.rates.size() == this.vatList.size();
    }

    private boolean rateExsistsInDb(TaxRate rate) {
        for (Vat vat : this.vatList) {
            if (!vat.getCode().equals(rate.getLabel())) continue;
            return true;
        }
        return false;
    }
}

