/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.print;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Item;
import rs.petcom.master.newFiscalization.invoice.Payment;
import rs.petcom.master.newFiscalization.tax.TaxRate;
import rs.petcom.master.utility.NPrintUtil;

public class A4PrintUtils {
    public static String a4PrintHeader(InvoiceResponse response) {
        String district = NPrintUtil.transliterate(response.getDistrict());
        StringBuilder header = new StringBuilder();
        header.append(response.getTin());
        header.append("\r\n");
        header.append(response.getBusinessName());
        header.append("\r\n");
        header.append(response.getLocationName());
        header.append("\r\n");
        header.append(response.getAddress());
        header.append("\r\n");
        header.append(district);
        header.append("\r\n");
        return header.toString();
    }

    public static String a4PrintHeaderAditional(InvoiceResponse response, InvoiceBody body, InvoiceType invoiceType) {
        String buyerCostCenterId;
        String buyerId;
        StringBuilder aditional = new StringBuilder();
        String cashier = body.getCashier();
        if (cashier != null && !cashier.isEmpty()) {
            aditional.append(" Kasir: ");
            aditional.append(cashier);
            aditional.append("\r\n");
        }
        if ((buyerId = body.getBuyerId()) != null && !buyerId.isEmpty()) {
            aditional.append(" ID kupca: ");
            aditional.append(buyerId);
            aditional.append("\r\n");
        }
        if ((buyerCostCenterId = body.getBuyerCostCenterId()) != null && !buyerCostCenterId.isEmpty()) {
            aditional.append(" Opciono polje kupca: ");
            aditional.append(buyerCostCenterId);
            aditional.append("\r\n");
        }
        aditional.append(" Esir Broj: ");
        aditional.append(body.getInvoiceNumber());
        aditional.append("\r\n");
        if (invoiceType == InvoiceType.SALE_COPY || invoiceType == InvoiceType.REFUND_COPY || invoiceType == InvoiceType.REFUND_NORMAL || invoiceType == InvoiceType.REFUND_PROFORMA) {
            String referentDocumentDT = NPrintUtil.textDatefromISO8601(body.getReferentDocumentDT());
            aditional.append(" RefBroj: ");
            aditional.append(body.getReferentDocumentNumber());
            aditional.append("\r\n");
            aditional.append(" Ref vreme: ");
            aditional.append(referentDocumentDT);
            aditional.append("\r\n");
        }
        aditional.append(" Pfr vreme: ");
        aditional.append(NPrintUtil.textDatefromISO8601(response.getSdcDateTime()));
        aditional.append("\r\n");
        aditional.append(" Brojac racuna: ");
        aditional.append(response.getInvoiceCounter());
        return aditional.toString();
    }

    public static ObservableList<Item> getItemsList(InvoiceBody body) {
        Item[] items;
        ObservableList itemsList = FXCollections.observableArrayList();
        for (Item item : items = body.getItems()) {
            itemsList.add((Object)item);
        }
        return itemsList;
    }

    public static ObservableList<TaxRate> getRatesList(InvoiceResponse response) {
        TaxRate[] rates;
        ObservableList ratesList = FXCollections.observableArrayList();
        for (TaxRate rate : rates = response.getTaxItems()) {
            ratesList.add((Object)rate);
        }
        return ratesList;
    }

    public static ObservableList<Payment> getPaymentsList(InvoiceBody body) {
        Payment[] payments;
        ObservableList paymentsList = FXCollections.observableArrayList();
        for (Payment payment : payments = body.getPayment()) {
            paymentsList.add((Object)payment);
        }
        return paymentsList;
    }
}

