/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.invoice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Round;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Item;
import rs.petcom.master.newFiscalization.invoice.Payment;

public class InvoiceRequest {
    private final String address;
    private ObjectMapper mapper;
    private Bill bill;
    private Connection connection;
    private InvoiceBody body;
    private Map<String, Double> payments;
    private Double amountSum;
    private String avanstin;
    double ukupanIznos;
    private String refNumber;
    private String vprfPath;
    private String JID;
    private String PAK;
    private String primaryAdress;
    private String passwordVprf;
    private ScreensController controller;

    public InvoiceRequest(Bill bill, Map<String, Double> payments, ScreensController controller) {
        this.controller = controller;
        this.ukupanIznos = 0.0;
        this.bill = bill;
        this.connection = controller.getSettings().getConnection();
        this.payments = payments;
        this.address = controller.getSettings().getLpfrPath() + "/api/v3/invoices";
        this.vprfPath = controller.getSettings().getVprfPath() + "/api/v3/invoices";
        this.PAK = controller.getSettings().getPAK();
        this.JID = controller.getSettings().getJID();
        this.primaryAdress = controller.getSettings().getPrimaryAdressVprf();
        this.passwordVprf = controller.getSettings().getPasswordVprf();
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.body = new InvoiceBody();
    }

    public Double getAmountSum() {
        return this.amountSum;
    }

    public void setAmountSum(Double amountSum) {
        this.amountSum = amountSum;
    }

    public InvoiceBody getBody() {
        return this.body;
    }

    public InvoiceResponse getInvoiceResponse(InvoiceType invoiceType) {
        InvoiceResponse response = null;
        try {
            response = (InvoiceResponse)this.mapper.readValue(this.getResponseLine(invoiceType), InvoiceResponse.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(response);
        return response;
    }

    private String getInputString(InvoiceType invoiceType) throws JsonProcessingException {
        Person person = this.bill.getPerson();
        Boolean tip = false;
        if (person != null) {
            tip = Person.getTip(person.getPersonVatTypeID(), this.controller);
        }
        if (person != null && (person.getTfJBKJ() == null || person.getTfJBKJ().isEmpty()) && !tip.booleanValue()) {
            this.body.setBuyerId("10:" + person.getPIB());
        } else if (person != null && person.getTfJBKJ() != null) {
            this.body.setBuyerId("12:" + person.getPIB() + ":" + person.getTfJBKJ());
        } else if (person != null && (person.getTfJBKJ() == null || person.getTfJBKJ().isEmpty()) && tip.booleanValue()) {
            this.body.setBuyerId("11:" + person.getMB());
        }
        this.body.setInvoiceType(invoiceType.getType());
        if ("refundacija".equals(this.avanstin)) {
            this.body.setTransactionType("Refund");
        } else {
            this.body.setTransactionType("Sale");
        }
        this.body.setCashier(this.bill.getUser().getUserName());
        if ("refundacija".equals(this.avanstin)) {
            this.body.setReferentDocumentNumber(this.refNumber);
            this.body.setReferentDocumentDT(Document.findByRefTime(this.controller.getSettings().getRefNumberTemp(), this.controller));
        } else if ("konacniracun".equals(this.avanstin)) {
            this.body.setReferentDocumentNumber(this.refNumber);
            this.body.setReferentDocumentDT(Document.findByRefTime(this.controller.getSettings().getRefNumberTemp(), this.controller));
        } else {
            this.body.setReferentDocumentNumber("");
        }
        this.body.setInvoiceNumber("1129/2.1");
        LocalDateTime localDateTime = LocalDateTime.now();
        if ("avanstin".equals(this.avanstin) && (this.refNumber == null || this.refNumber.isEmpty())) {
            this.body.setDateAndTimeOfIssue(LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond()));
        } else if ("avanstin".equals(this.avanstin) && (this.refNumber != null || !this.refNumber.isEmpty())) {
            this.body.setReferentDocumentNumber(this.refNumber);
            this.body.setReferentDocumentDT(Document.findByRefTime(this.controller.getSettings().getRefNumberTemp(), this.controller));
        }
        ArrayList<RoundItem> items = new ArrayList<RoundItem>();
        for (Round round : this.bill.getRoundList()) {
            for (RoundItem rItem : round.getItemList()) {
                items.add(rItem);
            }
        }
        HashMap<String, Item> hmAvans = new HashMap<String, Item>();
        Item[] lpfrItems = new Item[items.size()];
        HashMap<String, Item> hm = new HashMap<String, Item>();
        for (int i = 0; i < items.size(); ++i) {
            Item item1;
            RoundItem rItem = (RoundItem)items.get(i);
            Product product = rItem.getProductDepartment().getProduct();
            Vat vat = Vat.getById(product.getVatID(), this.connection);
            double priceWithDiscount = Settings.round(rItem.getRegularPrice() - rItem.getRegularPrice() * product.getDiscount() / 100.0, 2);
            double quantity = rItem.getQuantity();
            Item item = new Item();
            item.setLabels(new String[]{vat.getCode()});
            item.setName(product.getName());
            item.setQuantity(quantity);
            item.setUnitPrice(priceWithDiscount);
            item.setTotalAmount(Settings.round(quantity * priceWithDiscount, 2));
            if (hm.containsKey("Avans(" + vat.getCode() + ")")) {
                item1 = new Item();
                item1.setQuantity(((Item)hm.get("Avans(" + vat.getCode() + ")")).getQuantity() + item.quantity);
                item1.setTotalAmount(((Item)hm.get("Avans(" + vat.getCode() + ")")).getTotalAmount() + item.totalAmount);
                hm.put("Avans(" + vat.getCode() + ")", item1);
            } else {
                item1 = new Item();
                item1.setQuantity(item.quantity);
                item1.setTotalAmount(item.totalAmount);
                hm.put("Avans(" + vat.getCode() + ")", item1);
            }
            this.ukupanIznos += item.getTotalAmount();
            if (this.avanstin != null && this.amountSum != null && !"konacniracun".equals(this.avanstin)) {
                item.setName("Avans(" + vat.getCode() + ")");
                if (hmAvans.containsKey(item.getName())) {
                    item.setQuantity(1.0);
                    item.setUnitPrice(this.amountSum);
                    item.setTotalAmount(this.amountSum);
                    hmAvans.put(item.getName(), item);
                    continue;
                }
                item.setQuantity(1.0);
                item.setUnitPrice(this.amountSum);
                item.setTotalAmount(this.amountSum);
                hmAvans.put(item.getName(), item);
                continue;
            }
            lpfrItems[i] = item;
        }
        System.out.println("Ukupan iznos poreska  " + this.ukupanIznos);
        if (!hmAvans.isEmpty()) {
            lpfrItems = new Item[hmAvans.size()];
            HashMap proporcija = new HashMap();
            for (Map.Entry entry : hmAvans.entrySet()) {
                System.out.println("Ukupan iznos " + this.ukupanIznos + " total amount " + ((Item)hm.get(entry.getKey())).totalAmount);
                proporcija.put(entry.getKey(), Settings.round(this.ukupanIznos / ((Item)hm.get(entry.getKey())).totalAmount, 6));
            }
            int i = 0;
            for (Map.Entry entry : hmAvans.entrySet()) {
                ((Item)entry.getValue()).setTotalAmount(Settings.round(((Item)entry.getValue()).getTotalAmount() / (Double)proporcija.get(entry.getKey()), 2));
                ((Item)entry.getValue()).setUnitPrice(Settings.round(((Item)entry.getValue()).getTotalAmount(), 2));
                lpfrItems[i] = (Item)entry.getValue();
                ++i;
            }
        }
        Payment[] lpfrPayment = new Payment[this.payments.size()];
        int index = 0;
        for (Map.Entry<String, Double> entry : this.payments.entrySet()) {
            Payment p = new Payment();
            p.setPaymentType(entry.getKey());
            p.setAmount(entry.getValue());
            if (this.avanstin != null && this.amountSum != null && !"konacniracun".equals(this.avanstin)) {
                p.setAmount(this.amountSum);
            } else if (this.avanstin != null && this.amountSum != null && "konacniracun".equals(this.avanstin)) {
                p.setAmount(this.amountSum);
            }
            lpfrPayment[index] = p;
            ++index;
        }
        this.body.setItems(lpfrItems);
        this.body.setPayment(lpfrPayment);
        return this.mapper.writeValueAsString((Object)this.body);
    }

    private String getResponseLine(InvoiceType invoiceType) throws IOException {
        HttpURLConnection urlConnection;
        String responseLine = "";
        StringBuilder sb = new StringBuilder();
        if ("true".equals(this.primaryAdress)) {
            urlConnection = this.getUrlHttpsConnection();
            if (urlConnection == null) {
                urlConnection = this.getUrlConnection();
            }
        } else {
            urlConnection = this.getUrlConnection();
        }
        String input = this.getInputString(invoiceType);
        System.out.println(input + ", url connection " + urlConnection.toString());
        OutputStream os = urlConnection.getOutputStream();
        os.write(input.getBytes("UTF-8"));
        os.flush();
        int code = urlConnection.getResponseCode();
        if (code == 200) {
            InputStream is = urlConnection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        } else {
            InputStream is = urlConnection.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    private HttpURLConnection getUrlHttpsConnection() throws IOException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(new FileInputStream(this.controller.getSettings().getPutanjaSertifikat() + ".p12"), this.passwordVprf.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, this.passwordVprf.toCharArray());
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), null, null);
            SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
            URL url = new URL(this.vprfPath);
            System.out.println("Vprf adresa " + this.vprfPath);
            HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("JID", this.JID);
            urlConnection.setRequestProperty("PAC", this.PAK);
            urlConnection.setRequestProperty("Host", "");
            urlConnection.setDoOutput(true);
            urlConnection.setSSLSocketFactory(sslSocketFactory);
            return urlConnection;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HttpURLConnection getUrlConnection() throws IOException {
        Object keyStore = null;
        try {
            URL url = new URL(this.address);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("Host", "");
            urlConnection.setDoOutput(true);
            return urlConnection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setAvans(String avanstin) {
        this.avanstin = avanstin;
    }

    public void setLprfBroj(String refNumber) {
        this.refNumber = refNumber;
    }
}

