/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.badrequest;

import java.util.HashMap;
import javafx.stage.Window;
import rs.petcom.master.ScreensController;
import rs.petcom.master.newFiscalization.badrequest.ModelState;

public class BadRequestHandler {
    ScreensController controller;
    ModelState[] modelStates;
    Window owner;

    public BadRequestHandler(ScreensController controller, ModelState[] modelStates, Window owner) {
        this.controller = controller;
        this.modelStates = modelStates;
        this.owner = owner;
    }

    public void handleBadRequest() {
        String[] errors;
        for (String error : errors = this.getAllErrors()) {
            if (error.contains("2310")) {
                this.controller.alert("Greska", "Poslata pogre\u0161na poreska stopa. Pozovite tehni\u010dku podr\u0161ku", this.owner);
            }
            if (error.contains("1300")) {
                this.controller.alert("Obavestenje", "Kartica se ne nalazi u \u010dita\u010du. Proverite Va\u0161u karticu ili se obratite tehni\u010dkoj podr\u0161ci.", this.owner);
            }
            if (error.contains("1500")) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("controller", this.controller);
                hm.put("headLine", "Unesite va\u0161 LPFR pin");
                this.controller.showModalDialog("Unos PIN-a", ScreensController.SCREEN_BACKOFFICE_PIN_INSERT, hm, this.owner);
            }
            if (!error.contains("1400")) continue;
            this.controller.alert("Obavestenje", "Audit requred. Obratite se tehni\u010dkoj podr\u0161ci", this.owner);
        }
    }

    private String[] getAllErrors() {
        return this.getErrorsInString().split(",");
    }

    private String getErrorsInString() {
        String result = "";
        StringBuilder sb = new StringBuilder();
        for (ModelState ms : this.modelStates) {
            for (String error : this.getErrors(ms)) {
                sb.append(error);
                sb.append(",");
            }
        }
        result = sb.toString();
        return result.substring(0, result.length() - 1);
    }

    private String[] getErrors(ModelState modelState) {
        return modelState.getErrors();
    }
}

