/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.licence;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import rs.petcom.master.licence.exception.LicenseNotValid;
import rs.petcom.master.licence.exception.MacAddressReadException;

public class LicLogic {
    public static Date getLicenseExpiration(String in) throws LicenseNotValid, MacAddressReadException {
        int i;
        int i2;
        Date exp = new Date(0L);
        if (in.length() != 16) {
            return null;
        }
        int[] posKey = new int[]{6, 4, 12, 0, 5, 14, 3, 13, 10, 2, 15, 8, 1, 11, 7, 9};
        char[] ina = new char[in.length()];
        char[] inb = in.toCharArray();
        for (int i3 = 0; i3 < in.length(); ++i3) {
            ina[posKey[i3]] = inb[i3];
        }
        in = new String(ina);
        List<Character> codeTable = Arrays.asList(Character.valueOf('1'), Character.valueOf('6'), Character.valueOf('H'), Character.valueOf('P'), Character.valueOf('9'), Character.valueOf('Z'), Character.valueOf('X'), Character.valueOf('D'), Character.valueOf('7'), Character.valueOf('0'), Character.valueOf('8'), Character.valueOf('B'), Character.valueOf('F'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('2'), Character.valueOf('T'), Character.valueOf('J'), Character.valueOf('Y'), Character.valueOf('N'), Character.valueOf('S'), Character.valueOf('W'), Character.valueOf('K'), Character.valueOf('R'), Character.valueOf('U'), Character.valueOf('E'), Character.valueOf('V'), Character.valueOf('4'), Character.valueOf('G'), Character.valueOf('3'), Character.valueOf('C'), Character.valueOf('A'));
        byte[] out = new byte[5];
        long sum = 0L;
        for (i2 = 0; i2 < 8; ++i2) {
            int num = -1;
            char c = in.charAt(i2);
            num = codeTable.indexOf(Character.valueOf(c));
            if (num == -1) {
                return null;
            }
            sum += (long)num;
            if (i2 >= 7) continue;
            sum <<= 5;
        }
        for (i2 = 0; i2 < 5; ++i2) {
            byte b;
            out[Math.abs((int)(i2 - 4))] = b = (byte)(sum & 0xFFL);
            sum >>= 8;
        }
        byte[] bOut = new byte[10];
        bOut[0] = out[0];
        bOut[1] = out[1];
        bOut[2] = out[2];
        bOut[3] = out[3];
        bOut[4] = out[4];
        out = new byte[5];
        sum = 0L;
        for (i = 8; i < 16; ++i) {
            int num = -1;
            char c = in.charAt(i);
            num = codeTable.indexOf(Character.valueOf(c));
            if (num == -1) {
                return null;
            }
            sum += (long)num;
            if (i >= 15) continue;
            sum <<= 5;
        }
        for (i = 0; i < 5; ++i) {
            byte b;
            out[Math.abs((int)(i - 4))] = b = (byte)(sum & 0xFFL);
            sum >>= 8;
        }
        bOut[5] = out[0];
        bOut[6] = out[1];
        bOut[7] = out[2];
        bOut[8] = out[3];
        bOut[9] = out[4];
        byte[] date = new byte[5];
        byte[] macControl = new byte[4];
        date[0] = bOut[1];
        date[1] = bOut[2];
        date[2] = bOut[3];
        date[3] = bOut[4];
        date[4] = bOut[5];
        macControl[0] = bOut[6];
        macControl[1] = bOut[7];
        macControl[2] = bOut[8];
        macControl[3] = bOut[9];
        byte[] mac = LicLogic.getMacAddress();
        if (mac == null) {
            throw new MacAddressReadException();
        }
        byte[] macControlCheck = new byte[]{1, 2, 3, 4};
        if (mac != null) {
            macControlCheck[0] = mac[2];
            macControlCheck[1] = mac[3];
            macControlCheck[2] = mac[4];
            macControlCheck[3] = mac[5];
        }
        for (int i4 = 0; i4 < macControlCheck.length; ++i4) {
            byte b = macControlCheck[i4];
            byte b2 = macControl[i4];
            if (b == b2) continue;
            throw new LicenseNotValid("");
        }
        long check = 0L;
        for (int i5 = 0; i5 < date.length; ++i5) {
            byte b = date[i5];
            check += (long)(b & 0xFF);
            if (i5 >= date.length - 1) continue;
            check <<= 8;
        }
        long reference = 1280586190587L;
        long validTo = check + reference;
        exp.setTime(validTo);
        return exp;
    }

    public static int getLicenseType(String in) throws LicenseNotValid, MacAddressReadException {
        int i;
        int i2;
        int type = -1;
        if (in.length() != 16) {
            throw new LicenseNotValid("");
        }
        int[] posKey = new int[]{6, 4, 12, 0, 5, 14, 3, 13, 10, 2, 15, 8, 1, 11, 7, 9};
        char[] ina = new char[in.length()];
        char[] inb = in.toCharArray();
        for (int i3 = 0; i3 < in.length(); ++i3) {
            ina[posKey[i3]] = inb[i3];
        }
        in = new String(ina);
        List<Character> codeTable = Arrays.asList(Character.valueOf('1'), Character.valueOf('6'), Character.valueOf('H'), Character.valueOf('P'), Character.valueOf('9'), Character.valueOf('Z'), Character.valueOf('X'), Character.valueOf('D'), Character.valueOf('7'), Character.valueOf('0'), Character.valueOf('8'), Character.valueOf('B'), Character.valueOf('F'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('2'), Character.valueOf('T'), Character.valueOf('J'), Character.valueOf('Y'), Character.valueOf('N'), Character.valueOf('S'), Character.valueOf('W'), Character.valueOf('K'), Character.valueOf('R'), Character.valueOf('U'), Character.valueOf('E'), Character.valueOf('V'), Character.valueOf('4'), Character.valueOf('G'), Character.valueOf('3'), Character.valueOf('C'), Character.valueOf('A'));
        byte[] out = new byte[5];
        long sum = 0L;
        for (i2 = 0; i2 < 8; ++i2) {
            int num = -1;
            char c = in.charAt(i2);
            num = codeTable.indexOf(Character.valueOf(c));
            if (num == -1) {
                throw new LicenseNotValid("");
            }
            sum += (long)num;
            if (i2 >= 7) continue;
            sum <<= 5;
        }
        for (i2 = 0; i2 < 5; ++i2) {
            byte b;
            out[Math.abs((int)(i2 - 4))] = b = (byte)(sum & 0xFFL);
            sum >>= 8;
        }
        byte[] bOut = new byte[10];
        bOut[0] = out[0];
        bOut[1] = out[1];
        bOut[2] = out[2];
        bOut[3] = out[3];
        bOut[4] = out[4];
        out = new byte[5];
        sum = 0L;
        for (i = 8; i < 16; ++i) {
            int num = -1;
            char c = in.charAt(i);
            num = codeTable.indexOf(Character.valueOf(c));
            if (num == -1) {
                throw new LicenseNotValid("");
            }
            sum += (long)num;
            if (i >= 15) continue;
            sum <<= 5;
        }
        for (i = 0; i < 5; ++i) {
            byte b;
            out[Math.abs((int)(i - 4))] = b = (byte)(sum & 0xFFL);
            sum >>= 8;
        }
        bOut[5] = out[0];
        bOut[6] = out[1];
        bOut[7] = out[2];
        bOut[8] = out[3];
        bOut[9] = out[4];
        byte[] date = new byte[5];
        byte[] macControl = new byte[4];
        byte ctrl = bOut[0];
        date[0] = bOut[1];
        date[1] = bOut[2];
        date[2] = bOut[3];
        date[3] = bOut[4];
        date[4] = bOut[5];
        macControl[0] = bOut[6];
        macControl[1] = bOut[7];
        macControl[2] = bOut[8];
        macControl[3] = bOut[9];
        byte[] mac = LicLogic.getMacAddress();
        if (mac == null) {
            throw new MacAddressReadException();
        }
        byte[] macControlCheck = new byte[]{1, 2, 3, 4};
        if (mac != null) {
            macControlCheck[0] = mac[2];
            macControlCheck[1] = mac[3];
            macControlCheck[2] = mac[4];
            macControlCheck[3] = mac[5];
        }
        for (int i4 = 0; i4 < macControlCheck.length; ++i4) {
            byte b = macControlCheck[i4];
            byte b2 = macControl[i4];
            if (b == b2) continue;
            throw new LicenseNotValid("");
        }
        long check = 0L;
        for (int i5 = 0; i5 < date.length; ++i5) {
            byte b = date[i5];
            check += (long)(b & 0xFF);
            if (i5 >= date.length - 1) continue;
            check <<= 8;
        }
        type = ctrl & 0xFF;
        return type;
    }

    private static byte[] getMacAddress() {
        byte[] mac = null;
        try {
            NetworkInterface nic = null;
            File bmnis = new File(System.getProperty("user.dir") + "/config", "bmnis.conf");
            if (bmnis.exists()) {
                try {
                    FileReader fr = new FileReader(bmnis);
                    BufferedReader bfr = new BufferedReader(fr);
                    String nicName = bfr.readLine();
                    nic = NetworkInterface.getByName(nicName);
                    if (nic != null) {
                        mac = nic.getHardwareAddress();
                    }
                    bfr.close();
                    fr.close();
                }
                catch (Exception fr) {
                    // empty catch block
                }
            }
            InetAddress locIp = Inet4Address.getLocalHost();
            if (mac == null || mac.length != 6) {
                nic = NetworkInterface.getByInetAddress(locIp);
                mac = nic.getHardwareAddress();
                if (mac == null || mac.length != 6) {
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        NetworkInterface ni = en.nextElement();
                        if (ni.getHardwareAddress() == null || ni.getHardwareAddress().length != 6) continue;
                        mac = ni.getHardwareAddress();
                        nic = ni;
                        break;
                    }
                }
                try {
                    bmnis.delete();
                    bmnis.getParentFile().mkdirs();
                    bmnis.createNewFile();
                    FileWriter fw = new FileWriter(bmnis);
                    BufferedWriter bfw = new BufferedWriter(fw);
                    bfw.write(nic.getName());
                    bfw.flush();
                    bfw.close();
                    fw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(LicLogic.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (mac == null || mac.length != 6) {
                mac = new byte[]{0, 0, 1, 2, 3, 4};
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return mac;
    }

    public static String getControlCode(String in, byte cc) throws MacAddressReadException {
        int i;
        int a;
        int i2;
        String out = "";
        byte[] mac = null;
        byte[] macControl = new byte[]{1, 2, 3, 4};
        mac = LicLogic.getMacAddress();
        if (mac == null) {
            throw new MacAddressReadException();
        }
        macControl[0] = mac[2];
        macControl[1] = mac[3];
        macControl[2] = mac[4];
        macControl[3] = mac[5];
        long l = 0L;
        try {
            l = Long.parseLong(in.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        long mask = 0L;
        int count = 5;
        for (int i3 = 0; i3 < count; ++i3) {
            mask += 255L << i3 * 8;
        }
        if ((l %= mask + 1L) == 0L) {
            return "ERROR";
        }
        Long.bitCount(l);
        byte[] vat = new byte[count];
        for (i2 = 0; i2 < count; ++i2) {
            vat[i2] = 0;
        }
        for (i2 = 0; i2 < count; ++i2) {
            vat[Math.abs((int)(i2 - (count - 1)))] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        byte[] sum = new byte[]{cc, macControl[0], macControl[1], macControl[2], macControl[3], vat[0], vat[1], vat[2], vat[3], vat[4]};
        char[] codeTable = new char[]{'L', '9', 'U', '3', 'F', '4', 'J', 'N', 'P', 'B', 'Y', '2', 'H', 'D', 'K', 'M', 'S', 'C', '7', 'T', 'X', 'Z', 'V', '8', 'R', 'G', '1', '6', 'E', '0', 'A', 'W'};
        long sumL = 0L;
        int[] iis = new int[5];
        for (int i4 = 0; i4 < 5; ++i4) {
            byte b = sum[i4];
            iis[i4] = b & 0xFF;
            sumL += (long)(b & 0xFF);
            sumL <<= i4 < 4 ? 8 : 0;
        }
        long ttSum = sumL;
        int[] pp = new int[8];
        for (int i5 = 0; i5 < 8; ++i5) {
            a = (int)(ttSum % 32L);
            ttSum >>= 5;
            pp[Math.abs((int)(i5 - 7))] = a;
        }
        for (int i6 : pp) {
            out = out + codeTable[i6];
        }
        sumL = 0L;
        for (i = 5; i < 10; ++i) {
            byte b = sum[i];
            sumL += (long)(b & 0xFF);
            sumL <<= i < 9 ? 8 : 0;
        }
        ttSum = sumL;
        pp = new int[8];
        for (i = 0; i < 8; ++i) {
            a = (int)(ttSum % 32L);
            ttSum >>= 5;
            pp[Math.abs((int)(i - 7))] = a;
        }
        for (int i6 : pp) {
            out = out + codeTable[i6];
        }
        int[] posKey = new int[]{14, 11, 9, 1, 6, 8, 13, 0, 3, 7, 12, 10, 2, 15, 4, 5};
        char[] outa = new char[out.length()];
        char[] outb = out.toCharArray();
        for (int i6 = 0; i6 < out.length(); ++i6) {
            outa[posKey[i6]] = outb[i6];
        }
        out = new String(outa);
        return out;
    }
}

