/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.invoice.dto;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import rs.petcom.master.ScreensController;
import rs.petcom.master.invoice.dto.InvoiceDto;
import rs.petcom.master.invoice.dto.ResponseEInvoice;

public class InvoiceApi {
    private static final Logger LOGGER = Logger.getLogger("global");

    public String response(ScreensController controller, InvoiceDto invoice) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return this.getInvoiceResponse(controller, mapper, invoice);
    }

    public String getInvoiceResponse(ScreensController controller, ObjectMapper mapper, InvoiceDto invoice) {
        try {
            String responseCall = this.getResponseLine(mapper, controller, invoice);
            if (responseCall.contains("Upozorenje") || responseCall.contains("Greska") || responseCall.isEmpty()) {
                System.out.println("response call" + responseCall);
                return responseCall;
            }
            ResponseEInvoice response = (ResponseEInvoice)mapper.readValue(responseCall, ResponseEInvoice.class);
            controller.getBillList().get(0).setInvoiceId(response.getInvoiceId());
            controller.getBillList().get(0).setSalesInvoiceId(response.getSalesInvoiceId());
            controller.getBillList().get(0).setPurchaseInvoiceId(response.getPurchaseInvoiceId());
            return "OK";
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Response je " + null);
        return "";
    }

    private String getResponseLine(ObjectMapper mapper, ScreensController controller, InvoiceDto invoiceType) throws IOException {
        String input = this.getInputString(mapper, invoiceType);
        LOGGER.info("Request ka efakturi je  " + input);
        String res = this.call(invoiceType.getAccountingCustomerParty().getParty().getEndpointID(), controller.getObject().getApiKey(), input);
        LOGGER.info("Response efakture " + res);
        return res;
    }

    private String getInputString(ObjectMapper objectMapper, InvoiceDto invoiceType) {
        try {
            System.out.println(invoiceType.toString());
            SimpleModule module = new SimpleModule("LocalDateSerializer", new Version(1, 0, 0, null, null, null));
            module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
            objectMapper.registerModule((Module)module);
            return objectMapper.writeValueAsString((Object)invoiceType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String call(String pib, String apiKey, String json) {
        OkHttpClient client = new OkHttpClient();
        MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody formBody = RequestBody.create((String)json, (MediaType)JSON);
        Request request = new Request.Builder().url("https://api.master.software/api/v1/invoice?ApiKey=" + apiKey).post(formBody).header("ApiKey", apiKey).header("Origin", "https://localhost:4201").build();
        try {
            LOGGER.info("URL request efaktura " + request.url().url().toString());
            Response response = client.newCall(request).execute();
            if (200 == response.code()) {
                return response.body().string();
            }
            if (400 == response.code()) {
                LOGGER.warning("Upozorenje " + response.body().string());
                System.out.println("Upozorenje je ");
                return "Upozorenje nije doslo do kreiranje efakture," + response.body().string();
            }
            if (500 == response.code()) {
                LOGGER.warning("Greska, problem u komunikaciji sa sistemom efaktura " + response.body().string());
                return "Greska, problem u komunikaciji sa sistemom efaktura " + response.body().string();
            }
            LOGGER.warning("Statusni kod je " + response.code() + "," + response.body().string());
            return "Greska, zovite korisnicku podrsku " + response.body().string();
        }
        catch (Exception e) {
            return "Greska, zovite korisnicku podrsku, problem sa kreiranjem efaktura " + e.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String callCompany(String pib, String apiKey, String json) {
        try {
            OkHttpClient client = new OkHttpClient();
            MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
            Request request = new Request.Builder().url("https://api.dev.mastersoftware.rs/api/v1/subject/company/" + pib).build();
            try (Response response = client.newCall(request).execute();){
                if (response.code() != 200) {
                    LOGGER.warning("Greska je " + response.body().string());
                    String string = "";
                    return string;
                }
                String string = response.body().toString();
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Greska za proveru kopmanije");
            throw new RuntimeException("Greska za proveru kopmanije");
        }
    }

    private static class LocalDateSerializer
    extends StdSerializer<LocalDate> {
        private static final long serialVersionUID = -1203520161919841191L;

        protected LocalDateSerializer() {
            super(LocalDate.class);
        }

        public void serialize(LocalDate date, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
            if (date != null) {
                generator.writeString(date.format(DateTimeFormatter.ISO_LOCAL_DATE));
            }
        }
    }
}

