/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.invoice.dto;

import java.util.ArrayList;
import rs.petcom.master.dal.Object;
import rs.petcom.master.invoice.dto.Contact;
import rs.petcom.master.invoice.dto.Country;
import rs.petcom.master.invoice.dto.Party;
import rs.petcom.master.invoice.dto.PartyLegalEntity;
import rs.petcom.master.invoice.dto.PartyName;
import rs.petcom.master.invoice.dto.PartyTaxScheme;
import rs.petcom.master.invoice.dto.PostalAddress;
import rs.petcom.master.invoice.dto.TaxScheme;

public class AccountingSupplierParty {
    private Party party;
    private PostalAddress postalAddress;
    private PartyTaxScheme partyTaxScheme;
    private PartyLegalEntity partyLegalEntity;
    private Contact contact;

    public static AccountingSupplierParty getSupplier(Object object) {
        Party party = new Party();
        party.setSchemeID("9948");
        party.setEndpointID(object.getPIB());
        ArrayList<PartyName> partyNameList = new ArrayList<PartyName>();
        PartyName partyName = new PartyName();
        partyName.setName(object.getName());
        partyNameList.add(partyName);
        party.setPartyName(partyNameList);
        PostalAddress postalAddress = new PostalAddress();
        postalAddress.setCityName(object.getAddress().getCity());
        postalAddress.setCountry(new Country("RS"));
        postalAddress.setStreetName(object.getAddress().getAddress());
        PartyTaxScheme partyTaxScheme = new PartyTaxScheme();
        partyTaxScheme.setCompanyID("RS" + object.getPIB());
        TaxScheme taxScheme = new TaxScheme();
        taxScheme.setId("VAT");
        partyTaxScheme.setTaxScheme(taxScheme);
        PartyLegalEntity partyLegalEntity = new PartyLegalEntity();
        partyLegalEntity.setCompanyID(object.getMB());
        partyLegalEntity.setRegistrationName(object.getName());
        Contact contact = new Contact();
        contact.setElectronicMail("");
        AccountingSupplierParty accountingSupplierParty = new AccountingSupplierParty();
        accountingSupplierParty.setParty(party);
        accountingSupplierParty.setContact(contact);
        accountingSupplierParty.setPartyLegalEntity(partyLegalEntity);
        accountingSupplierParty.setPartyTaxScheme(partyTaxScheme);
        accountingSupplierParty.setPostalAddress(postalAddress);
        return accountingSupplierParty;
    }

    public Party getParty() {
        return this.party;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public PartyTaxScheme getPartyTaxScheme() {
        return this.partyTaxScheme;
    }

    public PartyLegalEntity getPartyLegalEntity() {
        return this.partyLegalEntity;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public void setPostalAddress(PostalAddress postalAddress) {
        this.postalAddress = postalAddress;
    }

    public void setPartyTaxScheme(PartyTaxScheme partyTaxScheme) {
        this.partyTaxScheme = partyTaxScheme;
    }

    public void setPartyLegalEntity(PartyLegalEntity partyLegalEntity) {
        this.partyLegalEntity = partyLegalEntity;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public AccountingSupplierParty(Party party, PostalAddress postalAddress, PartyTaxScheme partyTaxScheme, PartyLegalEntity partyLegalEntity, Contact contact) {
        this.party = party;
        this.postalAddress = postalAddress;
        this.partyTaxScheme = partyTaxScheme;
        this.partyLegalEntity = partyLegalEntity;
        this.contact = contact;
    }

    public AccountingSupplierParty() {
    }

    public String toString() {
        return "AccountingSupplierParty(party=" + this.getParty() + ", postalAddress=" + this.getPostalAddress() + ", partyTaxScheme=" + this.getPartyTaxScheme() + ", partyLegalEntity=" + this.getPartyLegalEntity() + ", contact=" + this.getContact() + ")";
    }
}

