/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.helper.convert;

import java.util.HashMap;
import java.util.Map;

public class CyrillicLatinConverter {
    static char[] cyrilic = new char[]{'\u0410', '\u0430', '\u0411', '\u0431', '\u0412', '\u0432', '\u0413', '\u0433', '\u0414', '\u0434', '\u0402', '\u0452', '\u0415', '\u0435', '\u0416', '\u0436', '\u0417', '\u0437', '\u0418', '\u0438', '\u0408', '\u0458', '\u041a', '\u043a', '\u041b', '\u043b', '\u0409', '\u0459', '\u041c', '\u043c', '\u041d', '\u043d', '\u040a', '\u045a', '\u041e', '\u043e', '\u041f', '\u043f', '\u0420', '\u0440', '\u0421', '\u0441', '\u0422', '\u0442', '\u040b', '\u045b', '\u0423', '\u0443', '\u0424', '\u0444', '\u0425', '\u0445', '\u0426', '\u0446', '\u0427', '\u0447', '\u040f', '\u045f', '\u0428', '\u0448'};
    static String[] latin = new String[]{"A", "a", "B", "b", "V", "v", "G", "g", "D", "d", "\u0110", "\u0111", "E", "e", "\u017d", "\u017e", "Z", "z", "I", "i", "J", "j", "K", "k", "L", "l", "Lj", "lj", "M", "m", "N", "n", "Nj", "nj", "O", "o", "P", "p", "R", "r", "S", "s", "T", "t", "\u0106", "\u0107", "U", "u", "F", "f", "H", "h", "C", "c", "\u010c", "\u010d", "D\u017e", "d\u017e", "\u0160", "\u0161"};
    static Map<Character, String> cyrMapping = new HashMap<Character, String>();
    static Map<String, Character> latMapping = new HashMap<String, Character>();

    public static String latinToCyrillic(String latinText) {
        StringBuffer latBuffer = new StringBuffer(latinText);
        StringBuffer cyrBuffer = new StringBuffer();
        for (int i = 0; i < latBuffer.length(); ++i) {
            String s = latBuffer.substring(i, i + 1);
            if (i < latBuffer.length() - 1) {
                char c = latBuffer.charAt(i + 1);
                if ((s.equals("L") || s.equals("l") || s.equals("N") || s.equals("n")) && (c == 'J' || c == 'j')) {
                    s = s + 'j';
                    ++i;
                } else if ((s.equals("D") || s.equals("d")) && (c == '\u017d' || c == '\u017e')) {
                    s = s + '\u017e';
                    ++i;
                }
            }
            if (latMapping.containsKey(s)) {
                cyrBuffer.append(latMapping.get(s).charValue());
                continue;
            }
            cyrBuffer.append(s);
        }
        return cyrBuffer.toString();
    }

    public static String cyrilicToLatin(String cyrillicText) {
        StringBuffer cyrBuffer = new StringBuffer(cyrillicText);
        StringBuffer latinBuffer = new StringBuffer();
        for (int i = 0; i < cyrBuffer.length(); ++i) {
            char c = cyrBuffer.charAt(i);
            Character character = new Character(c);
            if (cyrMapping.containsKey(character)) {
                latinBuffer.append(cyrMapping.get(character));
                continue;
            }
            latinBuffer.append(c);
        }
        return latinBuffer.toString();
    }

    static {
        for (int i = 0; i < cyrilic.length; ++i) {
            cyrMapping.put(new Character(cyrilic[i]), latin[i]);
            latMapping.put(latin[i], new Character(cyrilic[i]));
        }
    }
}

