/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui.trgovina;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.InputEvent;
import javafx.util.StringConverter;

public class TimeSpinner
extends Spinner<LocalTime> {
    private final ObjectProperty<Mode> mode = new SimpleObjectProperty((Object)Mode.HOURS);

    public ObjectProperty<Mode> modeProperty() {
        return this.mode;
    }

    public final Mode getMode() {
        return (Mode)((Object)this.modeProperty().get());
    }

    public final void setMode(Mode mode) {
        this.modeProperty().set((Object)mode);
    }

    public TimeSpinner(LocalTime time) {
        this.setEditable(true);
        final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        StringConverter<LocalTime> localTimeConverter = new StringConverter<LocalTime>(){

            public String toString(LocalTime time) {
                return formatter.format(time);
            }

            public LocalTime fromString(String string) {
                String[] tokens = string.split(":");
                int hours = this.getIntField(tokens, 0);
                int minutes = this.getIntField(tokens, 1);
                int seconds = this.getIntField(tokens, 2);
                int totalSeconds = (hours * 60 + minutes) * 60 + seconds;
                return LocalTime.of(totalSeconds / 3600 % 24, totalSeconds / 60 % 60, seconds % 60);
            }

            private int getIntField(String[] tokens, int index) {
                if (tokens.length <= index || tokens[index].isEmpty()) {
                    return 0;
                }
                return Integer.parseInt(tokens[index]);
            }
        };
        TextFormatter textFormatter = new TextFormatter((StringConverter)localTimeConverter, (Object)time, c -> {
            String newText = c.getControlNewText();
            if (newText.matches("[0-9]{0,2}:[0-9]{0,2}:[0-9]{0,2}")) {
                return c;
            }
            return null;
        });
        SpinnerValueFactory<LocalTime> valueFactory = new SpinnerValueFactory<LocalTime>((StringConverter)localTimeConverter, time){
            final /* synthetic */ StringConverter val$localTimeConverter;
            final /* synthetic */ LocalTime val$time;
            {
                this.val$localTimeConverter = stringConverter;
                this.val$time = localTime;
                this.setConverter(this.val$localTimeConverter);
                this.setValue(this.val$time);
            }

            public void decrement(int steps) {
                this.setValue(((Mode)((Object)TimeSpinner.this.mode.get())).decrement((LocalTime)this.getValue(), steps));
                ((Mode)((Object)TimeSpinner.this.mode.get())).select(TimeSpinner.this);
            }

            public void increment(int steps) {
                this.setValue(((Mode)((Object)TimeSpinner.this.mode.get())).increment((LocalTime)this.getValue(), steps));
                ((Mode)((Object)TimeSpinner.this.mode.get())).select(TimeSpinner.this);
            }
        };
        this.setValueFactory((SpinnerValueFactory)valueFactory);
        this.getEditor().setTextFormatter(textFormatter);
        this.getEditor().addEventHandler(InputEvent.ANY, e -> {
            int caretPos = this.getEditor().getCaretPosition();
            int hrIndex = this.getEditor().getText().indexOf(58);
            int minIndex = this.getEditor().getText().indexOf(58, hrIndex + 1);
            if (caretPos <= hrIndex) {
                this.mode.set((Object)Mode.HOURS);
            } else if (caretPos <= minIndex) {
                this.mode.set((Object)Mode.MINUTES);
            } else {
                this.mode.set((Object)Mode.SECONDS);
            }
        });
        this.mode.addListener((obs, oldMode, newMode) -> newMode.select(this));
    }

    public TimeSpinner() {
        this(LocalTime.MIDNIGHT);
        this.setStyle("-fx-background-color: #21252e;");
    }

    static enum Mode {
        HOURS{

            @Override
            LocalTime increment(LocalTime time, int steps) {
                return time.plusHours(steps);
            }

            @Override
            void select(TimeSpinner spinner) {
                int index = spinner.getEditor().getText().indexOf(58);
                spinner.getEditor().selectRange(0, index);
            }
        }
        ,
        MINUTES{

            @Override
            LocalTime increment(LocalTime time, int steps) {
                return time.plusMinutes(steps);
            }

            @Override
            void select(TimeSpinner spinner) {
                int hrIndex = spinner.getEditor().getText().indexOf(58);
                int minIndex = spinner.getEditor().getText().indexOf(58, hrIndex + 1);
                spinner.getEditor().selectRange(hrIndex + 1, minIndex);
            }
        }
        ,
        SECONDS{

            @Override
            LocalTime increment(LocalTime time, int steps) {
                return time.plusSeconds(steps);
            }

            @Override
            void select(TimeSpinner spinner) {
                int index = spinner.getEditor().getText().lastIndexOf(58);
                spinner.getEditor().selectRange(index + 1, spinner.getEditor().getText().length());
            }
        };


        abstract LocalTime increment(LocalTime var1, int var2);

        abstract void select(TimeSpinner var1);

        LocalTime decrement(LocalTime time, int steps) {
            return this.increment(time, -steps);
        }
    }
}

