/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui.trgovina;

import java.text.ParseException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.PopisDetailes;

public class EditingTableCellDoublePopisDetailes
extends TableCell<PopisDetailes, Double> {
    private TextField textField;
    private int decimalPlaces;
    private boolean useGrouping;

    public EditingTableCellDoublePopisDetailes(int decimalPlaces, boolean useGrouping) {
        this.decimalPlaces = decimalPlaces;
        this.useGrouping = useGrouping;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(Settings.getNumberFormat(2, true).format((Double)this.getItem()));
        this.setGraphic(null);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(Settings.getNumberFormat(this.decimalPlaces, this.useGrouping).format((Double)this.getItem()));
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(Settings.getNumberFormat(this.decimalPlaces, this.useGrouping).format((Double)this.getItem()));
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.getStyleClass().add((Object)"textFieldEdit");
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    try {
                        EditingTableCellDoublePopisDetailes.this.commitEdit(Settings.getNumberFormat(EditingTableCellDoublePopisDetailes.this.decimalPlaces, EditingTableCellDoublePopisDetailes.this.useGrouping).parse(EditingTableCellDoublePopisDetailes.this.textField.getText()).doubleValue());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER || t.getCode() == KeyCode.TAB) {
                    try {
                        EditingTableCellDoublePopisDetailes.this.commitEdit(Settings.getNumberFormat(EditingTableCellDoublePopisDetailes.this.decimalPlaces, EditingTableCellDoublePopisDetailes.this.useGrouping).parse(EditingTableCellDoublePopisDetailes.this.textField.getText()).doubleValue());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingTableCellDoublePopisDetailes.this.cancelEdit();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : Settings.getNumberFormat(this.decimalPlaces, this.useGrouping).format((Double)this.getItem());
    }
}

