/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui.trgovina;

import java.text.NumberFormat;
import java.util.ArrayList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.trgovina.BillSummaryPaneTrgovina;
import rs.petcom.master.gui.trgovina.BillSummaryRoundTrgovina;

public class BillSummaryItemTrgovina
extends GridPane {
    private RoundItem roundItem;
    private boolean selected;
    private Bill bill;
    private boolean lastColored;
    Label lSifra;
    Label lArtikal;
    Label lKolicina;
    Label lPopust;
    Label lCena;
    Label lUkupno;
    NumberFormat nf = NumberFormat.getNumberInstance();
    ArrayList<AditionalField> aditionalColNames;
    ArrayList<Label> aditionalLabels = new ArrayList();
    private int itemHeight = 0;
    public static int summaryItemHeight = 20;
    private static int sifraWidth = 80;
    private static int artikalWidth = 80;
    private static int kolicinaWidth = 60;
    private static int popustWidth = 60;
    private static int cenaWidth = 80;
    private static int ukupnoWidth = 80;

    public BillSummaryItemTrgovina(final RoundItem roundItem, final Bill bill, ArrayList<AditionalField> aditionalColNames, final ScreensController controller) {
        this.bill = bill;
        this.roundItem = roundItem;
        this.aditionalColNames = aditionalColNames;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        Product p = roundItem.getProductDepartment().getProduct();
        this.getStyleClass().add((Object)"billSummaryItem");
        this.setMinHeight(this.itemHeight);
        this.setPrefHeight(this.itemHeight);
        this.setMaxHeight(this.itemHeight);
        ColumnConstraints sifra = new ColumnConstraints((double)sifraWidth, (double)sifraWidth, Double.MAX_VALUE);
        sifra.setFillWidth(true);
        sifra.setHgrow(Priority.NEVER);
        sifra.setPercentWidth(18.0);
        ColumnConstraints artikal = new ColumnConstraints((double)artikalWidth, (double)artikalWidth, Double.MAX_VALUE);
        artikal.setFillWidth(true);
        artikal.setHgrow(Priority.ALWAYS);
        artikal.setPercentWidth(aditionalColNames.size() > 0 ? (double)(70 / aditionalColNames.size()) : 50.0);
        ColumnConstraints kolicina = new ColumnConstraints((double)kolicinaWidth, (double)kolicinaWidth, Double.MAX_VALUE);
        kolicina.setFillWidth(true);
        kolicina.setHgrow(Priority.ALWAYS);
        kolicina.setPercentWidth(10.0);
        ColumnConstraints popust = new ColumnConstraints((double)popustWidth, (double)popustWidth, Double.MAX_VALUE);
        popust.setFillWidth(true);
        popust.setHgrow(Priority.ALWAYS);
        popust.setPercentWidth(10.0);
        ColumnConstraints cena = new ColumnConstraints((double)cenaWidth, (double)cenaWidth, Double.MAX_VALUE);
        cena.setFillWidth(true);
        cena.setHgrow(Priority.ALWAYS);
        cena.setPercentWidth(12.5);
        ColumnConstraints ukupno = new ColumnConstraints((double)ukupnoWidth, (double)ukupnoWidth, Double.MAX_VALUE);
        ukupno.setFillWidth(true);
        ukupno.setHgrow(Priority.ALWAYS);
        ukupno.setPercentWidth(12.5);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{sifra, artikal});
        for (AditionalField aditionalField : aditionalColNames) {
            ColumnConstraints aditionalCol = new ColumnConstraints((double)kolicinaWidth, (double)kolicinaWidth, Double.MAX_VALUE);
            aditionalCol.setFillWidth(true);
            aditionalCol.setHgrow(Priority.ALWAYS);
            aditionalCol.setPercentWidth(12.5);
            this.getColumnConstraints().add((Object)aditionalCol);
        }
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{kolicina, popust, cena, ukupno});
        RowConstraints row1 = new RowConstraints((double)summaryItemHeight, (double)summaryItemHeight, (double)summaryItemHeight);
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        this.lSifra = new Label();
        this.lSifra.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lSifra.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
        this.lSifra.setAlignment(Pos.CENTER_LEFT);
        this.lSifra.setMinWidth((double)sifraWidth);
        this.lSifra.setPrefWidth((double)sifraWidth);
        this.lSifra.setMaxWidth(Double.MAX_VALUE);
        this.lSifra.setMinHeight((double)summaryItemHeight);
        this.lSifra.setPrefHeight((double)summaryItemHeight);
        this.lSifra.setMaxHeight((double)summaryItemHeight);
        this.lArtikal = new Label();
        this.lArtikal.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lArtikal.setAlignment(Pos.CENTER_LEFT);
        this.lArtikal.setMinWidth((double)artikalWidth);
        this.lArtikal.setPrefWidth((double)artikalWidth);
        this.lArtikal.setMaxWidth(Double.MAX_VALUE);
        this.lArtikal.setMinHeight((double)summaryItemHeight);
        this.lArtikal.setPrefHeight((double)summaryItemHeight);
        this.lArtikal.setMaxHeight((double)summaryItemHeight);
        this.lKolicina = new Label();
        this.lKolicina.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lKolicina.setAlignment(Pos.CENTER_RIGHT);
        this.lKolicina.setMinWidth((double)kolicinaWidth);
        this.lKolicina.setPrefWidth((double)kolicinaWidth);
        this.lKolicina.setMaxWidth(Double.MAX_VALUE);
        this.lKolicina.setMinHeight((double)summaryItemHeight);
        this.lKolicina.setPrefHeight((double)summaryItemHeight);
        this.lKolicina.setMaxHeight((double)summaryItemHeight);
        this.lPopust = new Label();
        this.lPopust.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lPopust.setAlignment(Pos.CENTER_RIGHT);
        this.lPopust.setMinWidth((double)popustWidth);
        this.lPopust.setPrefWidth((double)popustWidth);
        this.lPopust.setMaxWidth(Double.MAX_VALUE);
        this.lPopust.setMinHeight((double)summaryItemHeight);
        this.lPopust.setPrefHeight((double)summaryItemHeight);
        this.lPopust.setMaxHeight((double)summaryItemHeight);
        this.lCena = new Label();
        this.lCena.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lCena.setAlignment(Pos.CENTER_RIGHT);
        this.lCena.setMinWidth((double)cenaWidth);
        this.lCena.setPrefWidth((double)cenaWidth);
        this.lCena.setMaxWidth(Double.MAX_VALUE);
        this.lCena.setMinHeight((double)summaryItemHeight);
        this.lCena.setPrefHeight((double)summaryItemHeight);
        this.lCena.setMaxHeight((double)summaryItemHeight);
        this.lUkupno = new Label();
        this.lUkupno.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lUkupno.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        this.lUkupno.setAlignment(Pos.CENTER_RIGHT);
        this.lUkupno.setMinWidth((double)ukupnoWidth);
        this.lUkupno.setPrefWidth((double)ukupnoWidth);
        this.lUkupno.setMaxWidth(Double.MAX_VALUE);
        this.lUkupno.setMinHeight((double)summaryItemHeight);
        this.lUkupno.setPrefHeight((double)summaryItemHeight);
        this.lUkupno.setMaxHeight((double)summaryItemHeight);
        this.lSifra.setText(p.getCode() != null && !p.getCode().equals("") ? p.getCode() : p.getBarcodeLast());
        this.lArtikal.setText(roundItem.getProductDepartment().getProduct().getName());
        this.lKolicina.setText(Settings.getNumberFormat(3, true).format(roundItem.getQuantity()));
        this.lPopust.setText(this.nf.format(roundItem.getDiscount()) + "%");
        this.lCena.setText(this.nf.format(roundItem.getProductDepartment().getProduct().getPrice()));
        this.lUkupno.setText(this.nf.format(roundItem.getProductDepartment().getProduct().getPrice() * roundItem.getQuantity()));
        int indexKolone = 0;
        this.add((Node)this.lSifra, indexKolone++, 0);
        this.add((Node)this.lArtikal, indexKolone++, 0);
        for (AditionalField aditionalField : aditionalColNames) {
            Label lAditionalCol = new Label();
            try {
                for (AditionalFieldDetailsProduct afdp : roundItem.getProductDepartment().getProduct().getListAditionalFieldDetailsProduct()) {
                    if (afdp.getAditionalFieldID() != aditionalField.getAditionalFieldID()) continue;
                    lAditionalCol.setText(afdp.getAditionalFieldDetails().getName() + "");
                }
            }
            catch (NullPointerException e) {
                lAditionalCol.setText("");
            }
            lAditionalCol.getStyleClass().add((Object)"billSummaryItemLabel");
            lAditionalCol.setAlignment(Pos.CENTER_LEFT);
            lAditionalCol.setMinWidth((double)kolicinaWidth);
            lAditionalCol.setPrefWidth((double)kolicinaWidth);
            lAditionalCol.setMaxWidth(Double.MAX_VALUE);
            lAditionalCol.setMinHeight((double)summaryItemHeight);
            lAditionalCol.setPrefHeight((double)summaryItemHeight);
            lAditionalCol.setMaxHeight((double)summaryItemHeight);
            lAditionalCol.setWrapText(true);
            this.aditionalLabels.add(lAditionalCol);
            this.add((Node)lAditionalCol, indexKolone++, 0);
        }
        this.add((Node)this.lKolicina, indexKolone++, 0);
        this.add((Node)this.lPopust, indexKolone++, 0);
        this.add((Node)this.lCena, indexKolone++, 0);
        this.add((Node)this.lUkupno, indexKolone++, 0);
        EventHandler<Event> mouseEvent = new EventHandler<Event>(){

            public void handle(Event event) {
                BillSummaryItemTrgovina.this.setSelected(!BillSummaryItemTrgovina.this.selected);
                if (BillSummaryItemTrgovina.this.selected) {
                    BillSummaryPaneTrgovina.getBss().refresh(bill, roundItem);
                } else {
                    BillSummaryPaneTrgovina.getBss().refresh(bill, controller);
                }
            }
        };
        for (Node node : this.getChildren()) {
            if (!(node instanceof Label)) continue;
            ((Label)node).addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)mouseEvent);
        }
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int height) {
        this.itemHeight = height;
    }

    public RoundItem getRoundItem() {
        return this.roundItem;
    }

    public void setRoundItem(RoundItem roundItem) {
        this.roundItem = roundItem;
    }

    public void refresh1(ScreensController controller) {
        this.getChildren().clear();
        int indexKolone = 0;
        this.add((Node)this.lSifra, indexKolone++, 0);
        this.add((Node)this.lArtikal, indexKolone++, 0);
        for (Label label : this.aditionalLabels) {
            this.add((Node)label, indexKolone++, 0);
        }
        this.add((Node)this.lKolicina, indexKolone++, 0);
        this.add((Node)this.lPopust, indexKolone++, 0);
        this.add((Node)this.lCena, indexKolone++, 0);
        this.add((Node)this.lUkupno, indexKolone++, 0);
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() != 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setPrice(Product.getCurrentPrice(this.roundItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), this.bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()));
            this.roundItem.getProductDepartment().getProduct().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * this.bill.getPerson().getLoyality().getPoints() * this.bill.getPerson().getLoyality().getSellingPointsValue() / this.bill.getSumWithDiscout());
        }
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() == 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * this.bill.getPerson().getLoyality().getPoints() * this.bill.getPerson().getLoyality().getSellingPointsValue() / this.bill.getSumWithDiscout());
        }
        if (this.bill.getPerson() == null && this.bill.getPerson().getDiscount() == 0.0 && this.bill.getDiscount() != 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(this.bill.getDiscount());
        }
        if (!this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(0.0);
        }
        if (this.roundItem.getOfferPriceDetails() != null) {
            this.lUkupno.setText(this.nf.format(this.roundItem.getQuantity() * (this.roundItem.getProductDepartment().getProduct().getPrice() - this.roundItem.getProductDepartment().getProduct().getPrice() * (this.roundItem.getProductDepartment().getProduct().getDiscount() / 100.0))));
            this.roundItem.getProductDepartment().getProduct().getCurrentPriceAndDiscountOfferPrice(controller.getPointOfSale(), controller.getSettings().getConnection());
        } else {
            this.lUkupno.setText(this.nf.format(this.roundItem.getQuantity() * (this.roundItem.getProductDepartment().getProduct().getPrice() - this.roundItem.getProductDepartment().getProduct().getPrice() * (this.roundItem.getProductDepartment().getProduct().getDiscount() / 100.0))));
        }
        this.lCena.setText(this.nf.format(this.roundItem.getProductDepartment().getProduct().getPrice()));
        this.lPopust.setText(this.nf.format(this.roundItem.getProductDepartment().getProduct().getDiscount()));
        this.lKolicina.setText(Settings.getNumberFormat(3, true).format(this.roundItem.getQuantity()));
        this.itemHeight = summaryItemHeight * (this.roundItem.getAdditionalList().size() + 1);
        this.itemHeight = summaryItemHeight;
    }

    public void refresh(ScreensController controller) {
        Product p1;
        this.getChildren().clear();
        int indexKolone = 0;
        this.add((Node)this.lSifra, indexKolone++, 0);
        this.add((Node)this.lArtikal, indexKolone++, 0);
        for (Label label : this.aditionalLabels) {
            this.add((Node)label, indexKolone++, 0);
        }
        this.add((Node)this.lKolicina, indexKolone++, 0);
        this.add((Node)this.lPopust, indexKolone++, 0);
        this.add((Node)this.lCena, indexKolone++, 0);
        this.add((Node)this.lUkupno, indexKolone++, 0);
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() != 0.0 && (p1 = this.roundItem.getProductDepartment().getProduct()).isDiscountAllowed()) {
            double cenaNova = 0.0;
            try {
                cenaNova = Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), this.bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()) - Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), this.bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()) * controller.getCurrentBill().getPerson().getLoyality().getDiscount() / 100.0;
            }
            catch (NullPointerException e) {
                cenaNova = Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), false, controller.getSettings().getConnection()) - Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), false, controller.getSettings().getConnection()) * controller.getCurrentBill().getPerson().getDiscount() / 100.0;
            }
            if (Boolean.parseBoolean(controller.getSettings().getActualByName("loyalty.point.action"))) {
                double sumWithDiscount = this.bill.getSumWithDiscout();
                double sellingPointValue = this.bill.getPerson().getLoyality().getSellingPointsValue();
                double points = this.bill.getPerson().getLoyality().getPoints();
                double billDiscount = controller.getCurrentBill().getPerson().getLoyality().getDiscount();
                double discount = billDiscount + 100.0 * points * sellingPointValue / sumWithDiscount;
                this.roundItem.getProductDepartment().getProduct().setDiscount(discount);
            } else if (p1.getDiscount() == 0.0) {
                this.roundItem.getProductDepartment().getProduct().setDiscount(this.bill.getPerson().getDiscount());
            }
        }
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() == 0.0) {
            BuyerOfferPrice buyerOfferPrice = BuyerOfferPrice.getOfferPrice(this.bill.getPerson().getBuyerOfferPriceID(), controller.getSettings().getConnection());
            if (buyerOfferPrice.getBuyerOfferPriceID() != null) {
                BuyerOfferPriceDetailes buyerOfferPriceDetailes = BuyerOfferPriceDetailes.getRoundActive(this.roundItem.getProductDepartment().getProduct().getProductID(), buyerOfferPrice.getBuyerOfferPriceID(), controller.getSettings().getConnection());
                if (buyerOfferPriceDetailes.getBuyerOfferPriceDetailsID() != 0L) {
                    this.roundItem.getProductDepartment().getProduct().setDiscount((this.roundItem.getProductDepartment().getProduct().getPrice() - buyerOfferPriceDetailes.getPrice()) * 100.0 / this.roundItem.getProductDepartment().getProduct().getPrice());
                }
            } else if (controller.getCurrentBill().getPerson().getLoyality() != null) {
                if (this.roundItem.getProductDepartment().getProduct().isDiscountAllowed() && Boolean.parseBoolean(controller.getSettings().getActualByName("loyalty.point.action")) && this.bill.isUsingPoints()) {
                    double sumWithDiscount = this.bill.getSumWithDiscout();
                    double sellingPointValue = this.bill.getPerson().getLoyality().getSellingPointsValue();
                    double points = this.bill.getPerson().getLoyality().getPoints();
                    double billDiscount = controller.getCurrentBill().getPerson().getLoyality().getDiscount();
                    double discount = billDiscount + 100.0 * points * sellingPointValue / sumWithDiscount;
                    this.roundItem.getProductDepartment().getProduct().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * this.bill.getPerson().getLoyality().getPoints() * this.bill.getPerson().getLoyality().getSellingPointsValue() / this.bill.getSumWithDiscout());
                }
            } else {
                this.roundItem.getProductDepartment().getProduct().setDiscount(0.0);
            }
        }
        if (this.bill.getPerson() == null && this.bill.getDiscount() != 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(this.bill.getDiscount());
        }
        if (!this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(0.0);
        }
        double quantity = this.roundItem.getQuantity();
        double price = this.roundItem.getProductDepartment().getProduct().getPrice();
        double discount = this.roundItem.getProductDepartment().getProduct().getDiscount();
        double total = quantity * Settings.roundOnTwo(price - price * discount / 100.0);
        this.lUkupno.setText(this.nf.format(Settings.roundOnTwo(total)));
        this.lCena.setText(this.nf.format(this.roundItem.getProductDepartment().getProduct().getPrice()));
        this.lPopust.setText(this.nf.format(this.roundItem.getProductDepartment().getProduct().getDiscount()));
        this.lKolicina.setText(Settings.getNumberFormat(3, true).format(this.roundItem.getQuantity()));
        this.itemHeight = summaryItemHeight * (this.roundItem.getAdditionalList().size() + 1);
        this.itemHeight = summaryItemHeight;
    }

    public void setSelected(boolean selected) {
        this.unselectAll();
        ((BillSummaryRoundTrgovina)this.getParent()).uncolorAll();
        if (selected) {
            this.selected = true;
            ((BillSummaryRoundTrgovina)this.getParent()).unselectAllExcept(this);
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundTransparent");
                ((Label)node).getStyleClass().add((Object)"backGroundGreen");
            }
        } else {
            this.selected = false;
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundGreen");
                ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
            }
        }
    }

    public void setLastColored(boolean colored) {
        this.uncolorAll();
        if (colored) {
            this.lastColored = true;
            ((BillSummaryRoundTrgovina)this.getParent()).uncolorAllExcept(this);
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundTransparent");
                ((Label)node).getStyleClass().add((Object)"backGroundLightGreen");
            }
        } else {
            this.lastColored = false;
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundLightGreen");
                ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void unselectAll() {
        this.selected = false;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Label)) continue;
            ((Label)node).getStyleClass().remove((Object)"backGroundGreen");
            ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
        }
    }

    public void uncolorAll() {
        this.lastColored = false;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Label)) continue;
            ((Label)node).getStyleClass().remove((Object)"backGroundLightGreen");
            ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
        }
    }

    public boolean hasSelectedItems() {
        return this.selected;
    }

    public boolean hasColoredItems() {
        return this.lastColored;
    }
}

