/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui.pekara;

import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.gui.pekara.BillSummaryHeaderPekara;
import rs.petcom.master.gui.pekara.BillSummaryItemPekara;
import rs.petcom.master.gui.pekara.BillSummaryRoundPekara;
import rs.petcom.master.gui.pekara.BillSummarySumPekara;

public class BillSummaryPanePekara
extends BorderPane {
    private static BillSummaryHeaderPekara bsh;
    private static ScrollPane scrollPane;
    private static AnchorPane roundPane;
    private static BillSummarySumPekara bss;
    Bill bill;
    int selectedRoundIndex = -1;
    int selectedItemIndex = -1;
    int selectedAditionalIndex = -1;
    int selectedDescriptionalIndex = -1;
    ArrayList<BillSummaryRoundPekara> roundList = new ArrayList();
    ArrayList<AditionalField> additionalColNames;

    public void setPaneWidth(double width) {
        roundPane.setPrefWidth(width - 20.0);
    }

    public BillSummaryPanePekara(ArrayList<AditionalField> additionalColNames) {
        this.additionalColNames = additionalColNames;
        bsh = new BillSummaryHeaderPekara(additionalColNames);
        this.setTop((Node)bsh);
        this.setCenter((Node)scrollPane);
        roundPane.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        scrollPane.setContent((Node)roundPane);
        this.setBottom((Node)bss);
    }

    public void setAdditionalColNames(ArrayList<AditionalField> additionalColNames) {
        this.additionalColNames = additionalColNames;
        this.refreshHeader();
    }

    public ArrayList<AditionalField> getAdditionalColNames() {
        return this.additionalColNames;
    }

    public ArrayList<BillSummaryRoundPekara> getRoundList() {
        return this.roundList;
    }

    public void setBill(Bill bill, ScreensController controller) {
        this.bill = bill;
        this.refresh(controller);
    }

    public Bill getBill() {
        return this.bill;
    }

    public void refresh(ScreensController controller) {
        this.roundList.clear();
        for (int i = 0; i < this.bill.getRoundList().size(); ++i) {
            BillSummaryRoundPekara bsr = new BillSummaryRoundPekara(this.bill, this.additionalColNames);
            bsr.setRound(this.bill.getRoundList().get(i));
            bsr.refresh(controller);
            this.roundList.add(bsr);
        }
        double offset = 0.0;
        roundPane.getChildren().clear();
        for (int i = 0; i < this.roundList.size(); ++i) {
            AnchorPane.setTopAnchor((Node)((Node)this.roundList.get(i)), (Double)offset);
            AnchorPane.setLeftAnchor((Node)((Node)this.roundList.get(i)), (Double)0.0);
            AnchorPane.setRightAnchor((Node)((Node)this.roundList.get(i)), (Double)0.0);
            roundPane.getChildren().add((Object)this.roundList.get(i));
            offset += this.roundList.get(i).getItemHeight();
        }
        scrollPane.setVvalue(scrollPane.getVmax());
        bss.refresh(this.bill, controller);
    }

    public void refreshHeader() {
        bsh = new BillSummaryHeaderPekara(this.additionalColNames);
        this.setTop((Node)bsh);
    }

    public void unselectAll() {
        for (int i = 0; i < this.roundList.size(); ++i) {
            this.roundList.get(i).unselectAll();
        }
    }

    public boolean hasSelectedItems() {
        for (int i = 0; i < this.roundList.size(); ++i) {
            if (!this.roundList.get(i).hasSelectedItems()) continue;
            return true;
        }
        return false;
    }

    public void locateSelected() {
        int i;
        this.selectedRoundIndex = -1;
        this.selectedItemIndex = -1;
        this.selectedAditionalIndex = -1;
        this.selectedDescriptionalIndex = -1;
        if (this.roundList.size() > 1) {
            for (i = 0; i < this.roundList.size(); ++i) {
                if (!this.roundList.get(i).hasSelectedItems()) continue;
                this.selectedRoundIndex = i;
                break;
            }
        } else {
            this.selectedRoundIndex = 0;
        }
        if (this.selectedRoundIndex > -1) {
            for (i = 0; i < this.roundList.get((int)this.selectedRoundIndex).itemsList.size(); ++i) {
                BillSummaryItemPekara bsi = this.roundList.get((int)this.selectedRoundIndex).itemsList.get(i);
                if (bsi.isSelected()) {
                    this.selectedItemIndex = i;
                    break;
                }
                if (!bsi.hasSelectedItems()) continue;
                this.selectedItemIndex = i;
            }
        }
    }

    public void setSelectedItemSelected() {
        for (int i = 0; i < this.roundList.get((int)0).itemsList.size(); ++i) {
            BillSummaryItemPekara bsi = this.roundList.get((int)0).itemsList.get(i);
            if (this.selectedItemIndex != i) continue;
            bsi.setSelected(true);
        }
    }

    public void setLastColored() {
        this.roundList.get(0).getItemsList().get(this.roundList.get(0).getItemsList().size() - 1).setLastColored(true);
    }

    public void setColoredByIndex(int indexAlreadyExistedProductDepartment) {
        this.roundList.get(0).getItemsList().get(indexAlreadyExistedProductDepartment).setLastColored(true);
    }

    public void uncolorAll() {
        for (int i = 0; i < this.roundList.get((int)0).itemsList.size(); ++i) {
            this.roundList.get((int)0).itemsList.get(i).uncolorAll();
        }
    }

    public void decreaseSelected() {
        for (int i = 0; i < this.roundList.size(); ++i) {
            this.roundList.get(i).decreaseSelectedIndex();
        }
    }

    public void increaseSelected() {
        for (int i = 0; i < this.roundList.size(); ++i) {
            this.roundList.get(i).increaseSelectedIndex();
        }
    }

    public int getSelectedRoundIndex() {
        return this.selectedRoundIndex;
    }

    public void setSelectedRoundIndex(int selectedRoundIndex) {
        this.selectedRoundIndex = selectedRoundIndex;
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public void setSelectedItemIndex(int selectedItemIndex) {
        this.selectedItemIndex = selectedItemIndex;
    }

    public int getSelectedAditionalIndex() {
        return this.selectedAditionalIndex;
    }

    public void setSelectedAditionalIndex(int selectedAditionalIndex) {
        this.selectedAditionalIndex = selectedAditionalIndex;
    }

    public int getSelectedDescriptionalIndex() {
        return this.selectedDescriptionalIndex;
    }

    public void setSelectedDescriptionalIndex(int selectedDescriptionalIndex) {
        this.selectedDescriptionalIndex = selectedDescriptionalIndex;
    }

    public void selectItem(int roundIndex, int itemIndex) {
        this.roundList.get((int)roundIndex).itemsList.get(itemIndex).setSelected(true);
    }

    public static BillSummarySumPekara getBss() {
        return bss;
    }

    static {
        scrollPane = new ScrollPane();
        roundPane = new AnchorPane();
        bss = new BillSummarySumPekara();
    }
}

