/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui.pekara;

import java.text.NumberFormat;
import java.util.ArrayList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.gui.pekara.BillSummaryPanePekara;
import rs.petcom.master.gui.pekara.BillSummaryRoundPekara;

public class BillSummaryItemPekara
extends GridPane {
    private RoundItem roundItem;
    private boolean selected;
    private Bill bill;
    private boolean lastColored;
    Label lArtikal;
    Label lKolicina;
    Label lCena;
    Label lUkupno;
    NumberFormat nf = NumberFormat.getNumberInstance();
    ArrayList<AditionalField> aditionalColNames;
    ArrayList<Label> aditionalLabels = new ArrayList();
    private int itemHeight = 0;
    public static int summaryItemHeight = 20;
    private static int artikalWidth = 120;
    private static int kolicinaWidth = 40;
    private static int cenaWidth = 60;
    private static int ukupnoWidth = 100;

    public BillSummaryItemPekara(final RoundItem roundItem, final Bill bill, ArrayList<AditionalField> aditionalColNames, final ScreensController controller) {
        this.bill = bill;
        this.roundItem = roundItem;
        this.aditionalColNames = aditionalColNames;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        this.getStyleClass().add((Object)"billSummaryItem");
        this.setMinHeight(this.itemHeight);
        this.setPrefHeight(this.itemHeight);
        this.setMaxHeight(this.itemHeight);
        ColumnConstraints artikal = new ColumnConstraints((double)artikalWidth, (double)artikalWidth, Double.MAX_VALUE);
        artikal.setFillWidth(true);
        artikal.setHgrow(Priority.ALWAYS);
        ColumnConstraints kolicina = new ColumnConstraints((double)kolicinaWidth, (double)kolicinaWidth, Double.MAX_VALUE);
        kolicina.setHgrow(Priority.ALWAYS);
        ColumnConstraints cena = new ColumnConstraints((double)cenaWidth, (double)cenaWidth, Double.MAX_VALUE);
        cena.setHgrow(Priority.ALWAYS);
        ColumnConstraints ukupno = new ColumnConstraints((double)ukupnoWidth, (double)ukupnoWidth, Double.MAX_VALUE);
        ukupno.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{artikal});
        for (AditionalField aditionalField : aditionalColNames) {
            ColumnConstraints aditionalCol = new ColumnConstraints((double)kolicinaWidth, (double)kolicinaWidth, Double.MAX_VALUE);
            aditionalCol.setHgrow(Priority.ALWAYS);
            this.getColumnConstraints().add((Object)aditionalCol);
        }
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{kolicina, cena, ukupno});
        RowConstraints row1 = new RowConstraints((double)summaryItemHeight, (double)summaryItemHeight, (double)summaryItemHeight);
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        this.lArtikal = new Label();
        this.lArtikal.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lArtikal.setAlignment(Pos.CENTER_LEFT);
        this.lArtikal.setMinWidth((double)artikalWidth);
        this.lArtikal.setPrefWidth((double)artikalWidth);
        this.lArtikal.setMaxWidth(Double.MAX_VALUE);
        this.lArtikal.setMinHeight((double)summaryItemHeight);
        this.lArtikal.setPrefHeight((double)summaryItemHeight);
        this.lArtikal.setMaxHeight((double)summaryItemHeight);
        this.lKolicina = new Label();
        this.lKolicina.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lKolicina.setAlignment(Pos.CENTER_RIGHT);
        this.lKolicina.setMinWidth((double)kolicinaWidth);
        this.lKolicina.setPrefWidth((double)kolicinaWidth);
        this.lKolicina.setMaxWidth(Double.MAX_VALUE);
        this.lKolicina.setMinHeight((double)summaryItemHeight);
        this.lKolicina.setPrefHeight((double)summaryItemHeight);
        this.lKolicina.setMaxHeight((double)summaryItemHeight);
        this.lCena = new Label();
        this.lCena.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lCena.setAlignment(Pos.CENTER_RIGHT);
        this.lCena.setMinWidth((double)cenaWidth);
        this.lCena.setPrefWidth((double)cenaWidth);
        this.lCena.setMaxWidth(Double.MAX_VALUE);
        this.lCena.setMinHeight((double)summaryItemHeight);
        this.lCena.setPrefHeight((double)summaryItemHeight);
        this.lCena.setMaxHeight((double)summaryItemHeight);
        this.lUkupno = new Label();
        this.lUkupno.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lUkupno.setPadding(new Insets(0.0, 35.0, 0.0, 0.0));
        this.lUkupno.setAlignment(Pos.CENTER_RIGHT);
        this.lUkupno.setMinWidth((double)ukupnoWidth);
        this.lUkupno.setPrefWidth((double)ukupnoWidth);
        this.lUkupno.setMaxWidth(Double.MAX_VALUE);
        this.lUkupno.setMinHeight((double)summaryItemHeight);
        this.lUkupno.setPrefHeight((double)summaryItemHeight);
        this.lUkupno.setMaxHeight((double)summaryItemHeight);
        this.lArtikal.setText(roundItem.getProductDepartment().getProduct().getName());
        this.lKolicina.setText(Settings.getNumberFormat(4, true).format(roundItem.getQuantity()));
        this.lCena.setText(this.nf.format(roundItem.getProductDepartment().getProduct().getPrice()));
        this.lUkupno.setText(this.nf.format(roundItem.getProductDepartment().getProduct().getPrice() * roundItem.getQuantity()));
        int indexKolone = 0;
        this.add((Node)this.lArtikal, indexKolone++, 0);
        for (AditionalField aditionalField : aditionalColNames) {
            Label lAditionalCol = new Label();
            for (AditionalFieldDetailsProduct afdp : roundItem.getProductDepartment().getProduct().getListAditionalFieldDetailsProduct()) {
                if (afdp.getAditionalFieldID() != aditionalField.getAditionalFieldID()) continue;
                lAditionalCol.setText(afdp.getAditionalFieldDetails().getName() + "");
            }
            lAditionalCol.getStyleClass().add((Object)"billSummaryItemLabel");
            lAditionalCol.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
            lAditionalCol.setAlignment(Pos.CENTER_LEFT);
            lAditionalCol.setMinWidth((double)kolicinaWidth);
            lAditionalCol.setPrefWidth((double)kolicinaWidth);
            lAditionalCol.setMaxWidth(Double.MAX_VALUE);
            lAditionalCol.setMinHeight((double)summaryItemHeight);
            lAditionalCol.setPrefHeight((double)summaryItemHeight);
            lAditionalCol.setMaxHeight((double)summaryItemHeight);
            this.aditionalLabels.add(lAditionalCol);
            this.add((Node)lAditionalCol, indexKolone++, 0);
        }
        this.add((Node)this.lKolicina, indexKolone++, 0);
        this.add((Node)this.lCena, indexKolone++, 0);
        this.add((Node)this.lUkupno, indexKolone++, 0);
        EventHandler<Event> mouseEvent = new EventHandler<Event>(){

            public void handle(Event event) {
                BillSummaryItemPekara.this.setSelected(!BillSummaryItemPekara.this.selected);
                if (BillSummaryItemPekara.this.selected) {
                    BillSummaryPanePekara.getBss().refresh(bill, roundItem);
                } else {
                    BillSummaryPanePekara.getBss().refresh(bill, controller);
                }
            }
        };
        for (Node node : this.getChildren()) {
            if (!(node instanceof Label)) continue;
            ((Label)node).addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)mouseEvent);
        }
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int height) {
        this.itemHeight = height;
    }

    public RoundItem getRoundItem() {
        return this.roundItem;
    }

    public void setRoundItem(RoundItem roundItem) {
        this.roundItem = roundItem;
    }

    public void refresh1(ScreensController controller) {
        this.getChildren().clear();
        int indexKolone = 0;
        this.add((Node)this.lArtikal, indexKolone++, 0);
        for (Label label : this.aditionalLabels) {
            this.add((Node)label, indexKolone++, 0);
        }
        this.add((Node)this.lKolicina, indexKolone++, 0);
        this.add((Node)this.lCena, indexKolone++, 0);
        this.add((Node)this.lUkupno, indexKolone++, 0);
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() != 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setPrice(Product.getCurrentPrice(this.roundItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), this.bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()));
            this.roundItem.getProductDepartment().getProduct().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * this.bill.getPerson().getLoyality().getPoints() * this.bill.getPerson().getLoyality().getSellingPointsValue() / this.bill.getSumWithDiscout());
        }
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() == 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * this.bill.getPerson().getLoyality().getPoints() * this.bill.getPerson().getLoyality().getSellingPointsValue() / this.bill.getSumWithDiscout());
        }
        if (!this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(0.0);
        }
        if (this.roundItem.getOfferPriceDetails() != null) {
            this.lUkupno.setText(this.nf.format(this.roundItem.getQuantity() * (this.roundItem.getProductDepartment().getProduct().getPrice() - this.roundItem.getProductDepartment().getProduct().getPrice() * (this.roundItem.getProductDepartment().getProduct().getDiscount() / 100.0))));
            this.roundItem.getProductDepartment().getProduct().getCurrentPriceAndDiscountOfferPrice(controller.getPointOfSale(), controller.getSettings().getConnection());
        } else {
            this.lUkupno.setText(this.nf.format(this.roundItem.getQuantity() * (this.roundItem.getProductDepartment().getProduct().getPrice() - this.roundItem.getProductDepartment().getProduct().getPrice() * (this.roundItem.getProductDepartment().getProduct().getDiscount() / 100.0))));
        }
        this.lCena.setText(this.nf.format(this.roundItem.getProductDepartment().getProduct().getPrice()));
        this.lKolicina.setText(Settings.getNumberFormat(4, true).format(this.roundItem.getQuantity()));
        this.itemHeight = summaryItemHeight * (this.roundItem.getAdditionalList().size() + 1);
        this.itemHeight = summaryItemHeight;
    }

    public void refresh(ScreensController controller) {
        this.getChildren().clear();
        int indexKolone = 0;
        this.add((Node)this.lArtikal, indexKolone++, 0);
        for (Label label : this.aditionalLabels) {
            this.add((Node)label, indexKolone++, 0);
        }
        this.add((Node)this.lKolicina, indexKolone++, 0);
        this.add((Node)this.lCena, indexKolone++, 0);
        this.add((Node)this.lUkupno, indexKolone++, 0);
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() != 0.0 && this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            double cenaNova = 0.0;
            try {
                cenaNova = Product.getCurrentPrice(this.roundItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), this.bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()) - Product.getCurrentPrice(this.roundItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), this.bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()) * controller.getCurrentBill().getPerson().getLoyality().getDiscount() / 100.0;
            }
            catch (NullPointerException e) {
                cenaNova = Product.getCurrentPrice(this.roundItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), false, controller.getSettings().getConnection()) - Product.getCurrentPrice(this.roundItem.getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), false, controller.getSettings().getConnection()) * controller.getCurrentBill().getPerson().getDiscount() / 100.0;
            }
            this.roundItem.getProductDepartment().getProduct().setDiscount((this.roundItem.getProductDepartment().getProduct().getPrice() - cenaNova) * 100.0 / this.roundItem.getProductDepartment().getProduct().getPrice());
        }
        if (this.bill.getPerson() != null && this.bill.getPerson().getDiscount() == 0.0) {
            BuyerOfferPrice buyerOfferPrice = BuyerOfferPrice.getOfferPrice(this.bill.getPerson().getBuyerOfferPriceID(), controller.getSettings().getConnection());
            if (buyerOfferPrice.getBuyerOfferPriceID() != null) {
                BuyerOfferPriceDetailes buyerOfferPriceDetailes = BuyerOfferPriceDetailes.getRoundActive(this.roundItem.getProductDepartment().getProduct().getProductID(), buyerOfferPrice.getBuyerOfferPriceID(), controller.getSettings().getConnection());
                if (buyerOfferPriceDetailes.getBuyerOfferPriceDetailsID() != 0L) {
                    this.roundItem.getProductDepartment().getProduct().setDiscount((this.roundItem.getProductDepartment().getProduct().getPrice() - buyerOfferPriceDetailes.getPrice()) * 100.0 / this.roundItem.getProductDepartment().getProduct().getPrice());
                }
            } else if (controller.getCurrentBill().getPerson().getLoyality() != null) {
                if (this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
                    this.roundItem.getProductDepartment().getProduct().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * this.bill.getPerson().getLoyality().getPoints() * this.bill.getPerson().getLoyality().getSellingPointsValue() / this.bill.getSumWithDiscout());
                }
            } else {
                this.roundItem.getProductDepartment().getProduct().setDiscount(0.0);
            }
        }
        if (!this.roundItem.getProductDepartment().getProduct().isDiscountAllowed()) {
            this.roundItem.getProductDepartment().getProduct().setDiscount(0.0);
        }
        this.lUkupno.setText(this.nf.format(this.roundItem.getQuantity() * (this.roundItem.getProductDepartment().getProduct().getPrice() - this.roundItem.getProductDepartment().getProduct().getPrice() * (this.roundItem.getProductDepartment().getProduct().getDiscount() / 100.0))));
        this.lCena.setText(this.nf.format(this.roundItem.getProductDepartment().getProduct().getPrice()));
        this.lKolicina.setText(Settings.getNumberFormat(4, true).format(this.roundItem.getQuantity()));
        this.itemHeight = summaryItemHeight * (this.roundItem.getAdditionalList().size() + 1);
        this.itemHeight = summaryItemHeight;
    }

    public void setSelected(boolean selected) {
        this.unselectAll();
        ((BillSummaryRoundPekara)this.getParent()).uncolorAll();
        if (selected) {
            this.selected = true;
            ((BillSummaryRoundPekara)this.getParent()).unselectAllExcept(this);
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundTransparent");
                ((Label)node).getStyleClass().add((Object)"backGroundGreen");
            }
        } else {
            this.selected = false;
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundGreen");
                ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
            }
        }
    }

    public void setLastColored(boolean colored) {
        this.uncolorAll();
        if (colored) {
            this.lastColored = true;
            ((BillSummaryRoundPekara)this.getParent()).uncolorAllExcept(this);
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundTransparent");
                ((Label)node).getStyleClass().add((Object)"backGroundLightGreen");
            }
        } else {
            this.lastColored = false;
            for (Node node : this.getChildren()) {
                if (!(node instanceof Label)) continue;
                ((Label)node).getStyleClass().remove((Object)"backGroundLightGreen");
                ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void unselectAll() {
        this.selected = false;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Label)) continue;
            ((Label)node).getStyleClass().remove((Object)"backGroundGreen");
            ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
        }
    }

    public void uncolorAll() {
        this.lastColored = false;
        for (Node node : this.getChildren()) {
            if (!(node instanceof Label)) continue;
            ((Label)node).getStyleClass().remove((Object)"backGroundLightGreen");
            ((Label)node).getStyleClass().add((Object)"backGroundTransparent");
        }
    }

    public boolean hasSelectedItems() {
        return this.selected;
    }

    public boolean hasColoredItems() {
        return this.lastColored;
    }
}

