/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.layout.HBox;
import rs.petcom.master.dal.product.ProductGroup;

public class TreeProductGroupCell
extends TreeCell<ProductGroup> {
    protected void updateItem(final ProductGroup item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (this.isEmpty()) {
            this.setGraphic(null);
            this.setText(null);
        } else if (this.getTreeItem().isLeaf()) {
            HBox cellBox = new HBox();
            CheckBox checkBox = new CheckBox();
            checkBox.setSelected(item.isSelected());
            checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    item.setSelected(newValue);
                }
            });
            Label label = new Label(item.getName());
            label.prefHeightProperty().bind((ObservableValue)checkBox.heightProperty());
            cellBox.getChildren().addAll((Object[])new Node[]{checkBox, label});
            this.setGraphic((Node)cellBox);
            this.setText(null);
        } else {
            this.setGraphic(null);
            this.setText(item.getName());
        }
    }
}

