/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.util.Collection;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import rs.petcom.master.gui.RingProgressIndicator;

public class RingProgressIndicatorSkin
implements Skin<RingProgressIndicator> {
    private final RingProgressIndicator indicator;
    private final Label percentLabel = new Label();
    private final Circle innerCircle = new Circle();
    private final Circle outerCircle = new Circle();
    private final StackPane container = new StackPane();
    private final Arc fillerArc = new Arc();
    private final RotateTransition transition = new RotateTransition(Duration.millis((double)2000.0), (Node)this.fillerArc);

    public RingProgressIndicatorSkin(RingProgressIndicator indicator) {
        this.indicator = indicator;
        this.initContainer(indicator);
        this.initFillerArc();
        this.container.widthProperty().addListener((o, oldVal, newVal) -> this.fillerArc.setCenterX((double)(newVal.intValue() / 2)));
        this.container.heightProperty().addListener((o, oldVal, newVal) -> this.fillerArc.setCenterY((double)(newVal.intValue() / 2)));
        this.innerCircle.getStyleClass().add((Object)"ringindicator-inner-circle");
        this.outerCircle.getStyleClass().add((Object)"ringindicator-outer-circle-secondary");
        this.updateRadii();
        this.indicator.indeterminateProperty().addListener((o, oldVal, newVal) -> this.initIndeterminate((boolean)newVal));
        this.indicator.progressProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.intValue() >= 0) {
                this.setProgressLabel(newVal.intValue());
                this.fillerArc.setLength((double)newVal.intValue() * -3.6);
            }
        });
        this.indicator.ringWidthProperty().addListener((o, oldVal, newVal) -> this.updateRadii());
        this.innerCircle.strokeWidthProperty().addListener(e -> this.updateRadii());
        this.innerCircle.radiusProperty().addListener(e -> this.updateRadii());
        this.initTransition();
        this.initIndeterminate(indicator.isIndeterminate());
        this.initLabel(indicator.getProgress());
        indicator.visibleProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue() && this.indicator.isIndeterminate()) {
                this.transition.play();
            } else {
                this.transition.pause();
            }
        });
        this.container.getChildren().addAll((Object[])new Node[]{this.fillerArc, this.outerCircle, this.innerCircle, this.percentLabel});
    }

    private void setProgressLabel(int value) {
        if (value >= 0) {
            this.percentLabel.setText(String.format("%d%%", value));
        }
    }

    private void initTransition() {
        this.transition.setAutoReverse(false);
        this.transition.setCycleCount(-1);
        this.transition.setDelay(Duration.ZERO);
        this.transition.setInterpolator(Interpolator.LINEAR);
        this.transition.setByAngle(360.0);
    }

    private void initFillerArc() {
        this.fillerArc.setManaged(false);
        this.fillerArc.getStyleClass().add((Object)"ringindicator-filler");
        this.fillerArc.setStartAngle(90.0);
        this.fillerArc.setLength((double)this.indicator.getProgress() * -3.6);
    }

    private void initContainer(RingProgressIndicator indicator) {
        this.container.getStylesheets().addAll((Collection)indicator.getStylesheets());
        this.container.getStyleClass().addAll((Object[])new String[]{"circleindicator-container"});
        this.container.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.container.setMaxWidth(Double.NEGATIVE_INFINITY);
    }

    private void updateRadii() {
        double ringWidth = this.indicator.getRingWidth();
        double innerCircleHalfStrokeWidth = this.innerCircle.getStrokeWidth() / 2.0;
        double innerCircleRadius = this.indicator.getInnerCircleRadius();
        this.outerCircle.setRadius(innerCircleRadius + innerCircleHalfStrokeWidth + ringWidth);
        this.fillerArc.setRadiusY(innerCircleRadius + innerCircleHalfStrokeWidth - 1.0 + ringWidth / 2.0);
        this.fillerArc.setRadiusX(innerCircleRadius + innerCircleHalfStrokeWidth - 1.0 + ringWidth / 2.0);
        this.fillerArc.setStrokeWidth(ringWidth);
        this.innerCircle.setRadius(innerCircleRadius);
    }

    private void initLabel(int value) {
        this.setProgressLabel(value);
        this.percentLabel.getStyleClass().add((Object)"circleindicator-label");
    }

    private void initIndeterminate(boolean newVal) {
        this.percentLabel.setVisible(!newVal);
        if (newVal) {
            this.fillerArc.setLength(360.0);
            this.fillerArc.getStyleClass().add((Object)"indeterminate");
            if (this.indicator.isVisible()) {
                this.transition.play();
            }
        } else {
            this.fillerArc.getStyleClass().remove((Object)"indeterminate");
            this.fillerArc.setRotate(0.0);
            this.transition.stop();
        }
    }

    public RingProgressIndicator getSkinnable() {
        return this.indicator;
    }

    public Node getNode() {
        return this.container;
    }

    public void dispose() {
        this.transition.stop();
    }
}

