/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class JFXComboBoxListViewSkin<T>
extends ComboBoxListViewSkin<T> {
    private boolean invalid = true;
    private StackPane customPane;
    private StackPane line = new StackPane();
    private StackPane focusedLine = new StackPane();
    private Text promptText = new Text();
    private double initScale = 0.05;
    private Scale scale = new Scale(this.initScale, 1.0);
    private Scale promptTextScale = new Scale(1.0, 1.0, 0.0, 0.0);
    protected final ObjectProperty<Paint> promptTextFill = new StyleableObjectProperty<Paint>((Paint)Color.GRAY){

        public Object getBean() {
            return JFXComboBoxListViewSkin.this;
        }

        public String getName() {
            return "promptTextFill";
        }

        public CssMetaData<JFXComboBox, Paint> getCssMetaData() {
            return StyleableProperties.PROMPT_TEXT_FILL;
        }
    };
    private Paint oldPromptTextFill = (Paint)this.promptTextFill.get();
    protected final ObjectProperty<Paint> animatedPromptTextFill = new SimpleObjectProperty(this.promptTextFill.get());
    JFXAnimationTimer focusTimer = new JFXAnimationTimer(new JFXKeyFrame[]{new JFXKeyFrame(Duration.millis((double)1.0), new JFXKeyValue[]{JFXKeyValue.builder().setTarget((WritableValue)this.focusedLine.opacityProperty()).setEndValue((Object)1).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((ComboBoxBase)this.getSkinnable()).isFocused()).build()}), new JFXKeyFrame(Duration.millis((double)160.0), new JFXKeyValue[]{JFXKeyValue.builder().setTarget((WritableValue)this.scale.xProperty()).setEndValue((Object)1).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.animatedPromptTextFill).setEndValueSupplier(() -> ((JFXComboBox)this.getSkinnable()).getFocusColor()).setInterpolator(Interpolator.EASE_BOTH).setAnimateCondition(() -> ((ComboBoxBase)this.getSkinnable()).isFocused()).build(), JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.promptText.translateYProperty()).setEndValueSupplier(() -> -this.customPane.getHeight() + 6.05).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.promptTextScale.xProperty()).setEndValue((Object)0.85).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.promptTextScale.yProperty()).setEndValue((Object)0.85).setInterpolator(Interpolator.EASE_BOTH).build()})});
    JFXAnimationTimer unfocusTimer = new JFXAnimationTimer(new JFXKeyFrame[]{new JFXKeyFrame(Duration.millis((double)160.0), new JFXKeyValue[]{JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.promptText.translateYProperty()).setEndValue((Object)0).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.promptTextScale.xProperty()).setEndValue((Object)1).setInterpolator(Interpolator.EASE_BOTH).build(), JFXKeyValue.builder().setTargetSupplier(() -> !((JFXComboBox)this.getSkinnable()).isLabelFloat() ? null : this.promptTextScale.yProperty()).setEndValue((Object)1).setInterpolator(Interpolator.EASE_BOTH).build()})});
    private BooleanBinding usePromptText = Bindings.createBooleanBinding(() -> this.usePromptText(), (Observable[])new Observable[]{((JFXComboBox)this.getSkinnable()).valueProperty(), ((ComboBoxBase)this.getSkinnable()).promptTextProperty()});

    public JFXComboBoxListViewSkin(JFXComboBox<T> comboBox) {
        super(comboBox);
        this.promptText.textProperty().bind((ObservableValue)comboBox.promptTextProperty());
        this.promptText.fillProperty().bind(this.animatedPromptTextFill);
        this.promptText.getStyleClass().addAll((Object[])new String[]{"text", "prompt-text"});
        this.promptText.getTransforms().add((Object)this.promptTextScale);
        if (!comboBox.isLabelFloat()) {
            this.promptText.visibleProperty().bind((ObservableValue)this.usePromptText);
        }
        this.customPane = new StackPane();
        this.customPane.setMouseTransparent(true);
        this.customPane.getStyleClass().add((Object)"combo-box-button-container");
        this.customPane.getChildren().add((Object)this.promptText);
        this.getChildren().add(0, (Object)this.customPane);
        StackPane.setAlignment((Node)this.promptText, (Pos)Pos.CENTER_LEFT);
        this.line.getStyleClass().add((Object)"input-line");
        this.focusedLine.getStyleClass().add((Object)"input-focused-line");
        this.getChildren().add((Object)this.line);
        this.getChildren().add((Object)this.focusedLine);
        this.line.setPrefHeight(1.0);
        this.line.setTranslateY(1.0);
        this.line.setManaged(false);
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXComboBox)this.getSkinnable()).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        if (((ComboBoxBase)this.getSkinnable()).isDisabled()) {
            this.line.setBorder(new Border(new BorderStroke[]{new BorderStroke(((JFXComboBox)this.getSkinnable()).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(1.0))}));
            this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
        this.focusedLine.setPrefHeight(2.0);
        this.focusedLine.setTranslateY(0.0);
        this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXComboBox)this.getSkinnable()).getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setOpacity(0.0);
        this.focusedLine.getTransforms().add((Object)this.scale);
        this.focusedLine.setManaged(false);
        if (comboBox.isEditable()) {
            comboBox.getEditor().setStyle("-fx-background-color:TRANSPARENT;-fx-padding: 4 0 4 0");
            comboBox.getEditor().promptTextProperty().unbind();
            comboBox.getEditor().setPromptText(null);
            comboBox.getEditor().textProperty().addListener((o, oldVal, newVal) -> {
                this.usePromptText.invalidate();
                comboBox.setValue(this.getConverter().fromString(newVal));
            });
        }
        comboBox.labelFloatProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.promptText.visibleProperty().unbind();
            } else {
                this.promptText.visibleProperty().bind((ObservableValue)this.usePromptText);
            }
        });
        comboBox.focusColorProperty().addListener(observable -> {
            if (comboBox.getFocusColor() != null) {
                this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(comboBox.getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
            }
        });
        comboBox.unFocusColorProperty().addListener(observable -> {
            if (comboBox.getUnFocusColor() != null) {
                this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(comboBox.getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
            }
        });
        comboBox.disabledProperty().addListener(observable -> {
            this.line.setBorder(comboBox.isDisabled() ? new Border(new BorderStroke[]{new BorderStroke(((JFXComboBox)this.getSkinnable()).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(this.line.getHeight()))}) : Border.EMPTY);
            this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(comboBox.isDisabled() ? Color.TRANSPARENT : ((JFXComboBox)this.getSkinnable()).getUnFocusColor()), CornerRadii.EMPTY, Insets.EMPTY)}));
        });
        comboBox.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.focus();
            } else {
                this.unFocus();
            }
        });
        this.promptTextFill.addListener(observable -> {
            this.oldPromptTextFill = (Paint)this.promptTextFill.get();
            this.animatedPromptTextFill.set(this.promptTextFill.get());
        });
        comboBox.valueProperty().addListener(observable -> {
            if (!((ComboBoxBase)this.getSkinnable()).isFocused() && ((JFXComboBox)this.getSkinnable()).isLabelFloat()) {
                Object value = comboBox.getValue();
                if (value == null || value.toString().isEmpty()) {
                    this.animateFloatingLabel(false);
                } else {
                    this.animateFloatingLabel(true);
                }
            }
        });
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        this.customPane.resizeRelocate(x, y, w, h);
        if (this.invalid) {
            this.invalid = false;
            this.animatedPromptTextFill.set(this.promptTextFill.get());
            if (((ComboBoxBase)this.getSkinnable()).getValue() != null) {
                this.animateFloatingLabel(true);
            }
        }
        this.focusedLine.resizeRelocate(x, ((ComboBoxBase)this.getSkinnable()).getHeight(), w, this.focusedLine.prefHeight(-1.0));
        this.line.resizeRelocate(x, ((ComboBoxBase)this.getSkinnable()).getHeight(), w, this.line.prefHeight(-1.0));
        this.scale.setPivotX(w / 2.0);
    }

    private void focus() {
        this.unfocusTimer.stop();
        this.focusTimer.start();
    }

    private void animateFloatingLabel(boolean up) {
        if (this.promptText == null) {
            Platform.runLater(() -> this.animateFloatingLabel(up));
        } else if (up) {
            this.unfocusTimer.stop();
            this.focusTimer.start();
        } else if (!up) {
            this.focusTimer.stop();
            this.unfocusTimer.start();
        }
    }

    private void unFocus() {
        this.focusTimer.stop();
        this.scale.setX(this.initScale);
        this.focusedLine.setOpacity(0.0);
        if (((JFXComboBox)this.getSkinnable()).isLabelFloat() && this.oldPromptTextFill != null) {
            this.animatedPromptTextFill.set((Object)this.oldPromptTextFill);
            if (this.usePromptText()) {
                this.unfocusTimer.start();
            }
        }
    }

    private boolean usePromptText() {
        Object txt = ((JFXComboBox)this.getSkinnable()).getValue();
        String promptTxt = ((ComboBoxBase)this.getSkinnable()).getPromptText();
        boolean isLabelFloat = ((JFXComboBox)this.getSkinnable()).isLabelFloat();
        return !(txt != null && !txt.toString().isEmpty() || promptTxt == null || promptTxt.isEmpty() || ((Paint)this.promptTextFill.get()).equals(Color.TRANSPARENT) && !isLabelFloat);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXComboBoxListViewSkin.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXComboBox, Paint> PROMPT_TEXT_FILL = new CssMetaData<JFXComboBox, Paint>("-fx-prompt-text-fill", PaintConverter.getInstance(), (Paint)Color.GRAY){

            public boolean isSettable(JFXComboBox n) {
                JFXComboBoxListViewSkin skin = (JFXComboBoxListViewSkin)n.getSkin();
                return skin.promptTextFill == null || !skin.promptTextFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXComboBox n) {
                JFXComboBoxListViewSkin skin = (JFXComboBoxListViewSkin)n.getSkin();
                return (StyleableProperty)skin.promptTextFill;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<JFXComboBox, Paint>> styleables = new ArrayList<CssMetaData<JFXComboBox, Paint>>(ComboBoxListViewSkin.getClassCssMetaData());
            styleables.add(PROMPT_TEXT_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

