/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.layout.HBox;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.product.GroupPointOfSale;

public class GroupPointOfSaleCheckBoxCell
extends TreeCell<PointOfSale> {
    HBox cellBox = new HBox();
    CheckBox checkBox = new CheckBox();
    Label label = new Label("");
    ObservableList<User> listUserID = FXCollections.observableArrayList();
    ObservableList<GroupPointOfSale> listGroupPOS = FXCollections.observableArrayList();
    PointOfSale pos;

    public GroupPointOfSaleCheckBoxCell() {
        this.label.prefHeightProperty().bind((ObservableValue)this.checkBox.heightProperty());
        this.checkBox.setSelected(false);
        this.cellBox.getChildren().addAll((Object[])new Node[]{this.checkBox, this.label});
        this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                GroupPointOfSaleCheckBoxCell.this.pos.setSelected(newValue);
            }
        });
    }

    public GroupPointOfSaleCheckBoxCell(int groupID, ScreensController controller) {
        this.label.prefHeightProperty().bind((ObservableValue)this.checkBox.heightProperty());
        this.checkBox.setSelected(false);
        this.cellBox.getChildren().addAll((Object[])new Node[]{this.checkBox, this.label});
        this.listGroupPOS = GroupPointOfSale.getListForPOS(groupID, controller.getSettings().getConnection());
        this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                GroupPointOfSaleCheckBoxCell.this.pos.setSelected(newValue);
            }
        });
    }

    protected void updateItem(PointOfSale item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.pos = item;
        if (this.isEmpty()) {
            this.setGraphic(null);
            this.setText(null);
        } else if (this.getTreeItem().isLeaf()) {
            for (GroupPointOfSale gpos : this.listGroupPOS) {
                if (gpos.getPointOfSaleID() != this.pos.getPointOfSaleID()) continue;
                this.label.setText(this.pos.getName());
                this.checkBox.setSelected(true);
                this.setGraphic((Node)this.cellBox);
            }
            this.label.setText(this.pos.getName());
            this.checkBox.setSelected(this.pos.isSelected());
            this.setGraphic((Node)this.cellBox);
        } else {
            this.setGraphic(null);
            this.setText(this.pos.getName());
            this.checkBox.setSelected(false);
        }
    }
}

