/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.util.Collection;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import rs.petcom.master.gui.FillProgressIndicator;

public class FillProgressIndicatorSkin
implements Skin<FillProgressIndicator> {
    private final FillProgressIndicator indicator;
    private final StackPane container = new StackPane();
    private final Label percentLabel = new Label();
    private final Rectangle cover = new Rectangle();
    private final Circle borderCircle = new Circle();
    private final Circle fillerCircle = new Circle();
    private final Timeline transition = new Timeline();

    public FillProgressIndicatorSkin(FillProgressIndicator indicator) {
        this.indicator = indicator;
        this.initContainer(indicator);
        this.updateRadii();
        this.initStyles();
        AnchorPane coverPane = new AnchorPane();
        this.cover.getStyleClass().add((Object)"fillindicator-filler-cover");
        this.cover.widthProperty().bind((ObservableValue)coverPane.widthProperty());
        this.cover.setManaged(false);
        AnchorPane.setTopAnchor((Node)this.cover, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.cover, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.cover, (Double)0.0);
        coverPane.getChildren().addAll((Object[])new Node[]{this.cover});
        this.indicator.indeterminateProperty().addListener((o, oldVal, newVal) -> this.initIndeterminate((boolean)newVal));
        this.indicator.progressProperty().addListener((o, oldVal, newVal) -> {
            this.setProgressLabel(newVal.intValue());
            this.cover.setHeight(coverPane.getHeight() * ((double)(100 - newVal.intValue()) / 100.0));
        });
        this.indicator.innerCircleRadiusProperty().addListener(e -> this.updateRadii());
        coverPane.heightProperty().addListener((o, oldVal, newVal) -> this.cover.setHeight((double)newVal.intValue() * ((double)(100 - indicator.getProgress()) / 100.0)));
        this.initLabel(indicator.getProgress());
        indicator.visibleProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue() && this.indicator.isIndeterminate()) {
                this.transition.play();
            } else {
                this.transition.pause();
            }
        });
        this.container.getChildren().addAll((Object[])new Node[]{this.fillerCircle, coverPane, this.borderCircle, this.percentLabel});
        this.initTransition();
        this.initIndeterminate(indicator.isIndeterminate());
    }

    private void initContainer(FillProgressIndicator indicator) {
        this.container.getStylesheets().addAll((Collection)indicator.getStylesheets());
        this.container.getStyleClass().addAll((Object[])new String[]{"circleindicator-container"});
        this.container.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.container.setMaxWidth(Double.NEGATIVE_INFINITY);
    }

    private void initTransition() {
        this.transition.setCycleCount(-1);
        this.transition.setAutoReverse(true);
        KeyValue kv = new KeyValue((WritableValue)this.cover.heightProperty(), (Object)0);
        this.transition.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{kv})});
    }

    private void initStyles() {
        this.fillerCircle.getStyleClass().add((Object)"fillindicator-filler-circle");
        this.borderCircle.getStyleClass().add((Object)"fillindicator-border-circle");
    }

    private void updateRadii() {
        this.fillerCircle.setRadius(this.indicator.getInnerCircleRadius() + 5.0);
        this.borderCircle.setRadius(this.indicator.getInnerCircleRadius());
    }

    private void initLabel(int value) {
        this.setProgressLabel(value);
        this.percentLabel.getStyleClass().add((Object)"circleindicator-label");
    }

    private void setProgressLabel(int value) {
        if (value >= 0) {
            this.percentLabel.setText(String.format("%d%%", value));
        }
    }

    private void initIndeterminate(boolean newVal) {
        this.percentLabel.setVisible(!newVal);
        if (newVal && this.indicator.isVisible()) {
            this.transition.play();
        } else {
            this.transition.stop();
        }
    }

    public FillProgressIndicator getSkinnable() {
        return this.indicator;
    }

    public Node getNode() {
        return this.container;
    }

    public void dispose() {
        this.transition.stop();
    }
}

