/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.text.ParseException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import rs.petcom.master.dal.Settings;

public class EditingTableCellDoubleTest
extends TableCell<Object, Integer> {
    private TextField textField;
    private int decimalPlaces;
    private boolean useGrouping;

    public EditingTableCellDoubleTest(int decimalPlaces, boolean useGrouping) {
        this.decimalPlaces = decimalPlaces;
        this.useGrouping = useGrouping;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(Settings.getNumberFormat(2, true).format((double)((Integer)this.getItem()).intValue()));
        this.setGraphic(null);
    }

    public void updateItem(Integer item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (!this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(Settings.getNumberFormat(this.decimalPlaces, this.useGrouping).format((double)((Integer)this.getItem()).intValue()));
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(Settings.getNumberFormat(this.decimalPlaces, this.useGrouping).format((double)((Integer)this.getItem()).intValue()));
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.getStyleClass().add((Object)"textFieldEdit");
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    try {
                        EditingTableCellDoubleTest.this.commitEdit(Settings.getNumberFormat(EditingTableCellDoubleTest.this.decimalPlaces, EditingTableCellDoubleTest.this.useGrouping).parse(EditingTableCellDoubleTest.this.textField.getText()).intValue());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER || t.getCode() == KeyCode.TAB) {
                    try {
                        EditingTableCellDoubleTest.this.commitEdit(Settings.getNumberFormat(EditingTableCellDoubleTest.this.decimalPlaces, EditingTableCellDoubleTest.this.useGrouping).parse(EditingTableCellDoubleTest.this.textField.getText()).intValue());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingTableCellDoubleTest.this.cancelEdit();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : Settings.getNumberFormat(this.decimalPlaces, this.useGrouping).format((double)((Integer)this.getItem()).intValue());
    }
}

