/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import rs.petcom.master.dal.product.Product;

public class EditingCell
extends TableCell<Product, Double> {
    private TextField textField;
    TableView<Product> productTable;

    public EditingCell() {
    }

    public EditingCell(TableView<Product> productTable) {
        this.productTable = productTable;
    }

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EditingCell.this.textField.requestFocus();
                EditingCell.this.textField.selectAll();
            }
        });
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(Double item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setGraphic((Node)this.textField);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.getString());
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    if (!EditingCell.this.textField.getText().equals("")) {
                        EditingCell.this.commitEdit(Double.parseDouble(EditingCell.this.textField.getText().trim()));
                        TableColumn nextColumn = EditingCell.this.getNextColumn(!t.isShiftDown());
                        if (nextColumn != null && nextColumn.isEditable()) {
                            EditingCell.this.getTableView().edit(EditingCell.this.getTableRow().getIndex(), nextColumn);
                        }
                        EditingCell.this.productTable.requestFocus();
                    }
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingCell.this.cancelEdit();
                    EditingCell.this.productTable.requestFocus();
                } else if (t.getCode() == KeyCode.TAB) {
                    EditingCell.this.commitEdit(Double.parseDouble(EditingCell.this.textField.getText()));
                    TableColumn nextColumn = EditingCell.this.getNextColumn(!t.isShiftDown());
                    if (nextColumn != null && nextColumn.isEditable()) {
                        EditingCell.this.getTableView().edit(EditingCell.this.getTableRow().getIndex(), nextColumn);
                    }
                    EditingCell.this.productTable.requestFocus();
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && !EditingCell.this.textField.getText().equals("")) {
                    EditingCell.this.commitEdit(Double.parseDouble(EditingCell.this.textField.getText().trim()));
                    EditingCell.this.productTable.requestFocus();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((Double)this.getItem()).toString();
    }

    private TableColumn<Product, ?> getNextColumn(boolean forward) {
        int currentIndex;
        ArrayList columns = new ArrayList();
        for (TableColumn column : this.getTableView().getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        if (columns.size() < 2) {
            return null;
        }
        int nextIndex = currentIndex = columns.indexOf(this.getTableColumn());
        if (forward) {
            if (++nextIndex > columns.size() - 1) {
                nextIndex = 0;
            }
        } else if (--nextIndex < 0) {
            nextIndex = columns.size() - 1;
        }
        return (TableColumn)columns.get(nextIndex);
    }

    private List<TableColumn<Product, ?>> getLeaves(TableColumn<Product, ?> root) {
        ArrayList columns = new ArrayList();
        if (root.getColumns().isEmpty()) {
            if (root.isEditable()) {
                columns.add(root);
            }
            return columns;
        }
        for (TableColumn column : root.getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        return columns;
    }
}

