/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.gui.BillSummaryHeader;
import rs.petcom.master.gui.BillSummaryItem;
import rs.petcom.master.gui.BillSummaryRound;
import rs.petcom.master.gui.BillSummarySum;

public class BillSummaryPane
extends BorderPane {
    private static BillSummaryHeader bsh = new BillSummaryHeader();
    private static ScrollPane scrollPane = new ScrollPane();
    private static AnchorPane roundPane = new AnchorPane();
    private static BillSummarySum bss = new BillSummarySum();
    Bill bill;
    int selectedRoundIndex = -1;
    int selectedItemIndex = -1;
    int selectedAditionalIndex = -1;
    int selectedDescriptionalIndex = -1;
    ArrayList<BillSummaryRound> roundList = new ArrayList();

    public void setPaneWidth(double width) {
        roundPane.setPrefWidth(width - 20.0);
    }

    public BillSummaryPane() {
        this.setTop((Node)bsh);
        this.setCenter((Node)scrollPane);
        scrollPane.setContent((Node)roundPane);
        this.setBottom((Node)bss);
    }

    public void setBill(Bill bill) {
        this.bill = bill;
        this.refresh();
    }

    public void refresh() {
        this.roundList.clear();
        for (int i = 0; i < this.bill.getRoundList().size(); ++i) {
            BillSummaryRound bsr = new BillSummaryRound();
            bsr.setRound(this.bill.getRoundList().get(i));
            bsr.refresh();
            this.roundList.add(bsr);
        }
        double offset = 0.0;
        roundPane.getChildren().clear();
        for (int i = 0; i < this.roundList.size(); ++i) {
            AnchorPane.setTopAnchor((Node)((Node)this.roundList.get(i)), (Double)offset);
            AnchorPane.setLeftAnchor((Node)((Node)this.roundList.get(i)), (Double)0.0);
            AnchorPane.setRightAnchor((Node)((Node)this.roundList.get(i)), (Double)0.0);
            roundPane.getChildren().add((Object)this.roundList.get(i));
            offset += this.roundList.get(i).getItemHeight();
        }
        bss.refresh(this.bill);
    }

    public void unselectAll() {
        for (int i = 0; i < this.roundList.size(); ++i) {
            this.roundList.get(i).unselectAll();
        }
    }

    public boolean hasSelectedItems() {
        for (int i = 0; i < this.roundList.size(); ++i) {
            if (!this.roundList.get(i).hasSelectedItems()) continue;
            return true;
        }
        return false;
    }

    public void locateSelected() {
        int i;
        this.selectedRoundIndex = -1;
        this.selectedItemIndex = -1;
        this.selectedAditionalIndex = -1;
        this.selectedDescriptionalIndex = -1;
        if (this.roundList.size() > 1) {
            for (i = 0; i < this.roundList.size(); ++i) {
                if (!this.roundList.get(i).hasSelectedItems()) continue;
                this.selectedRoundIndex = i;
                break;
            }
        } else {
            this.selectedRoundIndex = 0;
        }
        if (this.selectedRoundIndex > -1) {
            for (i = 0; i < this.roundList.get((int)this.selectedRoundIndex).itemsList.size(); ++i) {
                BillSummaryItem bsi = this.roundList.get((int)this.selectedRoundIndex).itemsList.get(i);
                if (bsi.isSelected()) {
                    this.selectedItemIndex = i;
                    break;
                }
                if (!bsi.hasSelectedItems()) continue;
                this.selectedItemIndex = i;
                for (int j = 0; j < bsi.getAdditionalList().size(); ++j) {
                    if (!bsi.getAdditionalList().get(j).isSelected()) continue;
                    this.selectedAditionalIndex = j;
                    break;
                }
                for (int k = 0; k < bsi.getDescriptionalList().size(); ++k) {
                    if (!bsi.getDescriptionalList().get(k).isSelected()) continue;
                    this.selectedDescriptionalIndex = bsi.getDescriptionalList().get(k).getIndex();
                }
            }
        }
    }

    public int getSelectedRoundIndex() {
        return this.selectedRoundIndex;
    }

    public void setSelectedRoundIndex(int selectedRoundIndex) {
        this.selectedRoundIndex = selectedRoundIndex;
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public void setSelectedItemIndex(int selectedItemIndex) {
        this.selectedItemIndex = selectedItemIndex;
    }

    public int getSelectedAditionalIndex() {
        return this.selectedAditionalIndex;
    }

    public void setSelectedAditionalIndex(int selectedAditionalIndex) {
        this.selectedAditionalIndex = selectedAditionalIndex;
    }

    public int getSelectedDescriptionalIndex() {
        return this.selectedDescriptionalIndex;
    }

    public void setSelectedDescriptionalIndex(int selectedDescriptionalIndex) {
        this.selectedDescriptionalIndex = selectedDescriptionalIndex;
    }

    public void selectItem(int roundIndex, int itemIndex) {
        this.roundList.get((int)roundIndex).itemsList.get(itemIndex).setSelected(true);
    }
}

