/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.text.NumberFormat;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.dal.RoundItemDescription;
import rs.petcom.master.gui.BillSummaryItem;
import rs.petcom.master.gui.BillSummaryRound;

public class BillSummaryItemDescriptional
extends GridPane {
    private RoundItemDescription description;
    private boolean selected;
    private int index;
    Label lDescription = new Label();
    Label lQuantity = new Label();
    NumberFormat nf = NumberFormat.getNumberInstance();

    public RoundItemDescription getDescription() {
        return this.description;
    }

    public int getIndex() {
        return this.index;
    }

    public BillSummaryItemDescriptional(RoundItemDescription description, int index) {
        this.description = description;
        this.index = index;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        this.setMinHeight(BillSummaryItem.summaryItemHeight);
        this.setPrefHeight(BillSummaryItem.summaryItemHeight);
        this.setMaxHeight(BillSummaryItem.summaryItemHeight);
        ColumnConstraints column1 = new ColumnConstraints(150.0, 150.0, Double.MAX_VALUE);
        column1.setFillWidth(true);
        column1.setHgrow(Priority.ALWAYS);
        ColumnConstraints column2 = new ColumnConstraints(60.0, 60.0, 30.0);
        column2.setHgrow(Priority.NEVER);
        ColumnConstraints column3 = new ColumnConstraints(100.0, 100.0, 100.0);
        column3.setHgrow(Priority.NEVER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        RowConstraints row1 = new RowConstraints((double)(BillSummaryItem.summaryItemHeight - 1), (double)(BillSummaryItem.summaryItemHeight - 1), (double)(BillSummaryItem.summaryItemHeight - 1));
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        this.lDescription.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lDescription.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.lDescription.setAlignment(Pos.CENTER_LEFT);
        this.lDescription.setMinWidth(100.0);
        this.lDescription.setPrefWidth(100.0);
        this.lDescription.setMaxWidth(Double.MAX_VALUE);
        this.lDescription.setMinHeight((double)BillSummaryItem.summaryItemHeight);
        this.lDescription.setPrefHeight((double)BillSummaryItem.summaryItemHeight);
        this.lDescription.setMaxHeight((double)BillSummaryItem.summaryItemHeight);
        this.lQuantity.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lQuantity.setAlignment(Pos.CENTER_RIGHT);
        this.lQuantity.setMinWidth(30.0);
        this.lQuantity.setPrefWidth(60.0);
        this.lQuantity.setMaxWidth(60.0);
        this.lQuantity.setMinHeight((double)BillSummaryItem.summaryItemHeight);
        this.lQuantity.setPrefHeight((double)BillSummaryItem.summaryItemHeight);
        this.lQuantity.setMaxHeight((double)BillSummaryItem.summaryItemHeight);
        this.add((Node)this.lDescription, 0, 0);
        this.add((Node)this.lQuantity, 1, 0);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                BillSummaryItemDescriptional.this.selected = !BillSummaryItemDescriptional.this.selected;
                BillSummaryItemDescriptional.this.setSelected(BillSummaryItemDescriptional.this.selected);
            }
        });
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            BillSummaryItem bsi = (BillSummaryItem)this.getParent();
            bsi.unselectAll();
            ((BillSummaryRound)bsi.getParent()).unselectAllExcept(bsi);
            this.getStyleClass().remove((Object)"billSummaryItem");
            this.getStyleClass().add((Object)"billSummaryItemSelected");
            this.selected = selected;
        } else {
            this.getStyleClass().remove((Object)"billSummaryItemSelected");
            this.getStyleClass().add((Object)"billSummaryItem");
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void refresh() {
        this.lDescription.setText(" -> " + this.description.getDescription().getName());
        this.lQuantity.setText(this.nf.format(this.description.getQuantity()));
    }
}

