/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.text.NumberFormat;
import java.util.ArrayList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.gui.BillSummaryItemAditional;
import rs.petcom.master.gui.BillSummaryItemDescriptional;
import rs.petcom.master.gui.BillSummaryRound;

public class BillSummaryItem
extends GridPane {
    private RoundItem roundItem;
    private boolean selected;
    private ArrayList<BillSummaryItemAditional> additionalList = new ArrayList();
    private ArrayList<BillSummaryItemDescriptional> descriptionalList = new ArrayList();
    Label lArtikal = new Label();
    Label lKolicina = new Label();
    Label lCena = new Label();
    NumberFormat nf = NumberFormat.getNumberInstance();
    private int itemHeight = 0;
    public static int summaryItemHeight = 20;

    public BillSummaryItem(RoundItem roundItem) {
        int i;
        this.roundItem = roundItem;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        this.lArtikal.setText(roundItem.getProductDepartment().getProduct().getName());
        this.lKolicina.setText(this.nf.format(roundItem.getQuantity()));
        this.lCena.setText(this.nf.format(roundItem.getProductDepartment().getProduct().getPrice() * roundItem.getQuantity()));
        this.getStyleClass().add((Object)"billSummaryItem");
        this.setMinHeight(this.itemHeight);
        this.setPrefHeight(this.itemHeight);
        this.setMaxHeight(this.itemHeight);
        ColumnConstraints column1 = new ColumnConstraints(150.0, 150.0, Double.MAX_VALUE);
        column1.setFillWidth(true);
        column1.setHgrow(Priority.ALWAYS);
        ColumnConstraints column2 = new ColumnConstraints(60.0, 60.0, 30.0);
        column2.setHgrow(Priority.NEVER);
        ColumnConstraints column3 = new ColumnConstraints(100.0, 100.0, 100.0);
        column3.setHgrow(Priority.NEVER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        RowConstraints row1 = new RowConstraints((double)summaryItemHeight, (double)summaryItemHeight, (double)summaryItemHeight);
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        for (i = 0; i < this.roundItem.getAdditionalList().size(); ++i) {
            this.getRowConstraints().add((Object)row1);
        }
        for (i = 0; i < this.roundItem.getDescriptionalList().size(); ++i) {
            this.getRowConstraints().add((Object)row1);
        }
        this.lArtikal.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lArtikal.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.lArtikal.setAlignment(Pos.CENTER_LEFT);
        this.lArtikal.setMinWidth(150.0);
        this.lArtikal.setPrefWidth(150.0);
        this.lArtikal.setMaxWidth(Double.MAX_VALUE);
        this.lArtikal.setMinHeight((double)summaryItemHeight);
        this.lArtikal.setPrefHeight((double)summaryItemHeight);
        this.lArtikal.setMaxHeight((double)summaryItemHeight);
        this.lKolicina.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lKolicina.setAlignment(Pos.CENTER_RIGHT);
        this.lKolicina.setMinWidth(30.0);
        this.lKolicina.setPrefWidth(60.0);
        this.lKolicina.setMaxWidth(60.0);
        this.lKolicina.setMinHeight((double)summaryItemHeight);
        this.lKolicina.setPrefHeight((double)summaryItemHeight);
        this.lKolicina.setMaxHeight((double)summaryItemHeight);
        this.lCena.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lCena.setAlignment(Pos.CENTER_RIGHT);
        this.lCena.setMinWidth(100.0);
        this.lCena.setPrefWidth(100.0);
        this.lCena.setMaxWidth(100.0);
        this.lCena.setMinHeight((double)summaryItemHeight);
        this.lCena.setPrefHeight((double)summaryItemHeight);
        this.lCena.setMaxHeight((double)summaryItemHeight);
        this.add((Node)this.lArtikal, 0, 0);
        this.add((Node)this.lKolicina, 1, 0);
        this.add((Node)this.lCena, 2, 0);
        this.additionalList.clear();
        this.itemHeight = summaryItemHeight;
        for (i = 0; i < this.roundItem.getAdditionalList().size(); ++i) {
            BillSummaryItemAditional aditional = new BillSummaryItemAditional(this.roundItem.getAdditionalList().get(i));
            GridPane.setColumnSpan((Node)aditional, (Integer)3);
            this.add((Node)aditional, 0, i + 1);
            this.additionalList.add(aditional);
            this.itemHeight += summaryItemHeight;
        }
        for (i = 0; i < this.roundItem.getDescriptionalList().size(); ++i) {
            BillSummaryItemDescriptional descriptional = new BillSummaryItemDescriptional(this.roundItem.getDescriptionalList().get(i), i);
            GridPane.setColumnSpan((Node)descriptional, (Integer)3);
            this.add((Node)descriptional, 0, this.additionalList.size() + i + 1);
            this.descriptionalList.add(descriptional);
            this.itemHeight += summaryItemHeight;
        }
        this.lArtikal.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                BillSummaryItem.this.setSelected(!BillSummaryItem.this.selected);
            }
        });
        this.lKolicina.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                BillSummaryItem.this.setSelected(!BillSummaryItem.this.selected);
            }
        });
        this.lCena.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                BillSummaryItem.this.setSelected(!BillSummaryItem.this.selected);
            }
        });
    }

    public ArrayList<BillSummaryItemAditional> getAdditionalList() {
        return this.additionalList;
    }

    public void setAdditionalList(ArrayList<BillSummaryItemAditional> additionalList) {
        this.additionalList = additionalList;
    }

    public ArrayList<BillSummaryItemDescriptional> getDescriptionalList() {
        return this.descriptionalList;
    }

    public void setDescriptionalList(ArrayList<BillSummaryItemDescriptional> descriptionalList) {
        this.descriptionalList = descriptionalList;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int height) {
        this.itemHeight = height;
    }

    public RoundItem getRoundItem() {
        return this.roundItem;
    }

    public void setRoundItem(RoundItem roundItem) {
        this.roundItem = roundItem;
    }

    public void refresh() {
        int i;
        this.getChildren().clear();
        this.add((Node)this.lArtikal, 0, 0);
        this.add((Node)this.lKolicina, 1, 0);
        this.add((Node)this.lCena, 2, 0);
        this.lKolicina.setText(this.nf.format(this.roundItem.getQuantity()));
        this.lCena.setText(this.nf.format(this.roundItem.getQuantity() * this.roundItem.getProductDepartment().getProduct().getPrice()));
        this.itemHeight = summaryItemHeight * (this.roundItem.getAdditionalList().size() + 1);
        this.additionalList.clear();
        this.itemHeight = summaryItemHeight;
        for (i = 0; i < this.roundItem.getAdditionalList().size(); ++i) {
            BillSummaryItemAditional additional = new BillSummaryItemAditional(this.roundItem.getAdditionalList().get(i));
            additional.refresh();
            GridPane.setColumnSpan((Node)additional, (Integer)3);
            this.add((Node)additional, 0, i + 1);
            this.additionalList.add(additional);
            this.itemHeight += summaryItemHeight;
        }
        for (i = 0; i < this.roundItem.getDescriptionalList().size(); ++i) {
            BillSummaryItemDescriptional descriptional = new BillSummaryItemDescriptional(this.roundItem.getDescriptionalList().get(i), i);
            descriptional.refresh();
            GridPane.setColumnSpan((Node)descriptional, (Integer)3);
            this.add((Node)descriptional, 0, this.additionalList.size() + i + 1);
            this.descriptionalList.add(descriptional);
            this.itemHeight += summaryItemHeight;
        }
    }

    public void setSelected(boolean selected) {
        this.unselectAll();
        if (selected) {
            this.selected = true;
            ((BillSummaryRound)this.getParent()).unselectAllExcept(this);
            this.lArtikal.getStyleClass().remove((Object)"backGroundTransparent");
            this.lArtikal.getStyleClass().add((Object)"backGroundOrange");
            this.lKolicina.getStyleClass().remove((Object)"backGroundTransparent");
            this.lKolicina.getStyleClass().add((Object)"backGroundOrange");
            this.lCena.getStyleClass().remove((Object)"backGroundTransparent");
            this.lCena.getStyleClass().add((Object)"backGroundOrange");
        } else {
            this.selected = false;
            this.lArtikal.getStyleClass().remove((Object)"backGroundOrange");
            this.lArtikal.getStyleClass().add((Object)"backGroundTransparent");
            this.lKolicina.getStyleClass().remove((Object)"backGroundOrange");
            this.lKolicina.getStyleClass().add((Object)"backGroundTransparent");
            this.lCena.getStyleClass().remove((Object)"backGroundOrange");
            this.lCena.getStyleClass().add((Object)"backGroundTransparent");
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void unselectAll() {
        int i;
        this.selected = false;
        this.lArtikal.getStyleClass().remove((Object)"backGroundOrange");
        this.lArtikal.getStyleClass().add((Object)"backGroundTransparent");
        this.lKolicina.getStyleClass().remove((Object)"backGroundOrange");
        this.lKolicina.getStyleClass().add((Object)"backGroundTransparent");
        this.lCena.getStyleClass().remove((Object)"backGroundOrange");
        this.lCena.getStyleClass().add((Object)"backGroundTransparent");
        for (i = 0; i < this.additionalList.size(); ++i) {
            this.additionalList.get(i).setSelected(false);
        }
        for (i = 0; i < this.descriptionalList.size(); ++i) {
            this.descriptionalList.get(i).setSelected(false);
        }
    }

    public boolean hasSelectedItems() {
        int i;
        if (this.selected) {
            return true;
        }
        for (i = 0; i < this.additionalList.size(); ++i) {
            if (!this.additionalList.get(i).isSelected()) continue;
            return true;
        }
        for (i = 0; i < this.descriptionalList.size(); ++i) {
            if (!this.descriptionalList.get(i).isSelected()) continue;
            return true;
        }
        return false;
    }
}

