/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.fical;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DailyTurnover;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.Person;

public class XmlBill {
    private static final Logger LOGGER = Logger.getLogger("global");

    public static void createXMLBill(String fiscalFolder, ArrayList<RoundItem> itemList, double gotovina, double kartica, double cek, double virman, String user, Connection connection) {
        DocumentBuilderFactory icFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder icBuilder = icFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = icBuilder.newDocument();
            Element mainRootElement = doc.createElement("FiscalRecipet");
            doc.appendChild(mainRootElement);
            for (RoundItem roundItem : itemList) {
                mainRootElement.appendChild(XmlBill.getFiscalItem(doc, roundItem, connection));
            }
            mainRootElement.appendChild(XmlBill.getPlacanje(doc, gotovina, kartica, cek, virman));
            mainRootElement.appendChild(XmlBill.getUser(doc, user));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            File billFold = new File("./racuni");
            if (!billFold.exists()) {
                billFold.mkdir();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
            String filename = sdf.format(new Date());
            File f = new File(billFold + File.separator + filename + ".xml");
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            writer.write(XmlBill.convertDocumentToString(doc));
            writer.flush();
            writer.close();
            f.renameTo(new File(fiscalFolder + filename + ".xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String convertDocumentToString(org.w3c.dom.Document doc) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Node getUser(org.w3c.dom.Document doc, String user) {
        Element company = doc.createElement("Konobar");
        company.appendChild(doc.createTextNode(user));
        return company;
    }

    private static Node getFiscalItem(org.w3c.dom.Document doc, RoundItem roundItem, Connection connection) {
        Element company = doc.createElement("FiscalItem");
        if (roundItem.getProductDepartment().getProduct().getShortName().length() > 30) {
            company.appendChild(XmlBill.getCompanyElements(doc, company, "Naziv", roundItem.getProductDepartment().getProduct().getShortName().substring(0, 30).replace("&", "")));
        } else {
            company.appendChild(XmlBill.getCompanyElements(doc, company, "Naziv", roundItem.getProductDepartment().getProduct().getShortName().replace("&", "")));
        }
        company.appendChild(XmlBill.getCompanyElements(doc, company, "Cena", String.valueOf(Settings.round(roundItem.getProductDepartment().getProduct().getPrice() * (1.0 - roundItem.getProductDepartment().getProduct().getDiscount() / 100.0), 2))));
        company.appendChild(XmlBill.getCompanyElements(doc, company, "Kolicina", String.valueOf(roundItem.getQuantity())));
        company.appendChild(XmlBill.getCompanyElements(doc, company, "PoreskaStopa", Vat.getById(roundItem.getProductDepartment().getProduct().getVatID(), connection).getCode()));
        return company;
    }

    private static Node getPlacanje(org.w3c.dom.Document doc, double gotovina, double kartica, double cek, double virman) {
        Element company = doc.createElement("Placanje");
        company.appendChild(XmlBill.getCompanyElements(doc, company, "Gotovina", String.valueOf(gotovina)));
        company.appendChild(XmlBill.getCompanyElements(doc, company, "Cek", String.valueOf(cek)));
        company.appendChild(XmlBill.getCompanyElements(doc, company, "Kartica", String.valueOf(kartica)));
        company.appendChild(XmlBill.getCompanyElements(doc, company, "Virman", String.valueOf(virman)));
        return company;
    }

    private static Node getCompanyElements(org.w3c.dom.Document doc, Element element, String name, String value) {
        Element node = doc.createElement(name);
        node.appendChild(doc.createTextNode(value));
        return node;
    }

    public static synchronized void writeSalePOStoERP(Document document, ScreensController controller) throws Exception {
        File billFold = new File(controller.getSettings().getActualByName("excel.microcer.folder"));
        if (!billFold.exists()) {
            billFold.mkdir();
        }
        String filename = "POS_ORDER_" + document.getDocumentID();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        org.w3c.dom.Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("pos_order");
        newDoc.appendChild(rootElement);
        Element c1 = newDoc.createElement("date_order");
        c1.appendChild(newDoc.createTextNode(new SimpleDateFormat("yyyy-MM-dd HH:MM:SS").format(document.getDate())));
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("pos_user_login");
        c1.appendChild(newDoc.createTextNode(String.valueOf(User.getUserByID(document.getSysUserAddID(), controller.getSettings().getConnection()).getUserID())));
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("receipt_number");
        c1.appendChild(newDoc.createTextNode(document.getFullNumber().equals("") || document.getFullNumber() == null ? Document.getLastFullNumberByBill(controller, document) : document.getFullNumber()));
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("session_number");
        try {
            c1.appendChild(newDoc.createTextNode(String.valueOf(DailyTurnover.getLast(controller, document).getDailyTurnoverNumber() + 1)));
        }
        catch (NullPointerException e) {
            c1.appendChild(newDoc.createTextNode("1"));
        }
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("vat");
        if (document.getPersonID() != 0L) {
            c1.appendChild(newDoc.createTextNode(Person.getById(document.getPersonID(), controller).getPIB()));
        }
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("lines");
        rootElement.appendChild(c1);
        for (DocumentDetails documentDetails : DocumentDetails.getObeservableList(document.getDocumentID(), controller.getSettings().getConnection())) {
            Element e1 = newDoc.createElement("item");
            c1.appendChild(e1);
            Element cItem = newDoc.createElement("product_id");
            cItem.appendChild(newDoc.createTextNode(String.valueOf(documentDetails.getProductID())));
            e1.appendChild(cItem);
            cItem = newDoc.createElement("metakasa_tax_number");
            cItem.appendChild(newDoc.createTextNode(String.valueOf(documentDetails.getVatID())));
            e1.appendChild(cItem);
            cItem = newDoc.createElement("price_unit");
            cItem.appendChild(newDoc.createTextNode(String.valueOf(Settings.round(documentDetails.getPriceWithDiscount(), 2))));
            e1.appendChild(cItem);
            cItem = newDoc.createElement("qty");
            cItem.appendChild(newDoc.createTextNode(String.valueOf(Settings.round(documentDetails.getQuantity(), 3))));
            e1.appendChild(cItem);
        }
        c1 = newDoc.createElement("payments");
        rootElement.appendChild(c1);
        Element e2 = newDoc.createElement("payment");
        c1.appendChild(e2);
        Element e3 = newDoc.createElement("type");
        e3.appendChild(newDoc.createTextNode(PaymentMethod.getByID(document.getPaymentMethodID(), controller.getSettings().getConnection()).getName()));
        e2.appendChild(e3);
        e3 = newDoc.createElement("amount");
        e3.appendChild(newDoc.createTextNode(String.valueOf(Settings.round(document.getSumWithDiscount(), 2))));
        e2.appendChild(e3);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = billFold + File.separator + filename + ".xml";
        File f = new File(path1);
        while (f.exists()) {
            filename = "POS_ORDER_" + document.getDocumentID();
            path1 = billFold + filename + ".xml";
            f = new File(path1);
        }
        FileWriter writer = new FileWriter(f.getAbsoluteFile());
        StreamResult dest = new StreamResult(writer);
        aTransformer.transform(src, dest);
        writer.flush();
        writer.close();
    }

    public static synchronized void writeCloseDayPOStoERP(DailyTurnover dailyTurnover, ScreensController controller) throws Exception {
        File billFold = new File(controller.getSettings().getActualByName("excel.microcer.folder"));
        if (!billFold.exists()) {
            billFold.mkdir();
        }
        String filename = "POS_SESSION_" + dailyTurnover.getDailyTurnoverId();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        org.w3c.dom.Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("pos_session");
        newDoc.appendChild(rootElement);
        Element c1 = newDoc.createElement("date_closed");
        c1.appendChild(newDoc.createTextNode(new SimpleDateFormat("yyyy-MM-dd HH:MM:SS").format(dailyTurnover.getDailyTurnoverDate())));
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("check_total");
        c1.appendChild(newDoc.createTextNode(String.valueOf(dailyTurnover.getDailyTurnoverValue())));
        rootElement.appendChild(c1);
        c1 = newDoc.createElement("session_number");
        c1.appendChild(newDoc.createTextNode(String.valueOf(dailyTurnover.getDailyTurnoverNumber())));
        rootElement.appendChild(c1);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        String path1 = billFold + File.separator + filename + ".xml";
        File f = new File(path1);
        while (f.exists()) {
            filename = "POS_SESSION_" + dailyTurnover.getDailyTurnoverId();
            path1 = billFold + filename + ".xml";
            f = new File(path1);
        }
        FileWriter writer = new FileWriter(f.getAbsoluteFile());
        StreamResult dest = new StreamResult(writer);
        aTransformer.transform(src, dest);
        writer.flush();
        writer.close();
    }

    public static synchronized String writeFiscalReciept(ArrayList<RoundItem> itemList, String user, double gotovina, double kartica, double cek, double virman, String fiscalFolder, boolean waitingFPmaster, ScreensController controller) throws Exception {
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
        String filename = sdf.format(new Date());
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        org.w3c.dom.Document newDoc = domBuilder.newDocument();
        Element rootElement = newDoc.createElement("FiscalRecipet");
        newDoc.appendChild(rootElement);
        double sumaStavki = 0.0;
        for (RoundItem roundItem : itemList) {
            Element e1 = newDoc.createElement("FiscalItem");
            Element c1 = newDoc.createElement("Naziv");
            if (roundItem.getProductDepartment().getProduct().getShortName().length() > 30) {
                c1.appendChild(newDoc.createTextNode(roundItem.getProductDepartment().getProduct().getShortName().substring(0, 30).replace("&", "")));
            } else {
                c1.appendChild(newDoc.createTextNode(roundItem.getProductDepartment().getProduct().getShortName().replace("&", "")));
            }
            e1.appendChild(c1);
            c1 = newDoc.createElement("Cena");
            c1.appendChild(newDoc.createTextNode(String.valueOf(Settings.roundOnTwo(roundItem.getProductDepartment().getProduct().getPrice() * (1.0 - roundItem.getProductDepartment().getProduct().getDiscount() / 100.0)))));
            e1.appendChild(c1);
            c1 = newDoc.createElement("Kolicina");
            c1.appendChild(newDoc.createTextNode(String.valueOf(roundItem.getQuantity())));
            e1.appendChild(c1);
            c1 = newDoc.createElement("PoreskaGrupa");
            c1.appendChild(newDoc.createTextNode(Vat.getById(roundItem.getProductDepartment().getProduct().getVatID(), controller.getSettings().getConnection()).getCode()));
            e1.appendChild(c1);
            rootElement.appendChild(e1);
            sumaStavki += roundItem.getQuantity() * Settings.roundOnTwo(roundItem.getProductDepartment().getProduct().getPrice() * (1.0 - roundItem.getProductDepartment().getProduct().getDiscount() / 100.0));
        }
        Element e2 = newDoc.createElement("Placanje");
        Element c1 = newDoc.createElement("Gotovina");
        c1.appendChild(newDoc.createTextNode(String.valueOf(gotovina)));
        e2.appendChild(c1);
        c1 = newDoc.createElement("Cek");
        c1.appendChild(newDoc.createTextNode(String.valueOf(cek)));
        e2.appendChild(c1);
        c1 = newDoc.createElement("Kartica");
        c1.appendChild(newDoc.createTextNode(String.valueOf(kartica)));
        e2.appendChild(c1);
        c1 = newDoc.createElement("Virman");
        c1.appendChild(newDoc.createTextNode(String.valueOf(virman)));
        e2.appendChild(c1);
        rootElement.appendChild(e2);
        e2 = newDoc.createElement("Konobar");
        e2.appendChild(newDoc.createTextNode(user));
        rootElement.appendChild(e2);
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        Transformer aTransformer = tranFactory.newTransformer();
        aTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        aTransformer.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(newDoc);
        File billFold = new File("./racuni");
        if (!billFold.exists()) {
            billFold.mkdir();
        }
        String path1 = billFold + File.separator + filename + ".xml";
        File f = new File(path1);
        while (f.exists()) {
            filename = sdf.format(new Date());
            path1 = billFold + filename + ".xml";
            f = new File(path1);
        }
        try {
            FileWriter writer = new FileWriter(f.getAbsoluteFile());
            StreamResult dest = new StreamResult(writer);
            aTransformer.transform(src, dest);
            writer.flush();
            writer.close();
            File f2 = new File(fiscalFolder + File.separator + filename + ".xml");
            f.renameTo(f2);
            LOGGER.info("fiskalni ra\u010dun: Iznos: " + sumaStavki + " " + fiscalFolder + filename + ".xml");
            if (sumaStavki > 0.0) {
                Thread.sleep(400L);
                File f3 = new File(fiscalFolder + "fromfp\\" + filename + ".txt");
                int vremeCekanja = 0;
                while ((!f3.exists() || f3.isDirectory()) && waitingFPmaster) {
                    Thread.sleep(200L);
                    if ((vremeCekanja += 200) < 5000) continue;
                    LOGGER.warning("Vreme \u010dekanja na \u0161tampu ra\u010duna ve\u0107e od 5s");
                    break;
                }
                result = new String(Files.readAllBytes(Paths.get(f3.getAbsolutePath(), new String[0]))).trim();
                if (f3.delete()) {
                    System.out.println("File is deleted");
                } else {
                    System.out.println("Could not delete file");
                }
            }
        }
        catch (Exception ee) {
            LOGGER.severe("Problem pri \u0161tampi fiskalnog ra\u010duna;" + ee.getMessage());
            File f4 = new File(fiscalFolder + "\\Err\\" + filename + ".xml");
            FileWriter w = new FileWriter(f4.getAbsoluteFile());
            StreamResult dest = new StreamResult(w);
            aTransformer.transform(src, dest);
            w.flush();
            w.close();
            Log.writeLog(controller.getUser(), ee.getLocalizedMessage(), controller.getSettings().getConnection());
        }
        return result;
    }
}

